﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_OptionStation : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Option";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Tables.Options.Select("[id],[Key],[Value]", "[Key] like 'Station%'", "");
        if ((dt == null) || (dt.Rows.Count < 1))
            return;

        DataRow[] dr = dt.Select("Key=\'StationName\'");
        if (dr.Length > 0)
            tb1.Text = dr[0]["Value"].ToString();

        dr = dt.Select("Key=\'StationNum\'");
        if (dr.Length > 0)
            tb2.Text = dr[0]["Value"].ToString();

        dr = dt.Select("Key=\'StationAddress\'");
        if (dr.Length > 0)
            tb3.Text = dr[0]["Value"].ToString();

        dr = dt.Select("Key=\'StationTelephone\'");
        if (dr.Length > 0)
            tb4.Text = dr[0]["Value"].ToString();
    }

    protected void btnOK_Click(object sender, System.EventArgs e)
    {
        PublicFunction.SetOptions("StationName", tb1.Text.Trim());
        PublicFunction.SetOptions("StationNum", tb2.Text.Trim());
        PublicFunction.SetOptions("StationAddress", tb3.Text.Trim());
        PublicFunction.SetOptions("StationTelephone", tb4.Text.Trim());

        ShoveEL._Web.JavaScript.Alert(this.Page, "投注站信息保存成功。");
    }
}