﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_PromotionerDetail : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int id = -1;
            id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (id > 0)
            {
                tbID.Text = id.ToString();
            }

            BindDataForYearMonth();
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Promotioner";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForYearMonth()
    {
        ddlYear.Items.Clear();
        DateTime dt = DateTime.Now;
        int Year = dt.Year;
        int Month = dt.Month;

        if (Year < 2006)
        {
            btnSearch.Enabled = false;
            return;
        }

        for (int i = 2006; i <= Year; i++)
        {
            ddlYear.Items.Add(new ListItem(i.ToString() + "年", i.ToString()));
        }

        ddlYear.SelectedIndex = ddlYear.Items.Count - 1;

        ddlMonth.SelectedIndex = Month - 1;
    }

    private void BindData()
    {
        int ID = ShoveEL._Convert.StrToInt(tbID.Text, -1);
        if (ID < 0)
        {
            Response.Write("<center><br><br><br><br>暂无任何数据！</center>");
            Response.End();
            return;
        }

        DataTable dt = DAL.Tables.Users.Select("", "Year(RegisterTime) = " + ddlYear.SelectedValue + " and Month(RegisterTime) = " + ddlMonth.SelectedValue + " and Promotioner_id = " + ID.ToString(), "id desc");

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Cells[11].Text = e.Item.Cells[11].Text.Trim() == "2" ? "<font color='red'>高级</font>" : "普通";
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }

    protected void btnSearch_Click(object sender, System.EventArgs e)
    {
        BindData();
    }
}