﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

//public partial class Admin_PromotionersList : System.Web.UI.Page
public partial class Admin_PromotionersList : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            tbTimeFrom.Text = System.DateTime.Now.ToShortDateString();
            tbTimeTo.Text = System.DateTime.Now.ToShortDateString();

            
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Promotioner";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        System.DateTime TimeFrom, TimeTo;
        try
        {
            TimeFrom = System.DateTime.Parse(tbTimeFrom.Text.Trim());
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "开始时间格式输入错误！");
            return;
        }
        try
        {
            TimeTo = System.DateTime.Parse(tbTimeTo.Text.Trim());
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "结束时间格式输入错误！");
            return;
        }
        TimeFrom = DateTime.Parse(TimeFrom.ToShortDateString() + " 0:0:0");
        TimeTo = DateTime.Parse(TimeTo.ToShortDateString() + " 23:59:59");
        if (TimeFrom > TimeTo)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "结束时间应该在开始时间之后！");
            return;
        }

        DataTable dt = DAL.Views.V_Promotioners.Select("", "[Datetime] between '" +  @TimeFrom + "'and '" + @TimeTo +"'", "");

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);

        if (dt.Rows.Count > 0)
        {
            labSum.Text = String.Format("总注册人数：{0}， 总购彩金额：{1}, 总点击字数: {2}", (dt.Rows[0][21].ToString() == "") ? "0" : dt.Rows[0][21].ToString(), 
                         (dt.Rows[0][22].ToString() == "") ? "0" : double.Parse(dt.Rows[0][22].ToString()).ToString("N"), 
                         (dt.Rows[0][20].ToString() == "") ? "0" : dt.Rows[0][20].ToString());
        }
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[6].FindControl("cbON");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[19].Text, true);

            double BonusScale = ShoveEL._Convert.StrToDouble(e.Item.Cells[5].Text, 0) * 100;
            e.Item.Cells[5].Text = BonusScale.ToString() + "%";

            e.Item.Cells[2].Text = "<font color='red'>" + ShoveEL._Convert.StrToInt(e.Item.Cells[2].Text, 0).ToString() + "</font>";

            e.Item.Cells[3].Text = "<font color='red'>" + ShoveEL._Convert.StrToInt(e.Item.Cells[3].Text, 0).ToString() + "</font>";

            double money = ShoveEL._Convert.StrToDouble(e.Item.Cells[4].Text, 0);
            e.Item.Cells[4].Text = "<font color='red'>" + money.ToString("N") + "</font>";
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }

    protected void btnGO_Click(object sender, System.EventArgs e)
    {
        BindData();
    }
}