﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_SendEmail : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        // 在此处放置用户代码以初始化页面
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "SendEmail";
        base.OnInit(e);
    }
    #endregion

    protected void btnSend_Click(object sender, System.EventArgs e)
    {
        if (tbSubject.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入邮件标题。");
            return;
        }

        if (tbContent.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入邮件内容。");
            return;
        }

        if (cbSystemMessage.Checked)
        {
            SendSystemMessage();
            return;
        }

        if (tbAim.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入接收方用户名。");
            return;
        }

        string[] AimNames = GetAimNames(tbAim.Text.Trim());
        if (AimNames.Length < 1)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的接收方用户名。");
            return;
        }

        int CountOK = 0, CountFail = 0;	//发送计数统计
        string SendResult = "";	//发送结果

        for (int i = 0; i < AimNames.Length; i++)
        {
            Users tu = new Users();
            tu.Name = AimNames[i];
            int Result = tu.GetUserInfoByName();
            if ((Result != 0) && (Result != -3))
            {
                CountFail++;
                SendResult += "用户 " + AimNames[i] + " 不存在！<BR>";
                continue;
            }
            if (tu.Email.Trim() == "")
            {
                CountFail++;
                SendResult += "用户 " + AimNames[i] + " 没有输入邮件地址！<BR>";
                continue;
            }

            Result = PublicFunction.SendEmail(tu.Email, tbSubject.Text.Trim(), tbContent.Text.Trim());
            if (Result != 0)
            {
                CountFail++;
                SendResult += "用户 " + AimNames[i] + " 发送错误！<BR>";
                continue;
            }
            CountOK++;
            SendResult += "用户 " + AimNames[i] + " 发送成功。<BR>";
        }

        labSendResult.Text = "发送结果：成功 " + CountOK.ToString() + " 个，失败 " + CountFail.ToString() + " 个。<BR>" + SendResult;
        if (CountFail == 0)
        {
            tbAim.Text = "";
            tbContent.Text = "";
            cbSystemMessage.Checked = false;
        }
    }

    private string[] GetAimNames(string str)
    {
        string[] strs = str.Split(',');
        ArrayList AimNames = new ArrayList();

        for (int i = 0; i < strs.Length; i++)
        {
            strs[i] = strs[i].Trim();
            if (strs[i] == "")
                continue;

            bool isExist = false;
            for (int j = 0; j < AimNames.Count; j++)
            {
                if (AimNames[j].ToString() == strs[i])
                {
                    isExist = true;
                    break;
                }
            }

            if (!isExist)
                AimNames.Add(strs[i]);
        }

        while (AimNames.Count > 10)
            AimNames.RemoveAt(AimNames.Count - 1);

        string[] Result = new string[AimNames.Count];
        for (int i = 0; i < AimNames.Count; i++)
            Result[i] = AimNames[i].ToString();

        return Result;
    }

    private void SendSystemMessage()
    {
        DataTable dt = DAL.Tables.Users.Select("", "Email <> ''", "");
        if (dt == null)
        {
            GoError();
            return;
        }

        int CountOK = 0, CountFail = 0;	//发送计数统计
        string SendResult = "";	//发送结果
        foreach(DataRow dr in dt.Rows)
        {
            int Result = PublicFunction.SendEmail(dr["Email"].ToString(), tbSubject.Text.Trim(), tbContent.Text.Trim());
            if (Result != 0)
            {
                CountFail++;
                SendResult += "用户 " + dr["Name"].ToString() + " 发送错误！<BR>";
            }
            else
            {
                CountOK++;
                SendResult += "用户 " + dr["Name"].ToString() + " 发送成功。<BR>";
            }
        }

        labSendResult.Text = "发送结果：成功 " + CountOK.ToString() + " 个，失败 " + CountFail.ToString() + " 个。<BR>" + SendResult;
        if (CountFail == 0)
        {
            tbAim.Text = "";
            tbContent.Text = "";
            cbSystemMessage.Checked = false;
        }
    }
}