﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_UserAccount : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int id = -1;
            id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (id > 0)
                tbID.Text = id.ToString();

            BindDataForYearMonth();
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserAccount";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForYearMonth()
    {
        ddlYear.Items.Clear();
        DateTime dt = DateTime.Now;
        int Year = dt.Year;
        int Month = dt.Month;

        if (Year < 2006)
        {
            btnRead.Enabled = false;
            return;
        }

        for (int i = 2006; i <= Year; i++)
            ddlYear.Items.Add(new ListItem(i.ToString() + "年", i.ToString()));
        ddlYear.SelectedIndex = ddlYear.Items.Count - 1;

        ddlMonth.SelectedIndex = Month - 1;
    }

    private void BindData()
    {
        if (tbID.Text == "")
            return;

        if (ddlYear.Items.Count == 0)
            return;

        Users tu = new Users();
        tu.ID = int.Parse(tbID.Text);
        int Result = tu.GetUserInfoByID();
        if (!((Result == 0) || (Result == -3) || (Result == -4)))
        {
            GoError("用户参数错误。");
            return;
        }

        tbUserName.Text = tu.Name;
        BindData(tu);
    }

    private void BindData(Users tu)
    {
        if (ddlYear.Items.Count == 0)
            return;

        DataSet ds = DAL.Procedures.P_GetMemberAccountDetail.Open(tu.ID, ShoveEL._Convert.StrToInt(ddlYear.SelectedValue, 0), ShoveEL._Convert.StrToInt(ddlMonth.SelectedValue, 0));
        if ((ds == null) || (ds.Tables.Count < 1))
        {
            GoError();
            return;
        }

        g.DataSource = ds.Tables[0];
        g.DataBind();
        gPager.Visible = (ds.Tables[0].Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            e.Item.Cells[2].Text = (money == 0) ? "" : money.ToString("N");
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            e.Item.Cells[3].Text = (money == 0) ? "" : money.ToString("N");
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[4].Text, 0);
            e.Item.Cells[4].Text = (money == 0) ? "" : money.ToString("N");
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[5].Text, 0);
            e.Item.Cells[5].Text = (money == 0) ? "" : money.ToString("N");

            int Scheme = ShoveEL._Convert.StrToInt(e.Item.Cells[6].Text, 0);
            if (Scheme > 0)
                e.Item.Cells[1].Text = "<a href='../Scheme.aspx?id=" + Scheme.ToString() + "' target='_blank'><font color=\"#330099\">" + e.Item.Cells[1].Text + "</Font></a>";
        }
    }

    protected void btnRead_Click(object sender, System.EventArgs e)
    {
        if (tbUserName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入用户名。");
            return;
        }

        Users tu = new Users();
        tu.Name = tbUserName.Text.Trim();
        int Result = tu.GetUserInfoByName();
        if (!((Result == 0) || (Result == -3) || (Result == -4)))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "用户名不存在。");
            return;
        }

        tbID.Text = tu.ID.ToString();

        BindData(tu);
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }
}