﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_UserAddMoney : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        // 在此处放置用户代码以初始化页面
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserAddMoney";
        base.OnInit(e);
    }
    #endregion

    protected void btnGO_Click(object sender, System.EventArgs e)
    {
        if (tbUserName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入用户名称。");
            return;
        }

        double Money = ShoveEL._Convert.StrToDouble(tbMoney.Text, 0);
        if (Money == 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入有效的金额。");
            return;
        }

        Users tu = new Users();
        tu.Name = tbUserName.Text.Trim();
        int Result = tu.GetUserInfoByName();
        if (Result == -4)
        {
            GoError();
            return;
        }
        if (Result == -1)
        {
            ShoveEL._Web.JavaScript.Alert(this, "用户不存在。");
            return;
        }

        int type = (cbType.Checked) ? 2 : 3;
        string Return = "";
        if (tu.AddUserBalance_2(type, Money, "手工充值。", user.ID, ref Return) == -4)
        {
            GoError();
            return;
        }
        else
        {
            if (tu.ID == user.ID)
                user.Balance += Money;
            tbUserName.Text = "";
            tbMoney.Text = "";
            ShoveEL._Web.JavaScript.Alert(this, "为用户充值成功。");
        }
    }
}