﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_UserDetail : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            FillBanks();
            FillProvince();

            int id = -1;
            id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (id < 0)
            {
                Panel1.Visible = false;
                btnUserAccount.Visible = false;
            }
            else
            {
                tbID.Text = id.ToString();
                BindData(id);
            }
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserDetail";
        base.OnInit(e);
    }
    #endregion

    private void BindData(int id)
    {
        Users tu = new Users();
        tu.ID = id;
        int Result = tu.GetUserInfoByID();
        if (!((Result == 0) || (Result == -3) || (Result == -4)))
        {
            GoError("用户参数错误。");
            return;
        }

        BindData(tu);

        Promotioners tp = new Promotioners();
        tp.User_id = id;

        int PromotionerResult = tp.GetPromotionersInfoByUserID();

        if (!((PromotionerResult == 0) || (PromotionerResult == -4)))
        {
            if (PromotionerResult != -1)
            {
                GoError("用户参数错误。");
                return;
            }
        }

        BindPromotioners(tp);
    }

    private void BindData(Users tu)
    {
        Label3.Visible = true;
        Label5.Visible = true;
        tbUserPassword.Visible = true;
        tbUserEmail.Visible = true;

        tbUserName.Text = tu.Name;
        tbUserPassword.Text = "****************";
        tbUserEmail.Text = tu.Email;

        if (tu.UserType == 1)
            rbUserType1.Checked = true;
        else if (tu.UserType == 2)
            rbUserType2.Checked = true;
        tbUserRealityName.Text = tu.RealityName;
        tbUserIDCardNumber.Text = tu.IDCardNumber;
        ShoveEL.ControlExt.SetDownListBoxText(ddlUserProvince, tu.Province);
        //改变省后重新填充市
        FillCity(ddlUserProvince.SelectedItem.Text);
        ShoveEL.ControlExt.SetDownListBoxText(ddlUserCity, tu.City);
        tbUserPassword_2.Text = "****************";
        tbUserTelphone.Text = tu.Telphone;
        tbUserMobile.Text = tu.Mobile;
        cbUserMobileValid.Checked = (tu.MobileValid && (tu.Mobile != ""));
        tbUserEmail.Text = tu.Email;
        tbUserQQ.Text = tu.QQ;
        tbUserAddress.Text = tu.Address;
        if (tu.Sex == "男")
            rbUserSexM.Checked = true;
        else if (tu.Sex == "女")
            rbUserSexW.Checked = true;
        tbUserBirthDay.Text = tu.BirthDay.ToShortDateString();
        ShoveEL.ControlExt.SetDownListBoxText(ddlUserBankType, tu.BankType);
        tbUserBankName.Text = tu.BankName;
        tbUserBankCardNumber.Text = tu.BankCardNumber;
        cbPrivacy.Checked = tu.Privacy;
        cbBlackList.Checked = tu.Blacklist;
        cbUserisAcceptMobileMessage.Checked = tu.isAcceptMobileMessage;
        cbUserisAcceptEmail.Checked = tu.isAcceptEmail;
        cbUserisAcceptMessage.Checked = tu.isAcceptMessage;
        cbManagementRights.Checked = tu.ManagementRights;
        cbSuperManagementRights.Checked = tu.SuperManagementRights;

        tbID.Text = tu.ID.ToString();
        btnUserAccount.Visible = true;
        Panel1.Visible = true;

        cbManagementRights.Enabled = (ShoveEL._Convert.StrToInt(tbID.Text, -1) != 1);
        cbSuperManagementRights.Enabled = cbManagementRights.Enabled;
    }

    private void BindPromotioners(Promotioners tp)
    {
        tb_bonusscale.Text = (tp.BonusScale * 100).ToString();
        tb_company.Text = tp.Company;
        tb_logourl.Text = tp.LogoUrl;
        tb_url.Text = tp.Url;
        tb_ContactPerson.Text = tp.ContactPerson;
        tb_postcode.Text = tp.PostCode;
        tb_ResponsiblePerson.Text = tp.ResponsiblePerson;
        tb_ServiceTelephone.Text = tp.ServiceTelephone;
        cb_on.Checked = tp.IsON;
        tb_Address.Text = tp.Address;
        tb_email.Text = tp.Email;
        tb_fax.Text = tp.Fax;
        tb_Mobile.Text = tp.Mobile;
        tb_Name.Text = tp.Name;
        tb_qq.Text = tp.QQ;
        tb_Telephone.Text = tp.Telephone;
        tb_Name.Text = tp.Name;
    }

    private void FillBanks()
    {
        ddlUserBankType.Items.Clear();

        DataTable dt = DAL.Tables.Banks.Select("", "", "[Sort]");

        if (dt == null)
        {
            GoError();
            return;
        }

        foreach(DataRow dr in dt.Rows)
            ddlUserBankType.Items.Add(dr["Name"].ToString().Trim());

        if (ddlUserBankType.Items.Count > 0)
            ddlUserBankType.SelectedIndex = 0;
    }

    private void FillProvince()
    {
        ddlUserProvince.Items.Clear();

        DataTable dt = DAL.Tables.Province.Select("", "", "[Name]");
        if (dt == null)
        {
            GoError();
            return;
        }

        foreach(DataRow dr in dt.Rows)
            ddlUserProvince.Items.Add(dr["Name"].ToString().Trim());

        if (ddlUserProvince.Items.Count > 0)
            ddlUserProvince.SelectedIndex = 0;
    }

    private void FillCity(string ProvinceName)
    {
        ddlUserCity.Items.Clear();

        DataTable dt = DAL.Views.V_City.Select("", "Province=\'" + ProvinceName + "\'", "City");
        if (dt == null)
        {
            GoError();
            return;
        }

        foreach(DataRow dr in dt.Rows)
            ddlUserCity.Items.Add(dr["City"].ToString().Trim());

        if (ddlUserCity.Items.Count > 0)
            ddlUserCity.SelectedIndex = 0;
    }

    protected void btnRead_Click(object sender, System.EventArgs e)
    {
        if (tbUserName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入用户名。");
            return;
        }

        Users tu = new Users();
        tu.Name = tbUserName.Text.Trim();
        int Result = tu.GetUserInfoByName();
        if (!((Result == 0) || (Result == -3) || (Result == -4)))
        {
            Panel1.Visible = false;
            btnUserAccount.Visible = false;
            ShoveEL._Web.JavaScript.Alert(this.Page, "用户名不存在。");
            return;
        }

        BindData(tu);

        Promotioners tp = new Promotioners();
        tp.User_id = tu.ID;

        int PromotionerResult = tp.GetPromotionersInfoByUserID();

        if (!((PromotionerResult == 0) || (PromotionerResult == -4)))
        {
            if (PromotionerResult != -1)
            {
                GoError("用户参数错误。");
                return;
            }
        }

        BindPromotioners(tp);
    }

    protected void ddlUserProvince_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        FillCity(ddlUserProvince.SelectedItem.Text);
    }

    protected void btnSave_Click(object sender, System.EventArgs e)
    {
        if (tbID.Text == "")
        {
            GoError();
            return;
        }

        Users tu = new Users();
        tu.ID = int.Parse(tbID.Text);
        int Result = tu.GetUserInfoByID();
        if (!((Result == 0) || (Result == -3) || (Result == -4)))
        {
            GoError("用户参数错误。");
            return;
        }

        if (tu.Name != tbUserName.Text.Trim())
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "不能修改用户名。");
            return;
        }

        if (tbUserPassword.Text == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入普通密码。");
            return;
        }

        if (tbUserEmail.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入电子邮件地址。");
            return;
        }

        if (!ShoveEL._String.Valid.isEmail(tbUserEmail.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "电子邮件地址格式不正确。");
            return;
        }

        if (rbUserType2.Checked)
        {
            if (tbUserRealityName.Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入真实姓名。");
                return;
            }

            if (tbUserIDCardNumber.Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入身份证号。");
                return;
            }

            if (!ShoveEL._String.Valid.isIDCardNumber(tbUserIDCardNumber.Text.Trim()))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "身份证号格式不正确。");
                return;
            }

            if (tbUserPassword_2.Text == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入投注密码。");
                return;
            }

            try
            {
                DateTime.Parse(tbUserBirthDay.Text.Trim());
            }
            catch
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的生日。");
                return;
            }

            if (tbUserBankName.Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入开户银行。");
                return;
            }

            if (tbUserBankCardNumber.Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入银行卡号。");
                return;
            }

            /*
            if (!ShoveEL._String.Valid.isBankCardNumber(tbUserBankCardNumber.Text.Trim()))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "银行卡号格式不正确。");
                return;
            }
            */

            if (tb_url.Text != "")
            {
                if (!ShoveEL._String.Valid.isUrl(tb_url.Text))
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的网址。");
                    return;
                }
            }

            if (tb_bonusscale.Text != "")
            {
                for (int i = 0; i < tb_bonusscale.Text.Length; i++)
                {
                    if ("0123456789.".IndexOf(tb_bonusscale.Text.Substring(i, 1)) < 0)
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的推广佣金。");
                        return;
                    }
                }
            }

            if (tb_postcode.Text != "")
            {
                for (int i = 0; i < tb_postcode.Text.Length; i++)
                {
                    if ("0123456789".IndexOf(tb_postcode.Text.Substring(i, 1)) < 0)
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的邮编。");
                        return;
                    }
                }
            }
        }

        tu.UserType = rbUserType2.Checked ? 2 : 1;
        if (tbUserPassword.Text != "****************")
        {
            tu.Password = tbUserPassword.Text;
        }
        tu.Email = tbUserEmail.Text.Trim();
        tu.RealityName = tbUserRealityName.Text.Trim();
        tu.IDCardNumber = tbUserIDCardNumber.Text.Trim();
        tu.Province = ddlUserProvince.SelectedItem.Text;
        tu.City = ddlUserCity.SelectedItem.Text;
        if (tbUserPassword_2.Text != "****************")
        {
            tu.Password_2 = tbUserPassword_2.Text;
        }
        tu.Telphone = tbUserTelphone.Text.Trim();
        tu.Mobile = tbUserMobile.Text.Trim();
        tu.MobileValid = (cbUserMobileValid.Checked && (tu.Mobile != ""));
        tu.QQ = tbUserQQ.Text.Trim();
        tu.Address = tbUserAddress.Text.Trim();
        tu.Sex = rbUserSexM.Checked ? "男" : (rbUserSexW.Checked ? "女" : "");
        tu.BirthDay = DateTime.Parse(tbUserBirthDay.Text.Trim());
        tu.BankType = ddlUserBankType.SelectedItem.Text;
        tu.BankName = tbUserBankName.Text.Trim();
        tu.BankCardNumber = tbUserBankCardNumber.Text.Trim();

        tu.Privacy = cbPrivacy.Checked;
        tu.Blacklist = cbBlackList.Checked;
        tu.isAcceptMobileMessage = cbUserisAcceptMobileMessage.Checked;
        tu.isAcceptEmail = cbUserisAcceptEmail.Checked;
        tu.isAcceptMessage = cbUserisAcceptMessage.Checked;

        tu.ManagementRights = cbManagementRights.Checked;
        tu.SuperManagementRights = cbSuperManagementRights.Checked;

        string Return = "";
        int result = tu.EditByID(ref Return);

        if (result != 0 || Return != "")
        {
            GoError(Return);
            return;
        }

        if (tb_ContactPerson.Text != "")
        {
            if (user.ManagementRightsList.IndexOf("[Promotioner]") < 0)
            {
                GoError("管理权限不足。");
            }

            bool Promotioners_Status_ON = PublicFunction.GetOptionsAsBoolean("Promotioners_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetMID() + PublicFunction.GetOptionsAsString("Promotioners_LimitNum"), PublicFunction.GetOptionsAsString("Promotioners_ON_Cert"), "SLPC");


            if (!Promotioners_Status_ON)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "证书错误，请联系开发商。");
                return;
            }

            Promotioners tp = new Promotioners();
            tp.User_id = int.Parse(tbID.Text);

            //int PromotionerResult = tp.GetUserPromotionersInfoByUserID();

            tp.Url = tb_url.Text;
            tp.LogoUrl = tb_logourl.Text;
            tp.BonusScale = (ShoveEL._Convert.StrToDouble(tb_bonusscale.Text, 0) / 100);
            tp.IsON = cb_on.Checked;
            tp.Company = tb_company.Text;
            tp.Address = tb_Address.Text;
            tp.PostCode = tb_postcode.Text;
            tp.ResponsiblePerson = tb_ResponsiblePerson.Text;
            tp.ContactPerson = tb_ContactPerson.Text;
            tp.Telephone = tb_Telephone.Text;
            tp.Fax = tb_fax.Text;
            tp.Mobile = tb_Mobile.Text;
            tp.Email = tb_email.Text;
            tp.QQ = tb_qq.Text;
            tp.ServiceTelephone = tb_ServiceTelephone.Text;
            tp.Name = tb_Name.Text;

            DataTable dt;
            dt = DAL.Tables.Promotioners.Select("[ID]", "User_id = " + tu.ID, "");

            string PromotionerReturn = "";
            int Promotionerresult = 0;

            if (dt == null || dt.Rows.Count == 0)
            {
                int PromotionerCount = DAL.Tables.Promotioners.GetCount("");

                if (PromotionerCount >= int.Parse(PublicFunction.GetOptionsAsString("Promotioners_LimitNum")))
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "已达到最大的联盟人数。");
                    return;
                }

                Promotionerresult = tp.Add(ref PromotionerReturn);
                if (Promotionerresult != 0)
                {
                    GoError(PromotionerReturn);
                    return;
                }
            }
            else
            {
                tp.Id = int.Parse(dt.Rows[0][0].ToString());
                Promotionerresult = tp.EditByID(ref PromotionerReturn);
                if (Promotionerresult != 0 || Return != "")
                {
                    GoError(PromotionerReturn);
                    return;
                }
            }
        }

        if (tu.ID == user.ID)
            tu.Clone(user);

        ShoveEL._Web.JavaScript.Alert(this.Page, "用户资料已经保存成功。");
    }

    protected void btnUserAccount_Click(object sender, System.EventArgs e)
    {
        if (tbID.Text == "")
        {
            GoError();
            return;
        }

        this.Response.Redirect("UserAccount.aspx?id=" + tbID.Text);
    }
}