﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_UserDistill : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserDistill";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Views.V_UserDistill.Select("", "Result = 0", "[DateTime]");
        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
    {
        int id = ShoveEL._Convert.StrToInt(((HtmlInputHidden)e.Item.FindControl("tbID")).Value, 0);
        int UserID = ShoveEL._Convert.StrToInt(((HtmlInputHidden)e.Item.FindControl("tbUserID")).Value, 0);
        double Money = Math.Round(ShoveEL._Convert.StrToDouble(((HtmlInputHidden)e.Item.FindControl("tbMoney")).Value, 0), 2);

        if (e.CommandName == "btnNoAccept")
        {
            TextBox tb = (TextBox)e.Item.FindControl("tbMemo1");
            if (tb.Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入拒绝理由。");
                return;
            }

            Users tu = new Users();
            tu.ID = UserID;
            int Result = tu.GetUserInfoByID();
            if ((Result != 0) && (Result != -3))
            {
                GoError();
                return;
            }
            string Return = "";
            Result = tu.DistillNoAccept(id, tb.Text.Trim(), user.ID, ref Return);
            if ((Return != "") || (Result != 0))
            {
                GoError(Return);
                return;
            }

            BindData();
            return;
        }

        if (e.CommandName == "btnAccept")
        {
            TextBox tb = (TextBox)e.Item.FindControl("tbMemo2");
            if (tb.Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入支付摘要。");
                return;
            }

            Users tu = new Users();
            tu.ID = UserID;
            int Result = tu.GetUserInfoByID();
            if ((Result != 0) && (Result != -3))
            {
                GoError();
                return;
            }

            if (tu.FreezeMoney < Money)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户冻结账户余额不足以提款。");
                return;
            }

            if (tu.BankCardNumber == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户没有输入银行卡号。");
                return;
            }

            double DistillCommissionScale = PublicFunction.GetOptionsAsInt("DistillCommissionScale", 0);
            if (DistillCommissionScale >= 100)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "提款手续费比例设置错误。");
                return;
            }

            string Return = "";
            Result = tu.DistillAccept(id, tu.BankName, tu.BankCardNumber, tb.Text.Trim() + "(手续费" + DistillCommissionScale.ToString() + "%已经扣除)", user.ID, ref Return);
            if ((Return != "") || (Result != 0))
            {
                GoError(Return);
                return;
            }

            if (id == user.ID)	//自己
            {
                Return = "";
                user.GetUserBalance(ref Return);
            }

            BindData();
            return;
        }

        if (e.CommandName == "btnAccept_99BillPayOut")
        {
            if (!PublicFunction.GetOptionsAsBoolean("OnlinePay_99Bill_Status_ON", false) || !PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_99Bill_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_99Bill_ON_Cert"), "SPAYC"))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "没有启用快钱支付方式，不能在线派款。");
                return;
            }

            TextBox tb = (TextBox)e.Item.FindControl("tbMemo2");
            if (tb.Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入支付摘要。");
                return;
            }

            Users tu = new Users();
            tu.ID = UserID;
            int Result = tu.GetUserInfoByID();
            if ((Result != 0) && (Result != -3))
            {
                GoError();
                return;
            }

            if (tu.FreezeMoney < Money)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户冻结账户余额不足以提款。");
                return;
            }

            if (tu.BankType == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户没有输入银行类型，不能直接派款到其银行卡。");
                return;
            }

            if (tu.BankName == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户没有输入开户行名称，不能直接派款到其银行卡。");
                return;
            }

            if (tu.BankCardNumber == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户没有输入银行卡号，不能直接派款到其银行卡。");
                return;
            }

            double OnlinePayOut_Commission = Math.Round(PublicFunction.GetOptionsAsDouble("OnlinePayOut_99Bill_Commission", 0), 2);
            if (OnlinePayOut_Commission < 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "在线派款手续费设置错误。");
                return;
            }

            Money -= OnlinePayOut_Commission;

            if (Money <= 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "派款金额太少(不足扣除手续费)。");
                return;
            }

            // 开始派款
            _99BillPayOut.BillBankAccount BillBankAccount = new _99BillPayOut.BillBankAccount();
            BillBankAccount.Amount = Money;
            BillBankAccount.BankName = tu.BankType;
            BillBankAccount.KaiHuHang = tu.BankName;
            BillBankAccount.ProvinceCity = tu.Province + tu.City;
            BillBankAccount.CreditName = tu.RealityName;
            BillBankAccount.BankCardNumber = tu.BankCardNumber;
            BillBankAccount.Description = "在线派款";
            BillBankAccount.OrderId = id.ToString();

            _99BillPayOut.BillResult Request_Value = BillBankAccount.DoDealAccount();
            Request_Value.ResultInfo = (Request_Value.ResultFlag ? "" : Request_Value.GetResultInfo(Request_Value.ResultInfo));

            // 将派款结果写入表
            DAL.Tables.UsersPayOutDetail_99Bill.Insert(id, true, Request_Value.DealCharge, true, Request_Value.DebitCharge, true, Request_Value.CreditCharge, true, Request_Value.DealId, true, Request_Value.ResultFlag, true, Request_Value.ResultInfo, true);

            // 派款成功
            if (Request_Value.ResultFlag)
            {
                string Return = "";
                Result = tu.DistillAccept(id, tu.BankName, tu.BankCardNumber, tb.Text.Trim() + "(手续费" + OnlinePayOut_Commission.ToString() + "元已经扣除)", user.ID, ref Return);
                if ((Return != "") || (Result != 0))
                {
                    GoError(Return);
                    return;
                }

                if (id == user.ID)	//自己
                {
                    Return = "";
                    user.GetUserBalance(ref Return);
                }

                BindData();
            }
            else
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "在线派款发生错误，原因：" + Request_Value.ResultInfo);
                return;
            }

            return;
        }
    }
}