﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_UserList : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserList";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Tables.Users.Select("", "", "");

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[12].FindControl("cbPrivacy");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[30].Text, true);

            cb = (CheckBox)e.Item.Cells[13].FindControl("cbBlackList");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[31].Text, true);

            cb = (CheckBox)e.Item.Cells[18].FindControl("cbManagementRights");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[32].Text, true);

            cb = (CheckBox)e.Item.Cells[19].FindControl("cbSuperManagementRights");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[33].Text, true);

            cb = (CheckBox)e.Item.Cells[26].FindControl("cbisAcceptMobileMessage");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[34].Text, true);

            cb = (CheckBox)e.Item.Cells[27].FindControl("cbisAcceptEmail");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[35].Text, true);

            cb = (CheckBox)e.Item.Cells[28].FindControl("cbisAcceptMessage");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[36].Text, true);

            e.Item.Cells[20].Text = e.Item.Cells[20].Text.Trim() == "2" ? "<font color='red'>高级</font>" : "普通";

            double money = ShoveEL._Convert.StrToDouble(e.Item.Cells[21].Text, 0);
            e.Item.Cells[21].Text = money.ToString("N");

            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[22].Text, 0);
            e.Item.Cells[22].Text = money.ToString("N");
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}