﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_UserLoginCount : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForYearMonth();
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserLoginLog";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForYearMonth()
    {
        ddlYear.Items.Clear();
        DateTime dt = DateTime.Now;
        int Year = dt.Year;
        int Month = dt.Month;

        if (Year < 2006)
        {
            btnGO.Enabled = false;
            return;
        }

        for (int i = 2006; i <= Year; i++)
            ddlYear.Items.Add(new ListItem(i.ToString() + "年", i.ToString()));
        ddlYear.SelectedIndex = ddlYear.Items.Count - 1;

        ddlMonth.SelectedIndex = Month - 1;
    }

    private void BindData()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Admin_UserLoginCount");
            
        if (dt == null)
        {
            if (ddlYear.Items.Count == 0)
                return;

            DataSet ds = DAL.Procedures.P_GetUserLoginCount.Open(ShoveEL._Convert.StrToInt(ddlYear.SelectedValue, 0), ShoveEL._Convert.StrToInt(ddlMonth.SelectedValue, 0));

            if ((ds == null) || (ds.Tables.Count < 1))
            {
                GoError();
                return;
            }

            dt = ds.Tables[0];

            ShoveEL._Web.Cache.SetCache("Admin_UserLoginCount", dt);
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void btnGO_Click(object sender, System.EventArgs e)
    {
        ShoveEL._Web.Cache.ClearCache("Admin_UserLoginCount");
        BindData();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            for (int i = 4; i <= 36; i++)
                if (ShoveEL._Convert.StrToInt(e.Item.Cells[i].Text, 0) == 0)
                    e.Item.Cells[i].Text = "";
        }
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}