﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_UserLoginLog : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserLoginLog";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Admin_UserLoginLog");

        if (dt == null)
        {
            string strCmd = "select * from V_LoginLog";
            int QueryTime = ShoveEL._Convert.StrToInt(ddlTime.SelectedValue, -1);
            bool hasWhere = false;
            if (QueryTime > 0)
            {
                hasWhere = true;
                strCmd += " where Datediff(day, LoginTime, GetDate()) <= " + QueryTime.ToString();
            }
            if (tbUserName.Text.Trim() != "")
            {
                if (hasWhere)
                    strCmd += " and [Name] = '" + tbUserName.Text.Trim() + "'";
                else
                    strCmd += " where [Name] = '" + tbUserName.Text.Trim() + "'";
            }
            strCmd += " order by LoginTime";

            dt = MSSQL.Select(strCmd);

            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Admin_UserLoginLog", dt);
        }

        g.DataSource = dt;
        g.DataBind();
        btnClear.Enabled = (dt.Rows.Count > 0);

        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            if (e.Item.Cells[7].Text == "0")
                e.Item.Cells[7].Text = "正常登录";
            else if (e.Item.Cells[7].Text == "1")
                e.Item.Cells[7].Text = "<font color='red'>密码错误</font>";
            else
                e.Item.Cells[7].Text = "其它";
        }
    }

    protected void btnGo_Click(object sender, System.EventArgs e)
    {
        ShoveEL._Web.Cache.ClearCache("Admin_UserLoginLog");
        BindData();
    }

    protected void btnClear_Click(object sender, System.EventArgs e)
    {
        string strCmd = "delete from LoginLog";
        int QueryTime = ShoveEL._Convert.StrToInt(ddlTime.SelectedValue, -1);
        bool hasWhere = false;

        if (QueryTime > 0)
        {
            hasWhere = true;
            strCmd += " where Datediff(day, LoginTime, GetDate()) <= " + QueryTime.ToString();
        }

        if (tbUserName.Text.Trim() != "")
        {
            if (hasWhere)
                strCmd += " and dbo.F_GetUserID(Name) = '" + tbUserName.Text.Trim() + "'";
            else
                strCmd += " where dbo.F_GetUserID(Name) = '" + tbUserName.Text.Trim() + "'";
        }

        if (MSSQL.ExecuteNonQuery(strCmd) < 0)
        {
            GoError();
            return;
        }

        ShoveEL._Web.Cache.ClearCache("Admin_UserLoginLog");
        BindData();
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}