﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class Admin_UserLotteryBuyRights : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        isRequestSuperManagementRights = true;
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Tables.Users.Select("[id], [Name]", "(ManagementRights = 1 and charindex('[LotteryBuy]', ManagementRightsList) >= 1) or (SuperManagementRights = 1)", "[id]");
        if (dt == null)
        {
            GoError();
            return;
        }

        lbUser.DataSource = dt;
        lbUser.DataTextField = "Name";
        lbUser.DataValueField = "id";
        lbUser.DataBind();

        if (lbUser.Items.Count > 0)
        {
            lbUser.SelectedIndex = 0;
            lbUser_SelectedIndexChanged(lbUser, new EventArgs());

            btnOK.Enabled = true;
        }
        else
        {
            btnOK.Enabled = false;
        }
    }

    protected void lbUser_SelectedIndexChanged(object sender, EventArgs e)
    {
        BindDataForLottery();
    }

    private void BindDataForLottery()
    {
        DataTable dt = DAL.Tables.Lottery.Select("[id], [Name]", "isUsed = 1", "[Sort]");
        if (dt == null)
        {
            GoError();
            return;
        }

        dlLottery.DataSource = dt;
        dlLottery.DataBind();
    }

    protected void dlLottery_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        CheckBox cb = (CheckBox)e.Item.FindControl("cb");
        TextBox tbID = (TextBox)e.Item.FindControl("tbID");

        int User_id = int.Parse(lbUser.SelectedValue);
        int Lottery_id = int.Parse(tbID.Text);

        DataTable dt = DAL.Tables.Users.Select("LotteryBuyRightsList, SuperManagementRights", "[id] = " + User_id.ToString(), "");
        if ((dt == null) || (dt.Rows.Count < 1))
        {
            GoError();
            return;
        }

        string LotteryBuyRightsList = dt.Rows[0]["LotteryBuyRightsList"].ToString();
        bool SuperManagementRights = ShoveEL._Convert.StrToBool(dt.Rows[0]["SuperManagementRights"].ToString(), false);

        //cb.Checked = (SuperManagementRights || (LotteryBuyRightsList.IndexOf("[-1]") >= 0) || (LotteryBuyRightsList.IndexOf("[" + Lottery_id.ToString() + "]") >= 0));
        cb.Checked = ((LotteryBuyRightsList.IndexOf("[-1]") >= 0) || (LotteryBuyRightsList.IndexOf("[" + Lottery_id.ToString() + "]") >= 0));
    }

    protected void btnOK_Click(object sender, EventArgs e)
    {
        int User_id = int.Parse(lbUser.SelectedValue);
        string LotteryBuyRightsList = "";

        foreach (DataListItem item in dlLottery.Items)
        {
            CheckBox cb = (CheckBox)item.FindControl("cb");
            TextBox tbID = (TextBox)item.FindControl("tbID");

            int Lottery_id = int.Parse(tbID.Text);

            if (cb.Checked)
            {
                LotteryBuyRightsList += "[" + Lottery_id.ToString() + "]";
            }
        }

        if (MSSQL.ExecuteNonQuery("update Users set LotteryBuyRightsList = @p1 where [id] = @p2",
            new MSSQL.Parameter("p1", SqlDbType.VarChar, 0, ParameterDirection.Input, LotteryBuyRightsList),
            new MSSQL.Parameter("p2", SqlDbType.Int, 0, ParameterDirection.Input, User_id)) == 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "保存成功。");
        }
        else
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "数据读写失败。");
        }
    }
}
