﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_UserManagementRights : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        isRequestSuperManagementRights = true;
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Tables.Users.Select("[id], Name, RealityName, ManagementRightsList", "ManagementRights = 1 and [id] <> 1", "[id]");
        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            string ManagementRightsList = e.Item.Cells[22].Text.Trim();

            CheckBox cb = (CheckBox)e.Item.Cells[2].FindControl("cbFillContent");
            cb.Checked = ManagementRightsList.IndexOf("[FillContent]") >= 0;
            cb = (CheckBox)e.Item.Cells[3].FindControl("cbUserList");
            cb.Checked = ManagementRightsList.IndexOf("[UserList]") >= 0;
            cb = (CheckBox)e.Item.Cells[4].FindControl("cbUserDetail");
            cb.Checked = ManagementRightsList.IndexOf("[UserDetail]") >= 0;
            cb = (CheckBox)e.Item.Cells[5].FindControl("cbUserAccount");
            cb.Checked = ManagementRightsList.IndexOf("[UserAccount]") >= 0;
            cb = (CheckBox)e.Item.Cells[6].FindControl("cbUserAddMoney");
            cb.Checked = ManagementRightsList.IndexOf("[UserAddMoney]") >= 0;
            cb = (CheckBox)e.Item.Cells[7].FindControl("cbUserQuestion");
            cb.Checked = ManagementRightsList.IndexOf("[UserQuestion]") >= 0;
            cb = (CheckBox)e.Item.Cells[8].FindControl("cbUserDistill");
            cb.Checked = ManagementRightsList.IndexOf("[UserDistill]") >= 0;
            cb = (CheckBox)e.Item.Cells[9].FindControl("cbSendMessage");
            cb.Checked = ManagementRightsList.IndexOf("[SendMessage]") >= 0;
            cb = (CheckBox)e.Item.Cells[10].FindControl("cbSendEmail");
            cb.Checked = ManagementRightsList.IndexOf("[SendEmail]") >= 0;
            cb = (CheckBox)e.Item.Cells[11].FindControl("cbSendMobileMessage");
            cb.Checked = ManagementRightsList.IndexOf("[SendMobileMessage]") >= 0;
            cb = (CheckBox)e.Item.Cells[12].FindControl("cbUserLoginLog");
            cb.Checked = ManagementRightsList.IndexOf("[UserLoginLog]") >= 0;
            cb = (CheckBox)e.Item.Cells[13].FindControl("cbLotteryIsuse");
            cb.Checked = ManagementRightsList.IndexOf("[LotteryIsuse]") >= 0;
            cb = (CheckBox)e.Item.Cells[14].FindControl("cbLotterySchemeAtTop");
            cb.Checked = ManagementRightsList.IndexOf("[LotterySchemeAtTop]") >= 0;
            cb = (CheckBox)e.Item.Cells[15].FindControl("cbLotterySchemeQuash");
            cb.Checked = ManagementRightsList.IndexOf("[LotterySchemeQuash]") >= 0;
            cb = (CheckBox)e.Item.Cells[16].FindControl("cbLotteryBuy");
            cb.Checked = ManagementRightsList.IndexOf("[LotteryBuy]") >= 0;
            cb = (CheckBox)e.Item.Cells[17].FindControl("cbLotteryWin");
            cb.Checked = ManagementRightsList.IndexOf("[LotteryWin]") >= 0;
            cb = (CheckBox)e.Item.Cells[18].FindControl("cbFinance");
            cb.Checked = ManagementRightsList.IndexOf("[Finance]") >= 0;
            cb = (CheckBox)e.Item.Cells[19].FindControl("cbPromotioner");
            cb.Checked = ManagementRightsList.IndexOf("[Promotioner]") >= 0;
            cb = (CheckBox)e.Item.Cells[20].FindControl("cbOption");
            cb.Checked = ManagementRightsList.IndexOf("[Option]") >= 0;
        }
    }

    protected void g_ItemCreated(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[2].FindControl("cbFillContent");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[3].FindControl("cbUserList");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[4].FindControl("cbUserDetail");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[5].FindControl("cbUserAccount");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[6].FindControl("cbUserAddMoney");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[7].FindControl("cbUserQuestion");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[8].FindControl("cbUserDistill");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[9].FindControl("cbSendMessage");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[10].FindControl("cbSendEmail");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[11].FindControl("cbSendMobileMessage");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[12].FindControl("cbUserLoginLog");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[13].FindControl("cbLotteryIsuse");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[14].FindControl("cbLotterySchemeAtTop");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[15].FindControl("cbLotterySchemeQuash");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[16].FindControl("cbLotteryBuy");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[17].FindControl("cbLotteryWin");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[18].FindControl("cbFinance");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[19].FindControl("cbPromotioner");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
            cb = (CheckBox)e.Item.Cells[20].FindControl("cbOption");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
        }
    }

    protected void g_ItemCheckedChanged(object sender, System.EventArgs e)
    {
        DataGridItem item = (DataGridItem)((CheckBox)sender).Parent.Parent;
        int id = ShoveEL._Convert.StrToInt(item.Cells[21].Text, -1);
        string ManagementRightsList = "";

        CheckBox cb = (CheckBox)item.Cells[2].FindControl("cbFillContent");
        if (cb.Checked)
            ManagementRightsList += "[FillContent]";
        cb = (CheckBox)item.Cells[3].FindControl("cbUserList");
        if (cb.Checked)
            ManagementRightsList += "[UserList]";
        cb = (CheckBox)item.Cells[4].FindControl("cbUserDetail");
        if (cb.Checked)
            ManagementRightsList += "[UserDetail]";
        cb = (CheckBox)item.Cells[5].FindControl("cbUserAccount");
        if (cb.Checked)
            ManagementRightsList += "[UserAccount]";
        cb = (CheckBox)item.Cells[6].FindControl("cbUserAddMoney");
        if (cb.Checked)
            ManagementRightsList += "[UserAddMoney]";
        cb = (CheckBox)item.Cells[7].FindControl("cbUserQuestion");
        if (cb.Checked)
            ManagementRightsList += "[UserQuestion]";
        cb = (CheckBox)item.Cells[8].FindControl("cbUserDistill");
        if (cb.Checked)
            ManagementRightsList += "[UserDistill]";
        cb = (CheckBox)item.Cells[9].FindControl("cbSendMessage");
        if (cb.Checked)
            ManagementRightsList += "[SendMessage]";
        cb = (CheckBox)item.Cells[10].FindControl("cbSendEmail");
        if (cb.Checked)
            ManagementRightsList += "[SendEmail]";
        cb = (CheckBox)item.Cells[11].FindControl("cbSendMobileMessage");
        if (cb.Checked)
            ManagementRightsList += "[SendMobileMessage]";
        cb = (CheckBox)item.Cells[12].FindControl("cbUserLoginLog");
        if (cb.Checked)
            ManagementRightsList += "[UserLoginLog]";
        cb = (CheckBox)item.Cells[13].FindControl("cbLotteryIsuse");
        if (cb.Checked)
            ManagementRightsList += "[LotteryIsuse]";
        cb = (CheckBox)item.Cells[14].FindControl("cbLotterySchemeAtTop");
        if (cb.Checked)
            ManagementRightsList += "[LotterySchemeAtTop]";
        cb = (CheckBox)item.Cells[15].FindControl("cbLotterySchemeQuash");
        if (cb.Checked)
            ManagementRightsList += "[LotterySchemeQuash]";
        cb = (CheckBox)item.Cells[16].FindControl("cbLotteryBuy");
        if (cb.Checked)
            ManagementRightsList += "[LotteryBuy]";
        cb = (CheckBox)item.Cells[17].FindControl("cbLotteryWin");
        if (cb.Checked)
            ManagementRightsList += "[LotteryWin]";
        cb = (CheckBox)item.Cells[18].FindControl("cbFinance");
        if (cb.Checked)
            ManagementRightsList += "[Finance]";
        cb = (CheckBox)item.Cells[19].FindControl("cbPromotioner");
        if (cb.Checked)
            ManagementRightsList += "[Promotioner]";
        cb = (CheckBox)item.Cells[20].FindControl("cbOption");
        if (cb.Checked)
            ManagementRightsList += "[Option]";

        if (MSSQL.ExecuteNonQuery("update Users set ManagementRightsList = @p1 where id = " + id.ToString(),
            new MSSQL.Parameter("p1", SqlDbType.VarChar, 0, ParameterDirection.Input, ManagementRightsList)) < 0)
        {
            GoError();
            return;
        }

        BindData();
    }
}