﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_UserMessage : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "SendMessage";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("AdminUserMessage");

        if (dt == null)
        {
            dt = DAL.Views.V_Message.Select("", "", "[DateTime] desc");
            if (dt == null)
            {
                GoError();
                return;
            }

            dt.Columns.Add("Content2", System.Type.GetType("System.String"));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                string Content = "";
                try
                {
                    Content = ShoveEL._String.Decompress((byte[])dt.Rows[i]["Content"]);
                }
                catch
                { }
                dt.Rows[i]["Content2"] = Content;
                dt.AcceptChanges();
            }

            ShoveEL._Web.Cache.SetCache("AdminUserMessage", dt);
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemCreated(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[5].FindControl("cbisShow");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
        }
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[5].FindControl("cbisShow");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[7].Text, true);
        }
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
    {
        if (e.CommandName == "Del")
        {
            int id = ShoveEL._Convert.StrToInt(e.Item.Cells[6].Text, 0);

            if (DAL.Tables.Message.Delete("id = " + id.ToString()) < 0)
            {
                GoError();
                return;
            }

            BindData();
            return;
        }
    }

    protected void g_ItemCheckedChanged(object sender, System.EventArgs e)
    {
        CheckBox cb = (CheckBox)sender;
        DataGridItem item = (DataGridItem)cb.Parent.Parent;
        int id = ShoveEL._Convert.StrToInt(item.Cells[6].Text, 0);

        if (DAL.Tables.Message.Update("id = " + id.ToString(), -1, false, -1, false, -1, false, null, false, DateTime.Now, false, cb.Checked, true) < 0)
            GoError();
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}