﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_UserQuestion : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForType();
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserQuestion";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForType()
    {
        DataTable dt = DAL.Tables.QuestionType.Select("", "", "[id]");

        if (dt == null)
        {
            GoError();
            return;
        }

        ddlType.Items.Clear();
        ddlType.Items.Add("--选择问题类型--");

        foreach(DataRow dr in dt.Rows)
            ddlType.Items.Add(dr["Type"].ToString());
    }

    private void BindData()
    {
        string CmdStr = "select * from V_Question";
        bool hasWhere = false;
        if (rb2.Checked)
        {
            CmdStr += " where Answered = 1";
            hasWhere = true;
        }
        if (rb3.Checked)
        {
            CmdStr += " where Answered = 0";
            hasWhere = true;
        }

        if (ddlType.SelectedIndex > 0)
        {
            if (!hasWhere)
                CmdStr += " where ";
            else
                CmdStr += " and ";
            CmdStr += " Type_id = " + ddlType.SelectedIndex.ToString();
        }

        CmdStr += " order by User_id, [DateTime]";

        DataTable dt = MSSQL.Select(CmdStr);

        if (dt == null)
        {
            GoError();
            return;
        }

        dt.Columns.Add("Content2", System.Type.GetType("System.String"));
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            try
            {
                dt.Rows[i]["Content2"] = ShoveEL._String.Decompress((byte[])dt.Rows[i]["Content"]);
            }
            catch
            {
                dt.Rows[i]["Content2"] = "";
            }
            dt.AcceptChanges();
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Cells[3].Text = "<a href='UserQuestionAnswer.aspx?id=" + e.Item.Cells[5].Text + "&User_id=" + e.Item.Cells[6].Text + "'>" + e.Item.Cells[3].Text + "</a>";
            CheckBox cb = (CheckBox)e.Item.Cells[4].FindControl("cbAnswered");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[7].Text, true);
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }

    protected void rb1_CheckedChanged(object sender, System.EventArgs e)
    {
        BindData();
    }
}