﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_UserQuestionAnswer : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (id < 0)
            {
                GoError();
                return;
            }
            tbID.Text = id.ToString();

            int User_id = ShoveEL._Convert.StrToInt(this.Request["User_id"], -1);
            if (User_id < 0)
            {
                GoError();
                return;
            }
            tbUserID.Text = User_id.ToString();

            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "UserQuestion";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Tables.Question.Select("", "[id]=" + tbID.Text, "");

        if ((dt == null) || (dt.Rows.Count < 1))
        {
            GoError();
            return;
        }

        tbDateTime.Text = dt.Rows[0]["DateTime"].ToString();
        tbTelphone.Text = dt.Rows[0]["Telphone"].ToString();
        try
        {
            labContent.Text = ShoveEL._Convert.ToHtmlCode(ShoveEL._String.Decompress((byte[])dt.Rows[0]["Content"]));
        }
        catch
        { }

        bool Answered = ShoveEL._Convert.StrToBool(dt.Rows[0]["Answered"].ToString(), false);
        if (Answered)
        {
            try
            {
                tbAnswer.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Answer"]);
            }
            catch
            { }
            btnAnswer.Enabled = false;
        }
    }

    protected void btnAnswer_Click(object sender, System.EventArgs e)
    {
        if ((tbUserID.Text == "") || (tbID.Text == ""))
        {
            GoError();
            return;
        }

        if (tbAnswer.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入答复内容。");
            return;
        }

        if (DAL.Tables.Question.Update("[id]=" + tbID.Text, DateTime.Now, false, -1, false, -1, false, "", false, null, false, true, true,
            DateTime.Now, true, ShoveEL._String.Compress(tbAnswer.Text), true) < 0)
        {
            GoError();
            return;
        }

        if (DAL.Tables.Message.Insert(user.ID, true, int.Parse(tbUserID.Text), true, 1, true,
            ShoveEL._String.Compress("您有问题已经被管理员答复，请到“我的问题列表”查看，谢谢。"), true, DateTime.Now, false, true, false) < 0)
        {
            GoError();
            return;
        }

        //ShoveEL._Web.JavaScript.Alert(this.Page, "问题答复成功。");
        this.Response.Redirect("UserQuestion.aspx", true);
    }
}