﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_WinAffiche : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Views.V_Scheme.Select("id,[Name],Isuse,SchemeNumber,InitiateUser,WinMoney,WinDescription,[DateTime],AtWinAffiche",
            "LotteryBuyed = 1 and WinMoney > 0", "[Name],[DateTime] desc");
        if (dt == null)
        {
            GoError();
            return;
        }

        dt.Columns.Add("WinDescription2", System.Type.GetType("System.String"));
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            try
            {
                dt.Rows[i]["WinDescription2"] = ShoveEL._String.Decompress((byte[])dt.Rows[i]["WinDescription"]);
            }
            catch
            {
                dt.Rows[i]["WinDescription2"] = dt.Rows[i]["Isuse"].ToString() + dt.Rows[i]["Isuse"].ToString();
            }
            dt.AcceptChanges();
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemCreated(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[7].FindControl("cbAtWinAffiche");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
        }
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[7].FindControl("cbAtWinAffiche");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[9].Text, true);
        }
    }

    protected void g_ItemCheckedChanged(object sender, System.EventArgs e)
    {
        CheckBox cb = (CheckBox)sender;
        DataGridItem item = (DataGridItem)cb.Parent.Parent;

        int id = ShoveEL._Convert.StrToInt(item.Cells[8].Text, 0);
        bool AtWinAffiche = cb.Checked;
        
        if (MSSQL.ExecuteNonQuery("update Scheme set AtWinAffiche = " + (AtWinAffiche ? "1" : "0") + " where id = " + id.ToString()) < 0)
        {
            GoError();
            return;
        }

        //BindData();
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}