﻿using System;
using System.Data;
using System.Data.SqlClient;

public class AdminPage : System.Web.UI.Page
{
    public Users user;
    public string RequestManagementRightsType;
    public bool isRequestSuperManagementRights;

    public AdminPage()
    {
        RequestManagementRightsType = "";
        isRequestSuperManagementRights = false;
    }

    override protected void OnLoad(EventArgs e)
    {
        user = Users.GetSessionUser();

        if (user == null)
        {
            this.Response.Redirect("../Error2.aspx?ErrorNumber=02", true);
            return;
        }

        if (!user.ManagementRights)
        {
            this.Response.Redirect("../Error.aspx?ErrorNumber=03", true);
            return;
        }

        if (isRequestSuperManagementRights && !user.SuperManagementRights)
        {
            GoError("此功能需要超级管理权限。");
            return;
        }

        //需要明细管理权限
        if (RequestManagementRightsType.Trim() != "")
        {
            if (user.ManagementRightsList.IndexOf("[" + RequestManagementRightsType + "]") < 0)
                GoError("管理权限不足。");
        }

        base.OnLoad(e);
    }

    public void GoError()
    {
        Response.Redirect("../Error2.aspx?ErrorNumber=01", true);
    }

    public void GoError(string Tip)
    {
        Response.Redirect("../Error2.aspx?ErrorNumber=01&Tip=" + Tip.Trim(), true);
    }
}