﻿using System;
using System.Data;
using ShoveEL.Database;

namespace DAL
{
    /*
    Program Name: ShoveDAL
    Program Version: 1.0
    Writer By: 7ien.shovesoft.shove (zhou changjun)
    Release Time: 2007.2.4

    System Request: ShoveEL.dll
    All Rights saved.
    */


    // Please Add a Key in Web.config File's appSetting section, Exemple:
    // <add key="ConnectionString" value="server=(local);User id=shove;Pwd=;Database=ShoveLottery" />


    public class Tables
    {
        public class Banks
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Banks]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int id, bool isInsertid, string Name, bool isInsertName, int Sort, bool isInsertSort)
            {
                string CommandText = "insert into [Banks] (";
                string InsertFieldsList = "";

                if (isInsertid)
                    InsertFieldsList += "[id], ";
                if (isInsertName)
                    InsertFieldsList += "[Name], ";
                if (isInsertSort)
                    InsertFieldsList += "[Sort], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertid)
                    InsertValuesList += "@id, ";
                if (isInsertName)
                    InsertValuesList += "@Name, ";
                if (isInsertSort)
                    InsertValuesList += "@Sort, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isInsertName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isInsertSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort)
                    );
            }

            public static int Update(string Condition, int id, bool isUpdateid, string Name, bool isUpdateName, int Sort, bool isUpdateSort)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Banks] set ";
                string UpdateFieldsList = "";

                if (isUpdateid)
                    UpdateFieldsList += "[id] = @id, ";
                if (isUpdateName)
                    UpdateFieldsList += "[Name] = @Name, ";
                if (isUpdateSort)
                    UpdateFieldsList += "[Sort] = @Sort, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isUpdateName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isUpdateSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Banks]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Banks]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_admin
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_admin]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string admin, bool isInsertadmin, string username, bool isInsertusername, string password, bool isInsertpassword, DateTime lasttime, bool isInsertlasttime, int logins, bool isInsertlogins, string lastip, bool isInsertlastip, DateTime addtime, bool isInsertaddtime)
            {
                string CommandText = "insert into [bbs_admin] (";
                string InsertFieldsList = "";

                if (isInsertadmin)
                    InsertFieldsList += "[admin], ";
                if (isInsertusername)
                    InsertFieldsList += "[username], ";
                if (isInsertpassword)
                    InsertFieldsList += "[password], ";
                if (isInsertlasttime)
                    InsertFieldsList += "[lasttime], ";
                if (isInsertlogins)
                    InsertFieldsList += "[logins], ";
                if (isInsertlastip)
                    InsertFieldsList += "[lastip], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertadmin)
                    InsertValuesList += "@admin, ";
                if (isInsertusername)
                    InsertValuesList += "@username, ";
                if (isInsertpassword)
                    InsertValuesList += "@password, ";
                if (isInsertlasttime)
                    InsertValuesList += "@lasttime, ";
                if (isInsertlogins)
                    InsertValuesList += "@logins, ";
                if (isInsertlastip)
                    InsertValuesList += "@lastip, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertadmin ? null : new MSSQL.Parameter("admin", SqlDbType.NVarChar, 0, ParameterDirection.Input, admin),
                    !isInsertusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isInsertpassword ? null : new MSSQL.Parameter("password", SqlDbType.NVarChar, 0, ParameterDirection.Input, password),
                    !isInsertlasttime ? null : new MSSQL.Parameter("lasttime", SqlDbType.DateTime, 0, ParameterDirection.Input, lasttime),
                    !isInsertlogins ? null : new MSSQL.Parameter("logins", SqlDbType.Int, 0, ParameterDirection.Input, logins),
                    !isInsertlastip ? null : new MSSQL.Parameter("lastip", SqlDbType.NVarChar, 0, ParameterDirection.Input, lastip),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime)
                    );
            }

            public static int Update(string Condition, string admin, bool isUpdateadmin, string username, bool isUpdateusername, string password, bool isUpdatepassword, DateTime lasttime, bool isUpdatelasttime, int logins, bool isUpdatelogins, string lastip, bool isUpdatelastip, DateTime addtime, bool isUpdateaddtime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_admin] set ";
                string UpdateFieldsList = "";

                if (isUpdateadmin)
                    UpdateFieldsList += "[admin] = @admin, ";
                if (isUpdateusername)
                    UpdateFieldsList += "[username] = @username, ";
                if (isUpdatepassword)
                    UpdateFieldsList += "[password] = @password, ";
                if (isUpdatelasttime)
                    UpdateFieldsList += "[lasttime] = @lasttime, ";
                if (isUpdatelogins)
                    UpdateFieldsList += "[logins] = @logins, ";
                if (isUpdatelastip)
                    UpdateFieldsList += "[lastip] = @lastip, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateadmin ? null : new MSSQL.Parameter("admin", SqlDbType.NVarChar, 0, ParameterDirection.Input, admin),
                    !isUpdateusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isUpdatepassword ? null : new MSSQL.Parameter("password", SqlDbType.NVarChar, 0, ParameterDirection.Input, password),
                    !isUpdatelasttime ? null : new MSSQL.Parameter("lasttime", SqlDbType.DateTime, 0, ParameterDirection.Input, lasttime),
                    !isUpdatelogins ? null : new MSSQL.Parameter("logins", SqlDbType.Int, 0, ParameterDirection.Input, logins),
                    !isUpdatelastip ? null : new MSSQL.Parameter("lastip", SqlDbType.NVarChar, 0, ParameterDirection.Input, lastip),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_admin]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_admin]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_attach
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_attach]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int replyid, bool isInsertreplyid, int topicid, bool isInserttopicid, int boardid, bool isInsertboardid, string name, bool isInsertname, string attachname, bool isInsertattachname, string attachpath, bool isInsertattachpath, int attachtype, bool isInsertattachtype, int attachsize, bool isInsertattachsize, int downs, bool isInsertdowns, int downloadrequire, bool isInsertdownloadrequire, DateTime uploadtime, bool isInsertuploadtime)
            {
                string CommandText = "insert into [bbs_attach] (";
                string InsertFieldsList = "";

                if (isInsertreplyid)
                    InsertFieldsList += "[replyid], ";
                if (isInserttopicid)
                    InsertFieldsList += "[topicid], ";
                if (isInsertboardid)
                    InsertFieldsList += "[boardid], ";
                if (isInsertname)
                    InsertFieldsList += "[name], ";
                if (isInsertattachname)
                    InsertFieldsList += "[attachname], ";
                if (isInsertattachpath)
                    InsertFieldsList += "[attachpath], ";
                if (isInsertattachtype)
                    InsertFieldsList += "[attachtype], ";
                if (isInsertattachsize)
                    InsertFieldsList += "[attachsize], ";
                if (isInsertdowns)
                    InsertFieldsList += "[downs], ";
                if (isInsertdownloadrequire)
                    InsertFieldsList += "[downloadrequire], ";
                if (isInsertuploadtime)
                    InsertFieldsList += "[uploadtime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertreplyid)
                    InsertValuesList += "@replyid, ";
                if (isInserttopicid)
                    InsertValuesList += "@topicid, ";
                if (isInsertboardid)
                    InsertValuesList += "@boardid, ";
                if (isInsertname)
                    InsertValuesList += "@name, ";
                if (isInsertattachname)
                    InsertValuesList += "@attachname, ";
                if (isInsertattachpath)
                    InsertValuesList += "@attachpath, ";
                if (isInsertattachtype)
                    InsertValuesList += "@attachtype, ";
                if (isInsertattachsize)
                    InsertValuesList += "@attachsize, ";
                if (isInsertdowns)
                    InsertValuesList += "@downs, ";
                if (isInsertdownloadrequire)
                    InsertValuesList += "@downloadrequire, ";
                if (isInsertuploadtime)
                    InsertValuesList += "@uploadtime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertreplyid ? null : new MSSQL.Parameter("replyid", SqlDbType.Int, 0, ParameterDirection.Input, replyid),
                    !isInserttopicid ? null : new MSSQL.Parameter("topicid", SqlDbType.Int, 0, ParameterDirection.Input, topicid),
                    !isInsertboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    !isInsertname ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isInsertattachname ? null : new MSSQL.Parameter("attachname", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachname),
                    !isInsertattachpath ? null : new MSSQL.Parameter("attachpath", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachpath),
                    !isInsertattachtype ? null : new MSSQL.Parameter("attachtype", SqlDbType.Int, 0, ParameterDirection.Input, attachtype),
                    !isInsertattachsize ? null : new MSSQL.Parameter("attachsize", SqlDbType.Int, 0, ParameterDirection.Input, attachsize),
                    !isInsertdowns ? null : new MSSQL.Parameter("downs", SqlDbType.Int, 0, ParameterDirection.Input, downs),
                    !isInsertdownloadrequire ? null : new MSSQL.Parameter("downloadrequire", SqlDbType.Int, 0, ParameterDirection.Input, downloadrequire),
                    !isInsertuploadtime ? null : new MSSQL.Parameter("uploadtime", SqlDbType.DateTime, 0, ParameterDirection.Input, uploadtime)
                    );
            }

            public static int Update(string Condition, int replyid, bool isUpdatereplyid, int topicid, bool isUpdatetopicid, int boardid, bool isUpdateboardid, string name, bool isUpdatename, string attachname, bool isUpdateattachname, string attachpath, bool isUpdateattachpath, int attachtype, bool isUpdateattachtype, int attachsize, bool isUpdateattachsize, int downs, bool isUpdatedowns, int downloadrequire, bool isUpdatedownloadrequire, DateTime uploadtime, bool isUpdateuploadtime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_attach] set ";
                string UpdateFieldsList = "";

                if (isUpdatereplyid)
                    UpdateFieldsList += "[replyid] = @replyid, ";
                if (isUpdatetopicid)
                    UpdateFieldsList += "[topicid] = @topicid, ";
                if (isUpdateboardid)
                    UpdateFieldsList += "[boardid] = @boardid, ";
                if (isUpdatename)
                    UpdateFieldsList += "[name] = @name, ";
                if (isUpdateattachname)
                    UpdateFieldsList += "[attachname] = @attachname, ";
                if (isUpdateattachpath)
                    UpdateFieldsList += "[attachpath] = @attachpath, ";
                if (isUpdateattachtype)
                    UpdateFieldsList += "[attachtype] = @attachtype, ";
                if (isUpdateattachsize)
                    UpdateFieldsList += "[attachsize] = @attachsize, ";
                if (isUpdatedowns)
                    UpdateFieldsList += "[downs] = @downs, ";
                if (isUpdatedownloadrequire)
                    UpdateFieldsList += "[downloadrequire] = @downloadrequire, ";
                if (isUpdateuploadtime)
                    UpdateFieldsList += "[uploadtime] = @uploadtime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatereplyid ? null : new MSSQL.Parameter("replyid", SqlDbType.Int, 0, ParameterDirection.Input, replyid),
                    !isUpdatetopicid ? null : new MSSQL.Parameter("topicid", SqlDbType.Int, 0, ParameterDirection.Input, topicid),
                    !isUpdateboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    !isUpdatename ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isUpdateattachname ? null : new MSSQL.Parameter("attachname", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachname),
                    !isUpdateattachpath ? null : new MSSQL.Parameter("attachpath", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachpath),
                    !isUpdateattachtype ? null : new MSSQL.Parameter("attachtype", SqlDbType.Int, 0, ParameterDirection.Input, attachtype),
                    !isUpdateattachsize ? null : new MSSQL.Parameter("attachsize", SqlDbType.Int, 0, ParameterDirection.Input, attachsize),
                    !isUpdatedowns ? null : new MSSQL.Parameter("downs", SqlDbType.Int, 0, ParameterDirection.Input, downs),
                    !isUpdatedownloadrequire ? null : new MSSQL.Parameter("downloadrequire", SqlDbType.Int, 0, ParameterDirection.Input, downloadrequire),
                    !isUpdateuploadtime ? null : new MSSQL.Parameter("uploadtime", SqlDbType.DateTime, 0, ParameterDirection.Input, uploadtime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_attach]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_attach]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_board
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_board]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int categoryid, bool isInsertcategoryid, int sortid, bool isInsertsortid, string boardname, bool isInsertboardname, string subject, bool isInsertsubject, string logo, bool isInsertlogo, string admins, bool isInsertadmins, int browserequire, bool isInsertbrowserequire, int topicrequire, bool isInserttopicrequire, int replyrequire, bool isInsertreplyrequire, int topics, bool isInserttopics, int lasttopicid, bool isInsertlasttopicid, string lasttopictitle, bool isInsertlasttopictitle, DateTime lasttopictime, bool isInsertlasttopictime, string lasttopicuser, bool isInsertlasttopicuser, int parentid, bool isInsertparentid, int parentsortid, bool isInsertparentsortid, int childboards, bool isInsertchildboards, int replies, bool isInsertreplies, string announce, bool isInsertannounce)
            {
                string CommandText = "insert into [bbs_board] (";
                string InsertFieldsList = "";

                if (isInsertcategoryid)
                    InsertFieldsList += "[categoryid], ";
                if (isInsertsortid)
                    InsertFieldsList += "[sortid], ";
                if (isInsertboardname)
                    InsertFieldsList += "[boardname], ";
                if (isInsertsubject)
                    InsertFieldsList += "[subject], ";
                if (isInsertlogo)
                    InsertFieldsList += "[logo], ";
                if (isInsertadmins)
                    InsertFieldsList += "[admins], ";
                if (isInsertbrowserequire)
                    InsertFieldsList += "[browserequire], ";
                if (isInserttopicrequire)
                    InsertFieldsList += "[topicrequire], ";
                if (isInsertreplyrequire)
                    InsertFieldsList += "[replyrequire], ";
                if (isInserttopics)
                    InsertFieldsList += "[topics], ";
                if (isInsertlasttopicid)
                    InsertFieldsList += "[lasttopicid], ";
                if (isInsertlasttopictitle)
                    InsertFieldsList += "[lasttopictitle], ";
                if (isInsertlasttopictime)
                    InsertFieldsList += "[lasttopictime], ";
                if (isInsertlasttopicuser)
                    InsertFieldsList += "[lasttopicuser], ";
                if (isInsertparentid)
                    InsertFieldsList += "[parentid], ";
                if (isInsertparentsortid)
                    InsertFieldsList += "[parentsortid], ";
                if (isInsertchildboards)
                    InsertFieldsList += "[childboards], ";
                if (isInsertreplies)
                    InsertFieldsList += "[replies], ";
                if (isInsertannounce)
                    InsertFieldsList += "[announce], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertcategoryid)
                    InsertValuesList += "@categoryid, ";
                if (isInsertsortid)
                    InsertValuesList += "@sortid, ";
                if (isInsertboardname)
                    InsertValuesList += "@boardname, ";
                if (isInsertsubject)
                    InsertValuesList += "@subject, ";
                if (isInsertlogo)
                    InsertValuesList += "@logo, ";
                if (isInsertadmins)
                    InsertValuesList += "@admins, ";
                if (isInsertbrowserequire)
                    InsertValuesList += "@browserequire, ";
                if (isInserttopicrequire)
                    InsertValuesList += "@topicrequire, ";
                if (isInsertreplyrequire)
                    InsertValuesList += "@replyrequire, ";
                if (isInserttopics)
                    InsertValuesList += "@topics, ";
                if (isInsertlasttopicid)
                    InsertValuesList += "@lasttopicid, ";
                if (isInsertlasttopictitle)
                    InsertValuesList += "@lasttopictitle, ";
                if (isInsertlasttopictime)
                    InsertValuesList += "@lasttopictime, ";
                if (isInsertlasttopicuser)
                    InsertValuesList += "@lasttopicuser, ";
                if (isInsertparentid)
                    InsertValuesList += "@parentid, ";
                if (isInsertparentsortid)
                    InsertValuesList += "@parentsortid, ";
                if (isInsertchildboards)
                    InsertValuesList += "@childboards, ";
                if (isInsertreplies)
                    InsertValuesList += "@replies, ";
                if (isInsertannounce)
                    InsertValuesList += "@announce, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertcategoryid ? null : new MSSQL.Parameter("categoryid", SqlDbType.Int, 0, ParameterDirection.Input, categoryid),
                    !isInsertsortid ? null : new MSSQL.Parameter("sortid", SqlDbType.Int, 0, ParameterDirection.Input, sortid),
                    !isInsertboardname ? null : new MSSQL.Parameter("boardname", SqlDbType.NVarChar, 0, ParameterDirection.Input, boardname),
                    !isInsertsubject ? null : new MSSQL.Parameter("subject", SqlDbType.NVarChar, 0, ParameterDirection.Input, subject),
                    !isInsertlogo ? null : new MSSQL.Parameter("logo", SqlDbType.NVarChar, 0, ParameterDirection.Input, logo),
                    !isInsertadmins ? null : new MSSQL.Parameter("admins", SqlDbType.NVarChar, 0, ParameterDirection.Input, admins),
                    !isInsertbrowserequire ? null : new MSSQL.Parameter("browserequire", SqlDbType.Int, 0, ParameterDirection.Input, browserequire),
                    !isInserttopicrequire ? null : new MSSQL.Parameter("topicrequire", SqlDbType.Int, 0, ParameterDirection.Input, topicrequire),
                    !isInsertreplyrequire ? null : new MSSQL.Parameter("replyrequire", SqlDbType.Int, 0, ParameterDirection.Input, replyrequire),
                    !isInserttopics ? null : new MSSQL.Parameter("topics", SqlDbType.Int, 0, ParameterDirection.Input, topics),
                    !isInsertlasttopicid ? null : new MSSQL.Parameter("lasttopicid", SqlDbType.Int, 0, ParameterDirection.Input, lasttopicid),
                    !isInsertlasttopictitle ? null : new MSSQL.Parameter("lasttopictitle", SqlDbType.NVarChar, 0, ParameterDirection.Input, lasttopictitle),
                    !isInsertlasttopictime ? null : new MSSQL.Parameter("lasttopictime", SqlDbType.DateTime, 0, ParameterDirection.Input, lasttopictime),
                    !isInsertlasttopicuser ? null : new MSSQL.Parameter("lasttopicuser", SqlDbType.NVarChar, 0, ParameterDirection.Input, lasttopicuser),
                    !isInsertparentid ? null : new MSSQL.Parameter("parentid", SqlDbType.Int, 0, ParameterDirection.Input, parentid),
                    !isInsertparentsortid ? null : new MSSQL.Parameter("parentsortid", SqlDbType.Int, 0, ParameterDirection.Input, parentsortid),
                    !isInsertchildboards ? null : new MSSQL.Parameter("childboards", SqlDbType.Int, 0, ParameterDirection.Input, childboards),
                    !isInsertreplies ? null : new MSSQL.Parameter("replies", SqlDbType.Int, 0, ParameterDirection.Input, replies),
                    !isInsertannounce ? null : new MSSQL.Parameter("announce", SqlDbType.NText, 0, ParameterDirection.Input, announce)
                    );
            }

            public static int Update(string Condition, int categoryid, bool isUpdatecategoryid, int sortid, bool isUpdatesortid, string boardname, bool isUpdateboardname, string subject, bool isUpdatesubject, string logo, bool isUpdatelogo, string admins, bool isUpdateadmins, int browserequire, bool isUpdatebrowserequire, int topicrequire, bool isUpdatetopicrequire, int replyrequire, bool isUpdatereplyrequire, int topics, bool isUpdatetopics, int lasttopicid, bool isUpdatelasttopicid, string lasttopictitle, bool isUpdatelasttopictitle, DateTime lasttopictime, bool isUpdatelasttopictime, string lasttopicuser, bool isUpdatelasttopicuser, int parentid, bool isUpdateparentid, int parentsortid, bool isUpdateparentsortid, int childboards, bool isUpdatechildboards, int replies, bool isUpdatereplies, string announce, bool isUpdateannounce)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_board] set ";
                string UpdateFieldsList = "";

                if (isUpdatecategoryid)
                    UpdateFieldsList += "[categoryid] = @categoryid, ";
                if (isUpdatesortid)
                    UpdateFieldsList += "[sortid] = @sortid, ";
                if (isUpdateboardname)
                    UpdateFieldsList += "[boardname] = @boardname, ";
                if (isUpdatesubject)
                    UpdateFieldsList += "[subject] = @subject, ";
                if (isUpdatelogo)
                    UpdateFieldsList += "[logo] = @logo, ";
                if (isUpdateadmins)
                    UpdateFieldsList += "[admins] = @admins, ";
                if (isUpdatebrowserequire)
                    UpdateFieldsList += "[browserequire] = @browserequire, ";
                if (isUpdatetopicrequire)
                    UpdateFieldsList += "[topicrequire] = @topicrequire, ";
                if (isUpdatereplyrequire)
                    UpdateFieldsList += "[replyrequire] = @replyrequire, ";
                if (isUpdatetopics)
                    UpdateFieldsList += "[topics] = @topics, ";
                if (isUpdatelasttopicid)
                    UpdateFieldsList += "[lasttopicid] = @lasttopicid, ";
                if (isUpdatelasttopictitle)
                    UpdateFieldsList += "[lasttopictitle] = @lasttopictitle, ";
                if (isUpdatelasttopictime)
                    UpdateFieldsList += "[lasttopictime] = @lasttopictime, ";
                if (isUpdatelasttopicuser)
                    UpdateFieldsList += "[lasttopicuser] = @lasttopicuser, ";
                if (isUpdateparentid)
                    UpdateFieldsList += "[parentid] = @parentid, ";
                if (isUpdateparentsortid)
                    UpdateFieldsList += "[parentsortid] = @parentsortid, ";
                if (isUpdatechildboards)
                    UpdateFieldsList += "[childboards] = @childboards, ";
                if (isUpdatereplies)
                    UpdateFieldsList += "[replies] = @replies, ";
                if (isUpdateannounce)
                    UpdateFieldsList += "[announce] = @announce, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatecategoryid ? null : new MSSQL.Parameter("categoryid", SqlDbType.Int, 0, ParameterDirection.Input, categoryid),
                    !isUpdatesortid ? null : new MSSQL.Parameter("sortid", SqlDbType.Int, 0, ParameterDirection.Input, sortid),
                    !isUpdateboardname ? null : new MSSQL.Parameter("boardname", SqlDbType.NVarChar, 0, ParameterDirection.Input, boardname),
                    !isUpdatesubject ? null : new MSSQL.Parameter("subject", SqlDbType.NVarChar, 0, ParameterDirection.Input, subject),
                    !isUpdatelogo ? null : new MSSQL.Parameter("logo", SqlDbType.NVarChar, 0, ParameterDirection.Input, logo),
                    !isUpdateadmins ? null : new MSSQL.Parameter("admins", SqlDbType.NVarChar, 0, ParameterDirection.Input, admins),
                    !isUpdatebrowserequire ? null : new MSSQL.Parameter("browserequire", SqlDbType.Int, 0, ParameterDirection.Input, browserequire),
                    !isUpdatetopicrequire ? null : new MSSQL.Parameter("topicrequire", SqlDbType.Int, 0, ParameterDirection.Input, topicrequire),
                    !isUpdatereplyrequire ? null : new MSSQL.Parameter("replyrequire", SqlDbType.Int, 0, ParameterDirection.Input, replyrequire),
                    !isUpdatetopics ? null : new MSSQL.Parameter("topics", SqlDbType.Int, 0, ParameterDirection.Input, topics),
                    !isUpdatelasttopicid ? null : new MSSQL.Parameter("lasttopicid", SqlDbType.Int, 0, ParameterDirection.Input, lasttopicid),
                    !isUpdatelasttopictitle ? null : new MSSQL.Parameter("lasttopictitle", SqlDbType.NVarChar, 0, ParameterDirection.Input, lasttopictitle),
                    !isUpdatelasttopictime ? null : new MSSQL.Parameter("lasttopictime", SqlDbType.DateTime, 0, ParameterDirection.Input, lasttopictime),
                    !isUpdatelasttopicuser ? null : new MSSQL.Parameter("lasttopicuser", SqlDbType.NVarChar, 0, ParameterDirection.Input, lasttopicuser),
                    !isUpdateparentid ? null : new MSSQL.Parameter("parentid", SqlDbType.Int, 0, ParameterDirection.Input, parentid),
                    !isUpdateparentsortid ? null : new MSSQL.Parameter("parentsortid", SqlDbType.Int, 0, ParameterDirection.Input, parentsortid),
                    !isUpdatechildboards ? null : new MSSQL.Parameter("childboards", SqlDbType.Int, 0, ParameterDirection.Input, childboards),
                    !isUpdatereplies ? null : new MSSQL.Parameter("replies", SqlDbType.Int, 0, ParameterDirection.Input, replies),
                    !isUpdateannounce ? null : new MSSQL.Parameter("announce", SqlDbType.NText, 0, ParameterDirection.Input, announce)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_board]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_board]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_board_role
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_board_role]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int roleid, bool isInsertroleid, int boardid, bool isInsertboardid, string strategy, bool isInsertstrategy)
            {
                string CommandText = "insert into [bbs_board_role] (";
                string InsertFieldsList = "";

                if (isInsertroleid)
                    InsertFieldsList += "[roleid], ";
                if (isInsertboardid)
                    InsertFieldsList += "[boardid], ";
                if (isInsertstrategy)
                    InsertFieldsList += "[strategy], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertroleid)
                    InsertValuesList += "@roleid, ";
                if (isInsertboardid)
                    InsertValuesList += "@boardid, ";
                if (isInsertstrategy)
                    InsertValuesList += "@strategy, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertroleid ? null : new MSSQL.Parameter("roleid", SqlDbType.Int, 0, ParameterDirection.Input, roleid),
                    !isInsertboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    !isInsertstrategy ? null : new MSSQL.Parameter("strategy", SqlDbType.NVarChar, 0, ParameterDirection.Input, strategy)
                    );
            }

            public static int Update(string Condition, int roleid, bool isUpdateroleid, int boardid, bool isUpdateboardid, string strategy, bool isUpdatestrategy)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_board_role] set ";
                string UpdateFieldsList = "";

                if (isUpdateroleid)
                    UpdateFieldsList += "[roleid] = @roleid, ";
                if (isUpdateboardid)
                    UpdateFieldsList += "[boardid] = @boardid, ";
                if (isUpdatestrategy)
                    UpdateFieldsList += "[strategy] = @strategy, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateroleid ? null : new MSSQL.Parameter("roleid", SqlDbType.Int, 0, ParameterDirection.Input, roleid),
                    !isUpdateboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    !isUpdatestrategy ? null : new MSSQL.Parameter("strategy", SqlDbType.NVarChar, 0, ParameterDirection.Input, strategy)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_board_role]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_board_role]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_category
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_category]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string categoryname, bool isInsertcategoryname, int sortid, bool isInsertsortid)
            {
                string CommandText = "insert into [bbs_category] (";
                string InsertFieldsList = "";

                if (isInsertcategoryname)
                    InsertFieldsList += "[categoryname], ";
                if (isInsertsortid)
                    InsertFieldsList += "[sortid], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertcategoryname)
                    InsertValuesList += "@categoryname, ";
                if (isInsertsortid)
                    InsertValuesList += "@sortid, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertcategoryname ? null : new MSSQL.Parameter("categoryname", SqlDbType.NVarChar, 0, ParameterDirection.Input, categoryname),
                    !isInsertsortid ? null : new MSSQL.Parameter("sortid", SqlDbType.Int, 0, ParameterDirection.Input, sortid)
                    );
            }

            public static int Update(string Condition, string categoryname, bool isUpdatecategoryname, int sortid, bool isUpdatesortid)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_category] set ";
                string UpdateFieldsList = "";

                if (isUpdatecategoryname)
                    UpdateFieldsList += "[categoryname] = @categoryname, ";
                if (isUpdatesortid)
                    UpdateFieldsList += "[sortid] = @sortid, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatecategoryname ? null : new MSSQL.Parameter("categoryname", SqlDbType.NVarChar, 0, ParameterDirection.Input, categoryname),
                    !isUpdatesortid ? null : new MSSQL.Parameter("sortid", SqlDbType.Int, 0, ParameterDirection.Input, sortid)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_category]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_category]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_class
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_class]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string classname, bool isInsertclassname, string description, bool isInsertdescription, int boardid, bool isInsertboardid)
            {
                string CommandText = "insert into [bbs_class] (";
                string InsertFieldsList = "";

                if (isInsertclassname)
                    InsertFieldsList += "[classname], ";
                if (isInsertdescription)
                    InsertFieldsList += "[description], ";
                if (isInsertboardid)
                    InsertFieldsList += "[boardid], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertclassname)
                    InsertValuesList += "@classname, ";
                if (isInsertdescription)
                    InsertValuesList += "@description, ";
                if (isInsertboardid)
                    InsertValuesList += "@boardid, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertclassname ? null : new MSSQL.Parameter("classname", SqlDbType.NVarChar, 0, ParameterDirection.Input, classname),
                    !isInsertdescription ? null : new MSSQL.Parameter("description", SqlDbType.NVarChar, 0, ParameterDirection.Input, description),
                    !isInsertboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid)
                    );
            }

            public static int Update(string Condition, string classname, bool isUpdateclassname, string description, bool isUpdatedescription, int boardid, bool isUpdateboardid)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_class] set ";
                string UpdateFieldsList = "";

                if (isUpdateclassname)
                    UpdateFieldsList += "[classname] = @classname, ";
                if (isUpdatedescription)
                    UpdateFieldsList += "[description] = @description, ";
                if (isUpdateboardid)
                    UpdateFieldsList += "[boardid] = @boardid, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateclassname ? null : new MSSQL.Parameter("classname", SqlDbType.NVarChar, 0, ParameterDirection.Input, classname),
                    !isUpdatedescription ? null : new MSSQL.Parameter("description", SqlDbType.NVarChar, 0, ParameterDirection.Input, description),
                    !isUpdateboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_class]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_class]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_consume
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_consume]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string username, bool isInsertusername, int type, bool isInserttype, int productid, bool isInsertproductid, int money, bool isInsertmoney, DateTime addtime, bool isInsertaddtime, DateTime expire, bool isInsertexpire, string ip, bool isInsertip)
            {
                string CommandText = "insert into [bbs_consume] (";
                string InsertFieldsList = "";

                if (isInsertusername)
                    InsertFieldsList += "[username], ";
                if (isInserttype)
                    InsertFieldsList += "[type], ";
                if (isInsertproductid)
                    InsertFieldsList += "[productid], ";
                if (isInsertmoney)
                    InsertFieldsList += "[money], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";
                if (isInsertexpire)
                    InsertFieldsList += "[expire], ";
                if (isInsertip)
                    InsertFieldsList += "[ip], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertusername)
                    InsertValuesList += "@username, ";
                if (isInserttype)
                    InsertValuesList += "@type, ";
                if (isInsertproductid)
                    InsertValuesList += "@productid, ";
                if (isInsertmoney)
                    InsertValuesList += "@money, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";
                if (isInsertexpire)
                    InsertValuesList += "@expire, ";
                if (isInsertip)
                    InsertValuesList += "@ip, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isInserttype ? null : new MSSQL.Parameter("type", SqlDbType.Int, 0, ParameterDirection.Input, type),
                    !isInsertproductid ? null : new MSSQL.Parameter("productid", SqlDbType.Int, 0, ParameterDirection.Input, productid),
                    !isInsertmoney ? null : new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isInsertexpire ? null : new MSSQL.Parameter("expire", SqlDbType.DateTime, 0, ParameterDirection.Input, expire),
                    !isInsertip ? null : new MSSQL.Parameter("ip", SqlDbType.NVarChar, 0, ParameterDirection.Input, ip)
                    );
            }

            public static int Update(string Condition, string username, bool isUpdateusername, int type, bool isUpdatetype, int productid, bool isUpdateproductid, int money, bool isUpdatemoney, DateTime addtime, bool isUpdateaddtime, DateTime expire, bool isUpdateexpire, string ip, bool isUpdateip)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_consume] set ";
                string UpdateFieldsList = "";

                if (isUpdateusername)
                    UpdateFieldsList += "[username] = @username, ";
                if (isUpdatetype)
                    UpdateFieldsList += "[type] = @type, ";
                if (isUpdateproductid)
                    UpdateFieldsList += "[productid] = @productid, ";
                if (isUpdatemoney)
                    UpdateFieldsList += "[money] = @money, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";
                if (isUpdateexpire)
                    UpdateFieldsList += "[expire] = @expire, ";
                if (isUpdateip)
                    UpdateFieldsList += "[ip] = @ip, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isUpdatetype ? null : new MSSQL.Parameter("type", SqlDbType.Int, 0, ParameterDirection.Input, type),
                    !isUpdateproductid ? null : new MSSQL.Parameter("productid", SqlDbType.Int, 0, ParameterDirection.Input, productid),
                    !isUpdatemoney ? null : new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isUpdateexpire ? null : new MSSQL.Parameter("expire", SqlDbType.DateTime, 0, ParameterDirection.Input, expire),
                    !isUpdateip ? null : new MSSQL.Parameter("ip", SqlDbType.NVarChar, 0, ParameterDirection.Input, ip)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_consume]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_consume]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_exexp
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_exexp]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string username, bool isInsertusername, int ExExp1, bool isInsertExExp1, int ExExp2, bool isInsertExExp2, int ExExp3, bool isInsertExExp3, int ExExp4, bool isInsertExExp4, int ExExp5, bool isInsertExExp5, int ExExp6, bool isInsertExExp6, int ExExp7, bool isInsertExExp7, int ExExp8, bool isInsertExExp8, int ExExp9, bool isInsertExExp9, int ExExp10, bool isInsertExExp10)
            {
                string CommandText = "insert into [bbs_exexp] (";
                string InsertFieldsList = "";

                if (isInsertusername)
                    InsertFieldsList += "[username], ";
                if (isInsertExExp1)
                    InsertFieldsList += "[ExExp1], ";
                if (isInsertExExp2)
                    InsertFieldsList += "[ExExp2], ";
                if (isInsertExExp3)
                    InsertFieldsList += "[ExExp3], ";
                if (isInsertExExp4)
                    InsertFieldsList += "[ExExp4], ";
                if (isInsertExExp5)
                    InsertFieldsList += "[ExExp5], ";
                if (isInsertExExp6)
                    InsertFieldsList += "[ExExp6], ";
                if (isInsertExExp7)
                    InsertFieldsList += "[ExExp7], ";
                if (isInsertExExp8)
                    InsertFieldsList += "[ExExp8], ";
                if (isInsertExExp9)
                    InsertFieldsList += "[ExExp9], ";
                if (isInsertExExp10)
                    InsertFieldsList += "[ExExp10], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertusername)
                    InsertValuesList += "@username, ";
                if (isInsertExExp1)
                    InsertValuesList += "@ExExp1, ";
                if (isInsertExExp2)
                    InsertValuesList += "@ExExp2, ";
                if (isInsertExExp3)
                    InsertValuesList += "@ExExp3, ";
                if (isInsertExExp4)
                    InsertValuesList += "@ExExp4, ";
                if (isInsertExExp5)
                    InsertValuesList += "@ExExp5, ";
                if (isInsertExExp6)
                    InsertValuesList += "@ExExp6, ";
                if (isInsertExExp7)
                    InsertValuesList += "@ExExp7, ";
                if (isInsertExExp8)
                    InsertValuesList += "@ExExp8, ";
                if (isInsertExExp9)
                    InsertValuesList += "@ExExp9, ";
                if (isInsertExExp10)
                    InsertValuesList += "@ExExp10, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isInsertExExp1 ? null : new MSSQL.Parameter("ExExp1", SqlDbType.Int, 0, ParameterDirection.Input, ExExp1),
                    !isInsertExExp2 ? null : new MSSQL.Parameter("ExExp2", SqlDbType.Int, 0, ParameterDirection.Input, ExExp2),
                    !isInsertExExp3 ? null : new MSSQL.Parameter("ExExp3", SqlDbType.Int, 0, ParameterDirection.Input, ExExp3),
                    !isInsertExExp4 ? null : new MSSQL.Parameter("ExExp4", SqlDbType.Int, 0, ParameterDirection.Input, ExExp4),
                    !isInsertExExp5 ? null : new MSSQL.Parameter("ExExp5", SqlDbType.Int, 0, ParameterDirection.Input, ExExp5),
                    !isInsertExExp6 ? null : new MSSQL.Parameter("ExExp6", SqlDbType.Int, 0, ParameterDirection.Input, ExExp6),
                    !isInsertExExp7 ? null : new MSSQL.Parameter("ExExp7", SqlDbType.Int, 0, ParameterDirection.Input, ExExp7),
                    !isInsertExExp8 ? null : new MSSQL.Parameter("ExExp8", SqlDbType.Int, 0, ParameterDirection.Input, ExExp8),
                    !isInsertExExp9 ? null : new MSSQL.Parameter("ExExp9", SqlDbType.Int, 0, ParameterDirection.Input, ExExp9),
                    !isInsertExExp10 ? null : new MSSQL.Parameter("ExExp10", SqlDbType.Int, 0, ParameterDirection.Input, ExExp10)
                    );
            }

            public static int Update(string Condition, string username, bool isUpdateusername, int ExExp1, bool isUpdateExExp1, int ExExp2, bool isUpdateExExp2, int ExExp3, bool isUpdateExExp3, int ExExp4, bool isUpdateExExp4, int ExExp5, bool isUpdateExExp5, int ExExp6, bool isUpdateExExp6, int ExExp7, bool isUpdateExExp7, int ExExp8, bool isUpdateExExp8, int ExExp9, bool isUpdateExExp9, int ExExp10, bool isUpdateExExp10)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_exexp] set ";
                string UpdateFieldsList = "";

                if (isUpdateusername)
                    UpdateFieldsList += "[username] = @username, ";
                if (isUpdateExExp1)
                    UpdateFieldsList += "[ExExp1] = @ExExp1, ";
                if (isUpdateExExp2)
                    UpdateFieldsList += "[ExExp2] = @ExExp2, ";
                if (isUpdateExExp3)
                    UpdateFieldsList += "[ExExp3] = @ExExp3, ";
                if (isUpdateExExp4)
                    UpdateFieldsList += "[ExExp4] = @ExExp4, ";
                if (isUpdateExExp5)
                    UpdateFieldsList += "[ExExp5] = @ExExp5, ";
                if (isUpdateExExp6)
                    UpdateFieldsList += "[ExExp6] = @ExExp6, ";
                if (isUpdateExExp7)
                    UpdateFieldsList += "[ExExp7] = @ExExp7, ";
                if (isUpdateExExp8)
                    UpdateFieldsList += "[ExExp8] = @ExExp8, ";
                if (isUpdateExExp9)
                    UpdateFieldsList += "[ExExp9] = @ExExp9, ";
                if (isUpdateExExp10)
                    UpdateFieldsList += "[ExExp10] = @ExExp10, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isUpdateExExp1 ? null : new MSSQL.Parameter("ExExp1", SqlDbType.Int, 0, ParameterDirection.Input, ExExp1),
                    !isUpdateExExp2 ? null : new MSSQL.Parameter("ExExp2", SqlDbType.Int, 0, ParameterDirection.Input, ExExp2),
                    !isUpdateExExp3 ? null : new MSSQL.Parameter("ExExp3", SqlDbType.Int, 0, ParameterDirection.Input, ExExp3),
                    !isUpdateExExp4 ? null : new MSSQL.Parameter("ExExp4", SqlDbType.Int, 0, ParameterDirection.Input, ExExp4),
                    !isUpdateExExp5 ? null : new MSSQL.Parameter("ExExp5", SqlDbType.Int, 0, ParameterDirection.Input, ExExp5),
                    !isUpdateExExp6 ? null : new MSSQL.Parameter("ExExp6", SqlDbType.Int, 0, ParameterDirection.Input, ExExp6),
                    !isUpdateExExp7 ? null : new MSSQL.Parameter("ExExp7", SqlDbType.Int, 0, ParameterDirection.Input, ExExp7),
                    !isUpdateExExp8 ? null : new MSSQL.Parameter("ExExp8", SqlDbType.Int, 0, ParameterDirection.Input, ExExp8),
                    !isUpdateExExp9 ? null : new MSSQL.Parameter("ExExp9", SqlDbType.Int, 0, ParameterDirection.Input, ExExp9),
                    !isUpdateExExp10 ? null : new MSSQL.Parameter("ExExp10", SqlDbType.Int, 0, ParameterDirection.Input, ExExp10)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_exexp]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_exexp]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_favourite
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_favourite]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string username, bool isInsertusername, string item, bool isInsertitem, int itemid, bool isInsertitemid, DateTime addtime, bool isInsertaddtime)
            {
                string CommandText = "insert into [bbs_favourite] (";
                string InsertFieldsList = "";

                if (isInsertusername)
                    InsertFieldsList += "[username], ";
                if (isInsertitem)
                    InsertFieldsList += "[item], ";
                if (isInsertitemid)
                    InsertFieldsList += "[itemid], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertusername)
                    InsertValuesList += "@username, ";
                if (isInsertitem)
                    InsertValuesList += "@item, ";
                if (isInsertitemid)
                    InsertValuesList += "@itemid, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isInsertitem ? null : new MSSQL.Parameter("item", SqlDbType.NVarChar, 0, ParameterDirection.Input, item),
                    !isInsertitemid ? null : new MSSQL.Parameter("itemid", SqlDbType.Int, 0, ParameterDirection.Input, itemid),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime)
                    );
            }

            public static int Update(string Condition, string username, bool isUpdateusername, string item, bool isUpdateitem, int itemid, bool isUpdateitemid, DateTime addtime, bool isUpdateaddtime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_favourite] set ";
                string UpdateFieldsList = "";

                if (isUpdateusername)
                    UpdateFieldsList += "[username] = @username, ";
                if (isUpdateitem)
                    UpdateFieldsList += "[item] = @item, ";
                if (isUpdateitemid)
                    UpdateFieldsList += "[itemid] = @itemid, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isUpdateitem ? null : new MSSQL.Parameter("item", SqlDbType.NVarChar, 0, ParameterDirection.Input, item),
                    !isUpdateitemid ? null : new MSSQL.Parameter("itemid", SqlDbType.Int, 0, ParameterDirection.Input, itemid),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_favourite]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_favourite]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_friend
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_friend]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string username, bool isInsertusername, string friendname, bool isInsertfriendname, DateTime addtime, bool isInsertaddtime)
            {
                string CommandText = "insert into [bbs_friend] (";
                string InsertFieldsList = "";

                if (isInsertusername)
                    InsertFieldsList += "[username], ";
                if (isInsertfriendname)
                    InsertFieldsList += "[friendname], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertusername)
                    InsertValuesList += "@username, ";
                if (isInsertfriendname)
                    InsertValuesList += "@friendname, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isInsertfriendname ? null : new MSSQL.Parameter("friendname", SqlDbType.NVarChar, 0, ParameterDirection.Input, friendname),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime)
                    );
            }

            public static int Update(string Condition, string username, bool isUpdateusername, string friendname, bool isUpdatefriendname, DateTime addtime, bool isUpdateaddtime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_friend] set ";
                string UpdateFieldsList = "";

                if (isUpdateusername)
                    UpdateFieldsList += "[username] = @username, ";
                if (isUpdatefriendname)
                    UpdateFieldsList += "[friendname] = @friendname, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isUpdatefriendname ? null : new MSSQL.Parameter("friendname", SqlDbType.NVarChar, 0, ParameterDirection.Input, friendname),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_friend]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_friend]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_group
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_group]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int GroupID, bool isInsertGroupID, string GroupName, bool isInsertGroupName, string IconPath, bool isInsertIconPath, bool Enabled, bool isInsertEnabled, bool Required, bool isInsertRequired)
            {
                string CommandText = "insert into [bbs_group] (";
                string InsertFieldsList = "";

                if (isInsertGroupID)
                    InsertFieldsList += "[GroupID], ";
                if (isInsertGroupName)
                    InsertFieldsList += "[GroupName], ";
                if (isInsertIconPath)
                    InsertFieldsList += "[IconPath], ";
                if (isInsertEnabled)
                    InsertFieldsList += "[Enabled], ";
                if (isInsertRequired)
                    InsertFieldsList += "[Required], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertGroupID)
                    InsertValuesList += "@GroupID, ";
                if (isInsertGroupName)
                    InsertValuesList += "@GroupName, ";
                if (isInsertIconPath)
                    InsertValuesList += "@IconPath, ";
                if (isInsertEnabled)
                    InsertValuesList += "@Enabled, ";
                if (isInsertRequired)
                    InsertValuesList += "@Required, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertGroupID ? null : new MSSQL.Parameter("GroupID", SqlDbType.Int, 0, ParameterDirection.Input, GroupID),
                    !isInsertGroupName ? null : new MSSQL.Parameter("GroupName", SqlDbType.NVarChar, 0, ParameterDirection.Input, GroupName),
                    !isInsertIconPath ? null : new MSSQL.Parameter("IconPath", SqlDbType.NVarChar, 0, ParameterDirection.Input, IconPath),
                    !isInsertEnabled ? null : new MSSQL.Parameter("Enabled", SqlDbType.Bit, 0, ParameterDirection.Input, Enabled),
                    !isInsertRequired ? null : new MSSQL.Parameter("Required", SqlDbType.Bit, 0, ParameterDirection.Input, Required)
                    );
            }

            public static int Update(string Condition, int GroupID, bool isUpdateGroupID, string GroupName, bool isUpdateGroupName, string IconPath, bool isUpdateIconPath, bool Enabled, bool isUpdateEnabled, bool Required, bool isUpdateRequired)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_group] set ";
                string UpdateFieldsList = "";

                if (isUpdateGroupID)
                    UpdateFieldsList += "[GroupID] = @GroupID, ";
                if (isUpdateGroupName)
                    UpdateFieldsList += "[GroupName] = @GroupName, ";
                if (isUpdateIconPath)
                    UpdateFieldsList += "[IconPath] = @IconPath, ";
                if (isUpdateEnabled)
                    UpdateFieldsList += "[Enabled] = @Enabled, ";
                if (isUpdateRequired)
                    UpdateFieldsList += "[Required] = @Required, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateGroupID ? null : new MSSQL.Parameter("GroupID", SqlDbType.Int, 0, ParameterDirection.Input, GroupID),
                    !isUpdateGroupName ? null : new MSSQL.Parameter("GroupName", SqlDbType.NVarChar, 0, ParameterDirection.Input, GroupName),
                    !isUpdateIconPath ? null : new MSSQL.Parameter("IconPath", SqlDbType.NVarChar, 0, ParameterDirection.Input, IconPath),
                    !isUpdateEnabled ? null : new MSSQL.Parameter("Enabled", SqlDbType.Bit, 0, ParameterDirection.Input, Enabled),
                    !isUpdateRequired ? null : new MSSQL.Parameter("Required", SqlDbType.Bit, 0, ParameterDirection.Input, Required)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_group]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_group]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_log
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_log]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string name, bool isInsertname, string action, bool isInsertaction, DateTime addtime, bool isInsertaddtime, string ip, bool isInsertip, bool isforbacksystem, bool isInsertisforbacksystem)
            {
                string CommandText = "insert into [bbs_log] (";
                string InsertFieldsList = "";

                if (isInsertname)
                    InsertFieldsList += "[name], ";
                if (isInsertaction)
                    InsertFieldsList += "[action], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";
                if (isInsertip)
                    InsertFieldsList += "[ip], ";
                if (isInsertisforbacksystem)
                    InsertFieldsList += "[isforbacksystem], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertname)
                    InsertValuesList += "@name, ";
                if (isInsertaction)
                    InsertValuesList += "@action, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";
                if (isInsertip)
                    InsertValuesList += "@ip, ";
                if (isInsertisforbacksystem)
                    InsertValuesList += "@isforbacksystem, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertname ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isInsertaction ? null : new MSSQL.Parameter("action", SqlDbType.NVarChar, 0, ParameterDirection.Input, action),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isInsertip ? null : new MSSQL.Parameter("ip", SqlDbType.NVarChar, 0, ParameterDirection.Input, ip),
                    !isInsertisforbacksystem ? null : new MSSQL.Parameter("isforbacksystem", SqlDbType.Bit, 0, ParameterDirection.Input, isforbacksystem)
                    );
            }

            public static int Update(string Condition, string name, bool isUpdatename, string action, bool isUpdateaction, DateTime addtime, bool isUpdateaddtime, string ip, bool isUpdateip, bool isforbacksystem, bool isUpdateisforbacksystem)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_log] set ";
                string UpdateFieldsList = "";

                if (isUpdatename)
                    UpdateFieldsList += "[name] = @name, ";
                if (isUpdateaction)
                    UpdateFieldsList += "[action] = @action, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";
                if (isUpdateip)
                    UpdateFieldsList += "[ip] = @ip, ";
                if (isUpdateisforbacksystem)
                    UpdateFieldsList += "[isforbacksystem] = @isforbacksystem, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatename ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isUpdateaction ? null : new MSSQL.Parameter("action", SqlDbType.NVarChar, 0, ParameterDirection.Input, action),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isUpdateip ? null : new MSSQL.Parameter("ip", SqlDbType.NVarChar, 0, ParameterDirection.Input, ip),
                    !isUpdateisforbacksystem ? null : new MSSQL.Parameter("isforbacksystem", SqlDbType.Bit, 0, ParameterDirection.Input, isforbacksystem)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_log]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_log]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_medal
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_medal]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string username, bool isInsertusername, string medal, bool isInsertmedal, DateTime addtime, bool isInsertaddtime, string remark, bool isInsertremark)
            {
                string CommandText = "insert into [bbs_medal] (";
                string InsertFieldsList = "";

                if (isInsertusername)
                    InsertFieldsList += "[username], ";
                if (isInsertmedal)
                    InsertFieldsList += "[medal], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";
                if (isInsertremark)
                    InsertFieldsList += "[remark], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertusername)
                    InsertValuesList += "@username, ";
                if (isInsertmedal)
                    InsertValuesList += "@medal, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";
                if (isInsertremark)
                    InsertValuesList += "@remark, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isInsertmedal ? null : new MSSQL.Parameter("medal", SqlDbType.NVarChar, 0, ParameterDirection.Input, medal),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isInsertremark ? null : new MSSQL.Parameter("remark", SqlDbType.NText, 0, ParameterDirection.Input, remark)
                    );
            }

            public static int Update(string Condition, string username, bool isUpdateusername, string medal, bool isUpdatemedal, DateTime addtime, bool isUpdateaddtime, string remark, bool isUpdateremark)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_medal] set ";
                string UpdateFieldsList = "";

                if (isUpdateusername)
                    UpdateFieldsList += "[username] = @username, ";
                if (isUpdatemedal)
                    UpdateFieldsList += "[medal] = @medal, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";
                if (isUpdateremark)
                    UpdateFieldsList += "[remark] = @remark, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateusername ? null : new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    !isUpdatemedal ? null : new MSSQL.Parameter("medal", SqlDbType.NVarChar, 0, ParameterDirection.Input, medal),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isUpdateremark ? null : new MSSQL.Parameter("remark", SqlDbType.NText, 0, ParameterDirection.Input, remark)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_medal]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_medal]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_message
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_message]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string sender, bool isInsertsender, string recipient, bool isInsertrecipient, string title, bool isInserttitle, string content, bool isInsertcontent, bool isread, bool isInsertisread, bool issenderdel, bool isInsertissenderdel, bool isrecipientdel, bool isInsertisrecipientdel, DateTime sendtime, bool isInsertsendtime)
            {
                string CommandText = "insert into [bbs_message] (";
                string InsertFieldsList = "";

                if (isInsertsender)
                    InsertFieldsList += "[sender], ";
                if (isInsertrecipient)
                    InsertFieldsList += "[recipient], ";
                if (isInserttitle)
                    InsertFieldsList += "[title], ";
                if (isInsertcontent)
                    InsertFieldsList += "[content], ";
                if (isInsertisread)
                    InsertFieldsList += "[isread], ";
                if (isInsertissenderdel)
                    InsertFieldsList += "[issenderdel], ";
                if (isInsertisrecipientdel)
                    InsertFieldsList += "[isrecipientdel], ";
                if (isInsertsendtime)
                    InsertFieldsList += "[sendtime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertsender)
                    InsertValuesList += "@sender, ";
                if (isInsertrecipient)
                    InsertValuesList += "@recipient, ";
                if (isInserttitle)
                    InsertValuesList += "@title, ";
                if (isInsertcontent)
                    InsertValuesList += "@content, ";
                if (isInsertisread)
                    InsertValuesList += "@isread, ";
                if (isInsertissenderdel)
                    InsertValuesList += "@issenderdel, ";
                if (isInsertisrecipientdel)
                    InsertValuesList += "@isrecipientdel, ";
                if (isInsertsendtime)
                    InsertValuesList += "@sendtime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertsender ? null : new MSSQL.Parameter("sender", SqlDbType.NVarChar, 0, ParameterDirection.Input, sender),
                    !isInsertrecipient ? null : new MSSQL.Parameter("recipient", SqlDbType.NVarChar, 0, ParameterDirection.Input, recipient),
                    !isInserttitle ? null : new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    !isInsertcontent ? null : new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    !isInsertisread ? null : new MSSQL.Parameter("isread", SqlDbType.Bit, 0, ParameterDirection.Input, isread),
                    !isInsertissenderdel ? null : new MSSQL.Parameter("issenderdel", SqlDbType.Bit, 0, ParameterDirection.Input, issenderdel),
                    !isInsertisrecipientdel ? null : new MSSQL.Parameter("isrecipientdel", SqlDbType.Bit, 0, ParameterDirection.Input, isrecipientdel),
                    !isInsertsendtime ? null : new MSSQL.Parameter("sendtime", SqlDbType.DateTime, 0, ParameterDirection.Input, sendtime)
                    );
            }

            public static int Update(string Condition, string sender, bool isUpdatesender, string recipient, bool isUpdaterecipient, string title, bool isUpdatetitle, string content, bool isUpdatecontent, bool isread, bool isUpdateisread, bool issenderdel, bool isUpdateissenderdel, bool isrecipientdel, bool isUpdateisrecipientdel, DateTime sendtime, bool isUpdatesendtime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_message] set ";
                string UpdateFieldsList = "";

                if (isUpdatesender)
                    UpdateFieldsList += "[sender] = @sender, ";
                if (isUpdaterecipient)
                    UpdateFieldsList += "[recipient] = @recipient, ";
                if (isUpdatetitle)
                    UpdateFieldsList += "[title] = @title, ";
                if (isUpdatecontent)
                    UpdateFieldsList += "[content] = @content, ";
                if (isUpdateisread)
                    UpdateFieldsList += "[isread] = @isread, ";
                if (isUpdateissenderdel)
                    UpdateFieldsList += "[issenderdel] = @issenderdel, ";
                if (isUpdateisrecipientdel)
                    UpdateFieldsList += "[isrecipientdel] = @isrecipientdel, ";
                if (isUpdatesendtime)
                    UpdateFieldsList += "[sendtime] = @sendtime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatesender ? null : new MSSQL.Parameter("sender", SqlDbType.NVarChar, 0, ParameterDirection.Input, sender),
                    !isUpdaterecipient ? null : new MSSQL.Parameter("recipient", SqlDbType.NVarChar, 0, ParameterDirection.Input, recipient),
                    !isUpdatetitle ? null : new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    !isUpdatecontent ? null : new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    !isUpdateisread ? null : new MSSQL.Parameter("isread", SqlDbType.Bit, 0, ParameterDirection.Input, isread),
                    !isUpdateissenderdel ? null : new MSSQL.Parameter("issenderdel", SqlDbType.Bit, 0, ParameterDirection.Input, issenderdel),
                    !isUpdateisrecipientdel ? null : new MSSQL.Parameter("isrecipientdel", SqlDbType.Bit, 0, ParameterDirection.Input, isrecipientdel),
                    !isUpdatesendtime ? null : new MSSQL.Parameter("sendtime", SqlDbType.DateTime, 0, ParameterDirection.Input, sendtime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_message]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_message]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_online
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_online]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string sessionid, bool isInsertsessionid, string name, bool isInsertname, int power, bool isInsertpower, string ip, bool isInsertip, int boardid, bool isInsertboardid, string action, bool isInsertaction, DateTime activetime, bool isInsertactivetime, string agent, bool isInsertagent, bool isfade, bool isInsertisfade)
            {
                string CommandText = "insert into [bbs_online] (";
                string InsertFieldsList = "";

                if (isInsertsessionid)
                    InsertFieldsList += "[sessionid], ";
                if (isInsertname)
                    InsertFieldsList += "[name], ";
                if (isInsertpower)
                    InsertFieldsList += "[power], ";
                if (isInsertip)
                    InsertFieldsList += "[ip], ";
                if (isInsertboardid)
                    InsertFieldsList += "[boardid], ";
                if (isInsertaction)
                    InsertFieldsList += "[action], ";
                if (isInsertactivetime)
                    InsertFieldsList += "[activetime], ";
                if (isInsertagent)
                    InsertFieldsList += "[agent], ";
                if (isInsertisfade)
                    InsertFieldsList += "[isfade], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertsessionid)
                    InsertValuesList += "@sessionid, ";
                if (isInsertname)
                    InsertValuesList += "@name, ";
                if (isInsertpower)
                    InsertValuesList += "@power, ";
                if (isInsertip)
                    InsertValuesList += "@ip, ";
                if (isInsertboardid)
                    InsertValuesList += "@boardid, ";
                if (isInsertaction)
                    InsertValuesList += "@action, ";
                if (isInsertactivetime)
                    InsertValuesList += "@activetime, ";
                if (isInsertagent)
                    InsertValuesList += "@agent, ";
                if (isInsertisfade)
                    InsertValuesList += "@isfade, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertsessionid ? null : new MSSQL.Parameter("sessionid", SqlDbType.NVarChar, 0, ParameterDirection.Input, sessionid),
                    !isInsertname ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isInsertpower ? null : new MSSQL.Parameter("power", SqlDbType.Int, 0, ParameterDirection.Input, power),
                    !isInsertip ? null : new MSSQL.Parameter("ip", SqlDbType.NVarChar, 0, ParameterDirection.Input, ip),
                    !isInsertboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    !isInsertaction ? null : new MSSQL.Parameter("action", SqlDbType.NVarChar, 0, ParameterDirection.Input, action),
                    !isInsertactivetime ? null : new MSSQL.Parameter("activetime", SqlDbType.DateTime, 0, ParameterDirection.Input, activetime),
                    !isInsertagent ? null : new MSSQL.Parameter("agent", SqlDbType.NVarChar, 0, ParameterDirection.Input, agent),
                    !isInsertisfade ? null : new MSSQL.Parameter("isfade", SqlDbType.Bit, 0, ParameterDirection.Input, isfade)
                    );
            }

            public static int Update(string Condition, string sessionid, bool isUpdatesessionid, string name, bool isUpdatename, int power, bool isUpdatepower, string ip, bool isUpdateip, int boardid, bool isUpdateboardid, string action, bool isUpdateaction, DateTime activetime, bool isUpdateactivetime, string agent, bool isUpdateagent, bool isfade, bool isUpdateisfade)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_online] set ";
                string UpdateFieldsList = "";

                if (isUpdatesessionid)
                    UpdateFieldsList += "[sessionid] = @sessionid, ";
                if (isUpdatename)
                    UpdateFieldsList += "[name] = @name, ";
                if (isUpdatepower)
                    UpdateFieldsList += "[power] = @power, ";
                if (isUpdateip)
                    UpdateFieldsList += "[ip] = @ip, ";
                if (isUpdateboardid)
                    UpdateFieldsList += "[boardid] = @boardid, ";
                if (isUpdateaction)
                    UpdateFieldsList += "[action] = @action, ";
                if (isUpdateactivetime)
                    UpdateFieldsList += "[activetime] = @activetime, ";
                if (isUpdateagent)
                    UpdateFieldsList += "[agent] = @agent, ";
                if (isUpdateisfade)
                    UpdateFieldsList += "[isfade] = @isfade, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatesessionid ? null : new MSSQL.Parameter("sessionid", SqlDbType.NVarChar, 0, ParameterDirection.Input, sessionid),
                    !isUpdatename ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isUpdatepower ? null : new MSSQL.Parameter("power", SqlDbType.Int, 0, ParameterDirection.Input, power),
                    !isUpdateip ? null : new MSSQL.Parameter("ip", SqlDbType.NVarChar, 0, ParameterDirection.Input, ip),
                    !isUpdateboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    !isUpdateaction ? null : new MSSQL.Parameter("action", SqlDbType.NVarChar, 0, ParameterDirection.Input, action),
                    !isUpdateactivetime ? null : new MSSQL.Parameter("activetime", SqlDbType.DateTime, 0, ParameterDirection.Input, activetime),
                    !isUpdateagent ? null : new MSSQL.Parameter("agent", SqlDbType.NVarChar, 0, ParameterDirection.Input, agent),
                    !isUpdateisfade ? null : new MSSQL.Parameter("isfade", SqlDbType.Bit, 0, ParameterDirection.Input, isfade)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_online]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_online]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_refuseip
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_refuseip]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(long startip, bool isInsertstartip, long endip, bool isInsertendip)
            {
                string CommandText = "insert into [bbs_refuseip] (";
                string InsertFieldsList = "";

                if (isInsertstartip)
                    InsertFieldsList += "[startip], ";
                if (isInsertendip)
                    InsertFieldsList += "[endip], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertstartip)
                    InsertValuesList += "@startip, ";
                if (isInsertendip)
                    InsertValuesList += "@endip, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertstartip ? null : new MSSQL.Parameter("startip", SqlDbType.BigInt, 0, ParameterDirection.Input, startip),
                    !isInsertendip ? null : new MSSQL.Parameter("endip", SqlDbType.BigInt, 0, ParameterDirection.Input, endip)
                    );
            }

            public static int Update(string Condition, long startip, bool isUpdatestartip, long endip, bool isUpdateendip)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_refuseip] set ";
                string UpdateFieldsList = "";

                if (isUpdatestartip)
                    UpdateFieldsList += "[startip] = @startip, ";
                if (isUpdateendip)
                    UpdateFieldsList += "[endip] = @endip, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatestartip ? null : new MSSQL.Parameter("startip", SqlDbType.BigInt, 0, ParameterDirection.Input, startip),
                    !isUpdateendip ? null : new MSSQL.Parameter("endip", SqlDbType.BigInt, 0, ParameterDirection.Input, endip)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_refuseip]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_refuseip]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_reply
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_reply]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int topicid, bool isInserttopicid, string content, bool isInsertcontent, string name, bool isInsertname, string ip, bool isInsertip, DateTime addtime, bool isInsertaddtime, bool isdelete, bool isInsertisdelete, bool isformat, bool isInsertisformat, int usingtag, bool isInsertusingtag)
            {
                string CommandText = "insert into [bbs_reply] (";
                string InsertFieldsList = "";

                if (isInserttopicid)
                    InsertFieldsList += "[topicid], ";
                if (isInsertcontent)
                    InsertFieldsList += "[content], ";
                if (isInsertname)
                    InsertFieldsList += "[name], ";
                if (isInsertip)
                    InsertFieldsList += "[ip], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";
                if (isInsertisdelete)
                    InsertFieldsList += "[isdelete], ";
                if (isInsertisformat)
                    InsertFieldsList += "[isformat], ";
                if (isInsertusingtag)
                    InsertFieldsList += "[usingtag], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInserttopicid)
                    InsertValuesList += "@topicid, ";
                if (isInsertcontent)
                    InsertValuesList += "@content, ";
                if (isInsertname)
                    InsertValuesList += "@name, ";
                if (isInsertip)
                    InsertValuesList += "@ip, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";
                if (isInsertisdelete)
                    InsertValuesList += "@isdelete, ";
                if (isInsertisformat)
                    InsertValuesList += "@isformat, ";
                if (isInsertusingtag)
                    InsertValuesList += "@usingtag, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInserttopicid ? null : new MSSQL.Parameter("topicid", SqlDbType.Int, 0, ParameterDirection.Input, topicid),
                    !isInsertcontent ? null : new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    !isInsertname ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isInsertip ? null : new MSSQL.Parameter("ip", SqlDbType.NVarChar, 0, ParameterDirection.Input, ip),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isInsertisdelete ? null : new MSSQL.Parameter("isdelete", SqlDbType.Bit, 0, ParameterDirection.Input, isdelete),
                    !isInsertisformat ? null : new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat),
                    !isInsertusingtag ? null : new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag)
                    );
            }

            public static int Update(string Condition, int topicid, bool isUpdatetopicid, string content, bool isUpdatecontent, string name, bool isUpdatename, string ip, bool isUpdateip, DateTime addtime, bool isUpdateaddtime, bool isdelete, bool isUpdateisdelete, bool isformat, bool isUpdateisformat, int usingtag, bool isUpdateusingtag)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_reply] set ";
                string UpdateFieldsList = "";

                if (isUpdatetopicid)
                    UpdateFieldsList += "[topicid] = @topicid, ";
                if (isUpdatecontent)
                    UpdateFieldsList += "[content] = @content, ";
                if (isUpdatename)
                    UpdateFieldsList += "[name] = @name, ";
                if (isUpdateip)
                    UpdateFieldsList += "[ip] = @ip, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";
                if (isUpdateisdelete)
                    UpdateFieldsList += "[isdelete] = @isdelete, ";
                if (isUpdateisformat)
                    UpdateFieldsList += "[isformat] = @isformat, ";
                if (isUpdateusingtag)
                    UpdateFieldsList += "[usingtag] = @usingtag, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatetopicid ? null : new MSSQL.Parameter("topicid", SqlDbType.Int, 0, ParameterDirection.Input, topicid),
                    !isUpdatecontent ? null : new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    !isUpdatename ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isUpdateip ? null : new MSSQL.Parameter("ip", SqlDbType.NVarChar, 0, ParameterDirection.Input, ip),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isUpdateisdelete ? null : new MSSQL.Parameter("isdelete", SqlDbType.Bit, 0, ParameterDirection.Input, isdelete),
                    !isUpdateisformat ? null : new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat),
                    !isUpdateusingtag ? null : new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_reply]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_reply]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_robotsadvent
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_robotsadvent]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string agentinfo, bool isInsertagentinfo, string pagetitle, bool isInsertpagetitle, string realurl, bool isInsertrealurl, string rawurl, bool isInsertrawurl, DateTime happentime, bool isInserthappentime)
            {
                string CommandText = "insert into [bbs_robotsadvent] (";
                string InsertFieldsList = "";

                if (isInsertagentinfo)
                    InsertFieldsList += "[agentinfo], ";
                if (isInsertpagetitle)
                    InsertFieldsList += "[pagetitle], ";
                if (isInsertrealurl)
                    InsertFieldsList += "[realurl], ";
                if (isInsertrawurl)
                    InsertFieldsList += "[rawurl], ";
                if (isInserthappentime)
                    InsertFieldsList += "[happentime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertagentinfo)
                    InsertValuesList += "@agentinfo, ";
                if (isInsertpagetitle)
                    InsertValuesList += "@pagetitle, ";
                if (isInsertrealurl)
                    InsertValuesList += "@realurl, ";
                if (isInsertrawurl)
                    InsertValuesList += "@rawurl, ";
                if (isInserthappentime)
                    InsertValuesList += "@happentime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertagentinfo ? null : new MSSQL.Parameter("agentinfo", SqlDbType.NVarChar, 0, ParameterDirection.Input, agentinfo),
                    !isInsertpagetitle ? null : new MSSQL.Parameter("pagetitle", SqlDbType.NVarChar, 0, ParameterDirection.Input, pagetitle),
                    !isInsertrealurl ? null : new MSSQL.Parameter("realurl", SqlDbType.NVarChar, 0, ParameterDirection.Input, realurl),
                    !isInsertrawurl ? null : new MSSQL.Parameter("rawurl", SqlDbType.NVarChar, 0, ParameterDirection.Input, rawurl),
                    !isInserthappentime ? null : new MSSQL.Parameter("happentime", SqlDbType.DateTime, 0, ParameterDirection.Input, happentime)
                    );
            }

            public static int Update(string Condition, string agentinfo, bool isUpdateagentinfo, string pagetitle, bool isUpdatepagetitle, string realurl, bool isUpdaterealurl, string rawurl, bool isUpdaterawurl, DateTime happentime, bool isUpdatehappentime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_robotsadvent] set ";
                string UpdateFieldsList = "";

                if (isUpdateagentinfo)
                    UpdateFieldsList += "[agentinfo] = @agentinfo, ";
                if (isUpdatepagetitle)
                    UpdateFieldsList += "[pagetitle] = @pagetitle, ";
                if (isUpdaterealurl)
                    UpdateFieldsList += "[realurl] = @realurl, ";
                if (isUpdaterawurl)
                    UpdateFieldsList += "[rawurl] = @rawurl, ";
                if (isUpdatehappentime)
                    UpdateFieldsList += "[happentime] = @happentime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateagentinfo ? null : new MSSQL.Parameter("agentinfo", SqlDbType.NVarChar, 0, ParameterDirection.Input, agentinfo),
                    !isUpdatepagetitle ? null : new MSSQL.Parameter("pagetitle", SqlDbType.NVarChar, 0, ParameterDirection.Input, pagetitle),
                    !isUpdaterealurl ? null : new MSSQL.Parameter("realurl", SqlDbType.NVarChar, 0, ParameterDirection.Input, realurl),
                    !isUpdaterawurl ? null : new MSSQL.Parameter("rawurl", SqlDbType.NVarChar, 0, ParameterDirection.Input, rawurl),
                    !isUpdatehappentime ? null : new MSSQL.Parameter("happentime", SqlDbType.DateTime, 0, ParameterDirection.Input, happentime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_robotsadvent]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_robotsadvent]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_role
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_role]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int type, bool isInserttype, string rolename, bool isInsertrolename, int limexp, bool isInsertlimexp, int rank, bool isInsertrank, string color, bool isInsertcolor, string badge, bool isInsertbadge, string pop_strategy, bool isInsertpop_strategy, string mng_strategy, bool isInsertmng_strategy, string exp_strategy, bool isInsertexp_strategy)
            {
                string CommandText = "insert into [bbs_role] (";
                string InsertFieldsList = "";

                if (isInserttype)
                    InsertFieldsList += "[type], ";
                if (isInsertrolename)
                    InsertFieldsList += "[rolename], ";
                if (isInsertlimexp)
                    InsertFieldsList += "[limexp], ";
                if (isInsertrank)
                    InsertFieldsList += "[rank], ";
                if (isInsertcolor)
                    InsertFieldsList += "[color], ";
                if (isInsertbadge)
                    InsertFieldsList += "[badge], ";
                if (isInsertpop_strategy)
                    InsertFieldsList += "[pop_strategy], ";
                if (isInsertmng_strategy)
                    InsertFieldsList += "[mng_strategy], ";
                if (isInsertexp_strategy)
                    InsertFieldsList += "[exp_strategy], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInserttype)
                    InsertValuesList += "@type, ";
                if (isInsertrolename)
                    InsertValuesList += "@rolename, ";
                if (isInsertlimexp)
                    InsertValuesList += "@limexp, ";
                if (isInsertrank)
                    InsertValuesList += "@rank, ";
                if (isInsertcolor)
                    InsertValuesList += "@color, ";
                if (isInsertbadge)
                    InsertValuesList += "@badge, ";
                if (isInsertpop_strategy)
                    InsertValuesList += "@pop_strategy, ";
                if (isInsertmng_strategy)
                    InsertValuesList += "@mng_strategy, ";
                if (isInsertexp_strategy)
                    InsertValuesList += "@exp_strategy, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInserttype ? null : new MSSQL.Parameter("type", SqlDbType.Int, 0, ParameterDirection.Input, type),
                    !isInsertrolename ? null : new MSSQL.Parameter("rolename", SqlDbType.NVarChar, 0, ParameterDirection.Input, rolename),
                    !isInsertlimexp ? null : new MSSQL.Parameter("limexp", SqlDbType.Int, 0, ParameterDirection.Input, limexp),
                    !isInsertrank ? null : new MSSQL.Parameter("rank", SqlDbType.Int, 0, ParameterDirection.Input, rank),
                    !isInsertcolor ? null : new MSSQL.Parameter("color", SqlDbType.NVarChar, 0, ParameterDirection.Input, color),
                    !isInsertbadge ? null : new MSSQL.Parameter("badge", SqlDbType.NVarChar, 0, ParameterDirection.Input, badge),
                    !isInsertpop_strategy ? null : new MSSQL.Parameter("pop_strategy", SqlDbType.NText, 0, ParameterDirection.Input, pop_strategy),
                    !isInsertmng_strategy ? null : new MSSQL.Parameter("mng_strategy", SqlDbType.NText, 0, ParameterDirection.Input, mng_strategy),
                    !isInsertexp_strategy ? null : new MSSQL.Parameter("exp_strategy", SqlDbType.NText, 0, ParameterDirection.Input, exp_strategy)
                    );
            }

            public static int Update(string Condition, int type, bool isUpdatetype, string rolename, bool isUpdaterolename, int limexp, bool isUpdatelimexp, int rank, bool isUpdaterank, string color, bool isUpdatecolor, string badge, bool isUpdatebadge, string pop_strategy, bool isUpdatepop_strategy, string mng_strategy, bool isUpdatemng_strategy, string exp_strategy, bool isUpdateexp_strategy)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_role] set ";
                string UpdateFieldsList = "";

                if (isUpdatetype)
                    UpdateFieldsList += "[type] = @type, ";
                if (isUpdaterolename)
                    UpdateFieldsList += "[rolename] = @rolename, ";
                if (isUpdatelimexp)
                    UpdateFieldsList += "[limexp] = @limexp, ";
                if (isUpdaterank)
                    UpdateFieldsList += "[rank] = @rank, ";
                if (isUpdatecolor)
                    UpdateFieldsList += "[color] = @color, ";
                if (isUpdatebadge)
                    UpdateFieldsList += "[badge] = @badge, ";
                if (isUpdatepop_strategy)
                    UpdateFieldsList += "[pop_strategy] = @pop_strategy, ";
                if (isUpdatemng_strategy)
                    UpdateFieldsList += "[mng_strategy] = @mng_strategy, ";
                if (isUpdateexp_strategy)
                    UpdateFieldsList += "[exp_strategy] = @exp_strategy, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatetype ? null : new MSSQL.Parameter("type", SqlDbType.Int, 0, ParameterDirection.Input, type),
                    !isUpdaterolename ? null : new MSSQL.Parameter("rolename", SqlDbType.NVarChar, 0, ParameterDirection.Input, rolename),
                    !isUpdatelimexp ? null : new MSSQL.Parameter("limexp", SqlDbType.Int, 0, ParameterDirection.Input, limexp),
                    !isUpdaterank ? null : new MSSQL.Parameter("rank", SqlDbType.Int, 0, ParameterDirection.Input, rank),
                    !isUpdatecolor ? null : new MSSQL.Parameter("color", SqlDbType.NVarChar, 0, ParameterDirection.Input, color),
                    !isUpdatebadge ? null : new MSSQL.Parameter("badge", SqlDbType.NVarChar, 0, ParameterDirection.Input, badge),
                    !isUpdatepop_strategy ? null : new MSSQL.Parameter("pop_strategy", SqlDbType.NText, 0, ParameterDirection.Input, pop_strategy),
                    !isUpdatemng_strategy ? null : new MSSQL.Parameter("mng_strategy", SqlDbType.NText, 0, ParameterDirection.Input, mng_strategy),
                    !isUpdateexp_strategy ? null : new MSSQL.Parameter("exp_strategy", SqlDbType.NText, 0, ParameterDirection.Input, exp_strategy)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_role]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_role]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_topic
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_topic]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int boardid, bool isInsertboardid, int classid, bool isInsertclassid, string title, bool isInserttitle, string content, bool isInsertcontent, string name, bool isInsertname, DateTime addtime, bool isInsertaddtime, int clicks, bool isInsertclicks, bool istop, bool isInsertistop, bool istopall, bool isInsertistopall, bool isclassical, bool isInsertisclassical, bool islock, bool isInsertislock, bool isdelete, bool isInsertisdelete, string lastreplyuser, bool isInsertlastreplyuser, DateTime lastreplytime, bool isInsertlastreplytime, string lastreplypreview, bool isInsertlastreplypreview, int voteid, bool isInsertvoteid, int titlecolor, bool isInserttitlecolor, int limitexp, bool isInsertlimitexp, int money, bool isInsertmoney, int icon, bool isInserticon, int replies, bool isInsertreplies)
            {
                string CommandText = "insert into [bbs_topic] (";
                string InsertFieldsList = "";

                if (isInsertboardid)
                    InsertFieldsList += "[boardid], ";
                if (isInsertclassid)
                    InsertFieldsList += "[classid], ";
                if (isInserttitle)
                    InsertFieldsList += "[title], ";
                if (isInsertcontent)
                    InsertFieldsList += "[content], ";
                if (isInsertname)
                    InsertFieldsList += "[name], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";
                if (isInsertclicks)
                    InsertFieldsList += "[clicks], ";
                if (isInsertistop)
                    InsertFieldsList += "[istop], ";
                if (isInsertistopall)
                    InsertFieldsList += "[istopall], ";
                if (isInsertisclassical)
                    InsertFieldsList += "[isclassical], ";
                if (isInsertislock)
                    InsertFieldsList += "[islock], ";
                if (isInsertisdelete)
                    InsertFieldsList += "[isdelete], ";
                if (isInsertlastreplyuser)
                    InsertFieldsList += "[lastreplyuser], ";
                if (isInsertlastreplytime)
                    InsertFieldsList += "[lastreplytime], ";
                if (isInsertlastreplypreview)
                    InsertFieldsList += "[lastreplypreview], ";
                if (isInsertvoteid)
                    InsertFieldsList += "[voteid], ";
                if (isInserttitlecolor)
                    InsertFieldsList += "[titlecolor], ";
                if (isInsertlimitexp)
                    InsertFieldsList += "[limitexp], ";
                if (isInsertmoney)
                    InsertFieldsList += "[money], ";
                if (isInserticon)
                    InsertFieldsList += "[icon], ";
                if (isInsertreplies)
                    InsertFieldsList += "[replies], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertboardid)
                    InsertValuesList += "@boardid, ";
                if (isInsertclassid)
                    InsertValuesList += "@classid, ";
                if (isInserttitle)
                    InsertValuesList += "@title, ";
                if (isInsertcontent)
                    InsertValuesList += "@content, ";
                if (isInsertname)
                    InsertValuesList += "@name, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";
                if (isInsertclicks)
                    InsertValuesList += "@clicks, ";
                if (isInsertistop)
                    InsertValuesList += "@istop, ";
                if (isInsertistopall)
                    InsertValuesList += "@istopall, ";
                if (isInsertisclassical)
                    InsertValuesList += "@isclassical, ";
                if (isInsertislock)
                    InsertValuesList += "@islock, ";
                if (isInsertisdelete)
                    InsertValuesList += "@isdelete, ";
                if (isInsertlastreplyuser)
                    InsertValuesList += "@lastreplyuser, ";
                if (isInsertlastreplytime)
                    InsertValuesList += "@lastreplytime, ";
                if (isInsertlastreplypreview)
                    InsertValuesList += "@lastreplypreview, ";
                if (isInsertvoteid)
                    InsertValuesList += "@voteid, ";
                if (isInserttitlecolor)
                    InsertValuesList += "@titlecolor, ";
                if (isInsertlimitexp)
                    InsertValuesList += "@limitexp, ";
                if (isInsertmoney)
                    InsertValuesList += "@money, ";
                if (isInserticon)
                    InsertValuesList += "@icon, ";
                if (isInsertreplies)
                    InsertValuesList += "@replies, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    !isInsertclassid ? null : new MSSQL.Parameter("classid", SqlDbType.Int, 0, ParameterDirection.Input, classid),
                    !isInserttitle ? null : new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    !isInsertcontent ? null : new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    !isInsertname ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isInsertclicks ? null : new MSSQL.Parameter("clicks", SqlDbType.Int, 0, ParameterDirection.Input, clicks),
                    !isInsertistop ? null : new MSSQL.Parameter("istop", SqlDbType.Bit, 0, ParameterDirection.Input, istop),
                    !isInsertistopall ? null : new MSSQL.Parameter("istopall", SqlDbType.Bit, 0, ParameterDirection.Input, istopall),
                    !isInsertisclassical ? null : new MSSQL.Parameter("isclassical", SqlDbType.Bit, 0, ParameterDirection.Input, isclassical),
                    !isInsertislock ? null : new MSSQL.Parameter("islock", SqlDbType.Bit, 0, ParameterDirection.Input, islock),
                    !isInsertisdelete ? null : new MSSQL.Parameter("isdelete", SqlDbType.Bit, 0, ParameterDirection.Input, isdelete),
                    !isInsertlastreplyuser ? null : new MSSQL.Parameter("lastreplyuser", SqlDbType.NVarChar, 0, ParameterDirection.Input, lastreplyuser),
                    !isInsertlastreplytime ? null : new MSSQL.Parameter("lastreplytime", SqlDbType.DateTime, 0, ParameterDirection.Input, lastreplytime),
                    !isInsertlastreplypreview ? null : new MSSQL.Parameter("lastreplypreview", SqlDbType.NVarChar, 0, ParameterDirection.Input, lastreplypreview),
                    !isInsertvoteid ? null : new MSSQL.Parameter("voteid", SqlDbType.Int, 0, ParameterDirection.Input, voteid),
                    !isInserttitlecolor ? null : new MSSQL.Parameter("titlecolor", SqlDbType.Int, 0, ParameterDirection.Input, titlecolor),
                    !isInsertlimitexp ? null : new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp),
                    !isInsertmoney ? null : new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    !isInserticon ? null : new MSSQL.Parameter("icon", SqlDbType.Int, 0, ParameterDirection.Input, icon),
                    !isInsertreplies ? null : new MSSQL.Parameter("replies", SqlDbType.Int, 0, ParameterDirection.Input, replies)
                    );
            }

            public static int Update(string Condition, int boardid, bool isUpdateboardid, int classid, bool isUpdateclassid, string title, bool isUpdatetitle, string content, bool isUpdatecontent, string name, bool isUpdatename, DateTime addtime, bool isUpdateaddtime, int clicks, bool isUpdateclicks, bool istop, bool isUpdateistop, bool istopall, bool isUpdateistopall, bool isclassical, bool isUpdateisclassical, bool islock, bool isUpdateislock, bool isdelete, bool isUpdateisdelete, string lastreplyuser, bool isUpdatelastreplyuser, DateTime lastreplytime, bool isUpdatelastreplytime, string lastreplypreview, bool isUpdatelastreplypreview, int voteid, bool isUpdatevoteid, int titlecolor, bool isUpdatetitlecolor, int limitexp, bool isUpdatelimitexp, int money, bool isUpdatemoney, int icon, bool isUpdateicon, int replies, bool isUpdatereplies)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_topic] set ";
                string UpdateFieldsList = "";

                if (isUpdateboardid)
                    UpdateFieldsList += "[boardid] = @boardid, ";
                if (isUpdateclassid)
                    UpdateFieldsList += "[classid] = @classid, ";
                if (isUpdatetitle)
                    UpdateFieldsList += "[title] = @title, ";
                if (isUpdatecontent)
                    UpdateFieldsList += "[content] = @content, ";
                if (isUpdatename)
                    UpdateFieldsList += "[name] = @name, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";
                if (isUpdateclicks)
                    UpdateFieldsList += "[clicks] = @clicks, ";
                if (isUpdateistop)
                    UpdateFieldsList += "[istop] = @istop, ";
                if (isUpdateistopall)
                    UpdateFieldsList += "[istopall] = @istopall, ";
                if (isUpdateisclassical)
                    UpdateFieldsList += "[isclassical] = @isclassical, ";
                if (isUpdateislock)
                    UpdateFieldsList += "[islock] = @islock, ";
                if (isUpdateisdelete)
                    UpdateFieldsList += "[isdelete] = @isdelete, ";
                if (isUpdatelastreplyuser)
                    UpdateFieldsList += "[lastreplyuser] = @lastreplyuser, ";
                if (isUpdatelastreplytime)
                    UpdateFieldsList += "[lastreplytime] = @lastreplytime, ";
                if (isUpdatelastreplypreview)
                    UpdateFieldsList += "[lastreplypreview] = @lastreplypreview, ";
                if (isUpdatevoteid)
                    UpdateFieldsList += "[voteid] = @voteid, ";
                if (isUpdatetitlecolor)
                    UpdateFieldsList += "[titlecolor] = @titlecolor, ";
                if (isUpdatelimitexp)
                    UpdateFieldsList += "[limitexp] = @limitexp, ";
                if (isUpdatemoney)
                    UpdateFieldsList += "[money] = @money, ";
                if (isUpdateicon)
                    UpdateFieldsList += "[icon] = @icon, ";
                if (isUpdatereplies)
                    UpdateFieldsList += "[replies] = @replies, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateboardid ? null : new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    !isUpdateclassid ? null : new MSSQL.Parameter("classid", SqlDbType.Int, 0, ParameterDirection.Input, classid),
                    !isUpdatetitle ? null : new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    !isUpdatecontent ? null : new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    !isUpdatename ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isUpdateclicks ? null : new MSSQL.Parameter("clicks", SqlDbType.Int, 0, ParameterDirection.Input, clicks),
                    !isUpdateistop ? null : new MSSQL.Parameter("istop", SqlDbType.Bit, 0, ParameterDirection.Input, istop),
                    !isUpdateistopall ? null : new MSSQL.Parameter("istopall", SqlDbType.Bit, 0, ParameterDirection.Input, istopall),
                    !isUpdateisclassical ? null : new MSSQL.Parameter("isclassical", SqlDbType.Bit, 0, ParameterDirection.Input, isclassical),
                    !isUpdateislock ? null : new MSSQL.Parameter("islock", SqlDbType.Bit, 0, ParameterDirection.Input, islock),
                    !isUpdateisdelete ? null : new MSSQL.Parameter("isdelete", SqlDbType.Bit, 0, ParameterDirection.Input, isdelete),
                    !isUpdatelastreplyuser ? null : new MSSQL.Parameter("lastreplyuser", SqlDbType.NVarChar, 0, ParameterDirection.Input, lastreplyuser),
                    !isUpdatelastreplytime ? null : new MSSQL.Parameter("lastreplytime", SqlDbType.DateTime, 0, ParameterDirection.Input, lastreplytime),
                    !isUpdatelastreplypreview ? null : new MSSQL.Parameter("lastreplypreview", SqlDbType.NVarChar, 0, ParameterDirection.Input, lastreplypreview),
                    !isUpdatevoteid ? null : new MSSQL.Parameter("voteid", SqlDbType.Int, 0, ParameterDirection.Input, voteid),
                    !isUpdatetitlecolor ? null : new MSSQL.Parameter("titlecolor", SqlDbType.Int, 0, ParameterDirection.Input, titlecolor),
                    !isUpdatelimitexp ? null : new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp),
                    !isUpdatemoney ? null : new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    !isUpdateicon ? null : new MSSQL.Parameter("icon", SqlDbType.Int, 0, ParameterDirection.Input, icon),
                    !isUpdatereplies ? null : new MSSQL.Parameter("replies", SqlDbType.Int, 0, ParameterDirection.Input, replies)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_topic]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_topic]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_user
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_user]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string name, bool isInsertname, string password, bool isInsertpassword, bool sex, bool isInsertsex, string email, bool isInsertemail, string info, bool isInsertinfo, string face, bool isInsertface, string signature, bool isInsertsignature, int roleid, bool isInsertroleid, int power, bool isInsertpower, int experience, bool isInsertexperience, int money, bool isInsertmoney, string rank, bool isInsertrank, bool islock, bool isInsertislock, DateTime unlocktime, bool isInsertunlocktime, int logins, bool isInsertlogins, string lastip, bool isInsertlastip, DateTime lasttime, bool isInsertlasttime, DateTime jointime, bool isInsertjointime, bool isonline, bool isInsertisonline, int topics, bool isInserttopics, int deletes, bool isInsertdeletes, int todayuploads, bool isInserttodayuploads, int todayuploadcount, bool isInserttodayuploadcount, string firstip, bool isInsertfirstip, int timezone, bool isInserttimezone, bool isdelete, bool isInsertisdelete, string truename, bool isInserttruename, string referrer, bool isInsertreferrer, bool isactivated, bool isInsertisactivated, int replies, bool isInsertreplies, string question, bool isInsertquestion, string answer, bool isInsertanswer, bool ishide, bool isInsertishide)
            {
                string CommandText = "insert into [bbs_user] (";
                string InsertFieldsList = "";

                if (isInsertname)
                    InsertFieldsList += "[name], ";
                if (isInsertpassword)
                    InsertFieldsList += "[password], ";
                if (isInsertsex)
                    InsertFieldsList += "[sex], ";
                if (isInsertemail)
                    InsertFieldsList += "[email], ";
                if (isInsertinfo)
                    InsertFieldsList += "[info], ";
                if (isInsertface)
                    InsertFieldsList += "[face], ";
                if (isInsertsignature)
                    InsertFieldsList += "[signature], ";
                if (isInsertroleid)
                    InsertFieldsList += "[roleid], ";
                if (isInsertpower)
                    InsertFieldsList += "[power], ";
                if (isInsertexperience)
                    InsertFieldsList += "[experience], ";
                if (isInsertmoney)
                    InsertFieldsList += "[money], ";
                if (isInsertrank)
                    InsertFieldsList += "[rank], ";
                if (isInsertislock)
                    InsertFieldsList += "[islock], ";
                if (isInsertunlocktime)
                    InsertFieldsList += "[unlocktime], ";
                if (isInsertlogins)
                    InsertFieldsList += "[logins], ";
                if (isInsertlastip)
                    InsertFieldsList += "[lastip], ";
                if (isInsertlasttime)
                    InsertFieldsList += "[lasttime], ";
                if (isInsertjointime)
                    InsertFieldsList += "[jointime], ";
                if (isInsertisonline)
                    InsertFieldsList += "[isonline], ";
                if (isInserttopics)
                    InsertFieldsList += "[topics], ";
                if (isInsertdeletes)
                    InsertFieldsList += "[deletes], ";
                if (isInserttodayuploads)
                    InsertFieldsList += "[todayuploads], ";
                if (isInserttodayuploadcount)
                    InsertFieldsList += "[todayuploadcount], ";
                if (isInsertfirstip)
                    InsertFieldsList += "[firstip], ";
                if (isInserttimezone)
                    InsertFieldsList += "[timezone], ";
                if (isInsertisdelete)
                    InsertFieldsList += "[isdelete], ";
                if (isInserttruename)
                    InsertFieldsList += "[truename], ";
                if (isInsertreferrer)
                    InsertFieldsList += "[referrer], ";
                if (isInsertisactivated)
                    InsertFieldsList += "[isactivated], ";
                if (isInsertreplies)
                    InsertFieldsList += "[replies], ";
                if (isInsertquestion)
                    InsertFieldsList += "[question], ";
                if (isInsertanswer)
                    InsertFieldsList += "[answer], ";
                if (isInsertishide)
                    InsertFieldsList += "[ishide], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertname)
                    InsertValuesList += "@name, ";
                if (isInsertpassword)
                    InsertValuesList += "@password, ";
                if (isInsertsex)
                    InsertValuesList += "@sex, ";
                if (isInsertemail)
                    InsertValuesList += "@email, ";
                if (isInsertinfo)
                    InsertValuesList += "@info, ";
                if (isInsertface)
                    InsertValuesList += "@face, ";
                if (isInsertsignature)
                    InsertValuesList += "@signature, ";
                if (isInsertroleid)
                    InsertValuesList += "@roleid, ";
                if (isInsertpower)
                    InsertValuesList += "@power, ";
                if (isInsertexperience)
                    InsertValuesList += "@experience, ";
                if (isInsertmoney)
                    InsertValuesList += "@money, ";
                if (isInsertrank)
                    InsertValuesList += "@rank, ";
                if (isInsertislock)
                    InsertValuesList += "@islock, ";
                if (isInsertunlocktime)
                    InsertValuesList += "@unlocktime, ";
                if (isInsertlogins)
                    InsertValuesList += "@logins, ";
                if (isInsertlastip)
                    InsertValuesList += "@lastip, ";
                if (isInsertlasttime)
                    InsertValuesList += "@lasttime, ";
                if (isInsertjointime)
                    InsertValuesList += "@jointime, ";
                if (isInsertisonline)
                    InsertValuesList += "@isonline, ";
                if (isInserttopics)
                    InsertValuesList += "@topics, ";
                if (isInsertdeletes)
                    InsertValuesList += "@deletes, ";
                if (isInserttodayuploads)
                    InsertValuesList += "@todayuploads, ";
                if (isInserttodayuploadcount)
                    InsertValuesList += "@todayuploadcount, ";
                if (isInsertfirstip)
                    InsertValuesList += "@firstip, ";
                if (isInserttimezone)
                    InsertValuesList += "@timezone, ";
                if (isInsertisdelete)
                    InsertValuesList += "@isdelete, ";
                if (isInserttruename)
                    InsertValuesList += "@truename, ";
                if (isInsertreferrer)
                    InsertValuesList += "@referrer, ";
                if (isInsertisactivated)
                    InsertValuesList += "@isactivated, ";
                if (isInsertreplies)
                    InsertValuesList += "@replies, ";
                if (isInsertquestion)
                    InsertValuesList += "@question, ";
                if (isInsertanswer)
                    InsertValuesList += "@answer, ";
                if (isInsertishide)
                    InsertValuesList += "@ishide, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertname ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isInsertpassword ? null : new MSSQL.Parameter("password", SqlDbType.NVarChar, 0, ParameterDirection.Input, password),
                    !isInsertsex ? null : new MSSQL.Parameter("sex", SqlDbType.Bit, 0, ParameterDirection.Input, sex),
                    !isInsertemail ? null : new MSSQL.Parameter("email", SqlDbType.NVarChar, 0, ParameterDirection.Input, email),
                    !isInsertinfo ? null : new MSSQL.Parameter("info", SqlDbType.NVarChar, 0, ParameterDirection.Input, info),
                    !isInsertface ? null : new MSSQL.Parameter("face", SqlDbType.NVarChar, 0, ParameterDirection.Input, face),
                    !isInsertsignature ? null : new MSSQL.Parameter("signature", SqlDbType.NText, 0, ParameterDirection.Input, signature),
                    !isInsertroleid ? null : new MSSQL.Parameter("roleid", SqlDbType.Int, 0, ParameterDirection.Input, roleid),
                    !isInsertpower ? null : new MSSQL.Parameter("power", SqlDbType.Int, 0, ParameterDirection.Input, power),
                    !isInsertexperience ? null : new MSSQL.Parameter("experience", SqlDbType.Int, 0, ParameterDirection.Input, experience),
                    !isInsertmoney ? null : new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    !isInsertrank ? null : new MSSQL.Parameter("rank", SqlDbType.NVarChar, 0, ParameterDirection.Input, rank),
                    !isInsertislock ? null : new MSSQL.Parameter("islock", SqlDbType.Bit, 0, ParameterDirection.Input, islock),
                    !isInsertunlocktime ? null : new MSSQL.Parameter("unlocktime", SqlDbType.DateTime, 0, ParameterDirection.Input, unlocktime),
                    !isInsertlogins ? null : new MSSQL.Parameter("logins", SqlDbType.Int, 0, ParameterDirection.Input, logins),
                    !isInsertlastip ? null : new MSSQL.Parameter("lastip", SqlDbType.NVarChar, 0, ParameterDirection.Input, lastip),
                    !isInsertlasttime ? null : new MSSQL.Parameter("lasttime", SqlDbType.DateTime, 0, ParameterDirection.Input, lasttime),
                    !isInsertjointime ? null : new MSSQL.Parameter("jointime", SqlDbType.DateTime, 0, ParameterDirection.Input, jointime),
                    !isInsertisonline ? null : new MSSQL.Parameter("isonline", SqlDbType.Bit, 0, ParameterDirection.Input, isonline),
                    !isInserttopics ? null : new MSSQL.Parameter("topics", SqlDbType.Int, 0, ParameterDirection.Input, topics),
                    !isInsertdeletes ? null : new MSSQL.Parameter("deletes", SqlDbType.Int, 0, ParameterDirection.Input, deletes),
                    !isInserttodayuploads ? null : new MSSQL.Parameter("todayuploads", SqlDbType.Int, 0, ParameterDirection.Input, todayuploads),
                    !isInserttodayuploadcount ? null : new MSSQL.Parameter("todayuploadcount", SqlDbType.Int, 0, ParameterDirection.Input, todayuploadcount),
                    !isInsertfirstip ? null : new MSSQL.Parameter("firstip", SqlDbType.NVarChar, 0, ParameterDirection.Input, firstip),
                    !isInserttimezone ? null : new MSSQL.Parameter("timezone", SqlDbType.Int, 0, ParameterDirection.Input, timezone),
                    !isInsertisdelete ? null : new MSSQL.Parameter("isdelete", SqlDbType.Bit, 0, ParameterDirection.Input, isdelete),
                    !isInserttruename ? null : new MSSQL.Parameter("truename", SqlDbType.NVarChar, 0, ParameterDirection.Input, truename),
                    !isInsertreferrer ? null : new MSSQL.Parameter("referrer", SqlDbType.NVarChar, 0, ParameterDirection.Input, referrer),
                    !isInsertisactivated ? null : new MSSQL.Parameter("isactivated", SqlDbType.Bit, 0, ParameterDirection.Input, isactivated),
                    !isInsertreplies ? null : new MSSQL.Parameter("replies", SqlDbType.Int, 0, ParameterDirection.Input, replies),
                    !isInsertquestion ? null : new MSSQL.Parameter("question", SqlDbType.NVarChar, 0, ParameterDirection.Input, question),
                    !isInsertanswer ? null : new MSSQL.Parameter("answer", SqlDbType.NVarChar, 0, ParameterDirection.Input, answer),
                    !isInsertishide ? null : new MSSQL.Parameter("ishide", SqlDbType.Bit, 0, ParameterDirection.Input, ishide)
                    );
            }

            public static int Update(string Condition, string name, bool isUpdatename, string password, bool isUpdatepassword, bool sex, bool isUpdatesex, string email, bool isUpdateemail, string info, bool isUpdateinfo, string face, bool isUpdateface, string signature, bool isUpdatesignature, int roleid, bool isUpdateroleid, int power, bool isUpdatepower, int experience, bool isUpdateexperience, int money, bool isUpdatemoney, string rank, bool isUpdaterank, bool islock, bool isUpdateislock, DateTime unlocktime, bool isUpdateunlocktime, int logins, bool isUpdatelogins, string lastip, bool isUpdatelastip, DateTime lasttime, bool isUpdatelasttime, DateTime jointime, bool isUpdatejointime, bool isonline, bool isUpdateisonline, int topics, bool isUpdatetopics, int deletes, bool isUpdatedeletes, int todayuploads, bool isUpdatetodayuploads, int todayuploadcount, bool isUpdatetodayuploadcount, string firstip, bool isUpdatefirstip, int timezone, bool isUpdatetimezone, bool isdelete, bool isUpdateisdelete, string truename, bool isUpdatetruename, string referrer, bool isUpdatereferrer, bool isactivated, bool isUpdateisactivated, int replies, bool isUpdatereplies, string question, bool isUpdatequestion, string answer, bool isUpdateanswer, bool ishide, bool isUpdateishide)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_user] set ";
                string UpdateFieldsList = "";

                if (isUpdatename)
                    UpdateFieldsList += "[name] = @name, ";
                if (isUpdatepassword)
                    UpdateFieldsList += "[password] = @password, ";
                if (isUpdatesex)
                    UpdateFieldsList += "[sex] = @sex, ";
                if (isUpdateemail)
                    UpdateFieldsList += "[email] = @email, ";
                if (isUpdateinfo)
                    UpdateFieldsList += "[info] = @info, ";
                if (isUpdateface)
                    UpdateFieldsList += "[face] = @face, ";
                if (isUpdatesignature)
                    UpdateFieldsList += "[signature] = @signature, ";
                if (isUpdateroleid)
                    UpdateFieldsList += "[roleid] = @roleid, ";
                if (isUpdatepower)
                    UpdateFieldsList += "[power] = @power, ";
                if (isUpdateexperience)
                    UpdateFieldsList += "[experience] = @experience, ";
                if (isUpdatemoney)
                    UpdateFieldsList += "[money] = @money, ";
                if (isUpdaterank)
                    UpdateFieldsList += "[rank] = @rank, ";
                if (isUpdateislock)
                    UpdateFieldsList += "[islock] = @islock, ";
                if (isUpdateunlocktime)
                    UpdateFieldsList += "[unlocktime] = @unlocktime, ";
                if (isUpdatelogins)
                    UpdateFieldsList += "[logins] = @logins, ";
                if (isUpdatelastip)
                    UpdateFieldsList += "[lastip] = @lastip, ";
                if (isUpdatelasttime)
                    UpdateFieldsList += "[lasttime] = @lasttime, ";
                if (isUpdatejointime)
                    UpdateFieldsList += "[jointime] = @jointime, ";
                if (isUpdateisonline)
                    UpdateFieldsList += "[isonline] = @isonline, ";
                if (isUpdatetopics)
                    UpdateFieldsList += "[topics] = @topics, ";
                if (isUpdatedeletes)
                    UpdateFieldsList += "[deletes] = @deletes, ";
                if (isUpdatetodayuploads)
                    UpdateFieldsList += "[todayuploads] = @todayuploads, ";
                if (isUpdatetodayuploadcount)
                    UpdateFieldsList += "[todayuploadcount] = @todayuploadcount, ";
                if (isUpdatefirstip)
                    UpdateFieldsList += "[firstip] = @firstip, ";
                if (isUpdatetimezone)
                    UpdateFieldsList += "[timezone] = @timezone, ";
                if (isUpdateisdelete)
                    UpdateFieldsList += "[isdelete] = @isdelete, ";
                if (isUpdatetruename)
                    UpdateFieldsList += "[truename] = @truename, ";
                if (isUpdatereferrer)
                    UpdateFieldsList += "[referrer] = @referrer, ";
                if (isUpdateisactivated)
                    UpdateFieldsList += "[isactivated] = @isactivated, ";
                if (isUpdatereplies)
                    UpdateFieldsList += "[replies] = @replies, ";
                if (isUpdatequestion)
                    UpdateFieldsList += "[question] = @question, ";
                if (isUpdateanswer)
                    UpdateFieldsList += "[answer] = @answer, ";
                if (isUpdateishide)
                    UpdateFieldsList += "[ishide] = @ishide, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatename ? null : new MSSQL.Parameter("name", SqlDbType.NVarChar, 0, ParameterDirection.Input, name),
                    !isUpdatepassword ? null : new MSSQL.Parameter("password", SqlDbType.NVarChar, 0, ParameterDirection.Input, password),
                    !isUpdatesex ? null : new MSSQL.Parameter("sex", SqlDbType.Bit, 0, ParameterDirection.Input, sex),
                    !isUpdateemail ? null : new MSSQL.Parameter("email", SqlDbType.NVarChar, 0, ParameterDirection.Input, email),
                    !isUpdateinfo ? null : new MSSQL.Parameter("info", SqlDbType.NVarChar, 0, ParameterDirection.Input, info),
                    !isUpdateface ? null : new MSSQL.Parameter("face", SqlDbType.NVarChar, 0, ParameterDirection.Input, face),
                    !isUpdatesignature ? null : new MSSQL.Parameter("signature", SqlDbType.NText, 0, ParameterDirection.Input, signature),
                    !isUpdateroleid ? null : new MSSQL.Parameter("roleid", SqlDbType.Int, 0, ParameterDirection.Input, roleid),
                    !isUpdatepower ? null : new MSSQL.Parameter("power", SqlDbType.Int, 0, ParameterDirection.Input, power),
                    !isUpdateexperience ? null : new MSSQL.Parameter("experience", SqlDbType.Int, 0, ParameterDirection.Input, experience),
                    !isUpdatemoney ? null : new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    !isUpdaterank ? null : new MSSQL.Parameter("rank", SqlDbType.NVarChar, 0, ParameterDirection.Input, rank),
                    !isUpdateislock ? null : new MSSQL.Parameter("islock", SqlDbType.Bit, 0, ParameterDirection.Input, islock),
                    !isUpdateunlocktime ? null : new MSSQL.Parameter("unlocktime", SqlDbType.DateTime, 0, ParameterDirection.Input, unlocktime),
                    !isUpdatelogins ? null : new MSSQL.Parameter("logins", SqlDbType.Int, 0, ParameterDirection.Input, logins),
                    !isUpdatelastip ? null : new MSSQL.Parameter("lastip", SqlDbType.NVarChar, 0, ParameterDirection.Input, lastip),
                    !isUpdatelasttime ? null : new MSSQL.Parameter("lasttime", SqlDbType.DateTime, 0, ParameterDirection.Input, lasttime),
                    !isUpdatejointime ? null : new MSSQL.Parameter("jointime", SqlDbType.DateTime, 0, ParameterDirection.Input, jointime),
                    !isUpdateisonline ? null : new MSSQL.Parameter("isonline", SqlDbType.Bit, 0, ParameterDirection.Input, isonline),
                    !isUpdatetopics ? null : new MSSQL.Parameter("topics", SqlDbType.Int, 0, ParameterDirection.Input, topics),
                    !isUpdatedeletes ? null : new MSSQL.Parameter("deletes", SqlDbType.Int, 0, ParameterDirection.Input, deletes),
                    !isUpdatetodayuploads ? null : new MSSQL.Parameter("todayuploads", SqlDbType.Int, 0, ParameterDirection.Input, todayuploads),
                    !isUpdatetodayuploadcount ? null : new MSSQL.Parameter("todayuploadcount", SqlDbType.Int, 0, ParameterDirection.Input, todayuploadcount),
                    !isUpdatefirstip ? null : new MSSQL.Parameter("firstip", SqlDbType.NVarChar, 0, ParameterDirection.Input, firstip),
                    !isUpdatetimezone ? null : new MSSQL.Parameter("timezone", SqlDbType.Int, 0, ParameterDirection.Input, timezone),
                    !isUpdateisdelete ? null : new MSSQL.Parameter("isdelete", SqlDbType.Bit, 0, ParameterDirection.Input, isdelete),
                    !isUpdatetruename ? null : new MSSQL.Parameter("truename", SqlDbType.NVarChar, 0, ParameterDirection.Input, truename),
                    !isUpdatereferrer ? null : new MSSQL.Parameter("referrer", SqlDbType.NVarChar, 0, ParameterDirection.Input, referrer),
                    !isUpdateisactivated ? null : new MSSQL.Parameter("isactivated", SqlDbType.Bit, 0, ParameterDirection.Input, isactivated),
                    !isUpdatereplies ? null : new MSSQL.Parameter("replies", SqlDbType.Int, 0, ParameterDirection.Input, replies),
                    !isUpdatequestion ? null : new MSSQL.Parameter("question", SqlDbType.NVarChar, 0, ParameterDirection.Input, question),
                    !isUpdateanswer ? null : new MSSQL.Parameter("answer", SqlDbType.NVarChar, 0, ParameterDirection.Input, answer),
                    !isUpdateishide ? null : new MSSQL.Parameter("ishide", SqlDbType.Bit, 0, ParameterDirection.Input, ishide)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_user]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_user]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class bbs_vote
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [bbs_vote]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string items, bool isInsertitems, string tickets, bool isInserttickets, string users, bool isInsertusers, bool ismultiable, bool isInsertismultiable, DateTime addtime, bool isInsertaddtime, int days, bool isInsertdays, int limitexp, bool isInsertlimitexp)
            {
                string CommandText = "insert into [bbs_vote] (";
                string InsertFieldsList = "";

                if (isInsertitems)
                    InsertFieldsList += "[items], ";
                if (isInserttickets)
                    InsertFieldsList += "[tickets], ";
                if (isInsertusers)
                    InsertFieldsList += "[users], ";
                if (isInsertismultiable)
                    InsertFieldsList += "[ismultiable], ";
                if (isInsertaddtime)
                    InsertFieldsList += "[addtime], ";
                if (isInsertdays)
                    InsertFieldsList += "[days], ";
                if (isInsertlimitexp)
                    InsertFieldsList += "[limitexp], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertitems)
                    InsertValuesList += "@items, ";
                if (isInserttickets)
                    InsertValuesList += "@tickets, ";
                if (isInsertusers)
                    InsertValuesList += "@users, ";
                if (isInsertismultiable)
                    InsertValuesList += "@ismultiable, ";
                if (isInsertaddtime)
                    InsertValuesList += "@addtime, ";
                if (isInsertdays)
                    InsertValuesList += "@days, ";
                if (isInsertlimitexp)
                    InsertValuesList += "@limitexp, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertitems ? null : new MSSQL.Parameter("items", SqlDbType.NText, 0, ParameterDirection.Input, items),
                    !isInserttickets ? null : new MSSQL.Parameter("tickets", SqlDbType.NVarChar, 0, ParameterDirection.Input, tickets),
                    !isInsertusers ? null : new MSSQL.Parameter("users", SqlDbType.NText, 0, ParameterDirection.Input, users),
                    !isInsertismultiable ? null : new MSSQL.Parameter("ismultiable", SqlDbType.Bit, 0, ParameterDirection.Input, ismultiable),
                    !isInsertaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isInsertdays ? null : new MSSQL.Parameter("days", SqlDbType.Int, 0, ParameterDirection.Input, days),
                    !isInsertlimitexp ? null : new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp)
                    );
            }

            public static int Update(string Condition, string items, bool isUpdateitems, string tickets, bool isUpdatetickets, string users, bool isUpdateusers, bool ismultiable, bool isUpdateismultiable, DateTime addtime, bool isUpdateaddtime, int days, bool isUpdatedays, int limitexp, bool isUpdatelimitexp)
            {
                Condition = Condition.Trim();

                string CommandText = "update [bbs_vote] set ";
                string UpdateFieldsList = "";

                if (isUpdateitems)
                    UpdateFieldsList += "[items] = @items, ";
                if (isUpdatetickets)
                    UpdateFieldsList += "[tickets] = @tickets, ";
                if (isUpdateusers)
                    UpdateFieldsList += "[users] = @users, ";
                if (isUpdateismultiable)
                    UpdateFieldsList += "[ismultiable] = @ismultiable, ";
                if (isUpdateaddtime)
                    UpdateFieldsList += "[addtime] = @addtime, ";
                if (isUpdatedays)
                    UpdateFieldsList += "[days] = @days, ";
                if (isUpdatelimitexp)
                    UpdateFieldsList += "[limitexp] = @limitexp, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateitems ? null : new MSSQL.Parameter("items", SqlDbType.NText, 0, ParameterDirection.Input, items),
                    !isUpdatetickets ? null : new MSSQL.Parameter("tickets", SqlDbType.NVarChar, 0, ParameterDirection.Input, tickets),
                    !isUpdateusers ? null : new MSSQL.Parameter("users", SqlDbType.NText, 0, ParameterDirection.Input, users),
                    !isUpdateismultiable ? null : new MSSQL.Parameter("ismultiable", SqlDbType.Bit, 0, ParameterDirection.Input, ismultiable),
                    !isUpdateaddtime ? null : new MSSQL.Parameter("addtime", SqlDbType.DateTime, 0, ParameterDirection.Input, addtime),
                    !isUpdatedays ? null : new MSSQL.Parameter("days", SqlDbType.Int, 0, ParameterDirection.Input, days),
                    !isUpdatelimitexp ? null : new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [bbs_vote]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [bbs_vote]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Celeb
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Celeb]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int User_id, bool isInsertUser_id, string Title, bool isInsertTitle, byte[] Intro, bool isInsertIntro, byte[] Say, bool isInsertSay, byte[] Comment, bool isInsertComment, byte[] Score, bool isInsertScore, string Photo, bool isInsertPhoto, int Sort, bool isInsertSort, bool isAtWinNameList, bool isInsertisAtWinNameList)
            {
                string CommandText = "insert into [Celeb] (";
                string InsertFieldsList = "";

                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertIntro)
                    InsertFieldsList += "[Intro], ";
                if (isInsertSay)
                    InsertFieldsList += "[Say], ";
                if (isInsertComment)
                    InsertFieldsList += "[Comment], ";
                if (isInsertScore)
                    InsertFieldsList += "[Score], ";
                if (isInsertPhoto)
                    InsertFieldsList += "[Photo], ";
                if (isInsertSort)
                    InsertFieldsList += "[Sort], ";
                if (isInsertisAtWinNameList)
                    InsertFieldsList += "[isAtWinNameList], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertIntro)
                    InsertValuesList += "@Intro, ";
                if (isInsertSay)
                    InsertValuesList += "@Say, ";
                if (isInsertComment)
                    InsertValuesList += "@Comment, ";
                if (isInsertScore)
                    InsertValuesList += "@Score, ";
                if (isInsertPhoto)
                    InsertValuesList += "@Photo, ";
                if (isInsertSort)
                    InsertValuesList += "@Sort, ";
                if (isInsertisAtWinNameList)
                    InsertValuesList += "@isAtWinNameList, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertIntro ? null : new MSSQL.Parameter("Intro", SqlDbType.Image, 0, ParameterDirection.Input, Intro),
                    !isInsertSay ? null : new MSSQL.Parameter("Say", SqlDbType.Image, 0, ParameterDirection.Input, Say),
                    !isInsertComment ? null : new MSSQL.Parameter("Comment", SqlDbType.Image, 0, ParameterDirection.Input, Comment),
                    !isInsertScore ? null : new MSSQL.Parameter("Score", SqlDbType.Image, 0, ParameterDirection.Input, Score),
                    !isInsertPhoto ? null : new MSSQL.Parameter("Photo", SqlDbType.VarChar, 0, ParameterDirection.Input, Photo),
                    !isInsertSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort),
                    !isInsertisAtWinNameList ? null : new MSSQL.Parameter("isAtWinNameList", SqlDbType.Bit, 0, ParameterDirection.Input, isAtWinNameList)
                    );
            }

            public static int Update(string Condition, int User_id, bool isUpdateUser_id, string Title, bool isUpdateTitle, byte[] Intro, bool isUpdateIntro, byte[] Say, bool isUpdateSay, byte[] Comment, bool isUpdateComment, byte[] Score, bool isUpdateScore, string Photo, bool isUpdatePhoto, int Sort, bool isUpdateSort, bool isAtWinNameList, bool isUpdateisAtWinNameList)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Celeb] set ";
                string UpdateFieldsList = "";

                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateIntro)
                    UpdateFieldsList += "[Intro] = @Intro, ";
                if (isUpdateSay)
                    UpdateFieldsList += "[Say] = @Say, ";
                if (isUpdateComment)
                    UpdateFieldsList += "[Comment] = @Comment, ";
                if (isUpdateScore)
                    UpdateFieldsList += "[Score] = @Score, ";
                if (isUpdatePhoto)
                    UpdateFieldsList += "[Photo] = @Photo, ";
                if (isUpdateSort)
                    UpdateFieldsList += "[Sort] = @Sort, ";
                if (isUpdateisAtWinNameList)
                    UpdateFieldsList += "[isAtWinNameList] = @isAtWinNameList, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateIntro ? null : new MSSQL.Parameter("Intro", SqlDbType.Image, 0, ParameterDirection.Input, Intro),
                    !isUpdateSay ? null : new MSSQL.Parameter("Say", SqlDbType.Image, 0, ParameterDirection.Input, Say),
                    !isUpdateComment ? null : new MSSQL.Parameter("Comment", SqlDbType.Image, 0, ParameterDirection.Input, Comment),
                    !isUpdateScore ? null : new MSSQL.Parameter("Score", SqlDbType.Image, 0, ParameterDirection.Input, Score),
                    !isUpdatePhoto ? null : new MSSQL.Parameter("Photo", SqlDbType.VarChar, 0, ParameterDirection.Input, Photo),
                    !isUpdateSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort),
                    !isUpdateisAtWinNameList ? null : new MSSQL.Parameter("isAtWinNameList", SqlDbType.Bit, 0, ParameterDirection.Input, isAtWinNameList)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Celeb]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Celeb]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Chase
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Chase]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, int User_id, bool isInsertUser_id, string Title, bool isInsertTitle, byte[] Description, bool isInsertDescription, int Lottery_id, bool isInsertLottery_id, int BuyType_id, bool isInsertBuyType_id, byte[] LotteryNumber, bool isInsertLotteryNumber, int Multiple, bool isInsertMultiple, double IsuseMoney, bool isInsertIsuseMoney, bool Quashed, bool isInsertQuashed, double AutoStopAtWinMoney, bool isInsertAutoStopAtWinMoney, int SecrecyLevel, bool isInsertSecrecyLevel)
            {
                string CommandText = "insert into [Chase] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertDescription)
                    InsertFieldsList += "[Description], ";
                if (isInsertLottery_id)
                    InsertFieldsList += "[Lottery_id], ";
                if (isInsertBuyType_id)
                    InsertFieldsList += "[BuyType_id], ";
                if (isInsertLotteryNumber)
                    InsertFieldsList += "[LotteryNumber], ";
                if (isInsertMultiple)
                    InsertFieldsList += "[Multiple], ";
                if (isInsertIsuseMoney)
                    InsertFieldsList += "[IsuseMoney], ";
                if (isInsertQuashed)
                    InsertFieldsList += "[Quashed], ";
                if (isInsertAutoStopAtWinMoney)
                    InsertFieldsList += "[AutoStopAtWinMoney], ";
                if (isInsertSecrecyLevel)
                    InsertFieldsList += "[SecrecyLevel], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertDescription)
                    InsertValuesList += "@Description, ";
                if (isInsertLottery_id)
                    InsertValuesList += "@Lottery_id, ";
                if (isInsertBuyType_id)
                    InsertValuesList += "@BuyType_id, ";
                if (isInsertLotteryNumber)
                    InsertValuesList += "@LotteryNumber, ";
                if (isInsertMultiple)
                    InsertValuesList += "@Multiple, ";
                if (isInsertIsuseMoney)
                    InsertValuesList += "@IsuseMoney, ";
                if (isInsertQuashed)
                    InsertValuesList += "@Quashed, ";
                if (isInsertAutoStopAtWinMoney)
                    InsertValuesList += "@AutoStopAtWinMoney, ";
                if (isInsertSecrecyLevel)
                    InsertValuesList += "@SecrecyLevel, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertDescription ? null : new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    !isInsertLottery_id ? null : new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    !isInsertBuyType_id ? null : new MSSQL.Parameter("BuyType_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyType_id),
                    !isInsertLotteryNumber ? null : new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    !isInsertMultiple ? null : new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    !isInsertIsuseMoney ? null : new MSSQL.Parameter("IsuseMoney", SqlDbType.Money, 0, ParameterDirection.Input, IsuseMoney),
                    !isInsertQuashed ? null : new MSSQL.Parameter("Quashed", SqlDbType.Bit, 0, ParameterDirection.Input, Quashed),
                    !isInsertAutoStopAtWinMoney ? null : new MSSQL.Parameter("AutoStopAtWinMoney", SqlDbType.Money, 0, ParameterDirection.Input, AutoStopAtWinMoney),
                    !isInsertSecrecyLevel ? null : new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, int User_id, bool isUpdateUser_id, string Title, bool isUpdateTitle, byte[] Description, bool isUpdateDescription, int Lottery_id, bool isUpdateLottery_id, int BuyType_id, bool isUpdateBuyType_id, byte[] LotteryNumber, bool isUpdateLotteryNumber, int Multiple, bool isUpdateMultiple, double IsuseMoney, bool isUpdateIsuseMoney, bool Quashed, bool isUpdateQuashed, double AutoStopAtWinMoney, bool isUpdateAutoStopAtWinMoney, int SecrecyLevel, bool isUpdateSecrecyLevel)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Chase] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateDescription)
                    UpdateFieldsList += "[Description] = @Description, ";
                if (isUpdateLottery_id)
                    UpdateFieldsList += "[Lottery_id] = @Lottery_id, ";
                if (isUpdateBuyType_id)
                    UpdateFieldsList += "[BuyType_id] = @BuyType_id, ";
                if (isUpdateLotteryNumber)
                    UpdateFieldsList += "[LotteryNumber] = @LotteryNumber, ";
                if (isUpdateMultiple)
                    UpdateFieldsList += "[Multiple] = @Multiple, ";
                if (isUpdateIsuseMoney)
                    UpdateFieldsList += "[IsuseMoney] = @IsuseMoney, ";
                if (isUpdateQuashed)
                    UpdateFieldsList += "[Quashed] = @Quashed, ";
                if (isUpdateAutoStopAtWinMoney)
                    UpdateFieldsList += "[AutoStopAtWinMoney] = @AutoStopAtWinMoney, ";
                if (isUpdateSecrecyLevel)
                    UpdateFieldsList += "[SecrecyLevel] = @SecrecyLevel, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateDescription ? null : new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    !isUpdateLottery_id ? null : new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    !isUpdateBuyType_id ? null : new MSSQL.Parameter("BuyType_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyType_id),
                    !isUpdateLotteryNumber ? null : new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    !isUpdateMultiple ? null : new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    !isUpdateIsuseMoney ? null : new MSSQL.Parameter("IsuseMoney", SqlDbType.Money, 0, ParameterDirection.Input, IsuseMoney),
                    !isUpdateQuashed ? null : new MSSQL.Parameter("Quashed", SqlDbType.Bit, 0, ParameterDirection.Input, Quashed),
                    !isUpdateAutoStopAtWinMoney ? null : new MSSQL.Parameter("AutoStopAtWinMoney", SqlDbType.Money, 0, ParameterDirection.Input, AutoStopAtWinMoney),
                    !isUpdateSecrecyLevel ? null : new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Chase]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Chase]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class ChaseDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [ChaseDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, int Chase_id, bool isInsertChase_id, int Isuse_id, bool isInsertIsuse_id, byte[] LotteryNumber, bool isInsertLotteryNumber, bool Quashed, bool isInsertQuashed, bool Buyed, bool isInsertBuyed, int Scheme_id, bool isInsertScheme_id)
            {
                string CommandText = "insert into [ChaseDetail] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertChase_id)
                    InsertFieldsList += "[Chase_id], ";
                if (isInsertIsuse_id)
                    InsertFieldsList += "[Isuse_id], ";
                if (isInsertLotteryNumber)
                    InsertFieldsList += "[LotteryNumber], ";
                if (isInsertQuashed)
                    InsertFieldsList += "[Quashed], ";
                if (isInsertBuyed)
                    InsertFieldsList += "[Buyed], ";
                if (isInsertScheme_id)
                    InsertFieldsList += "[Scheme_id], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertChase_id)
                    InsertValuesList += "@Chase_id, ";
                if (isInsertIsuse_id)
                    InsertValuesList += "@Isuse_id, ";
                if (isInsertLotteryNumber)
                    InsertValuesList += "@LotteryNumber, ";
                if (isInsertQuashed)
                    InsertValuesList += "@Quashed, ";
                if (isInsertBuyed)
                    InsertValuesList += "@Buyed, ";
                if (isInsertScheme_id)
                    InsertValuesList += "@Scheme_id, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertChase_id ? null : new MSSQL.Parameter("Chase_id", SqlDbType.Int, 0, ParameterDirection.Input, Chase_id),
                    !isInsertIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isInsertLotteryNumber ? null : new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    !isInsertQuashed ? null : new MSSQL.Parameter("Quashed", SqlDbType.Bit, 0, ParameterDirection.Input, Quashed),
                    !isInsertBuyed ? null : new MSSQL.Parameter("Buyed", SqlDbType.Bit, 0, ParameterDirection.Input, Buyed),
                    !isInsertScheme_id ? null : new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, int Chase_id, bool isUpdateChase_id, int Isuse_id, bool isUpdateIsuse_id, byte[] LotteryNumber, bool isUpdateLotteryNumber, bool Quashed, bool isUpdateQuashed, bool Buyed, bool isUpdateBuyed, int Scheme_id, bool isUpdateScheme_id)
            {
                Condition = Condition.Trim();

                string CommandText = "update [ChaseDetail] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateChase_id)
                    UpdateFieldsList += "[Chase_id] = @Chase_id, ";
                if (isUpdateIsuse_id)
                    UpdateFieldsList += "[Isuse_id] = @Isuse_id, ";
                if (isUpdateLotteryNumber)
                    UpdateFieldsList += "[LotteryNumber] = @LotteryNumber, ";
                if (isUpdateQuashed)
                    UpdateFieldsList += "[Quashed] = @Quashed, ";
                if (isUpdateBuyed)
                    UpdateFieldsList += "[Buyed] = @Buyed, ";
                if (isUpdateScheme_id)
                    UpdateFieldsList += "[Scheme_id] = @Scheme_id, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateChase_id ? null : new MSSQL.Parameter("Chase_id", SqlDbType.Int, 0, ParameterDirection.Input, Chase_id),
                    !isUpdateIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isUpdateLotteryNumber ? null : new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    !isUpdateQuashed ? null : new MSSQL.Parameter("Quashed", SqlDbType.Bit, 0, ParameterDirection.Input, Quashed),
                    !isUpdateBuyed ? null : new MSSQL.Parameter("Buyed", SqlDbType.Bit, 0, ParameterDirection.Input, Buyed),
                    !isUpdateScheme_id ? null : new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [ChaseDetail]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [ChaseDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class City
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [City]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int id, bool isInsertid, int Province_id, bool isInsertProvince_id, string Name, bool isInsertName)
            {
                string CommandText = "insert into [City] (";
                string InsertFieldsList = "";

                if (isInsertid)
                    InsertFieldsList += "[id], ";
                if (isInsertProvince_id)
                    InsertFieldsList += "[Province_id], ";
                if (isInsertName)
                    InsertFieldsList += "[Name], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertid)
                    InsertValuesList += "@id, ";
                if (isInsertProvince_id)
                    InsertValuesList += "@Province_id, ";
                if (isInsertName)
                    InsertValuesList += "@Name, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isInsertProvince_id ? null : new MSSQL.Parameter("Province_id", SqlDbType.Int, 0, ParameterDirection.Input, Province_id),
                    !isInsertName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name)
                    );
            }

            public static int Update(string Condition, int id, bool isUpdateid, int Province_id, bool isUpdateProvince_id, string Name, bool isUpdateName)
            {
                Condition = Condition.Trim();

                string CommandText = "update [City] set ";
                string UpdateFieldsList = "";

                if (isUpdateid)
                    UpdateFieldsList += "[id] = @id, ";
                if (isUpdateProvince_id)
                    UpdateFieldsList += "[Province_id] = @Province_id, ";
                if (isUpdateName)
                    UpdateFieldsList += "[Name] = @Name, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isUpdateProvince_id ? null : new MSSQL.Parameter("Province_id", SqlDbType.Int, 0, ParameterDirection.Input, Province_id),
                    !isUpdateName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [City]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [City]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class IPAddress
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [IPAddress]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(double IPStart, bool isInsertIPStart, double IPEnd, bool isInsertIPEnd, string Country, bool isInsertCountry, string City, bool isInsertCity)
            {
                string CommandText = "insert into [IPAddress] (";
                string InsertFieldsList = "";

                if (isInsertIPStart)
                    InsertFieldsList += "[IPStart], ";
                if (isInsertIPEnd)
                    InsertFieldsList += "[IPEnd], ";
                if (isInsertCountry)
                    InsertFieldsList += "[Country], ";
                if (isInsertCity)
                    InsertFieldsList += "[City], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertIPStart)
                    InsertValuesList += "@IPStart, ";
                if (isInsertIPEnd)
                    InsertValuesList += "@IPEnd, ";
                if (isInsertCountry)
                    InsertValuesList += "@Country, ";
                if (isInsertCity)
                    InsertValuesList += "@City, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertIPStart ? null : new MSSQL.Parameter("IPStart", SqlDbType.Float, 0, ParameterDirection.Input, IPStart),
                    !isInsertIPEnd ? null : new MSSQL.Parameter("IPEnd", SqlDbType.Float, 0, ParameterDirection.Input, IPEnd),
                    !isInsertCountry ? null : new MSSQL.Parameter("Country", SqlDbType.NVarChar, 0, ParameterDirection.Input, Country),
                    !isInsertCity ? null : new MSSQL.Parameter("City", SqlDbType.NVarChar, 0, ParameterDirection.Input, City)
                    );
            }

            public static int Update(string Condition, double IPStart, bool isUpdateIPStart, double IPEnd, bool isUpdateIPEnd, string Country, bool isUpdateCountry, string City, bool isUpdateCity)
            {
                Condition = Condition.Trim();

                string CommandText = "update [IPAddress] set ";
                string UpdateFieldsList = "";

                if (isUpdateIPStart)
                    UpdateFieldsList += "[IPStart] = @IPStart, ";
                if (isUpdateIPEnd)
                    UpdateFieldsList += "[IPEnd] = @IPEnd, ";
                if (isUpdateCountry)
                    UpdateFieldsList += "[Country] = @Country, ";
                if (isUpdateCity)
                    UpdateFieldsList += "[City] = @City, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateIPStart ? null : new MSSQL.Parameter("IPStart", SqlDbType.Float, 0, ParameterDirection.Input, IPStart),
                    !isUpdateIPEnd ? null : new MSSQL.Parameter("IPEnd", SqlDbType.Float, 0, ParameterDirection.Input, IPEnd),
                    !isUpdateCountry ? null : new MSSQL.Parameter("Country", SqlDbType.NVarChar, 0, ParameterDirection.Input, Country),
                    !isUpdateCity ? null : new MSSQL.Parameter("City", SqlDbType.NVarChar, 0, ParameterDirection.Input, City)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [IPAddress]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [IPAddress]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Isuse
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Isuse]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Lottery_id, bool isInsertLottery_id, string Isuse, bool isInsertIsuse, DateTime StartTime, bool isInsertStartTime, DateTime EndTime, bool isInsertEndTime, bool ChaseExecuted, bool isInsertChaseExecuted, string WinLotteryNumber, bool isInsertWinLotteryNumber, byte[] OpenAffiche, bool isInsertOpenAffiche, bool IsOpen, bool isInsertIsOpen)
            {
                string CommandText = "insert into [Isuse] (";
                string InsertFieldsList = "";

                if (isInsertLottery_id)
                    InsertFieldsList += "[Lottery_id], ";
                if (isInsertIsuse)
                    InsertFieldsList += "[Isuse], ";
                if (isInsertStartTime)
                    InsertFieldsList += "[StartTime], ";
                if (isInsertEndTime)
                    InsertFieldsList += "[EndTime], ";
                if (isInsertChaseExecuted)
                    InsertFieldsList += "[ChaseExecuted], ";
                if (isInsertWinLotteryNumber)
                    InsertFieldsList += "[WinLotteryNumber], ";
                if (isInsertOpenAffiche)
                    InsertFieldsList += "[OpenAffiche], ";
                if (isInsertIsOpen)
                    InsertFieldsList += "[IsOpen], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertLottery_id)
                    InsertValuesList += "@Lottery_id, ";
                if (isInsertIsuse)
                    InsertValuesList += "@Isuse, ";
                if (isInsertStartTime)
                    InsertValuesList += "@StartTime, ";
                if (isInsertEndTime)
                    InsertValuesList += "@EndTime, ";
                if (isInsertChaseExecuted)
                    InsertValuesList += "@ChaseExecuted, ";
                if (isInsertWinLotteryNumber)
                    InsertValuesList += "@WinLotteryNumber, ";
                if (isInsertOpenAffiche)
                    InsertValuesList += "@OpenAffiche, ";
                if (isInsertIsOpen)
                    InsertValuesList += "@IsOpen, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertLottery_id ? null : new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    !isInsertIsuse ? null : new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    !isInsertStartTime ? null : new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    !isInsertEndTime ? null : new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    !isInsertChaseExecuted ? null : new MSSQL.Parameter("ChaseExecuted", SqlDbType.Bit, 0, ParameterDirection.Input, ChaseExecuted),
                    !isInsertWinLotteryNumber ? null : new MSSQL.Parameter("WinLotteryNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, WinLotteryNumber),
                    !isInsertOpenAffiche ? null : new MSSQL.Parameter("OpenAffiche", SqlDbType.Image, 0, ParameterDirection.Input, OpenAffiche),
                    !isInsertIsOpen ? null : new MSSQL.Parameter("IsOpen", SqlDbType.Bit, 0, ParameterDirection.Input, IsOpen)
                    );
            }

            public static int Update(string Condition, int Lottery_id, bool isUpdateLottery_id, string Isuse, bool isUpdateIsuse, DateTime StartTime, bool isUpdateStartTime, DateTime EndTime, bool isUpdateEndTime, bool ChaseExecuted, bool isUpdateChaseExecuted, string WinLotteryNumber, bool isUpdateWinLotteryNumber, byte[] OpenAffiche, bool isUpdateOpenAffiche, bool IsOpen, bool isUpdateIsOpen)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Isuse] set ";
                string UpdateFieldsList = "";

                if (isUpdateLottery_id)
                    UpdateFieldsList += "[Lottery_id] = @Lottery_id, ";
                if (isUpdateIsuse)
                    UpdateFieldsList += "[Isuse] = @Isuse, ";
                if (isUpdateStartTime)
                    UpdateFieldsList += "[StartTime] = @StartTime, ";
                if (isUpdateEndTime)
                    UpdateFieldsList += "[EndTime] = @EndTime, ";
                if (isUpdateChaseExecuted)
                    UpdateFieldsList += "[ChaseExecuted] = @ChaseExecuted, ";
                if (isUpdateWinLotteryNumber)
                    UpdateFieldsList += "[WinLotteryNumber] = @WinLotteryNumber, ";
                if (isUpdateOpenAffiche)
                    UpdateFieldsList += "[OpenAffiche] = @OpenAffiche, ";
                if (isUpdateIsOpen)
                    UpdateFieldsList += "[IsOpen] = @IsOpen, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateLottery_id ? null : new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    !isUpdateIsuse ? null : new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    !isUpdateStartTime ? null : new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    !isUpdateEndTime ? null : new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    !isUpdateChaseExecuted ? null : new MSSQL.Parameter("ChaseExecuted", SqlDbType.Bit, 0, ParameterDirection.Input, ChaseExecuted),
                    !isUpdateWinLotteryNumber ? null : new MSSQL.Parameter("WinLotteryNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, WinLotteryNumber),
                    !isUpdateOpenAffiche ? null : new MSSQL.Parameter("OpenAffiche", SqlDbType.Image, 0, ParameterDirection.Input, OpenAffiche),
                    !isUpdateIsOpen ? null : new MSSQL.Parameter("IsOpen", SqlDbType.Bit, 0, ParameterDirection.Input, IsOpen)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Isuse]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Isuse]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class IsuseForJQC
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [IsuseForJQC]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Isuse_id, bool isInsertIsuse_id, int No, bool isInsertNo, string Team, bool isInsertTeam, string DateTime, bool isInsertDateTime)
            {
                string CommandText = "insert into [IsuseForJQC] (";
                string InsertFieldsList = "";

                if (isInsertIsuse_id)
                    InsertFieldsList += "[Isuse_id], ";
                if (isInsertNo)
                    InsertFieldsList += "[No], ";
                if (isInsertTeam)
                    InsertFieldsList += "[Team], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertIsuse_id)
                    InsertValuesList += "@Isuse_id, ";
                if (isInsertNo)
                    InsertValuesList += "@No, ";
                if (isInsertTeam)
                    InsertValuesList += "@Team, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isInsertNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isInsertTeam ? null : new MSSQL.Parameter("Team", SqlDbType.VarChar, 0, ParameterDirection.Input, Team),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Update(string Condition, int Isuse_id, bool isUpdateIsuse_id, int No, bool isUpdateNo, string Team, bool isUpdateTeam, string DateTime, bool isUpdateDateTime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [IsuseForJQC] set ";
                string UpdateFieldsList = "";

                if (isUpdateIsuse_id)
                    UpdateFieldsList += "[Isuse_id] = @Isuse_id, ";
                if (isUpdateNo)
                    UpdateFieldsList += "[No] = @No, ";
                if (isUpdateTeam)
                    UpdateFieldsList += "[Team] = @Team, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isUpdateNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isUpdateTeam ? null : new MSSQL.Parameter("Team", SqlDbType.VarChar, 0, ParameterDirection.Input, Team),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [IsuseForJQC]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [IsuseForJQC]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class IsuseForLCBQC
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [IsuseForLCBQC]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Isuse_id, bool isInsertIsuse_id, int No, bool isInsertNo, string HostTeam, bool isInsertHostTeam, string QuestTeam, bool isInsertQuestTeam, string DateTime, bool isInsertDateTime)
            {
                string CommandText = "insert into [IsuseForLCBQC] (";
                string InsertFieldsList = "";

                if (isInsertIsuse_id)
                    InsertFieldsList += "[Isuse_id], ";
                if (isInsertNo)
                    InsertFieldsList += "[No], ";
                if (isInsertHostTeam)
                    InsertFieldsList += "[HostTeam], ";
                if (isInsertQuestTeam)
                    InsertFieldsList += "[QuestTeam], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertIsuse_id)
                    InsertValuesList += "@Isuse_id, ";
                if (isInsertNo)
                    InsertValuesList += "@No, ";
                if (isInsertHostTeam)
                    InsertValuesList += "@HostTeam, ";
                if (isInsertQuestTeam)
                    InsertValuesList += "@QuestTeam, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isInsertNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isInsertHostTeam ? null : new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    !isInsertQuestTeam ? null : new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Update(string Condition, int Isuse_id, bool isUpdateIsuse_id, int No, bool isUpdateNo, string HostTeam, bool isUpdateHostTeam, string QuestTeam, bool isUpdateQuestTeam, string DateTime, bool isUpdateDateTime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [IsuseForLCBQC] set ";
                string UpdateFieldsList = "";

                if (isUpdateIsuse_id)
                    UpdateFieldsList += "[Isuse_id] = @Isuse_id, ";
                if (isUpdateNo)
                    UpdateFieldsList += "[No] = @No, ";
                if (isUpdateHostTeam)
                    UpdateFieldsList += "[HostTeam] = @HostTeam, ";
                if (isUpdateQuestTeam)
                    UpdateFieldsList += "[QuestTeam] = @QuestTeam, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isUpdateNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isUpdateHostTeam ? null : new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    !isUpdateQuestTeam ? null : new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [IsuseForLCBQC]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [IsuseForLCBQC]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class IsuseForLCDC
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [IsuseForLCDC]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Isuse_id, bool isInsertIsuse_id, int No, bool isInsertNo, string HostTeam, bool isInsertHostTeam, string QuestTeam, bool isInsertQuestTeam, string DateTime, bool isInsertDateTime)
            {
                string CommandText = "insert into [IsuseForLCDC] (";
                string InsertFieldsList = "";

                if (isInsertIsuse_id)
                    InsertFieldsList += "[Isuse_id], ";
                if (isInsertNo)
                    InsertFieldsList += "[No], ";
                if (isInsertHostTeam)
                    InsertFieldsList += "[HostTeam], ";
                if (isInsertQuestTeam)
                    InsertFieldsList += "[QuestTeam], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertIsuse_id)
                    InsertValuesList += "@Isuse_id, ";
                if (isInsertNo)
                    InsertValuesList += "@No, ";
                if (isInsertHostTeam)
                    InsertValuesList += "@HostTeam, ";
                if (isInsertQuestTeam)
                    InsertValuesList += "@QuestTeam, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isInsertNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isInsertHostTeam ? null : new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    !isInsertQuestTeam ? null : new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Update(string Condition, int Isuse_id, bool isUpdateIsuse_id, int No, bool isUpdateNo, string HostTeam, bool isUpdateHostTeam, string QuestTeam, bool isUpdateQuestTeam, string DateTime, bool isUpdateDateTime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [IsuseForLCDC] set ";
                string UpdateFieldsList = "";

                if (isUpdateIsuse_id)
                    UpdateFieldsList += "[Isuse_id] = @Isuse_id, ";
                if (isUpdateNo)
                    UpdateFieldsList += "[No] = @No, ";
                if (isUpdateHostTeam)
                    UpdateFieldsList += "[HostTeam] = @HostTeam, ";
                if (isUpdateQuestTeam)
                    UpdateFieldsList += "[QuestTeam] = @QuestTeam, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isUpdateNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isUpdateHostTeam ? null : new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    !isUpdateQuestTeam ? null : new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [IsuseForLCDC]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [IsuseForLCDC]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class IsuseForSFC
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [IsuseForSFC]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Isuse_id, bool isInsertIsuse_id, int No, bool isInsertNo, string HostTeam, bool isInsertHostTeam, string QuestTeam, bool isInsertQuestTeam, string DateTime, bool isInsertDateTime)
            {
                string CommandText = "insert into [IsuseForSFC] (";
                string InsertFieldsList = "";

                if (isInsertIsuse_id)
                    InsertFieldsList += "[Isuse_id], ";
                if (isInsertNo)
                    InsertFieldsList += "[No], ";
                if (isInsertHostTeam)
                    InsertFieldsList += "[HostTeam], ";
                if (isInsertQuestTeam)
                    InsertFieldsList += "[QuestTeam], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertIsuse_id)
                    InsertValuesList += "@Isuse_id, ";
                if (isInsertNo)
                    InsertValuesList += "@No, ";
                if (isInsertHostTeam)
                    InsertValuesList += "@HostTeam, ";
                if (isInsertQuestTeam)
                    InsertValuesList += "@QuestTeam, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isInsertNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isInsertHostTeam ? null : new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    !isInsertQuestTeam ? null : new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Update(string Condition, int Isuse_id, bool isUpdateIsuse_id, int No, bool isUpdateNo, string HostTeam, bool isUpdateHostTeam, string QuestTeam, bool isUpdateQuestTeam, string DateTime, bool isUpdateDateTime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [IsuseForSFC] set ";
                string UpdateFieldsList = "";

                if (isUpdateIsuse_id)
                    UpdateFieldsList += "[Isuse_id] = @Isuse_id, ";
                if (isUpdateNo)
                    UpdateFieldsList += "[No] = @No, ";
                if (isUpdateHostTeam)
                    UpdateFieldsList += "[HostTeam] = @HostTeam, ";
                if (isUpdateQuestTeam)
                    UpdateFieldsList += "[QuestTeam] = @QuestTeam, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isUpdateNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isUpdateHostTeam ? null : new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    !isUpdateQuestTeam ? null : new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [IsuseForSFC]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [IsuseForSFC]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class IsuseForZCDC
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [IsuseForZCDC]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Isuse_id, bool isInsertIsuse_id, int TypeId, bool isInsertTypeId, int No, bool isInsertNo, string HostTeam, bool isInsertHostTeam, string QuestTeam, bool isInsertQuestTeam, string LetBall, bool isInsertLetBall, string DateTime, bool isInsertDateTime, string HalftimeResult, bool isInsertHalftimeResult, string Result, bool isInsertResult, string SPFResult, bool isInsertSPFResult, double SPFSp, bool isInsertSPFSp, string ZJQResult, bool isInsertZJQResult, double ZJQSp, bool isInsertZJQSp, string SXDSResult, bool isInsertSXDSResult, double SXDSSp, bool isInsertSXDSSp, string ZQBFResult, bool isInsertZQBFResult, double ZQBFSp, bool isInsertZQBFSp, string BQCSPFResult, bool isInsertBQCSPFResult, double BQCSPFSp, bool isInsertBQCSPFSp)
            {
                string CommandText = "insert into [IsuseForZCDC] (";
                string InsertFieldsList = "";

                if (isInsertIsuse_id)
                    InsertFieldsList += "[Isuse_id], ";
                if (isInsertTypeId)
                    InsertFieldsList += "[TypeId], ";
                if (isInsertNo)
                    InsertFieldsList += "[No], ";
                if (isInsertHostTeam)
                    InsertFieldsList += "[HostTeam], ";
                if (isInsertQuestTeam)
                    InsertFieldsList += "[QuestTeam], ";
                if (isInsertLetBall)
                    InsertFieldsList += "[LetBall], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertHalftimeResult)
                    InsertFieldsList += "[HalftimeResult], ";
                if (isInsertResult)
                    InsertFieldsList += "[Result], ";
                if (isInsertSPFResult)
                    InsertFieldsList += "[SPFResult], ";
                if (isInsertSPFSp)
                    InsertFieldsList += "[SPFSp], ";
                if (isInsertZJQResult)
                    InsertFieldsList += "[ZJQResult], ";
                if (isInsertZJQSp)
                    InsertFieldsList += "[ZJQSp], ";
                if (isInsertSXDSResult)
                    InsertFieldsList += "[SXDSResult], ";
                if (isInsertSXDSSp)
                    InsertFieldsList += "[SXDSSp], ";
                if (isInsertZQBFResult)
                    InsertFieldsList += "[ZQBFResult], ";
                if (isInsertZQBFSp)
                    InsertFieldsList += "[ZQBFSp], ";
                if (isInsertBQCSPFResult)
                    InsertFieldsList += "[BQCSPFResult], ";
                if (isInsertBQCSPFSp)
                    InsertFieldsList += "[BQCSPFSp], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertIsuse_id)
                    InsertValuesList += "@Isuse_id, ";
                if (isInsertTypeId)
                    InsertValuesList += "@TypeId, ";
                if (isInsertNo)
                    InsertValuesList += "@No, ";
                if (isInsertHostTeam)
                    InsertValuesList += "@HostTeam, ";
                if (isInsertQuestTeam)
                    InsertValuesList += "@QuestTeam, ";
                if (isInsertLetBall)
                    InsertValuesList += "@LetBall, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertHalftimeResult)
                    InsertValuesList += "@HalftimeResult, ";
                if (isInsertResult)
                    InsertValuesList += "@Result, ";
                if (isInsertSPFResult)
                    InsertValuesList += "@SPFResult, ";
                if (isInsertSPFSp)
                    InsertValuesList += "@SPFSp, ";
                if (isInsertZJQResult)
                    InsertValuesList += "@ZJQResult, ";
                if (isInsertZJQSp)
                    InsertValuesList += "@ZJQSp, ";
                if (isInsertSXDSResult)
                    InsertValuesList += "@SXDSResult, ";
                if (isInsertSXDSSp)
                    InsertValuesList += "@SXDSSp, ";
                if (isInsertZQBFResult)
                    InsertValuesList += "@ZQBFResult, ";
                if (isInsertZQBFSp)
                    InsertValuesList += "@ZQBFSp, ";
                if (isInsertBQCSPFResult)
                    InsertValuesList += "@BQCSPFResult, ";
                if (isInsertBQCSPFSp)
                    InsertValuesList += "@BQCSPFSp, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isInsertTypeId ? null : new MSSQL.Parameter("TypeId", SqlDbType.Int, 0, ParameterDirection.Input, TypeId),
                    !isInsertNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isInsertHostTeam ? null : new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    !isInsertQuestTeam ? null : new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    !isInsertLetBall ? null : new MSSQL.Parameter("LetBall", SqlDbType.VarChar, 0, ParameterDirection.Input, LetBall),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime),
                    !isInsertHalftimeResult ? null : new MSSQL.Parameter("HalftimeResult", SqlDbType.VarChar, 0, ParameterDirection.Input, HalftimeResult),
                    !isInsertResult ? null : new MSSQL.Parameter("Result", SqlDbType.VarChar, 0, ParameterDirection.Input, Result),
                    !isInsertSPFResult ? null : new MSSQL.Parameter("SPFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, SPFResult),
                    !isInsertSPFSp ? null : new MSSQL.Parameter("SPFSp", SqlDbType.Float, 0, ParameterDirection.Input, SPFSp),
                    !isInsertZJQResult ? null : new MSSQL.Parameter("ZJQResult", SqlDbType.VarChar, 0, ParameterDirection.Input, ZJQResult),
                    !isInsertZJQSp ? null : new MSSQL.Parameter("ZJQSp", SqlDbType.Float, 0, ParameterDirection.Input, ZJQSp),
                    !isInsertSXDSResult ? null : new MSSQL.Parameter("SXDSResult", SqlDbType.VarChar, 0, ParameterDirection.Input, SXDSResult),
                    !isInsertSXDSSp ? null : new MSSQL.Parameter("SXDSSp", SqlDbType.Float, 0, ParameterDirection.Input, SXDSSp),
                    !isInsertZQBFResult ? null : new MSSQL.Parameter("ZQBFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, ZQBFResult),
                    !isInsertZQBFSp ? null : new MSSQL.Parameter("ZQBFSp", SqlDbType.Float, 0, ParameterDirection.Input, ZQBFSp),
                    !isInsertBQCSPFResult ? null : new MSSQL.Parameter("BQCSPFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, BQCSPFResult),
                    !isInsertBQCSPFSp ? null : new MSSQL.Parameter("BQCSPFSp", SqlDbType.Float, 0, ParameterDirection.Input, BQCSPFSp)
                    );
            }

            public static int Update(string Condition, int Isuse_id, bool isUpdateIsuse_id, int TypeId, bool isUpdateTypeId, int No, bool isUpdateNo, string HostTeam, bool isUpdateHostTeam, string QuestTeam, bool isUpdateQuestTeam, string LetBall, bool isUpdateLetBall, string DateTime, bool isUpdateDateTime, string HalftimeResult, bool isUpdateHalftimeResult, string Result, bool isUpdateResult, string SPFResult, bool isUpdateSPFResult, double SPFSp, bool isUpdateSPFSp, string ZJQResult, bool isUpdateZJQResult, double ZJQSp, bool isUpdateZJQSp, string SXDSResult, bool isUpdateSXDSResult, double SXDSSp, bool isUpdateSXDSSp, string ZQBFResult, bool isUpdateZQBFResult, double ZQBFSp, bool isUpdateZQBFSp, string BQCSPFResult, bool isUpdateBQCSPFResult, double BQCSPFSp, bool isUpdateBQCSPFSp)
            {
                Condition = Condition.Trim();

                string CommandText = "update [IsuseForZCDC] set ";
                string UpdateFieldsList = "";

                if (isUpdateIsuse_id)
                    UpdateFieldsList += "[Isuse_id] = @Isuse_id, ";
                if (isUpdateTypeId)
                    UpdateFieldsList += "[TypeId] = @TypeId, ";
                if (isUpdateNo)
                    UpdateFieldsList += "[No] = @No, ";
                if (isUpdateHostTeam)
                    UpdateFieldsList += "[HostTeam] = @HostTeam, ";
                if (isUpdateQuestTeam)
                    UpdateFieldsList += "[QuestTeam] = @QuestTeam, ";
                if (isUpdateLetBall)
                    UpdateFieldsList += "[LetBall] = @LetBall, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateHalftimeResult)
                    UpdateFieldsList += "[HalftimeResult] = @HalftimeResult, ";
                if (isUpdateResult)
                    UpdateFieldsList += "[Result] = @Result, ";
                if (isUpdateSPFResult)
                    UpdateFieldsList += "[SPFResult] = @SPFResult, ";
                if (isUpdateSPFSp)
                    UpdateFieldsList += "[SPFSp] = @SPFSp, ";
                if (isUpdateZJQResult)
                    UpdateFieldsList += "[ZJQResult] = @ZJQResult, ";
                if (isUpdateZJQSp)
                    UpdateFieldsList += "[ZJQSp] = @ZJQSp, ";
                if (isUpdateSXDSResult)
                    UpdateFieldsList += "[SXDSResult] = @SXDSResult, ";
                if (isUpdateSXDSSp)
                    UpdateFieldsList += "[SXDSSp] = @SXDSSp, ";
                if (isUpdateZQBFResult)
                    UpdateFieldsList += "[ZQBFResult] = @ZQBFResult, ";
                if (isUpdateZQBFSp)
                    UpdateFieldsList += "[ZQBFSp] = @ZQBFSp, ";
                if (isUpdateBQCSPFResult)
                    UpdateFieldsList += "[BQCSPFResult] = @BQCSPFResult, ";
                if (isUpdateBQCSPFSp)
                    UpdateFieldsList += "[BQCSPFSp] = @BQCSPFSp, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isUpdateTypeId ? null : new MSSQL.Parameter("TypeId", SqlDbType.Int, 0, ParameterDirection.Input, TypeId),
                    !isUpdateNo ? null : new MSSQL.Parameter("No", SqlDbType.Int, 0, ParameterDirection.Input, No),
                    !isUpdateHostTeam ? null : new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    !isUpdateQuestTeam ? null : new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    !isUpdateLetBall ? null : new MSSQL.Parameter("LetBall", SqlDbType.VarChar, 0, ParameterDirection.Input, LetBall),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.VarChar, 0, ParameterDirection.Input, DateTime),
                    !isUpdateHalftimeResult ? null : new MSSQL.Parameter("HalftimeResult", SqlDbType.VarChar, 0, ParameterDirection.Input, HalftimeResult),
                    !isUpdateResult ? null : new MSSQL.Parameter("Result", SqlDbType.VarChar, 0, ParameterDirection.Input, Result),
                    !isUpdateSPFResult ? null : new MSSQL.Parameter("SPFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, SPFResult),
                    !isUpdateSPFSp ? null : new MSSQL.Parameter("SPFSp", SqlDbType.Float, 0, ParameterDirection.Input, SPFSp),
                    !isUpdateZJQResult ? null : new MSSQL.Parameter("ZJQResult", SqlDbType.VarChar, 0, ParameterDirection.Input, ZJQResult),
                    !isUpdateZJQSp ? null : new MSSQL.Parameter("ZJQSp", SqlDbType.Float, 0, ParameterDirection.Input, ZJQSp),
                    !isUpdateSXDSResult ? null : new MSSQL.Parameter("SXDSResult", SqlDbType.VarChar, 0, ParameterDirection.Input, SXDSResult),
                    !isUpdateSXDSSp ? null : new MSSQL.Parameter("SXDSSp", SqlDbType.Float, 0, ParameterDirection.Input, SXDSSp),
                    !isUpdateZQBFResult ? null : new MSSQL.Parameter("ZQBFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, ZQBFResult),
                    !isUpdateZQBFSp ? null : new MSSQL.Parameter("ZQBFSp", SqlDbType.Float, 0, ParameterDirection.Input, ZQBFSp),
                    !isUpdateBQCSPFResult ? null : new MSSQL.Parameter("BQCSPFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, BQCSPFResult),
                    !isUpdateBQCSPFSp ? null : new MSSQL.Parameter("BQCSPFSp", SqlDbType.Float, 0, ParameterDirection.Input, BQCSPFSp)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [IsuseForZCDC]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [IsuseForZCDC]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class LeagueTypeForZCDC
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [LeagueTypeForZCDC]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string LeagueTypeName, bool isInsertLeagueTypeName, string LeagueColor, bool isInsertLeagueColor)
            {
                string CommandText = "insert into [LeagueTypeForZCDC] (";
                string InsertFieldsList = "";

                if (isInsertLeagueTypeName)
                    InsertFieldsList += "[LeagueTypeName], ";
                if (isInsertLeagueColor)
                    InsertFieldsList += "[LeagueColor], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertLeagueTypeName)
                    InsertValuesList += "@LeagueTypeName, ";
                if (isInsertLeagueColor)
                    InsertValuesList += "@LeagueColor, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertLeagueTypeName ? null : new MSSQL.Parameter("LeagueTypeName", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueTypeName),
                    !isInsertLeagueColor ? null : new MSSQL.Parameter("LeagueColor", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueColor)
                    );
            }

            public static int Update(string Condition, string LeagueTypeName, bool isUpdateLeagueTypeName, string LeagueColor, bool isUpdateLeagueColor)
            {
                Condition = Condition.Trim();

                string CommandText = "update [LeagueTypeForZCDC] set ";
                string UpdateFieldsList = "";

                if (isUpdateLeagueTypeName)
                    UpdateFieldsList += "[LeagueTypeName] = @LeagueTypeName, ";
                if (isUpdateLeagueColor)
                    UpdateFieldsList += "[LeagueColor] = @LeagueColor, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateLeagueTypeName ? null : new MSSQL.Parameter("LeagueTypeName", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueTypeName),
                    !isUpdateLeagueColor ? null : new MSSQL.Parameter("LeagueColor", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueColor)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [LeagueTypeForZCDC]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [LeagueTypeForZCDC]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Links
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Links]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string LinkName, bool isInsertLinkName, string Logo, bool isInsertLogo, string HomePage, bool isInsertHomePage, int Sort, bool isInsertSort, bool isShow, bool isInsertisShow)
            {
                string CommandText = "insert into [Links] (";
                string InsertFieldsList = "";

                if (isInsertLinkName)
                    InsertFieldsList += "[LinkName], ";
                if (isInsertLogo)
                    InsertFieldsList += "[Logo], ";
                if (isInsertHomePage)
                    InsertFieldsList += "[HomePage], ";
                if (isInsertSort)
                    InsertFieldsList += "[Sort], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertLinkName)
                    InsertValuesList += "@LinkName, ";
                if (isInsertLogo)
                    InsertValuesList += "@Logo, ";
                if (isInsertHomePage)
                    InsertValuesList += "@HomePage, ";
                if (isInsertSort)
                    InsertValuesList += "@Sort, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertLinkName ? null : new MSSQL.Parameter("LinkName", SqlDbType.VarChar, 0, ParameterDirection.Input, LinkName),
                    !isInsertLogo ? null : new MSSQL.Parameter("Logo", SqlDbType.VarChar, 0, ParameterDirection.Input, Logo),
                    !isInsertHomePage ? null : new MSSQL.Parameter("HomePage", SqlDbType.VarChar, 0, ParameterDirection.Input, HomePage),
                    !isInsertSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow)
                    );
            }

            public static int Update(string Condition, string LinkName, bool isUpdateLinkName, string Logo, bool isUpdateLogo, string HomePage, bool isUpdateHomePage, int Sort, bool isUpdateSort, bool isShow, bool isUpdateisShow)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Links] set ";
                string UpdateFieldsList = "";

                if (isUpdateLinkName)
                    UpdateFieldsList += "[LinkName] = @LinkName, ";
                if (isUpdateLogo)
                    UpdateFieldsList += "[Logo] = @Logo, ";
                if (isUpdateHomePage)
                    UpdateFieldsList += "[HomePage] = @HomePage, ";
                if (isUpdateSort)
                    UpdateFieldsList += "[Sort] = @Sort, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateLinkName ? null : new MSSQL.Parameter("LinkName", SqlDbType.VarChar, 0, ParameterDirection.Input, LinkName),
                    !isUpdateLogo ? null : new MSSQL.Parameter("Logo", SqlDbType.VarChar, 0, ParameterDirection.Input, Logo),
                    !isUpdateHomePage ? null : new MSSQL.Parameter("HomePage", SqlDbType.VarChar, 0, ParameterDirection.Input, HomePage),
                    !isUpdateSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Links]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Links]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class LoginLog
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [LoginLog]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int User_id, bool isInsertUser_id, DateTime LoginTime, bool isInsertLoginTime, string IPAddress, bool isInsertIPAddress, int Description, bool isInsertDescription)
            {
                string CommandText = "insert into [LoginLog] (";
                string InsertFieldsList = "";

                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertLoginTime)
                    InsertFieldsList += "[LoginTime], ";
                if (isInsertIPAddress)
                    InsertFieldsList += "[IPAddress], ";
                if (isInsertDescription)
                    InsertFieldsList += "[Description], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertLoginTime)
                    InsertValuesList += "@LoginTime, ";
                if (isInsertIPAddress)
                    InsertValuesList += "@IPAddress, ";
                if (isInsertDescription)
                    InsertValuesList += "@Description, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertLoginTime ? null : new MSSQL.Parameter("LoginTime", SqlDbType.DateTime, 0, ParameterDirection.Input, LoginTime),
                    !isInsertIPAddress ? null : new MSSQL.Parameter("IPAddress", SqlDbType.VarChar, 0, ParameterDirection.Input, IPAddress),
                    !isInsertDescription ? null : new MSSQL.Parameter("Description", SqlDbType.Int, 0, ParameterDirection.Input, Description)
                    );
            }

            public static int Update(string Condition, int User_id, bool isUpdateUser_id, DateTime LoginTime, bool isUpdateLoginTime, string IPAddress, bool isUpdateIPAddress, int Description, bool isUpdateDescription)
            {
                Condition = Condition.Trim();

                string CommandText = "update [LoginLog] set ";
                string UpdateFieldsList = "";

                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateLoginTime)
                    UpdateFieldsList += "[LoginTime] = @LoginTime, ";
                if (isUpdateIPAddress)
                    UpdateFieldsList += "[IPAddress] = @IPAddress, ";
                if (isUpdateDescription)
                    UpdateFieldsList += "[Description] = @Description, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateLoginTime ? null : new MSSQL.Parameter("LoginTime", SqlDbType.DateTime, 0, ParameterDirection.Input, LoginTime),
                    !isUpdateIPAddress ? null : new MSSQL.Parameter("IPAddress", SqlDbType.VarChar, 0, ParameterDirection.Input, IPAddress),
                    !isUpdateDescription ? null : new MSSQL.Parameter("Description", SqlDbType.Int, 0, ParameterDirection.Input, Description)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [LoginLog]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [LoginLog]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Lottery
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Lottery]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int id, bool isInsertid, string Name, bool isInsertName, string Code, bool isInsertCode, bool CanChase, bool isInsertCanChase, int ChaseBuyType_id, bool isInsertChaseBuyType_id, int ChaseExecuteDeferMinute, bool isInsertChaseExecuteDeferMinute, bool isUsed, bool isInsertisUsed, int Sort, bool isInsertSort, byte[] Agreement, bool isInsertAgreement, byte[] Explain, bool isInsertExplain, byte[] LotteryExemple, bool isInsertLotteryExemple, byte[] OpenAfficheTemplate, bool isInsertOpenAfficheTemplate, string WinLotteryExemple, bool isInsertWinLotteryExemple, string BasePlayPage, bool isInsertBasePlayPage, string IntervalType, bool isInsertIntervalType, int Type_id, bool isInsertType_id)
            {
                string CommandText = "insert into [Lottery] (";
                string InsertFieldsList = "";

                if (isInsertid)
                    InsertFieldsList += "[id], ";
                if (isInsertName)
                    InsertFieldsList += "[Name], ";
                if (isInsertCode)
                    InsertFieldsList += "[Code], ";
                if (isInsertCanChase)
                    InsertFieldsList += "[CanChase], ";
                if (isInsertChaseBuyType_id)
                    InsertFieldsList += "[ChaseBuyType_id], ";
                if (isInsertChaseExecuteDeferMinute)
                    InsertFieldsList += "[ChaseExecuteDeferMinute], ";
                if (isInsertisUsed)
                    InsertFieldsList += "[isUsed], ";
                if (isInsertSort)
                    InsertFieldsList += "[Sort], ";
                if (isInsertAgreement)
                    InsertFieldsList += "[Agreement], ";
                if (isInsertExplain)
                    InsertFieldsList += "[Explain], ";
                if (isInsertLotteryExemple)
                    InsertFieldsList += "[LotteryExemple], ";
                if (isInsertOpenAfficheTemplate)
                    InsertFieldsList += "[OpenAfficheTemplate], ";
                if (isInsertWinLotteryExemple)
                    InsertFieldsList += "[WinLotteryExemple], ";
                if (isInsertBasePlayPage)
                    InsertFieldsList += "[BasePlayPage], ";
                if (isInsertIntervalType)
                    InsertFieldsList += "[IntervalType], ";
                if (isInsertType_id)
                    InsertFieldsList += "[Type_id], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertid)
                    InsertValuesList += "@id, ";
                if (isInsertName)
                    InsertValuesList += "@Name, ";
                if (isInsertCode)
                    InsertValuesList += "@Code, ";
                if (isInsertCanChase)
                    InsertValuesList += "@CanChase, ";
                if (isInsertChaseBuyType_id)
                    InsertValuesList += "@ChaseBuyType_id, ";
                if (isInsertChaseExecuteDeferMinute)
                    InsertValuesList += "@ChaseExecuteDeferMinute, ";
                if (isInsertisUsed)
                    InsertValuesList += "@isUsed, ";
                if (isInsertSort)
                    InsertValuesList += "@Sort, ";
                if (isInsertAgreement)
                    InsertValuesList += "@Agreement, ";
                if (isInsertExplain)
                    InsertValuesList += "@Explain, ";
                if (isInsertLotteryExemple)
                    InsertValuesList += "@LotteryExemple, ";
                if (isInsertOpenAfficheTemplate)
                    InsertValuesList += "@OpenAfficheTemplate, ";
                if (isInsertWinLotteryExemple)
                    InsertValuesList += "@WinLotteryExemple, ";
                if (isInsertBasePlayPage)
                    InsertValuesList += "@BasePlayPage, ";
                if (isInsertIntervalType)
                    InsertValuesList += "@IntervalType, ";
                if (isInsertType_id)
                    InsertValuesList += "@Type_id, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isInsertName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isInsertCode ? null : new MSSQL.Parameter("Code", SqlDbType.VarChar, 0, ParameterDirection.Input, Code),
                    !isInsertCanChase ? null : new MSSQL.Parameter("CanChase", SqlDbType.Bit, 0, ParameterDirection.Input, CanChase),
                    !isInsertChaseBuyType_id ? null : new MSSQL.Parameter("ChaseBuyType_id", SqlDbType.Int, 0, ParameterDirection.Input, ChaseBuyType_id),
                    !isInsertChaseExecuteDeferMinute ? null : new MSSQL.Parameter("ChaseExecuteDeferMinute", SqlDbType.Int, 0, ParameterDirection.Input, ChaseExecuteDeferMinute),
                    !isInsertisUsed ? null : new MSSQL.Parameter("isUsed", SqlDbType.Bit, 0, ParameterDirection.Input, isUsed),
                    !isInsertSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort),
                    !isInsertAgreement ? null : new MSSQL.Parameter("Agreement", SqlDbType.Image, 0, ParameterDirection.Input, Agreement),
                    !isInsertExplain ? null : new MSSQL.Parameter("Explain", SqlDbType.Image, 0, ParameterDirection.Input, Explain),
                    !isInsertLotteryExemple ? null : new MSSQL.Parameter("LotteryExemple", SqlDbType.Image, 0, ParameterDirection.Input, LotteryExemple),
                    !isInsertOpenAfficheTemplate ? null : new MSSQL.Parameter("OpenAfficheTemplate", SqlDbType.Image, 0, ParameterDirection.Input, OpenAfficheTemplate),
                    !isInsertWinLotteryExemple ? null : new MSSQL.Parameter("WinLotteryExemple", SqlDbType.VarChar, 0, ParameterDirection.Input, WinLotteryExemple),
                    !isInsertBasePlayPage ? null : new MSSQL.Parameter("BasePlayPage", SqlDbType.VarChar, 0, ParameterDirection.Input, BasePlayPage),
                    !isInsertIntervalType ? null : new MSSQL.Parameter("IntervalType", SqlDbType.VarChar, 0, ParameterDirection.Input, IntervalType),
                    !isInsertType_id ? null : new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id)
                    );
            }

            public static int Update(string Condition, int id, bool isUpdateid, string Name, bool isUpdateName, string Code, bool isUpdateCode, bool CanChase, bool isUpdateCanChase, int ChaseBuyType_id, bool isUpdateChaseBuyType_id, int ChaseExecuteDeferMinute, bool isUpdateChaseExecuteDeferMinute, bool isUsed, bool isUpdateisUsed, int Sort, bool isUpdateSort, byte[] Agreement, bool isUpdateAgreement, byte[] Explain, bool isUpdateExplain, byte[] LotteryExemple, bool isUpdateLotteryExemple, byte[] OpenAfficheTemplate, bool isUpdateOpenAfficheTemplate, string WinLotteryExemple, bool isUpdateWinLotteryExemple, string BasePlayPage, bool isUpdateBasePlayPage, string IntervalType, bool isUpdateIntervalType, int Type_id, bool isUpdateType_id)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Lottery] set ";
                string UpdateFieldsList = "";

                if (isUpdateid)
                    UpdateFieldsList += "[id] = @id, ";
                if (isUpdateName)
                    UpdateFieldsList += "[Name] = @Name, ";
                if (isUpdateCode)
                    UpdateFieldsList += "[Code] = @Code, ";
                if (isUpdateCanChase)
                    UpdateFieldsList += "[CanChase] = @CanChase, ";
                if (isUpdateChaseBuyType_id)
                    UpdateFieldsList += "[ChaseBuyType_id] = @ChaseBuyType_id, ";
                if (isUpdateChaseExecuteDeferMinute)
                    UpdateFieldsList += "[ChaseExecuteDeferMinute] = @ChaseExecuteDeferMinute, ";
                if (isUpdateisUsed)
                    UpdateFieldsList += "[isUsed] = @isUsed, ";
                if (isUpdateSort)
                    UpdateFieldsList += "[Sort] = @Sort, ";
                if (isUpdateAgreement)
                    UpdateFieldsList += "[Agreement] = @Agreement, ";
                if (isUpdateExplain)
                    UpdateFieldsList += "[Explain] = @Explain, ";
                if (isUpdateLotteryExemple)
                    UpdateFieldsList += "[LotteryExemple] = @LotteryExemple, ";
                if (isUpdateOpenAfficheTemplate)
                    UpdateFieldsList += "[OpenAfficheTemplate] = @OpenAfficheTemplate, ";
                if (isUpdateWinLotteryExemple)
                    UpdateFieldsList += "[WinLotteryExemple] = @WinLotteryExemple, ";
                if (isUpdateBasePlayPage)
                    UpdateFieldsList += "[BasePlayPage] = @BasePlayPage, ";
                if (isUpdateIntervalType)
                    UpdateFieldsList += "[IntervalType] = @IntervalType, ";
                if (isUpdateType_id)
                    UpdateFieldsList += "[Type_id] = @Type_id, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isUpdateName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isUpdateCode ? null : new MSSQL.Parameter("Code", SqlDbType.VarChar, 0, ParameterDirection.Input, Code),
                    !isUpdateCanChase ? null : new MSSQL.Parameter("CanChase", SqlDbType.Bit, 0, ParameterDirection.Input, CanChase),
                    !isUpdateChaseBuyType_id ? null : new MSSQL.Parameter("ChaseBuyType_id", SqlDbType.Int, 0, ParameterDirection.Input, ChaseBuyType_id),
                    !isUpdateChaseExecuteDeferMinute ? null : new MSSQL.Parameter("ChaseExecuteDeferMinute", SqlDbType.Int, 0, ParameterDirection.Input, ChaseExecuteDeferMinute),
                    !isUpdateisUsed ? null : new MSSQL.Parameter("isUsed", SqlDbType.Bit, 0, ParameterDirection.Input, isUsed),
                    !isUpdateSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort),
                    !isUpdateAgreement ? null : new MSSQL.Parameter("Agreement", SqlDbType.Image, 0, ParameterDirection.Input, Agreement),
                    !isUpdateExplain ? null : new MSSQL.Parameter("Explain", SqlDbType.Image, 0, ParameterDirection.Input, Explain),
                    !isUpdateLotteryExemple ? null : new MSSQL.Parameter("LotteryExemple", SqlDbType.Image, 0, ParameterDirection.Input, LotteryExemple),
                    !isUpdateOpenAfficheTemplate ? null : new MSSQL.Parameter("OpenAfficheTemplate", SqlDbType.Image, 0, ParameterDirection.Input, OpenAfficheTemplate),
                    !isUpdateWinLotteryExemple ? null : new MSSQL.Parameter("WinLotteryExemple", SqlDbType.VarChar, 0, ParameterDirection.Input, WinLotteryExemple),
                    !isUpdateBasePlayPage ? null : new MSSQL.Parameter("BasePlayPage", SqlDbType.VarChar, 0, ParameterDirection.Input, BasePlayPage),
                    !isUpdateIntervalType ? null : new MSSQL.Parameter("IntervalType", SqlDbType.VarChar, 0, ParameterDirection.Input, IntervalType),
                    !isUpdateType_id ? null : new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Lottery]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Lottery]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class LotteryBuyDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [LotteryBuyDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int User_id, bool isInsertUser_id, DateTime DateTime, bool isInsertDateTime, int Scheme_id, bool isInsertScheme_id, int Share, bool isInsertShare, bool CanQuash, bool isInsertCanQuash, bool Quashed, bool isInsertQuashed, double WinMoneyNoWithTax, bool isInsertWinMoneyNoWithTax)
            {
                string CommandText = "insert into [LotteryBuyDetail] (";
                string InsertFieldsList = "";

                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertScheme_id)
                    InsertFieldsList += "[Scheme_id], ";
                if (isInsertShare)
                    InsertFieldsList += "[Share], ";
                if (isInsertCanQuash)
                    InsertFieldsList += "[CanQuash], ";
                if (isInsertQuashed)
                    InsertFieldsList += "[Quashed], ";
                if (isInsertWinMoneyNoWithTax)
                    InsertFieldsList += "[WinMoneyNoWithTax], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertScheme_id)
                    InsertValuesList += "@Scheme_id, ";
                if (isInsertShare)
                    InsertValuesList += "@Share, ";
                if (isInsertCanQuash)
                    InsertValuesList += "@CanQuash, ";
                if (isInsertQuashed)
                    InsertValuesList += "@Quashed, ";
                if (isInsertWinMoneyNoWithTax)
                    InsertValuesList += "@WinMoneyNoWithTax, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertScheme_id ? null : new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    !isInsertShare ? null : new MSSQL.Parameter("Share", SqlDbType.Int, 0, ParameterDirection.Input, Share),
                    !isInsertCanQuash ? null : new MSSQL.Parameter("CanQuash", SqlDbType.Bit, 0, ParameterDirection.Input, CanQuash),
                    !isInsertQuashed ? null : new MSSQL.Parameter("Quashed", SqlDbType.Bit, 0, ParameterDirection.Input, Quashed),
                    !isInsertWinMoneyNoWithTax ? null : new MSSQL.Parameter("WinMoneyNoWithTax", SqlDbType.Money, 0, ParameterDirection.Input, WinMoneyNoWithTax)
                    );
            }

            public static int Update(string Condition, int User_id, bool isUpdateUser_id, DateTime DateTime, bool isUpdateDateTime, int Scheme_id, bool isUpdateScheme_id, int Share, bool isUpdateShare, bool CanQuash, bool isUpdateCanQuash, bool Quashed, bool isUpdateQuashed, double WinMoneyNoWithTax, bool isUpdateWinMoneyNoWithTax)
            {
                Condition = Condition.Trim();

                string CommandText = "update [LotteryBuyDetail] set ";
                string UpdateFieldsList = "";

                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateScheme_id)
                    UpdateFieldsList += "[Scheme_id] = @Scheme_id, ";
                if (isUpdateShare)
                    UpdateFieldsList += "[Share] = @Share, ";
                if (isUpdateCanQuash)
                    UpdateFieldsList += "[CanQuash] = @CanQuash, ";
                if (isUpdateQuashed)
                    UpdateFieldsList += "[Quashed] = @Quashed, ";
                if (isUpdateWinMoneyNoWithTax)
                    UpdateFieldsList += "[WinMoneyNoWithTax] = @WinMoneyNoWithTax, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateScheme_id ? null : new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    !isUpdateShare ? null : new MSSQL.Parameter("Share", SqlDbType.Int, 0, ParameterDirection.Input, Share),
                    !isUpdateCanQuash ? null : new MSSQL.Parameter("CanQuash", SqlDbType.Bit, 0, ParameterDirection.Input, CanQuash),
                    !isUpdateQuashed ? null : new MSSQL.Parameter("Quashed", SqlDbType.Bit, 0, ParameterDirection.Input, Quashed),
                    !isUpdateWinMoneyNoWithTax ? null : new MSSQL.Parameter("WinMoneyNoWithTax", SqlDbType.Money, 0, ParameterDirection.Input, WinMoneyNoWithTax)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [LotteryBuyDetail]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [LotteryBuyDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class LotteryBuyType
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [LotteryBuyType]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int id, bool isInsertid, int Lottery_id, bool isInsertLottery_id, string Type, bool isInsertType, int SystemEndAheadMinute, bool isInsertSystemEndAheadMinute, string BuyFileName, bool isInsertBuyFileName)
            {
                string CommandText = "insert into [LotteryBuyType] (";
                string InsertFieldsList = "";

                if (isInsertid)
                    InsertFieldsList += "[id], ";
                if (isInsertLottery_id)
                    InsertFieldsList += "[Lottery_id], ";
                if (isInsertType)
                    InsertFieldsList += "[Type], ";
                if (isInsertSystemEndAheadMinute)
                    InsertFieldsList += "[SystemEndAheadMinute], ";
                if (isInsertBuyFileName)
                    InsertFieldsList += "[BuyFileName], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertid)
                    InsertValuesList += "@id, ";
                if (isInsertLottery_id)
                    InsertValuesList += "@Lottery_id, ";
                if (isInsertType)
                    InsertValuesList += "@Type, ";
                if (isInsertSystemEndAheadMinute)
                    InsertValuesList += "@SystemEndAheadMinute, ";
                if (isInsertBuyFileName)
                    InsertValuesList += "@BuyFileName, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isInsertLottery_id ? null : new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    !isInsertType ? null : new MSSQL.Parameter("Type", SqlDbType.VarChar, 0, ParameterDirection.Input, Type),
                    !isInsertSystemEndAheadMinute ? null : new MSSQL.Parameter("SystemEndAheadMinute", SqlDbType.Int, 0, ParameterDirection.Input, SystemEndAheadMinute),
                    !isInsertBuyFileName ? null : new MSSQL.Parameter("BuyFileName", SqlDbType.VarChar, 0, ParameterDirection.Input, BuyFileName)
                    );
            }

            public static int Update(string Condition, int id, bool isUpdateid, int Lottery_id, bool isUpdateLottery_id, string Type, bool isUpdateType, int SystemEndAheadMinute, bool isUpdateSystemEndAheadMinute, string BuyFileName, bool isUpdateBuyFileName)
            {
                Condition = Condition.Trim();

                string CommandText = "update [LotteryBuyType] set ";
                string UpdateFieldsList = "";

                if (isUpdateid)
                    UpdateFieldsList += "[id] = @id, ";
                if (isUpdateLottery_id)
                    UpdateFieldsList += "[Lottery_id] = @Lottery_id, ";
                if (isUpdateType)
                    UpdateFieldsList += "[Type] = @Type, ";
                if (isUpdateSystemEndAheadMinute)
                    UpdateFieldsList += "[SystemEndAheadMinute] = @SystemEndAheadMinute, ";
                if (isUpdateBuyFileName)
                    UpdateFieldsList += "[BuyFileName] = @BuyFileName, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isUpdateLottery_id ? null : new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    !isUpdateType ? null : new MSSQL.Parameter("Type", SqlDbType.VarChar, 0, ParameterDirection.Input, Type),
                    !isUpdateSystemEndAheadMinute ? null : new MSSQL.Parameter("SystemEndAheadMinute", SqlDbType.Int, 0, ParameterDirection.Input, SystemEndAheadMinute),
                    !isUpdateBuyFileName ? null : new MSSQL.Parameter("BuyFileName", SqlDbType.VarChar, 0, ParameterDirection.Input, BuyFileName)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [LotteryBuyType]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [LotteryBuyType]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class LotteryType
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [LotteryType]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Parent_id, bool isInsertParent_id, string Name, bool isInsertName, string Description, bool isInsertDescription, int Sort, bool isInsertSort)
            {
                string CommandText = "insert into [LotteryType] (";
                string InsertFieldsList = "";

                if (isInsertParent_id)
                    InsertFieldsList += "[Parent_id], ";
                if (isInsertName)
                    InsertFieldsList += "[Name], ";
                if (isInsertDescription)
                    InsertFieldsList += "[Description], ";
                if (isInsertSort)
                    InsertFieldsList += "[Sort], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertParent_id)
                    InsertValuesList += "@Parent_id, ";
                if (isInsertName)
                    InsertValuesList += "@Name, ";
                if (isInsertDescription)
                    InsertValuesList += "@Description, ";
                if (isInsertSort)
                    InsertValuesList += "@Sort, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertParent_id ? null : new MSSQL.Parameter("Parent_id", SqlDbType.Int, 0, ParameterDirection.Input, Parent_id),
                    !isInsertName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isInsertDescription ? null : new MSSQL.Parameter("Description", SqlDbType.VarChar, 0, ParameterDirection.Input, Description),
                    !isInsertSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort)
                    );
            }

            public static int Update(string Condition, int Parent_id, bool isUpdateParent_id, string Name, bool isUpdateName, string Description, bool isUpdateDescription, int Sort, bool isUpdateSort)
            {
                Condition = Condition.Trim();

                string CommandText = "update [LotteryType] set ";
                string UpdateFieldsList = "";

                if (isUpdateParent_id)
                    UpdateFieldsList += "[Parent_id] = @Parent_id, ";
                if (isUpdateName)
                    UpdateFieldsList += "[Name] = @Name, ";
                if (isUpdateDescription)
                    UpdateFieldsList += "[Description] = @Description, ";
                if (isUpdateSort)
                    UpdateFieldsList += "[Sort] = @Sort, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateParent_id ? null : new MSSQL.Parameter("Parent_id", SqlDbType.Int, 0, ParameterDirection.Input, Parent_id),
                    !isUpdateName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isUpdateDescription ? null : new MSSQL.Parameter("Description", SqlDbType.VarChar, 0, ParameterDirection.Input, Description),
                    !isUpdateSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [LotteryType]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [LotteryType]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class LotteryWinType
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [LotteryWinType]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int id, bool isInsertid, int Lottery_id, bool isInsertLottery_id, string Name, bool isInsertName, int Sort, bool isInsertSort, double DefaultMoney, bool isInsertDefaultMoney, double DefaultMoneyNoWithTax, bool isInsertDefaultMoneyNoWithTax)
            {
                string CommandText = "insert into [LotteryWinType] (";
                string InsertFieldsList = "";

                if (isInsertid)
                    InsertFieldsList += "[id], ";
                if (isInsertLottery_id)
                    InsertFieldsList += "[Lottery_id], ";
                if (isInsertName)
                    InsertFieldsList += "[Name], ";
                if (isInsertSort)
                    InsertFieldsList += "[Sort], ";
                if (isInsertDefaultMoney)
                    InsertFieldsList += "[DefaultMoney], ";
                if (isInsertDefaultMoneyNoWithTax)
                    InsertFieldsList += "[DefaultMoneyNoWithTax], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertid)
                    InsertValuesList += "@id, ";
                if (isInsertLottery_id)
                    InsertValuesList += "@Lottery_id, ";
                if (isInsertName)
                    InsertValuesList += "@Name, ";
                if (isInsertSort)
                    InsertValuesList += "@Sort, ";
                if (isInsertDefaultMoney)
                    InsertValuesList += "@DefaultMoney, ";
                if (isInsertDefaultMoneyNoWithTax)
                    InsertValuesList += "@DefaultMoneyNoWithTax, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isInsertLottery_id ? null : new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    !isInsertName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isInsertSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort),
                    !isInsertDefaultMoney ? null : new MSSQL.Parameter("DefaultMoney", SqlDbType.Money, 0, ParameterDirection.Input, DefaultMoney),
                    !isInsertDefaultMoneyNoWithTax ? null : new MSSQL.Parameter("DefaultMoneyNoWithTax", SqlDbType.Money, 0, ParameterDirection.Input, DefaultMoneyNoWithTax)
                    );
            }

            public static int Update(string Condition, int id, bool isUpdateid, int Lottery_id, bool isUpdateLottery_id, string Name, bool isUpdateName, int Sort, bool isUpdateSort, double DefaultMoney, bool isUpdateDefaultMoney, double DefaultMoneyNoWithTax, bool isUpdateDefaultMoneyNoWithTax)
            {
                Condition = Condition.Trim();

                string CommandText = "update [LotteryWinType] set ";
                string UpdateFieldsList = "";

                if (isUpdateid)
                    UpdateFieldsList += "[id] = @id, ";
                if (isUpdateLottery_id)
                    UpdateFieldsList += "[Lottery_id] = @Lottery_id, ";
                if (isUpdateName)
                    UpdateFieldsList += "[Name] = @Name, ";
                if (isUpdateSort)
                    UpdateFieldsList += "[Sort] = @Sort, ";
                if (isUpdateDefaultMoney)
                    UpdateFieldsList += "[DefaultMoney] = @DefaultMoney, ";
                if (isUpdateDefaultMoneyNoWithTax)
                    UpdateFieldsList += "[DefaultMoneyNoWithTax] = @DefaultMoneyNoWithTax, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isUpdateLottery_id ? null : new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    !isUpdateName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isUpdateSort ? null : new MSSQL.Parameter("Sort", SqlDbType.Int, 0, ParameterDirection.Input, Sort),
                    !isUpdateDefaultMoney ? null : new MSSQL.Parameter("DefaultMoney", SqlDbType.Money, 0, ParameterDirection.Input, DefaultMoney),
                    !isUpdateDefaultMoneyNoWithTax ? null : new MSSQL.Parameter("DefaultMoneyNoWithTax", SqlDbType.Money, 0, ParameterDirection.Input, DefaultMoneyNoWithTax)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [LotteryWinType]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [LotteryWinType]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Message
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Message]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Source_id, bool isInsertSource_id, int Aim_id, bool isInsertAim_id, int Type, bool isInsertType, byte[] Content, bool isInsertContent, DateTime DateTime, bool isInsertDateTime, bool isShow, bool isInsertisShow)
            {
                string CommandText = "insert into [Message] (";
                string InsertFieldsList = "";

                if (isInsertSource_id)
                    InsertFieldsList += "[Source_id], ";
                if (isInsertAim_id)
                    InsertFieldsList += "[Aim_id], ";
                if (isInsertType)
                    InsertFieldsList += "[Type], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertSource_id)
                    InsertValuesList += "@Source_id, ";
                if (isInsertAim_id)
                    InsertValuesList += "@Aim_id, ";
                if (isInsertType)
                    InsertValuesList += "@Type, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertSource_id ? null : new MSSQL.Parameter("Source_id", SqlDbType.Int, 0, ParameterDirection.Input, Source_id),
                    !isInsertAim_id ? null : new MSSQL.Parameter("Aim_id", SqlDbType.Int, 0, ParameterDirection.Input, Aim_id),
                    !isInsertType ? null : new MSSQL.Parameter("Type", SqlDbType.Int, 0, ParameterDirection.Input, Type),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow)
                    );
            }

            public static int Update(string Condition, int Source_id, bool isUpdateSource_id, int Aim_id, bool isUpdateAim_id, int Type, bool isUpdateType, byte[] Content, bool isUpdateContent, DateTime DateTime, bool isUpdateDateTime, bool isShow, bool isUpdateisShow)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Message] set ";
                string UpdateFieldsList = "";

                if (isUpdateSource_id)
                    UpdateFieldsList += "[Source_id] = @Source_id, ";
                if (isUpdateAim_id)
                    UpdateFieldsList += "[Aim_id] = @Aim_id, ";
                if (isUpdateType)
                    UpdateFieldsList += "[Type] = @Type, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateSource_id ? null : new MSSQL.Parameter("Source_id", SqlDbType.Int, 0, ParameterDirection.Input, Source_id),
                    !isUpdateAim_id ? null : new MSSQL.Parameter("Aim_id", SqlDbType.Int, 0, ParameterDirection.Input, Aim_id),
                    !isUpdateType ? null : new MSSQL.Parameter("Type", SqlDbType.Int, 0, ParameterDirection.Input, Type),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Message]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Message]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class MobileMessage
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [MobileMessage]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int MsgID, bool isInsertMsgID, string From, bool isInsertFrom, string To, bool isInsertTo, DateTime DateTime, bool isInsertDateTime, string Content, bool isInsertContent)
            {
                string CommandText = "insert into [MobileMessage] (";
                string InsertFieldsList = "";

                if (isInsertMsgID)
                    InsertFieldsList += "[MsgID], ";
                if (isInsertFrom)
                    InsertFieldsList += "[From], ";
                if (isInsertTo)
                    InsertFieldsList += "[To], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertMsgID)
                    InsertValuesList += "@MsgID, ";
                if (isInsertFrom)
                    InsertValuesList += "@From, ";
                if (isInsertTo)
                    InsertValuesList += "@To, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertMsgID ? null : new MSSQL.Parameter("MsgID", SqlDbType.Int, 0, ParameterDirection.Input, MsgID),
                    !isInsertFrom ? null : new MSSQL.Parameter("From", SqlDbType.VarChar, 0, ParameterDirection.Input, From),
                    !isInsertTo ? null : new MSSQL.Parameter("To", SqlDbType.VarChar, 0, ParameterDirection.Input, To),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.VarChar, 0, ParameterDirection.Input, Content)
                    );
            }

            public static int Update(string Condition, int MsgID, bool isUpdateMsgID, string From, bool isUpdateFrom, string To, bool isUpdateTo, DateTime DateTime, bool isUpdateDateTime, string Content, bool isUpdateContent)
            {
                Condition = Condition.Trim();

                string CommandText = "update [MobileMessage] set ";
                string UpdateFieldsList = "";

                if (isUpdateMsgID)
                    UpdateFieldsList += "[MsgID] = @MsgID, ";
                if (isUpdateFrom)
                    UpdateFieldsList += "[From] = @From, ";
                if (isUpdateTo)
                    UpdateFieldsList += "[To] = @To, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateMsgID ? null : new MSSQL.Parameter("MsgID", SqlDbType.Int, 0, ParameterDirection.Input, MsgID),
                    !isUpdateFrom ? null : new MSSQL.Parameter("From", SqlDbType.VarChar, 0, ParameterDirection.Input, From),
                    !isUpdateTo ? null : new MSSQL.Parameter("To", SqlDbType.VarChar, 0, ParameterDirection.Input, To),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.VarChar, 0, ParameterDirection.Input, Content)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [MobileMessage]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [MobileMessage]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class News01
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [News01]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [News01] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [News01] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [News01]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [News01]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class News02
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [News02]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [News02] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [News02] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [News02]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [News02]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class News03
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [News03]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [News03] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [News03] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [News03]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [News03]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class News04
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [News04]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [News04] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [News04] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [News04]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [News04]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class NewsFootball01
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [NewsFootball01]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [NewsFootball01] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [NewsFootball01] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [NewsFootball01]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [NewsFootball01]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class NewsFootball02
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [NewsFootball02]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [NewsFootball02] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [NewsFootball02] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [NewsFootball02]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [NewsFootball02]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class NewsFootball03
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [NewsFootball03]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [NewsFootball03] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [NewsFootball03] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [NewsFootball03]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [NewsFootball03]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class NewsFootball04
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [NewsFootball04]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [NewsFootball04] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [NewsFootball04] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [NewsFootball04]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [NewsFootball04]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class NewsFootball05
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [NewsFootball05]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [NewsFootball05] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [NewsFootball05] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [NewsFootball05]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [NewsFootball05]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class NewsFootball06
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [NewsFootball06]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [NewsFootball06] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [NewsFootball06] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [NewsFootball06]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [NewsFootball06]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class NewsSite
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [NewsSite]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string Title, bool isInsertTitle, byte[] Content, bool isInsertContent, bool isShow, bool isInsertisShow, string Image, bool isInsertImage)
            {
                string CommandText = "insert into [NewsSite] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertisShow)
                    InsertFieldsList += "[isShow], ";
                if (isInsertImage)
                    InsertFieldsList += "[Image], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertisShow)
                    InsertValuesList += "@isShow, ";
                if (isInsertImage)
                    InsertValuesList += "@Image, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isInsertImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string Title, bool isUpdateTitle, byte[] Content, bool isUpdateContent, bool isShow, bool isUpdateisShow, string Image, bool isUpdateImage)
            {
                Condition = Condition.Trim();

                string CommandText = "update [NewsSite] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateisShow)
                    UpdateFieldsList += "[isShow] = @isShow, ";
                if (isUpdateImage)
                    UpdateFieldsList += "[Image] = @Image, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateisShow ? null : new MSSQL.Parameter("isShow", SqlDbType.Bit, 0, ParameterDirection.Input, isShow),
                    !isUpdateImage ? null : new MSSQL.Parameter("Image", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [NewsSite]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [NewsSite]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Options
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Options]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int id, bool isInsertid, string Key, bool isInsertKey, byte[] ValueImage, bool isInsertValueImage, string Value, bool isInsertValue)
            {
                string CommandText = "insert into [Options] (";
                string InsertFieldsList = "";

                if (isInsertid)
                    InsertFieldsList += "[id], ";
                if (isInsertKey)
                    InsertFieldsList += "[Key], ";
                if (isInsertValueImage)
                    InsertFieldsList += "[ValueImage], ";
                if (isInsertValue)
                    InsertFieldsList += "[Value], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertid)
                    InsertValuesList += "@id, ";
                if (isInsertKey)
                    InsertValuesList += "@Key, ";
                if (isInsertValueImage)
                    InsertValuesList += "@ValueImage, ";
                if (isInsertValue)
                    InsertValuesList += "@Value, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isInsertKey ? null : new MSSQL.Parameter("Key", SqlDbType.VarChar, 0, ParameterDirection.Input, Key),
                    !isInsertValueImage ? null : new MSSQL.Parameter("ValueImage", SqlDbType.Image, 0, ParameterDirection.Input, ValueImage),
                    !isInsertValue ? null : new MSSQL.Parameter("Value", SqlDbType.VarChar, 0, ParameterDirection.Input, Value)
                    );
            }

            public static int Update(string Condition, int id, bool isUpdateid, string Key, bool isUpdateKey, byte[] ValueImage, bool isUpdateValueImage, string Value, bool isUpdateValue)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Options] set ";
                string UpdateFieldsList = "";

                if (isUpdateid)
                    UpdateFieldsList += "[id] = @id, ";
                if (isUpdateKey)
                    UpdateFieldsList += "[Key] = @Key, ";
                if (isUpdateValueImage)
                    UpdateFieldsList += "[ValueImage] = @ValueImage, ";
                if (isUpdateValue)
                    UpdateFieldsList += "[Value] = @Value, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isUpdateKey ? null : new MSSQL.Parameter("Key", SqlDbType.VarChar, 0, ParameterDirection.Input, Key),
                    !isUpdateValueImage ? null : new MSSQL.Parameter("ValueImage", SqlDbType.Image, 0, ParameterDirection.Input, ValueImage),
                    !isUpdateValue ? null : new MSSQL.Parameter("Value", SqlDbType.VarChar, 0, ParameterDirection.Input, Value)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Options]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Options]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class PromotionerClicks
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [PromotionerClicks]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int PromotionerID, bool isInsertPromotionerID, DateTime DateTime, bool isInsertDateTime, string IPAddress, bool isInsertIPAddress)
            {
                string CommandText = "insert into [PromotionerClicks] (";
                string InsertFieldsList = "";

                if (isInsertPromotionerID)
                    InsertFieldsList += "[PromotionerID], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertIPAddress)
                    InsertFieldsList += "[IPAddress], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertPromotionerID)
                    InsertValuesList += "@PromotionerID, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertIPAddress)
                    InsertValuesList += "@IPAddress, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertPromotionerID ? null : new MSSQL.Parameter("PromotionerID", SqlDbType.Int, 0, ParameterDirection.Input, PromotionerID),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertIPAddress ? null : new MSSQL.Parameter("IPAddress", SqlDbType.VarChar, 0, ParameterDirection.Input, IPAddress)
                    );
            }

            public static int Update(string Condition, int PromotionerID, bool isUpdatePromotionerID, DateTime DateTime, bool isUpdateDateTime, string IPAddress, bool isUpdateIPAddress)
            {
                Condition = Condition.Trim();

                string CommandText = "update [PromotionerClicks] set ";
                string UpdateFieldsList = "";

                if (isUpdatePromotionerID)
                    UpdateFieldsList += "[PromotionerID] = @PromotionerID, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateIPAddress)
                    UpdateFieldsList += "[IPAddress] = @IPAddress, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdatePromotionerID ? null : new MSSQL.Parameter("PromotionerID", SqlDbType.Int, 0, ParameterDirection.Input, PromotionerID),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateIPAddress ? null : new MSSQL.Parameter("IPAddress", SqlDbType.VarChar, 0, ParameterDirection.Input, IPAddress)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [PromotionerClicks]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [PromotionerClicks]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Promotioners
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Promotioners]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int User_id, bool isInsertUser_id, string Name, bool isInsertName, string Url, bool isInsertUrl, string LogoUrl, bool isInsertLogoUrl, double BonusScale, bool isInsertBonusScale, bool ON, bool isInsertON, string Company, bool isInsertCompany, string Address, bool isInsertAddress, string PostCode, bool isInsertPostCode, string ResponsiblePerson, bool isInsertResponsiblePerson, string ContactPerson, bool isInsertContactPerson, string Telephone, bool isInsertTelephone, string Fax, bool isInsertFax, string Mobile, bool isInsertMobile, string Email, bool isInsertEmail, string QQ, bool isInsertQQ, string ServiceTelephone, bool isInsertServiceTelephone, DateTime DateTime, bool isInsertDateTime)
            {
                string CommandText = "insert into [Promotioners] (";
                string InsertFieldsList = "";

                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertName)
                    InsertFieldsList += "[Name], ";
                if (isInsertUrl)
                    InsertFieldsList += "[Url], ";
                if (isInsertLogoUrl)
                    InsertFieldsList += "[LogoUrl], ";
                if (isInsertBonusScale)
                    InsertFieldsList += "[BonusScale], ";
                if (isInsertON)
                    InsertFieldsList += "[ON], ";
                if (isInsertCompany)
                    InsertFieldsList += "[Company], ";
                if (isInsertAddress)
                    InsertFieldsList += "[Address], ";
                if (isInsertPostCode)
                    InsertFieldsList += "[PostCode], ";
                if (isInsertResponsiblePerson)
                    InsertFieldsList += "[ResponsiblePerson], ";
                if (isInsertContactPerson)
                    InsertFieldsList += "[ContactPerson], ";
                if (isInsertTelephone)
                    InsertFieldsList += "[Telephone], ";
                if (isInsertFax)
                    InsertFieldsList += "[Fax], ";
                if (isInsertMobile)
                    InsertFieldsList += "[Mobile], ";
                if (isInsertEmail)
                    InsertFieldsList += "[Email], ";
                if (isInsertQQ)
                    InsertFieldsList += "[QQ], ";
                if (isInsertServiceTelephone)
                    InsertFieldsList += "[ServiceTelephone], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertName)
                    InsertValuesList += "@Name, ";
                if (isInsertUrl)
                    InsertValuesList += "@Url, ";
                if (isInsertLogoUrl)
                    InsertValuesList += "@LogoUrl, ";
                if (isInsertBonusScale)
                    InsertValuesList += "@BonusScale, ";
                if (isInsertON)
                    InsertValuesList += "@ON, ";
                if (isInsertCompany)
                    InsertValuesList += "@Company, ";
                if (isInsertAddress)
                    InsertValuesList += "@Address, ";
                if (isInsertPostCode)
                    InsertValuesList += "@PostCode, ";
                if (isInsertResponsiblePerson)
                    InsertValuesList += "@ResponsiblePerson, ";
                if (isInsertContactPerson)
                    InsertValuesList += "@ContactPerson, ";
                if (isInsertTelephone)
                    InsertValuesList += "@Telephone, ";
                if (isInsertFax)
                    InsertValuesList += "@Fax, ";
                if (isInsertMobile)
                    InsertValuesList += "@Mobile, ";
                if (isInsertEmail)
                    InsertValuesList += "@Email, ";
                if (isInsertQQ)
                    InsertValuesList += "@QQ, ";
                if (isInsertServiceTelephone)
                    InsertValuesList += "@ServiceTelephone, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isInsertUrl ? null : new MSSQL.Parameter("Url", SqlDbType.VarChar, 0, ParameterDirection.Input, Url),
                    !isInsertLogoUrl ? null : new MSSQL.Parameter("LogoUrl", SqlDbType.VarChar, 0, ParameterDirection.Input, LogoUrl),
                    !isInsertBonusScale ? null : new MSSQL.Parameter("BonusScale", SqlDbType.Float, 0, ParameterDirection.Input, BonusScale),
                    !isInsertON ? null : new MSSQL.Parameter("ON", SqlDbType.Bit, 0, ParameterDirection.Input, ON),
                    !isInsertCompany ? null : new MSSQL.Parameter("Company", SqlDbType.VarChar, 0, ParameterDirection.Input, Company),
                    !isInsertAddress ? null : new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    !isInsertPostCode ? null : new MSSQL.Parameter("PostCode", SqlDbType.VarChar, 0, ParameterDirection.Input, PostCode),
                    !isInsertResponsiblePerson ? null : new MSSQL.Parameter("ResponsiblePerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ResponsiblePerson),
                    !isInsertContactPerson ? null : new MSSQL.Parameter("ContactPerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ContactPerson),
                    !isInsertTelephone ? null : new MSSQL.Parameter("Telephone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telephone),
                    !isInsertFax ? null : new MSSQL.Parameter("Fax", SqlDbType.VarChar, 0, ParameterDirection.Input, Fax),
                    !isInsertMobile ? null : new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    !isInsertEmail ? null : new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    !isInsertQQ ? null : new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    !isInsertServiceTelephone ? null : new MSSQL.Parameter("ServiceTelephone", SqlDbType.VarChar, 0, ParameterDirection.Input, ServiceTelephone),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Update(string Condition, int User_id, bool isUpdateUser_id, string Name, bool isUpdateName, string Url, bool isUpdateUrl, string LogoUrl, bool isUpdateLogoUrl, double BonusScale, bool isUpdateBonusScale, bool ON, bool isUpdateON, string Company, bool isUpdateCompany, string Address, bool isUpdateAddress, string PostCode, bool isUpdatePostCode, string ResponsiblePerson, bool isUpdateResponsiblePerson, string ContactPerson, bool isUpdateContactPerson, string Telephone, bool isUpdateTelephone, string Fax, bool isUpdateFax, string Mobile, bool isUpdateMobile, string Email, bool isUpdateEmail, string QQ, bool isUpdateQQ, string ServiceTelephone, bool isUpdateServiceTelephone, DateTime DateTime, bool isUpdateDateTime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Promotioners] set ";
                string UpdateFieldsList = "";

                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateName)
                    UpdateFieldsList += "[Name] = @Name, ";
                if (isUpdateUrl)
                    UpdateFieldsList += "[Url] = @Url, ";
                if (isUpdateLogoUrl)
                    UpdateFieldsList += "[LogoUrl] = @LogoUrl, ";
                if (isUpdateBonusScale)
                    UpdateFieldsList += "[BonusScale] = @BonusScale, ";
                if (isUpdateON)
                    UpdateFieldsList += "[ON] = @ON, ";
                if (isUpdateCompany)
                    UpdateFieldsList += "[Company] = @Company, ";
                if (isUpdateAddress)
                    UpdateFieldsList += "[Address] = @Address, ";
                if (isUpdatePostCode)
                    UpdateFieldsList += "[PostCode] = @PostCode, ";
                if (isUpdateResponsiblePerson)
                    UpdateFieldsList += "[ResponsiblePerson] = @ResponsiblePerson, ";
                if (isUpdateContactPerson)
                    UpdateFieldsList += "[ContactPerson] = @ContactPerson, ";
                if (isUpdateTelephone)
                    UpdateFieldsList += "[Telephone] = @Telephone, ";
                if (isUpdateFax)
                    UpdateFieldsList += "[Fax] = @Fax, ";
                if (isUpdateMobile)
                    UpdateFieldsList += "[Mobile] = @Mobile, ";
                if (isUpdateEmail)
                    UpdateFieldsList += "[Email] = @Email, ";
                if (isUpdateQQ)
                    UpdateFieldsList += "[QQ] = @QQ, ";
                if (isUpdateServiceTelephone)
                    UpdateFieldsList += "[ServiceTelephone] = @ServiceTelephone, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isUpdateUrl ? null : new MSSQL.Parameter("Url", SqlDbType.VarChar, 0, ParameterDirection.Input, Url),
                    !isUpdateLogoUrl ? null : new MSSQL.Parameter("LogoUrl", SqlDbType.VarChar, 0, ParameterDirection.Input, LogoUrl),
                    !isUpdateBonusScale ? null : new MSSQL.Parameter("BonusScale", SqlDbType.Float, 0, ParameterDirection.Input, BonusScale),
                    !isUpdateON ? null : new MSSQL.Parameter("ON", SqlDbType.Bit, 0, ParameterDirection.Input, ON),
                    !isUpdateCompany ? null : new MSSQL.Parameter("Company", SqlDbType.VarChar, 0, ParameterDirection.Input, Company),
                    !isUpdateAddress ? null : new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    !isUpdatePostCode ? null : new MSSQL.Parameter("PostCode", SqlDbType.VarChar, 0, ParameterDirection.Input, PostCode),
                    !isUpdateResponsiblePerson ? null : new MSSQL.Parameter("ResponsiblePerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ResponsiblePerson),
                    !isUpdateContactPerson ? null : new MSSQL.Parameter("ContactPerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ContactPerson),
                    !isUpdateTelephone ? null : new MSSQL.Parameter("Telephone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telephone),
                    !isUpdateFax ? null : new MSSQL.Parameter("Fax", SqlDbType.VarChar, 0, ParameterDirection.Input, Fax),
                    !isUpdateMobile ? null : new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    !isUpdateEmail ? null : new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    !isUpdateQQ ? null : new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    !isUpdateServiceTelephone ? null : new MSSQL.Parameter("ServiceTelephone", SqlDbType.VarChar, 0, ParameterDirection.Input, ServiceTelephone),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Promotioners]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Promotioners]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Province
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Province]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int id, bool isInsertid, string Name, bool isInsertName)
            {
                string CommandText = "insert into [Province] (";
                string InsertFieldsList = "";

                if (isInsertid)
                    InsertFieldsList += "[id], ";
                if (isInsertName)
                    InsertFieldsList += "[Name], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertid)
                    InsertValuesList += "@id, ";
                if (isInsertName)
                    InsertValuesList += "@Name, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isInsertName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name)
                    );
            }

            public static int Update(string Condition, int id, bool isUpdateid, string Name, bool isUpdateName)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Province] set ";
                string UpdateFieldsList = "";

                if (isUpdateid)
                    UpdateFieldsList += "[id] = @id, ";
                if (isUpdateName)
                    UpdateFieldsList += "[Name] = @Name, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateid ? null : new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    !isUpdateName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Province]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Province]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Question
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Question]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, int User_id, bool isInsertUser_id, int Type_id, bool isInsertType_id, string Telphone, bool isInsertTelphone, byte[] Content, bool isInsertContent, bool Answered, bool isInsertAnswered, DateTime AnswerDateTime, bool isInsertAnswerDateTime, byte[] Answer, bool isInsertAnswer)
            {
                string CommandText = "insert into [Question] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertType_id)
                    InsertFieldsList += "[Type_id], ";
                if (isInsertTelphone)
                    InsertFieldsList += "[Telphone], ";
                if (isInsertContent)
                    InsertFieldsList += "[Content], ";
                if (isInsertAnswered)
                    InsertFieldsList += "[Answered], ";
                if (isInsertAnswerDateTime)
                    InsertFieldsList += "[AnswerDateTime], ";
                if (isInsertAnswer)
                    InsertFieldsList += "[Answer], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertType_id)
                    InsertValuesList += "@Type_id, ";
                if (isInsertTelphone)
                    InsertValuesList += "@Telphone, ";
                if (isInsertContent)
                    InsertValuesList += "@Content, ";
                if (isInsertAnswered)
                    InsertValuesList += "@Answered, ";
                if (isInsertAnswerDateTime)
                    InsertValuesList += "@AnswerDateTime, ";
                if (isInsertAnswer)
                    InsertValuesList += "@Answer, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertType_id ? null : new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    !isInsertTelphone ? null : new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    !isInsertContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isInsertAnswered ? null : new MSSQL.Parameter("Answered", SqlDbType.Bit, 0, ParameterDirection.Input, Answered),
                    !isInsertAnswerDateTime ? null : new MSSQL.Parameter("AnswerDateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, AnswerDateTime),
                    !isInsertAnswer ? null : new MSSQL.Parameter("Answer", SqlDbType.Image, 0, ParameterDirection.Input, Answer)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, int User_id, bool isUpdateUser_id, int Type_id, bool isUpdateType_id, string Telphone, bool isUpdateTelphone, byte[] Content, bool isUpdateContent, bool Answered, bool isUpdateAnswered, DateTime AnswerDateTime, bool isUpdateAnswerDateTime, byte[] Answer, bool isUpdateAnswer)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Question] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateType_id)
                    UpdateFieldsList += "[Type_id] = @Type_id, ";
                if (isUpdateTelphone)
                    UpdateFieldsList += "[Telphone] = @Telphone, ";
                if (isUpdateContent)
                    UpdateFieldsList += "[Content] = @Content, ";
                if (isUpdateAnswered)
                    UpdateFieldsList += "[Answered] = @Answered, ";
                if (isUpdateAnswerDateTime)
                    UpdateFieldsList += "[AnswerDateTime] = @AnswerDateTime, ";
                if (isUpdateAnswer)
                    UpdateFieldsList += "[Answer] = @Answer, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateType_id ? null : new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    !isUpdateTelphone ? null : new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    !isUpdateContent ? null : new MSSQL.Parameter("Content", SqlDbType.Image, 0, ParameterDirection.Input, Content),
                    !isUpdateAnswered ? null : new MSSQL.Parameter("Answered", SqlDbType.Bit, 0, ParameterDirection.Input, Answered),
                    !isUpdateAnswerDateTime ? null : new MSSQL.Parameter("AnswerDateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, AnswerDateTime),
                    !isUpdateAnswer ? null : new MSSQL.Parameter("Answer", SqlDbType.Image, 0, ParameterDirection.Input, Answer)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Question]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Question]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class QuestionType
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [QuestionType]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string Type, bool isInsertType)
            {
                string CommandText = "insert into [QuestionType] (";
                string InsertFieldsList = "";

                if (isInsertType)
                    InsertFieldsList += "[Type], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertType)
                    InsertValuesList += "@Type, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertType ? null : new MSSQL.Parameter("Type", SqlDbType.VarChar, 0, ParameterDirection.Input, Type)
                    );
            }

            public static int Update(string Condition, string Type, bool isUpdateType)
            {
                Condition = Condition.Trim();

                string CommandText = "update [QuestionType] set ";
                string UpdateFieldsList = "";

                if (isUpdateType)
                    UpdateFieldsList += "[Type] = @Type, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateType ? null : new MSSQL.Parameter("Type", SqlDbType.VarChar, 0, ParameterDirection.Input, Type)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [QuestionType]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [QuestionType]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Scheme
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Scheme]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(DateTime DateTime, bool isInsertDateTime, string SchemeNumber, bool isInsertSchemeNumber, string Title, bool isInsertTitle, byte[] Description, bool isInsertDescription, int InitiateUser_id, bool isInsertInitiateUser_id, int Isuse_id, bool isInsertIsuse_id, int Type_id, bool isInsertType_id, byte[] LotteryNumber, bool isInsertLotteryNumber, string FileName, bool isInsertFileName, int Multiple, bool isInsertMultiple, double Money, bool isInsertMoney, double AssureMoney, bool isInsertAssureMoney, int Share, bool isInsertShare, bool Quashed, bool isInsertQuashed, bool isSystemQuashed, bool isInsertisSystemQuashed, bool LotteryBuyed, bool isInsertLotteryBuyed, byte[] LotteryCode, bool isInsertLotteryCode, double WinMoney, bool isInsertWinMoney, double WinMoneyNoWithTax, bool isInsertWinMoneyNoWithTax, double WinCommission, bool isInsertWinCommission, byte[] WinDescription, bool isInsertWinDescription, bool AtTopApplication, bool isInsertAtTopApplication, bool AtTop, bool isInsertAtTop, bool AtWinAffiche, bool isInsertAtWinAffiche, string OpenUserList, bool isInsertOpenUserList, int SecrecyLevel, bool isInsertSecrecyLevel, int BuyOperator_id, bool isInsertBuyOperator_id, int WinOperator_id, bool isInsertWinOperator_id, bool SchemeIsOpen, bool isInsertSchemeIsOpen)
            {
                string CommandText = "insert into [Scheme] (";
                string InsertFieldsList = "";

                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertSchemeNumber)
                    InsertFieldsList += "[SchemeNumber], ";
                if (isInsertTitle)
                    InsertFieldsList += "[Title], ";
                if (isInsertDescription)
                    InsertFieldsList += "[Description], ";
                if (isInsertInitiateUser_id)
                    InsertFieldsList += "[InitiateUser_id], ";
                if (isInsertIsuse_id)
                    InsertFieldsList += "[Isuse_id], ";
                if (isInsertType_id)
                    InsertFieldsList += "[Type_id], ";
                if (isInsertLotteryNumber)
                    InsertFieldsList += "[LotteryNumber], ";
                if (isInsertFileName)
                    InsertFieldsList += "[FileName], ";
                if (isInsertMultiple)
                    InsertFieldsList += "[Multiple], ";
                if (isInsertMoney)
                    InsertFieldsList += "[Money], ";
                if (isInsertAssureMoney)
                    InsertFieldsList += "[AssureMoney], ";
                if (isInsertShare)
                    InsertFieldsList += "[Share], ";
                if (isInsertQuashed)
                    InsertFieldsList += "[Quashed], ";
                if (isInsertisSystemQuashed)
                    InsertFieldsList += "[isSystemQuashed], ";
                if (isInsertLotteryBuyed)
                    InsertFieldsList += "[LotteryBuyed], ";
                if (isInsertLotteryCode)
                    InsertFieldsList += "[LotteryCode], ";
                if (isInsertWinMoney)
                    InsertFieldsList += "[WinMoney], ";
                if (isInsertWinMoneyNoWithTax)
                    InsertFieldsList += "[WinMoneyNoWithTax], ";
                if (isInsertWinCommission)
                    InsertFieldsList += "[WinCommission], ";
                if (isInsertWinDescription)
                    InsertFieldsList += "[WinDescription], ";
                if (isInsertAtTopApplication)
                    InsertFieldsList += "[AtTopApplication], ";
                if (isInsertAtTop)
                    InsertFieldsList += "[AtTop], ";
                if (isInsertAtWinAffiche)
                    InsertFieldsList += "[AtWinAffiche], ";
                if (isInsertOpenUserList)
                    InsertFieldsList += "[OpenUserList], ";
                if (isInsertSecrecyLevel)
                    InsertFieldsList += "[SecrecyLevel], ";
                if (isInsertBuyOperator_id)
                    InsertFieldsList += "[BuyOperator_id], ";
                if (isInsertWinOperator_id)
                    InsertFieldsList += "[WinOperator_id], ";
                if (isInsertSchemeIsOpen)
                    InsertFieldsList += "[SchemeIsOpen], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertSchemeNumber)
                    InsertValuesList += "@SchemeNumber, ";
                if (isInsertTitle)
                    InsertValuesList += "@Title, ";
                if (isInsertDescription)
                    InsertValuesList += "@Description, ";
                if (isInsertInitiateUser_id)
                    InsertValuesList += "@InitiateUser_id, ";
                if (isInsertIsuse_id)
                    InsertValuesList += "@Isuse_id, ";
                if (isInsertType_id)
                    InsertValuesList += "@Type_id, ";
                if (isInsertLotteryNumber)
                    InsertValuesList += "@LotteryNumber, ";
                if (isInsertFileName)
                    InsertValuesList += "@FileName, ";
                if (isInsertMultiple)
                    InsertValuesList += "@Multiple, ";
                if (isInsertMoney)
                    InsertValuesList += "@Money, ";
                if (isInsertAssureMoney)
                    InsertValuesList += "@AssureMoney, ";
                if (isInsertShare)
                    InsertValuesList += "@Share, ";
                if (isInsertQuashed)
                    InsertValuesList += "@Quashed, ";
                if (isInsertisSystemQuashed)
                    InsertValuesList += "@isSystemQuashed, ";
                if (isInsertLotteryBuyed)
                    InsertValuesList += "@LotteryBuyed, ";
                if (isInsertLotteryCode)
                    InsertValuesList += "@LotteryCode, ";
                if (isInsertWinMoney)
                    InsertValuesList += "@WinMoney, ";
                if (isInsertWinMoneyNoWithTax)
                    InsertValuesList += "@WinMoneyNoWithTax, ";
                if (isInsertWinCommission)
                    InsertValuesList += "@WinCommission, ";
                if (isInsertWinDescription)
                    InsertValuesList += "@WinDescription, ";
                if (isInsertAtTopApplication)
                    InsertValuesList += "@AtTopApplication, ";
                if (isInsertAtTop)
                    InsertValuesList += "@AtTop, ";
                if (isInsertAtWinAffiche)
                    InsertValuesList += "@AtWinAffiche, ";
                if (isInsertOpenUserList)
                    InsertValuesList += "@OpenUserList, ";
                if (isInsertSecrecyLevel)
                    InsertValuesList += "@SecrecyLevel, ";
                if (isInsertBuyOperator_id)
                    InsertValuesList += "@BuyOperator_id, ";
                if (isInsertWinOperator_id)
                    InsertValuesList += "@WinOperator_id, ";
                if (isInsertSchemeIsOpen)
                    InsertValuesList += "@SchemeIsOpen, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertSchemeNumber ? null : new MSSQL.Parameter("SchemeNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, SchemeNumber),
                    !isInsertTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isInsertDescription ? null : new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    !isInsertInitiateUser_id ? null : new MSSQL.Parameter("InitiateUser_id", SqlDbType.Int, 0, ParameterDirection.Input, InitiateUser_id),
                    !isInsertIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isInsertType_id ? null : new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    !isInsertLotteryNumber ? null : new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    !isInsertFileName ? null : new MSSQL.Parameter("FileName", SqlDbType.VarChar, 0, ParameterDirection.Input, FileName),
                    !isInsertMultiple ? null : new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    !isInsertMoney ? null : new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    !isInsertAssureMoney ? null : new MSSQL.Parameter("AssureMoney", SqlDbType.Money, 0, ParameterDirection.Input, AssureMoney),
                    !isInsertShare ? null : new MSSQL.Parameter("Share", SqlDbType.Int, 0, ParameterDirection.Input, Share),
                    !isInsertQuashed ? null : new MSSQL.Parameter("Quashed", SqlDbType.Bit, 0, ParameterDirection.Input, Quashed),
                    !isInsertisSystemQuashed ? null : new MSSQL.Parameter("isSystemQuashed", SqlDbType.Bit, 0, ParameterDirection.Input, isSystemQuashed),
                    !isInsertLotteryBuyed ? null : new MSSQL.Parameter("LotteryBuyed", SqlDbType.Bit, 0, ParameterDirection.Input, LotteryBuyed),
                    !isInsertLotteryCode ? null : new MSSQL.Parameter("LotteryCode", SqlDbType.Image, 0, ParameterDirection.Input, LotteryCode),
                    !isInsertWinMoney ? null : new MSSQL.Parameter("WinMoney", SqlDbType.Money, 0, ParameterDirection.Input, WinMoney),
                    !isInsertWinMoneyNoWithTax ? null : new MSSQL.Parameter("WinMoneyNoWithTax", SqlDbType.Money, 0, ParameterDirection.Input, WinMoneyNoWithTax),
                    !isInsertWinCommission ? null : new MSSQL.Parameter("WinCommission", SqlDbType.Money, 0, ParameterDirection.Input, WinCommission),
                    !isInsertWinDescription ? null : new MSSQL.Parameter("WinDescription", SqlDbType.Image, 0, ParameterDirection.Input, WinDescription),
                    !isInsertAtTopApplication ? null : new MSSQL.Parameter("AtTopApplication", SqlDbType.Bit, 0, ParameterDirection.Input, AtTopApplication),
                    !isInsertAtTop ? null : new MSSQL.Parameter("AtTop", SqlDbType.Bit, 0, ParameterDirection.Input, AtTop),
                    !isInsertAtWinAffiche ? null : new MSSQL.Parameter("AtWinAffiche", SqlDbType.Bit, 0, ParameterDirection.Input, AtWinAffiche),
                    !isInsertOpenUserList ? null : new MSSQL.Parameter("OpenUserList", SqlDbType.VarChar, 0, ParameterDirection.Input, OpenUserList),
                    !isInsertSecrecyLevel ? null : new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    !isInsertBuyOperator_id ? null : new MSSQL.Parameter("BuyOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyOperator_id),
                    !isInsertWinOperator_id ? null : new MSSQL.Parameter("WinOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, WinOperator_id),
                    !isInsertSchemeIsOpen ? null : new MSSQL.Parameter("SchemeIsOpen", SqlDbType.Bit, 0, ParameterDirection.Input, SchemeIsOpen)
                    );
            }

            public static int Update(string Condition, DateTime DateTime, bool isUpdateDateTime, string SchemeNumber, bool isUpdateSchemeNumber, string Title, bool isUpdateTitle, byte[] Description, bool isUpdateDescription, int InitiateUser_id, bool isUpdateInitiateUser_id, int Isuse_id, bool isUpdateIsuse_id, int Type_id, bool isUpdateType_id, byte[] LotteryNumber, bool isUpdateLotteryNumber, string FileName, bool isUpdateFileName, int Multiple, bool isUpdateMultiple, double Money, bool isUpdateMoney, double AssureMoney, bool isUpdateAssureMoney, int Share, bool isUpdateShare, bool Quashed, bool isUpdateQuashed, bool isSystemQuashed, bool isUpdateisSystemQuashed, bool LotteryBuyed, bool isUpdateLotteryBuyed, byte[] LotteryCode, bool isUpdateLotteryCode, double WinMoney, bool isUpdateWinMoney, double WinMoneyNoWithTax, bool isUpdateWinMoneyNoWithTax, double WinCommission, bool isUpdateWinCommission, byte[] WinDescription, bool isUpdateWinDescription, bool AtTopApplication, bool isUpdateAtTopApplication, bool AtTop, bool isUpdateAtTop, bool AtWinAffiche, bool isUpdateAtWinAffiche, string OpenUserList, bool isUpdateOpenUserList, int SecrecyLevel, bool isUpdateSecrecyLevel, int BuyOperator_id, bool isUpdateBuyOperator_id, int WinOperator_id, bool isUpdateWinOperator_id, bool SchemeIsOpen, bool isUpdateSchemeIsOpen)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Scheme] set ";
                string UpdateFieldsList = "";

                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateSchemeNumber)
                    UpdateFieldsList += "[SchemeNumber] = @SchemeNumber, ";
                if (isUpdateTitle)
                    UpdateFieldsList += "[Title] = @Title, ";
                if (isUpdateDescription)
                    UpdateFieldsList += "[Description] = @Description, ";
                if (isUpdateInitiateUser_id)
                    UpdateFieldsList += "[InitiateUser_id] = @InitiateUser_id, ";
                if (isUpdateIsuse_id)
                    UpdateFieldsList += "[Isuse_id] = @Isuse_id, ";
                if (isUpdateType_id)
                    UpdateFieldsList += "[Type_id] = @Type_id, ";
                if (isUpdateLotteryNumber)
                    UpdateFieldsList += "[LotteryNumber] = @LotteryNumber, ";
                if (isUpdateFileName)
                    UpdateFieldsList += "[FileName] = @FileName, ";
                if (isUpdateMultiple)
                    UpdateFieldsList += "[Multiple] = @Multiple, ";
                if (isUpdateMoney)
                    UpdateFieldsList += "[Money] = @Money, ";
                if (isUpdateAssureMoney)
                    UpdateFieldsList += "[AssureMoney] = @AssureMoney, ";
                if (isUpdateShare)
                    UpdateFieldsList += "[Share] = @Share, ";
                if (isUpdateQuashed)
                    UpdateFieldsList += "[Quashed] = @Quashed, ";
                if (isUpdateisSystemQuashed)
                    UpdateFieldsList += "[isSystemQuashed] = @isSystemQuashed, ";
                if (isUpdateLotteryBuyed)
                    UpdateFieldsList += "[LotteryBuyed] = @LotteryBuyed, ";
                if (isUpdateLotteryCode)
                    UpdateFieldsList += "[LotteryCode] = @LotteryCode, ";
                if (isUpdateWinMoney)
                    UpdateFieldsList += "[WinMoney] = @WinMoney, ";
                if (isUpdateWinMoneyNoWithTax)
                    UpdateFieldsList += "[WinMoneyNoWithTax] = @WinMoneyNoWithTax, ";
                if (isUpdateWinCommission)
                    UpdateFieldsList += "[WinCommission] = @WinCommission, ";
                if (isUpdateWinDescription)
                    UpdateFieldsList += "[WinDescription] = @WinDescription, ";
                if (isUpdateAtTopApplication)
                    UpdateFieldsList += "[AtTopApplication] = @AtTopApplication, ";
                if (isUpdateAtTop)
                    UpdateFieldsList += "[AtTop] = @AtTop, ";
                if (isUpdateAtWinAffiche)
                    UpdateFieldsList += "[AtWinAffiche] = @AtWinAffiche, ";
                if (isUpdateOpenUserList)
                    UpdateFieldsList += "[OpenUserList] = @OpenUserList, ";
                if (isUpdateSecrecyLevel)
                    UpdateFieldsList += "[SecrecyLevel] = @SecrecyLevel, ";
                if (isUpdateBuyOperator_id)
                    UpdateFieldsList += "[BuyOperator_id] = @BuyOperator_id, ";
                if (isUpdateWinOperator_id)
                    UpdateFieldsList += "[WinOperator_id] = @WinOperator_id, ";
                if (isUpdateSchemeIsOpen)
                    UpdateFieldsList += "[SchemeIsOpen] = @SchemeIsOpen, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateSchemeNumber ? null : new MSSQL.Parameter("SchemeNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, SchemeNumber),
                    !isUpdateTitle ? null : new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    !isUpdateDescription ? null : new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    !isUpdateInitiateUser_id ? null : new MSSQL.Parameter("InitiateUser_id", SqlDbType.Int, 0, ParameterDirection.Input, InitiateUser_id),
                    !isUpdateIsuse_id ? null : new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    !isUpdateType_id ? null : new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    !isUpdateLotteryNumber ? null : new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    !isUpdateFileName ? null : new MSSQL.Parameter("FileName", SqlDbType.VarChar, 0, ParameterDirection.Input, FileName),
                    !isUpdateMultiple ? null : new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    !isUpdateMoney ? null : new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    !isUpdateAssureMoney ? null : new MSSQL.Parameter("AssureMoney", SqlDbType.Money, 0, ParameterDirection.Input, AssureMoney),
                    !isUpdateShare ? null : new MSSQL.Parameter("Share", SqlDbType.Int, 0, ParameterDirection.Input, Share),
                    !isUpdateQuashed ? null : new MSSQL.Parameter("Quashed", SqlDbType.Bit, 0, ParameterDirection.Input, Quashed),
                    !isUpdateisSystemQuashed ? null : new MSSQL.Parameter("isSystemQuashed", SqlDbType.Bit, 0, ParameterDirection.Input, isSystemQuashed),
                    !isUpdateLotteryBuyed ? null : new MSSQL.Parameter("LotteryBuyed", SqlDbType.Bit, 0, ParameterDirection.Input, LotteryBuyed),
                    !isUpdateLotteryCode ? null : new MSSQL.Parameter("LotteryCode", SqlDbType.Image, 0, ParameterDirection.Input, LotteryCode),
                    !isUpdateWinMoney ? null : new MSSQL.Parameter("WinMoney", SqlDbType.Money, 0, ParameterDirection.Input, WinMoney),
                    !isUpdateWinMoneyNoWithTax ? null : new MSSQL.Parameter("WinMoneyNoWithTax", SqlDbType.Money, 0, ParameterDirection.Input, WinMoneyNoWithTax),
                    !isUpdateWinCommission ? null : new MSSQL.Parameter("WinCommission", SqlDbType.Money, 0, ParameterDirection.Input, WinCommission),
                    !isUpdateWinDescription ? null : new MSSQL.Parameter("WinDescription", SqlDbType.Image, 0, ParameterDirection.Input, WinDescription),
                    !isUpdateAtTopApplication ? null : new MSSQL.Parameter("AtTopApplication", SqlDbType.Bit, 0, ParameterDirection.Input, AtTopApplication),
                    !isUpdateAtTop ? null : new MSSQL.Parameter("AtTop", SqlDbType.Bit, 0, ParameterDirection.Input, AtTop),
                    !isUpdateAtWinAffiche ? null : new MSSQL.Parameter("AtWinAffiche", SqlDbType.Bit, 0, ParameterDirection.Input, AtWinAffiche),
                    !isUpdateOpenUserList ? null : new MSSQL.Parameter("OpenUserList", SqlDbType.VarChar, 0, ParameterDirection.Input, OpenUserList),
                    !isUpdateSecrecyLevel ? null : new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    !isUpdateBuyOperator_id ? null : new MSSQL.Parameter("BuyOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyOperator_id),
                    !isUpdateWinOperator_id ? null : new MSSQL.Parameter("WinOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, WinOperator_id),
                    !isUpdateSchemeIsOpen ? null : new MSSQL.Parameter("SchemeIsOpen", SqlDbType.Bit, 0, ParameterDirection.Input, SchemeIsOpen)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Scheme]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Scheme]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class SchemeChat
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [SchemeChat]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int SchemeID, bool isInsertSchemeID, int SiteID, bool isInsertSiteID, int UserID, bool isInsertUserID, bool Talking, bool isInsertTalking, DateTime LastJoinTime, bool isInsertLastJoinTime)
            {
                string CommandText = "insert into [SchemeChat] (";
                string InsertFieldsList = "";

                if (isInsertSchemeID)
                    InsertFieldsList += "[SchemeID], ";
                if (isInsertSiteID)
                    InsertFieldsList += "[SiteID], ";
                if (isInsertUserID)
                    InsertFieldsList += "[UserID], ";
                if (isInsertTalking)
                    InsertFieldsList += "[Talking], ";
                if (isInsertLastJoinTime)
                    InsertFieldsList += "[LastJoinTime], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertSchemeID)
                    InsertValuesList += "@SchemeID, ";
                if (isInsertSiteID)
                    InsertValuesList += "@SiteID, ";
                if (isInsertUserID)
                    InsertValuesList += "@UserID, ";
                if (isInsertTalking)
                    InsertValuesList += "@Talking, ";
                if (isInsertLastJoinTime)
                    InsertValuesList += "@LastJoinTime, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertSchemeID ? null : new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    !isInsertSiteID ? null : new MSSQL.Parameter("SiteID", SqlDbType.Int, 0, ParameterDirection.Input, SiteID),
                    !isInsertUserID ? null : new MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID),
                    !isInsertTalking ? null : new MSSQL.Parameter("Talking", SqlDbType.Bit, 0, ParameterDirection.Input, Talking),
                    !isInsertLastJoinTime ? null : new MSSQL.Parameter("LastJoinTime", SqlDbType.DateTime, 0, ParameterDirection.Input, LastJoinTime)
                    );
            }

            public static int Update(string Condition, int SchemeID, bool isUpdateSchemeID, int SiteID, bool isUpdateSiteID, int UserID, bool isUpdateUserID, bool Talking, bool isUpdateTalking, DateTime LastJoinTime, bool isUpdateLastJoinTime)
            {
                Condition = Condition.Trim();

                string CommandText = "update [SchemeChat] set ";
                string UpdateFieldsList = "";

                if (isUpdateSchemeID)
                    UpdateFieldsList += "[SchemeID] = @SchemeID, ";
                if (isUpdateSiteID)
                    UpdateFieldsList += "[SiteID] = @SiteID, ";
                if (isUpdateUserID)
                    UpdateFieldsList += "[UserID] = @UserID, ";
                if (isUpdateTalking)
                    UpdateFieldsList += "[Talking] = @Talking, ";
                if (isUpdateLastJoinTime)
                    UpdateFieldsList += "[LastJoinTime] = @LastJoinTime, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateSchemeID ? null : new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    !isUpdateSiteID ? null : new MSSQL.Parameter("SiteID", SqlDbType.Int, 0, ParameterDirection.Input, SiteID),
                    !isUpdateUserID ? null : new MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID),
                    !isUpdateTalking ? null : new MSSQL.Parameter("Talking", SqlDbType.Bit, 0, ParameterDirection.Input, Talking),
                    !isUpdateLastJoinTime ? null : new MSSQL.Parameter("LastJoinTime", SqlDbType.DateTime, 0, ParameterDirection.Input, LastJoinTime)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [SchemeChat]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [SchemeChat]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class SchemeChatContent
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [SchemeChatContent]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string id, bool isInsertid, DateTime Time, bool isInsertTime, int SchemeID, bool isInsertSchemeID, int SiteID, bool isInsertSiteID, int FromUserID, bool isInsertFromUserID, int ToUserID, bool isInsertToUserID, string Type, bool isInsertType, byte[] Text, bool isInsertText, string Readed, bool isInsertReaded)
            {
                string CommandText = "insert into [SchemeChatContent] (";
                string InsertFieldsList = "";

                if (isInsertid)
                    InsertFieldsList += "[id], ";
                if (isInsertTime)
                    InsertFieldsList += "[Time], ";
                if (isInsertSchemeID)
                    InsertFieldsList += "[SchemeID], ";
                if (isInsertSiteID)
                    InsertFieldsList += "[SiteID], ";
                if (isInsertFromUserID)
                    InsertFieldsList += "[FromUserID], ";
                if (isInsertToUserID)
                    InsertFieldsList += "[ToUserID], ";
                if (isInsertType)
                    InsertFieldsList += "[Type], ";
                if (isInsertText)
                    InsertFieldsList += "[Text], ";
                if (isInsertReaded)
                    InsertFieldsList += "[Readed], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertid)
                    InsertValuesList += "@id, ";
                if (isInsertTime)
                    InsertValuesList += "@Time, ";
                if (isInsertSchemeID)
                    InsertValuesList += "@SchemeID, ";
                if (isInsertSiteID)
                    InsertValuesList += "@SiteID, ";
                if (isInsertFromUserID)
                    InsertValuesList += "@FromUserID, ";
                if (isInsertToUserID)
                    InsertValuesList += "@ToUserID, ";
                if (isInsertType)
                    InsertValuesList += "@Type, ";
                if (isInsertText)
                    InsertValuesList += "@Text, ";
                if (isInsertReaded)
                    InsertValuesList += "@Readed, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertid ? null : new MSSQL.Parameter("id", SqlDbType.UniqueIdentifier, 0, ParameterDirection.Input, id),
                    !isInsertTime ? null : new MSSQL.Parameter("Time", SqlDbType.DateTime, 0, ParameterDirection.Input, Time),
                    !isInsertSchemeID ? null : new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    !isInsertSiteID ? null : new MSSQL.Parameter("SiteID", SqlDbType.Int, 0, ParameterDirection.Input, SiteID),
                    !isInsertFromUserID ? null : new MSSQL.Parameter("FromUserID", SqlDbType.Int, 0, ParameterDirection.Input, FromUserID),
                    !isInsertToUserID ? null : new MSSQL.Parameter("ToUserID", SqlDbType.Int, 0, ParameterDirection.Input, ToUserID),
                    !isInsertType ? null : new MSSQL.Parameter("Type", SqlDbType.Char, 0, ParameterDirection.Input, Type),
                    !isInsertText ? null : new MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, Text),
                    !isInsertReaded ? null : new MSSQL.Parameter("Readed", SqlDbType.VarChar, 0, ParameterDirection.Input, Readed)
                    );
            }

            public static int Update(string Condition, string id, bool isUpdateid, DateTime Time, bool isUpdateTime, int SchemeID, bool isUpdateSchemeID, int SiteID, bool isUpdateSiteID, int FromUserID, bool isUpdateFromUserID, int ToUserID, bool isUpdateToUserID, string Type, bool isUpdateType, byte[] Text, bool isUpdateText, string Readed, bool isUpdateReaded)
            {
                Condition = Condition.Trim();

                string CommandText = "update [SchemeChatContent] set ";
                string UpdateFieldsList = "";

                if (isUpdateid)
                    UpdateFieldsList += "[id] = @id, ";
                if (isUpdateTime)
                    UpdateFieldsList += "[Time] = @Time, ";
                if (isUpdateSchemeID)
                    UpdateFieldsList += "[SchemeID] = @SchemeID, ";
                if (isUpdateSiteID)
                    UpdateFieldsList += "[SiteID] = @SiteID, ";
                if (isUpdateFromUserID)
                    UpdateFieldsList += "[FromUserID] = @FromUserID, ";
                if (isUpdateToUserID)
                    UpdateFieldsList += "[ToUserID] = @ToUserID, ";
                if (isUpdateType)
                    UpdateFieldsList += "[Type] = @Type, ";
                if (isUpdateText)
                    UpdateFieldsList += "[Text] = @Text, ";
                if (isUpdateReaded)
                    UpdateFieldsList += "[Readed] = @Readed, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateid ? null : new MSSQL.Parameter("id", SqlDbType.UniqueIdentifier, 0, ParameterDirection.Input, id),
                    !isUpdateTime ? null : new MSSQL.Parameter("Time", SqlDbType.DateTime, 0, ParameterDirection.Input, Time),
                    !isUpdateSchemeID ? null : new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    !isUpdateSiteID ? null : new MSSQL.Parameter("SiteID", SqlDbType.Int, 0, ParameterDirection.Input, SiteID),
                    !isUpdateFromUserID ? null : new MSSQL.Parameter("FromUserID", SqlDbType.Int, 0, ParameterDirection.Input, FromUserID),
                    !isUpdateToUserID ? null : new MSSQL.Parameter("ToUserID", SqlDbType.Int, 0, ParameterDirection.Input, ToUserID),
                    !isUpdateType ? null : new MSSQL.Parameter("Type", SqlDbType.Char, 0, ParameterDirection.Input, Type),
                    !isUpdateText ? null : new MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, Text),
                    !isUpdateReaded ? null : new MSSQL.Parameter("Readed", SqlDbType.VarChar, 0, ParameterDirection.Input, Readed)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [SchemeChatContent]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [SchemeChatContent]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class UserDistill
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [UserDistill]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int User_id, bool isInsertUser_id, DateTime DateTime, bool isInsertDateTime, double Money, bool isInsertMoney, int Result, bool isInsertResult, DateTime AcceptDateTime, bool isInsertAcceptDateTime, string Bank, bool isInsertBank, string CardNumber, bool isInsertCardNumber, string Memo, bool isInsertMemo, int AcceptOperator_id, bool isInsertAcceptOperator_id)
            {
                string CommandText = "insert into [UserDistill] (";
                string InsertFieldsList = "";

                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertMoney)
                    InsertFieldsList += "[Money], ";
                if (isInsertResult)
                    InsertFieldsList += "[Result], ";
                if (isInsertAcceptDateTime)
                    InsertFieldsList += "[AcceptDateTime], ";
                if (isInsertBank)
                    InsertFieldsList += "[Bank], ";
                if (isInsertCardNumber)
                    InsertFieldsList += "[CardNumber], ";
                if (isInsertMemo)
                    InsertFieldsList += "[Memo], ";
                if (isInsertAcceptOperator_id)
                    InsertFieldsList += "[AcceptOperator_id], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertMoney)
                    InsertValuesList += "@Money, ";
                if (isInsertResult)
                    InsertValuesList += "@Result, ";
                if (isInsertAcceptDateTime)
                    InsertValuesList += "@AcceptDateTime, ";
                if (isInsertBank)
                    InsertValuesList += "@Bank, ";
                if (isInsertCardNumber)
                    InsertValuesList += "@CardNumber, ";
                if (isInsertMemo)
                    InsertValuesList += "@Memo, ";
                if (isInsertAcceptOperator_id)
                    InsertValuesList += "@AcceptOperator_id, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertMoney ? null : new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    !isInsertResult ? null : new MSSQL.Parameter("Result", SqlDbType.Int, 0, ParameterDirection.Input, Result),
                    !isInsertAcceptDateTime ? null : new MSSQL.Parameter("AcceptDateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, AcceptDateTime),
                    !isInsertBank ? null : new MSSQL.Parameter("Bank", SqlDbType.VarChar, 0, ParameterDirection.Input, Bank),
                    !isInsertCardNumber ? null : new MSSQL.Parameter("CardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, CardNumber),
                    !isInsertMemo ? null : new MSSQL.Parameter("Memo", SqlDbType.VarChar, 0, ParameterDirection.Input, Memo),
                    !isInsertAcceptOperator_id ? null : new MSSQL.Parameter("AcceptOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, AcceptOperator_id)
                    );
            }

            public static int Update(string Condition, int User_id, bool isUpdateUser_id, DateTime DateTime, bool isUpdateDateTime, double Money, bool isUpdateMoney, int Result, bool isUpdateResult, DateTime AcceptDateTime, bool isUpdateAcceptDateTime, string Bank, bool isUpdateBank, string CardNumber, bool isUpdateCardNumber, string Memo, bool isUpdateMemo, int AcceptOperator_id, bool isUpdateAcceptOperator_id)
            {
                Condition = Condition.Trim();

                string CommandText = "update [UserDistill] set ";
                string UpdateFieldsList = "";

                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateMoney)
                    UpdateFieldsList += "[Money] = @Money, ";
                if (isUpdateResult)
                    UpdateFieldsList += "[Result] = @Result, ";
                if (isUpdateAcceptDateTime)
                    UpdateFieldsList += "[AcceptDateTime] = @AcceptDateTime, ";
                if (isUpdateBank)
                    UpdateFieldsList += "[Bank] = @Bank, ";
                if (isUpdateCardNumber)
                    UpdateFieldsList += "[CardNumber] = @CardNumber, ";
                if (isUpdateMemo)
                    UpdateFieldsList += "[Memo] = @Memo, ";
                if (isUpdateAcceptOperator_id)
                    UpdateFieldsList += "[AcceptOperator_id] = @AcceptOperator_id, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateMoney ? null : new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    !isUpdateResult ? null : new MSSQL.Parameter("Result", SqlDbType.Int, 0, ParameterDirection.Input, Result),
                    !isUpdateAcceptDateTime ? null : new MSSQL.Parameter("AcceptDateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, AcceptDateTime),
                    !isUpdateBank ? null : new MSSQL.Parameter("Bank", SqlDbType.VarChar, 0, ParameterDirection.Input, Bank),
                    !isUpdateCardNumber ? null : new MSSQL.Parameter("CardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, CardNumber),
                    !isUpdateMemo ? null : new MSSQL.Parameter("Memo", SqlDbType.VarChar, 0, ParameterDirection.Input, Memo),
                    !isUpdateAcceptOperator_id ? null : new MSSQL.Parameter("AcceptOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, AcceptOperator_id)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [UserDistill]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [UserDistill]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class Users
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [Users]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(string Name, bool isInsertName, string RealityName, bool isInsertRealityName, string Password, bool isInsertPassword, string Password_2, bool isInsertPassword_2, string Province, bool isInsertProvince, string City, bool isInsertCity, string Sex, bool isInsertSex, DateTime BirthDay, bool isInsertBirthDay, string IDCardNumber, bool isInsertIDCardNumber, string Address, bool isInsertAddress, string Email, bool isInsertEmail, string QQ, bool isInsertQQ, string Telphone, bool isInsertTelphone, string Mobile, bool isInsertMobile, bool MobileValid, bool isInsertMobileValid, bool Privacy, bool isInsertPrivacy, bool Blacklist, bool isInsertBlacklist, DateTime RegisterTime, bool isInsertRegisterTime, DateTime LastLoginTime, bool isInsertLastLoginTime, string LastLoginIP, bool isInsertLastLoginIP, int LoginNum, bool isInsertLoginNum, bool ManagementRights, bool isInsertManagementRights, string ManagementRightsList, bool isInsertManagementRightsList, bool SuperManagementRights, bool isInsertSuperManagementRights, string LotteryBuyRightsList, bool isInsertLotteryBuyRightsList, int UserType, bool isInsertUserType, double Balance, bool isInsertBalance, double FreezeMoney, bool isInsertFreezeMoney, int Scoring, bool isInsertScoring, string BankType, bool isInsertBankType, string BankName, bool isInsertBankName, string BankCardNumber, bool isInsertBankCardNumber, bool isAcceptMobileMessage, bool isInsertisAcceptMobileMessage, string AcceptMobileMessageList, bool isInsertAcceptMobileMessageList, bool isAcceptEmail, bool isInsertisAcceptEmail, bool isAcceptMessage, bool isInsertisAcceptMessage, int HigherUp_id, bool isInsertHigherUp_id, int Promotioner_id, bool isInsertPromotioner_id, bool isAlipayMember, bool isInsertisAlipayMember)
            {
                string CommandText = "insert into [Users] (";
                string InsertFieldsList = "";

                if (isInsertName)
                    InsertFieldsList += "[Name], ";
                if (isInsertRealityName)
                    InsertFieldsList += "[RealityName], ";
                if (isInsertPassword)
                    InsertFieldsList += "[Password], ";
                if (isInsertPassword_2)
                    InsertFieldsList += "[Password_2], ";
                if (isInsertProvince)
                    InsertFieldsList += "[Province], ";
                if (isInsertCity)
                    InsertFieldsList += "[City], ";
                if (isInsertSex)
                    InsertFieldsList += "[Sex], ";
                if (isInsertBirthDay)
                    InsertFieldsList += "[BirthDay], ";
                if (isInsertIDCardNumber)
                    InsertFieldsList += "[IDCardNumber], ";
                if (isInsertAddress)
                    InsertFieldsList += "[Address], ";
                if (isInsertEmail)
                    InsertFieldsList += "[Email], ";
                if (isInsertQQ)
                    InsertFieldsList += "[QQ], ";
                if (isInsertTelphone)
                    InsertFieldsList += "[Telphone], ";
                if (isInsertMobile)
                    InsertFieldsList += "[Mobile], ";
                if (isInsertMobileValid)
                    InsertFieldsList += "[MobileValid], ";
                if (isInsertPrivacy)
                    InsertFieldsList += "[Privacy], ";
                if (isInsertBlacklist)
                    InsertFieldsList += "[Blacklist], ";
                if (isInsertRegisterTime)
                    InsertFieldsList += "[RegisterTime], ";
                if (isInsertLastLoginTime)
                    InsertFieldsList += "[LastLoginTime], ";
                if (isInsertLastLoginIP)
                    InsertFieldsList += "[LastLoginIP], ";
                if (isInsertLoginNum)
                    InsertFieldsList += "[LoginNum], ";
                if (isInsertManagementRights)
                    InsertFieldsList += "[ManagementRights], ";
                if (isInsertManagementRightsList)
                    InsertFieldsList += "[ManagementRightsList], ";
                if (isInsertSuperManagementRights)
                    InsertFieldsList += "[SuperManagementRights], ";
                if (isInsertLotteryBuyRightsList)
                    InsertFieldsList += "[LotteryBuyRightsList], ";
                if (isInsertUserType)
                    InsertFieldsList += "[UserType], ";
                if (isInsertBalance)
                    InsertFieldsList += "[Balance], ";
                if (isInsertFreezeMoney)
                    InsertFieldsList += "[FreezeMoney], ";
                if (isInsertScoring)
                    InsertFieldsList += "[Scoring], ";
                if (isInsertBankType)
                    InsertFieldsList += "[BankType], ";
                if (isInsertBankName)
                    InsertFieldsList += "[BankName], ";
                if (isInsertBankCardNumber)
                    InsertFieldsList += "[BankCardNumber], ";
                if (isInsertisAcceptMobileMessage)
                    InsertFieldsList += "[isAcceptMobileMessage], ";
                if (isInsertAcceptMobileMessageList)
                    InsertFieldsList += "[AcceptMobileMessageList], ";
                if (isInsertisAcceptEmail)
                    InsertFieldsList += "[isAcceptEmail], ";
                if (isInsertisAcceptMessage)
                    InsertFieldsList += "[isAcceptMessage], ";
                if (isInsertHigherUp_id)
                    InsertFieldsList += "[HigherUp_id], ";
                if (isInsertPromotioner_id)
                    InsertFieldsList += "[Promotioner_id], ";
                if (isInsertisAlipayMember)
                    InsertFieldsList += "[isAlipayMember], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertName)
                    InsertValuesList += "@Name, ";
                if (isInsertRealityName)
                    InsertValuesList += "@RealityName, ";
                if (isInsertPassword)
                    InsertValuesList += "@Password, ";
                if (isInsertPassword_2)
                    InsertValuesList += "@Password_2, ";
                if (isInsertProvince)
                    InsertValuesList += "@Province, ";
                if (isInsertCity)
                    InsertValuesList += "@City, ";
                if (isInsertSex)
                    InsertValuesList += "@Sex, ";
                if (isInsertBirthDay)
                    InsertValuesList += "@BirthDay, ";
                if (isInsertIDCardNumber)
                    InsertValuesList += "@IDCardNumber, ";
                if (isInsertAddress)
                    InsertValuesList += "@Address, ";
                if (isInsertEmail)
                    InsertValuesList += "@Email, ";
                if (isInsertQQ)
                    InsertValuesList += "@QQ, ";
                if (isInsertTelphone)
                    InsertValuesList += "@Telphone, ";
                if (isInsertMobile)
                    InsertValuesList += "@Mobile, ";
                if (isInsertMobileValid)
                    InsertValuesList += "@MobileValid, ";
                if (isInsertPrivacy)
                    InsertValuesList += "@Privacy, ";
                if (isInsertBlacklist)
                    InsertValuesList += "@Blacklist, ";
                if (isInsertRegisterTime)
                    InsertValuesList += "@RegisterTime, ";
                if (isInsertLastLoginTime)
                    InsertValuesList += "@LastLoginTime, ";
                if (isInsertLastLoginIP)
                    InsertValuesList += "@LastLoginIP, ";
                if (isInsertLoginNum)
                    InsertValuesList += "@LoginNum, ";
                if (isInsertManagementRights)
                    InsertValuesList += "@ManagementRights, ";
                if (isInsertManagementRightsList)
                    InsertValuesList += "@ManagementRightsList, ";
                if (isInsertSuperManagementRights)
                    InsertValuesList += "@SuperManagementRights, ";
                if (isInsertLotteryBuyRightsList)
                    InsertValuesList += "@LotteryBuyRightsList, ";
                if (isInsertUserType)
                    InsertValuesList += "@UserType, ";
                if (isInsertBalance)
                    InsertValuesList += "@Balance, ";
                if (isInsertFreezeMoney)
                    InsertValuesList += "@FreezeMoney, ";
                if (isInsertScoring)
                    InsertValuesList += "@Scoring, ";
                if (isInsertBankType)
                    InsertValuesList += "@BankType, ";
                if (isInsertBankName)
                    InsertValuesList += "@BankName, ";
                if (isInsertBankCardNumber)
                    InsertValuesList += "@BankCardNumber, ";
                if (isInsertisAcceptMobileMessage)
                    InsertValuesList += "@isAcceptMobileMessage, ";
                if (isInsertAcceptMobileMessageList)
                    InsertValuesList += "@AcceptMobileMessageList, ";
                if (isInsertisAcceptEmail)
                    InsertValuesList += "@isAcceptEmail, ";
                if (isInsertisAcceptMessage)
                    InsertValuesList += "@isAcceptMessage, ";
                if (isInsertHigherUp_id)
                    InsertValuesList += "@HigherUp_id, ";
                if (isInsertPromotioner_id)
                    InsertValuesList += "@Promotioner_id, ";
                if (isInsertisAlipayMember)
                    InsertValuesList += "@isAlipayMember, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isInsertRealityName ? null : new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 0, ParameterDirection.Input, RealityName),
                    !isInsertPassword ? null : new MSSQL.Parameter("Password", SqlDbType.VarChar, 0, ParameterDirection.Input, Password),
                    !isInsertPassword_2 ? null : new MSSQL.Parameter("Password_2", SqlDbType.VarChar, 0, ParameterDirection.Input, Password_2),
                    !isInsertProvince ? null : new MSSQL.Parameter("Province", SqlDbType.VarChar, 0, ParameterDirection.Input, Province),
                    !isInsertCity ? null : new MSSQL.Parameter("City", SqlDbType.VarChar, 0, ParameterDirection.Input, City),
                    !isInsertSex ? null : new MSSQL.Parameter("Sex", SqlDbType.Char, 0, ParameterDirection.Input, Sex),
                    !isInsertBirthDay ? null : new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 0, ParameterDirection.Input, BirthDay),
                    !isInsertIDCardNumber ? null : new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, IDCardNumber),
                    !isInsertAddress ? null : new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    !isInsertEmail ? null : new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    !isInsertQQ ? null : new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    !isInsertTelphone ? null : new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    !isInsertMobile ? null : new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    !isInsertMobileValid ? null : new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 0, ParameterDirection.Input, MobileValid),
                    !isInsertPrivacy ? null : new MSSQL.Parameter("Privacy", SqlDbType.Bit, 0, ParameterDirection.Input, Privacy),
                    !isInsertBlacklist ? null : new MSSQL.Parameter("Blacklist", SqlDbType.Bit, 0, ParameterDirection.Input, Blacklist),
                    !isInsertRegisterTime ? null : new MSSQL.Parameter("RegisterTime", SqlDbType.DateTime, 0, ParameterDirection.Input, RegisterTime),
                    !isInsertLastLoginTime ? null : new MSSQL.Parameter("LastLoginTime", SqlDbType.DateTime, 0, ParameterDirection.Input, LastLoginTime),
                    !isInsertLastLoginIP ? null : new MSSQL.Parameter("LastLoginIP", SqlDbType.VarChar, 0, ParameterDirection.Input, LastLoginIP),
                    !isInsertLoginNum ? null : new MSSQL.Parameter("LoginNum", SqlDbType.Int, 0, ParameterDirection.Input, LoginNum),
                    !isInsertManagementRights ? null : new MSSQL.Parameter("ManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, ManagementRights),
                    !isInsertManagementRightsList ? null : new MSSQL.Parameter("ManagementRightsList", SqlDbType.VarChar, 0, ParameterDirection.Input, ManagementRightsList),
                    !isInsertSuperManagementRights ? null : new MSSQL.Parameter("SuperManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, SuperManagementRights),
                    !isInsertLotteryBuyRightsList ? null : new MSSQL.Parameter("LotteryBuyRightsList", SqlDbType.VarChar, 0, ParameterDirection.Input, LotteryBuyRightsList),
                    !isInsertUserType ? null : new MSSQL.Parameter("UserType", SqlDbType.Int, 0, ParameterDirection.Input, UserType),
                    !isInsertBalance ? null : new MSSQL.Parameter("Balance", SqlDbType.Money, 0, ParameterDirection.Input, Balance),
                    !isInsertFreezeMoney ? null : new MSSQL.Parameter("FreezeMoney", SqlDbType.Money, 0, ParameterDirection.Input, FreezeMoney),
                    !isInsertScoring ? null : new MSSQL.Parameter("Scoring", SqlDbType.Int, 0, ParameterDirection.Input, Scoring),
                    !isInsertBankType ? null : new MSSQL.Parameter("BankType", SqlDbType.VarChar, 0, ParameterDirection.Input, BankType),
                    !isInsertBankName ? null : new MSSQL.Parameter("BankName", SqlDbType.VarChar, 0, ParameterDirection.Input, BankName),
                    !isInsertBankCardNumber ? null : new MSSQL.Parameter("BankCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, BankCardNumber),
                    !isInsertisAcceptMobileMessage ? null : new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMobileMessage),
                    !isInsertAcceptMobileMessageList ? null : new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 0, ParameterDirection.Input, AcceptMobileMessageList),
                    !isInsertisAcceptEmail ? null : new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptEmail),
                    !isInsertisAcceptMessage ? null : new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMessage),
                    !isInsertHigherUp_id ? null : new MSSQL.Parameter("HigherUp_id", SqlDbType.Int, 0, ParameterDirection.Input, HigherUp_id),
                    !isInsertPromotioner_id ? null : new MSSQL.Parameter("Promotioner_id", SqlDbType.Int, 0, ParameterDirection.Input, Promotioner_id),
                    !isInsertisAlipayMember ? null : new MSSQL.Parameter("isAlipayMember", SqlDbType.Bit, 0, ParameterDirection.Input, isAlipayMember)
                    );
            }

            public static int Update(string Condition, string Name, bool isUpdateName, string RealityName, bool isUpdateRealityName, string Password, bool isUpdatePassword, string Password_2, bool isUpdatePassword_2, string Province, bool isUpdateProvince, string City, bool isUpdateCity, string Sex, bool isUpdateSex, DateTime BirthDay, bool isUpdateBirthDay, string IDCardNumber, bool isUpdateIDCardNumber, string Address, bool isUpdateAddress, string Email, bool isUpdateEmail, string QQ, bool isUpdateQQ, string Telphone, bool isUpdateTelphone, string Mobile, bool isUpdateMobile, bool MobileValid, bool isUpdateMobileValid, bool Privacy, bool isUpdatePrivacy, bool Blacklist, bool isUpdateBlacklist, DateTime RegisterTime, bool isUpdateRegisterTime, DateTime LastLoginTime, bool isUpdateLastLoginTime, string LastLoginIP, bool isUpdateLastLoginIP, int LoginNum, bool isUpdateLoginNum, bool ManagementRights, bool isUpdateManagementRights, string ManagementRightsList, bool isUpdateManagementRightsList, bool SuperManagementRights, bool isUpdateSuperManagementRights, string LotteryBuyRightsList, bool isUpdateLotteryBuyRightsList, int UserType, bool isUpdateUserType, double Balance, bool isUpdateBalance, double FreezeMoney, bool isUpdateFreezeMoney, int Scoring, bool isUpdateScoring, string BankType, bool isUpdateBankType, string BankName, bool isUpdateBankName, string BankCardNumber, bool isUpdateBankCardNumber, bool isAcceptMobileMessage, bool isUpdateisAcceptMobileMessage, string AcceptMobileMessageList, bool isUpdateAcceptMobileMessageList, bool isAcceptEmail, bool isUpdateisAcceptEmail, bool isAcceptMessage, bool isUpdateisAcceptMessage, int HigherUp_id, bool isUpdateHigherUp_id, int Promotioner_id, bool isUpdatePromotioner_id, bool isAlipayMember, bool isUpdateisAlipayMember)
            {
                Condition = Condition.Trim();

                string CommandText = "update [Users] set ";
                string UpdateFieldsList = "";

                if (isUpdateName)
                    UpdateFieldsList += "[Name] = @Name, ";
                if (isUpdateRealityName)
                    UpdateFieldsList += "[RealityName] = @RealityName, ";
                if (isUpdatePassword)
                    UpdateFieldsList += "[Password] = @Password, ";
                if (isUpdatePassword_2)
                    UpdateFieldsList += "[Password_2] = @Password_2, ";
                if (isUpdateProvince)
                    UpdateFieldsList += "[Province] = @Province, ";
                if (isUpdateCity)
                    UpdateFieldsList += "[City] = @City, ";
                if (isUpdateSex)
                    UpdateFieldsList += "[Sex] = @Sex, ";
                if (isUpdateBirthDay)
                    UpdateFieldsList += "[BirthDay] = @BirthDay, ";
                if (isUpdateIDCardNumber)
                    UpdateFieldsList += "[IDCardNumber] = @IDCardNumber, ";
                if (isUpdateAddress)
                    UpdateFieldsList += "[Address] = @Address, ";
                if (isUpdateEmail)
                    UpdateFieldsList += "[Email] = @Email, ";
                if (isUpdateQQ)
                    UpdateFieldsList += "[QQ] = @QQ, ";
                if (isUpdateTelphone)
                    UpdateFieldsList += "[Telphone] = @Telphone, ";
                if (isUpdateMobile)
                    UpdateFieldsList += "[Mobile] = @Mobile, ";
                if (isUpdateMobileValid)
                    UpdateFieldsList += "[MobileValid] = @MobileValid, ";
                if (isUpdatePrivacy)
                    UpdateFieldsList += "[Privacy] = @Privacy, ";
                if (isUpdateBlacklist)
                    UpdateFieldsList += "[Blacklist] = @Blacklist, ";
                if (isUpdateRegisterTime)
                    UpdateFieldsList += "[RegisterTime] = @RegisterTime, ";
                if (isUpdateLastLoginTime)
                    UpdateFieldsList += "[LastLoginTime] = @LastLoginTime, ";
                if (isUpdateLastLoginIP)
                    UpdateFieldsList += "[LastLoginIP] = @LastLoginIP, ";
                if (isUpdateLoginNum)
                    UpdateFieldsList += "[LoginNum] = @LoginNum, ";
                if (isUpdateManagementRights)
                    UpdateFieldsList += "[ManagementRights] = @ManagementRights, ";
                if (isUpdateManagementRightsList)
                    UpdateFieldsList += "[ManagementRightsList] = @ManagementRightsList, ";
                if (isUpdateSuperManagementRights)
                    UpdateFieldsList += "[SuperManagementRights] = @SuperManagementRights, ";
                if (isUpdateLotteryBuyRightsList)
                    UpdateFieldsList += "[LotteryBuyRightsList] = @LotteryBuyRightsList, ";
                if (isUpdateUserType)
                    UpdateFieldsList += "[UserType] = @UserType, ";
                if (isUpdateBalance)
                    UpdateFieldsList += "[Balance] = @Balance, ";
                if (isUpdateFreezeMoney)
                    UpdateFieldsList += "[FreezeMoney] = @FreezeMoney, ";
                if (isUpdateScoring)
                    UpdateFieldsList += "[Scoring] = @Scoring, ";
                if (isUpdateBankType)
                    UpdateFieldsList += "[BankType] = @BankType, ";
                if (isUpdateBankName)
                    UpdateFieldsList += "[BankName] = @BankName, ";
                if (isUpdateBankCardNumber)
                    UpdateFieldsList += "[BankCardNumber] = @BankCardNumber, ";
                if (isUpdateisAcceptMobileMessage)
                    UpdateFieldsList += "[isAcceptMobileMessage] = @isAcceptMobileMessage, ";
                if (isUpdateAcceptMobileMessageList)
                    UpdateFieldsList += "[AcceptMobileMessageList] = @AcceptMobileMessageList, ";
                if (isUpdateisAcceptEmail)
                    UpdateFieldsList += "[isAcceptEmail] = @isAcceptEmail, ";
                if (isUpdateisAcceptMessage)
                    UpdateFieldsList += "[isAcceptMessage] = @isAcceptMessage, ";
                if (isUpdateHigherUp_id)
                    UpdateFieldsList += "[HigherUp_id] = @HigherUp_id, ";
                if (isUpdatePromotioner_id)
                    UpdateFieldsList += "[Promotioner_id] = @Promotioner_id, ";
                if (isUpdateisAlipayMember)
                    UpdateFieldsList += "[isAlipayMember] = @isAlipayMember, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateName ? null : new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    !isUpdateRealityName ? null : new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 0, ParameterDirection.Input, RealityName),
                    !isUpdatePassword ? null : new MSSQL.Parameter("Password", SqlDbType.VarChar, 0, ParameterDirection.Input, Password),
                    !isUpdatePassword_2 ? null : new MSSQL.Parameter("Password_2", SqlDbType.VarChar, 0, ParameterDirection.Input, Password_2),
                    !isUpdateProvince ? null : new MSSQL.Parameter("Province", SqlDbType.VarChar, 0, ParameterDirection.Input, Province),
                    !isUpdateCity ? null : new MSSQL.Parameter("City", SqlDbType.VarChar, 0, ParameterDirection.Input, City),
                    !isUpdateSex ? null : new MSSQL.Parameter("Sex", SqlDbType.Char, 0, ParameterDirection.Input, Sex),
                    !isUpdateBirthDay ? null : new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 0, ParameterDirection.Input, BirthDay),
                    !isUpdateIDCardNumber ? null : new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, IDCardNumber),
                    !isUpdateAddress ? null : new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    !isUpdateEmail ? null : new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    !isUpdateQQ ? null : new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    !isUpdateTelphone ? null : new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    !isUpdateMobile ? null : new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    !isUpdateMobileValid ? null : new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 0, ParameterDirection.Input, MobileValid),
                    !isUpdatePrivacy ? null : new MSSQL.Parameter("Privacy", SqlDbType.Bit, 0, ParameterDirection.Input, Privacy),
                    !isUpdateBlacklist ? null : new MSSQL.Parameter("Blacklist", SqlDbType.Bit, 0, ParameterDirection.Input, Blacklist),
                    !isUpdateRegisterTime ? null : new MSSQL.Parameter("RegisterTime", SqlDbType.DateTime, 0, ParameterDirection.Input, RegisterTime),
                    !isUpdateLastLoginTime ? null : new MSSQL.Parameter("LastLoginTime", SqlDbType.DateTime, 0, ParameterDirection.Input, LastLoginTime),
                    !isUpdateLastLoginIP ? null : new MSSQL.Parameter("LastLoginIP", SqlDbType.VarChar, 0, ParameterDirection.Input, LastLoginIP),
                    !isUpdateLoginNum ? null : new MSSQL.Parameter("LoginNum", SqlDbType.Int, 0, ParameterDirection.Input, LoginNum),
                    !isUpdateManagementRights ? null : new MSSQL.Parameter("ManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, ManagementRights),
                    !isUpdateManagementRightsList ? null : new MSSQL.Parameter("ManagementRightsList", SqlDbType.VarChar, 0, ParameterDirection.Input, ManagementRightsList),
                    !isUpdateSuperManagementRights ? null : new MSSQL.Parameter("SuperManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, SuperManagementRights),
                    !isUpdateLotteryBuyRightsList ? null : new MSSQL.Parameter("LotteryBuyRightsList", SqlDbType.VarChar, 0, ParameterDirection.Input, LotteryBuyRightsList),
                    !isUpdateUserType ? null : new MSSQL.Parameter("UserType", SqlDbType.Int, 0, ParameterDirection.Input, UserType),
                    !isUpdateBalance ? null : new MSSQL.Parameter("Balance", SqlDbType.Money, 0, ParameterDirection.Input, Balance),
                    !isUpdateFreezeMoney ? null : new MSSQL.Parameter("FreezeMoney", SqlDbType.Money, 0, ParameterDirection.Input, FreezeMoney),
                    !isUpdateScoring ? null : new MSSQL.Parameter("Scoring", SqlDbType.Int, 0, ParameterDirection.Input, Scoring),
                    !isUpdateBankType ? null : new MSSQL.Parameter("BankType", SqlDbType.VarChar, 0, ParameterDirection.Input, BankType),
                    !isUpdateBankName ? null : new MSSQL.Parameter("BankName", SqlDbType.VarChar, 0, ParameterDirection.Input, BankName),
                    !isUpdateBankCardNumber ? null : new MSSQL.Parameter("BankCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, BankCardNumber),
                    !isUpdateisAcceptMobileMessage ? null : new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMobileMessage),
                    !isUpdateAcceptMobileMessageList ? null : new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 0, ParameterDirection.Input, AcceptMobileMessageList),
                    !isUpdateisAcceptEmail ? null : new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptEmail),
                    !isUpdateisAcceptMessage ? null : new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMessage),
                    !isUpdateHigherUp_id ? null : new MSSQL.Parameter("HigherUp_id", SqlDbType.Int, 0, ParameterDirection.Input, HigherUp_id),
                    !isUpdatePromotioner_id ? null : new MSSQL.Parameter("Promotioner_id", SqlDbType.Int, 0, ParameterDirection.Input, Promotioner_id),
                    !isUpdateisAlipayMember ? null : new MSSQL.Parameter("isAlipayMember", SqlDbType.Bit, 0, ParameterDirection.Input, isAlipayMember)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [Users]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [Users]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class UsersDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [UsersDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int User_id, bool isInsertUser_id, DateTime DateTime, bool isInsertDateTime, int OperatorType, bool isInsertOperatorType, double Money, bool isInsertMoney, double Commission, bool isInsertCommission, int Scheme_id, bool isInsertScheme_id, string PayNumber, bool isInsertPayNumber, string PayBank, bool isInsertPayBank, string PayRemark1, bool isInsertPayRemark1, string PayRemark2, bool isInsertPayRemark2, string Memo, bool isInsertMemo, int PayOperator_id, bool isInsertPayOperator_id)
            {
                string CommandText = "insert into [UsersDetail] (";
                string InsertFieldsList = "";

                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertOperatorType)
                    InsertFieldsList += "[OperatorType], ";
                if (isInsertMoney)
                    InsertFieldsList += "[Money], ";
                if (isInsertCommission)
                    InsertFieldsList += "[Commission], ";
                if (isInsertScheme_id)
                    InsertFieldsList += "[Scheme_id], ";
                if (isInsertPayNumber)
                    InsertFieldsList += "[PayNumber], ";
                if (isInsertPayBank)
                    InsertFieldsList += "[PayBank], ";
                if (isInsertPayRemark1)
                    InsertFieldsList += "[PayRemark1], ";
                if (isInsertPayRemark2)
                    InsertFieldsList += "[PayRemark2], ";
                if (isInsertMemo)
                    InsertFieldsList += "[Memo], ";
                if (isInsertPayOperator_id)
                    InsertFieldsList += "[PayOperator_id], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertOperatorType)
                    InsertValuesList += "@OperatorType, ";
                if (isInsertMoney)
                    InsertValuesList += "@Money, ";
                if (isInsertCommission)
                    InsertValuesList += "@Commission, ";
                if (isInsertScheme_id)
                    InsertValuesList += "@Scheme_id, ";
                if (isInsertPayNumber)
                    InsertValuesList += "@PayNumber, ";
                if (isInsertPayBank)
                    InsertValuesList += "@PayBank, ";
                if (isInsertPayRemark1)
                    InsertValuesList += "@PayRemark1, ";
                if (isInsertPayRemark2)
                    InsertValuesList += "@PayRemark2, ";
                if (isInsertMemo)
                    InsertValuesList += "@Memo, ";
                if (isInsertPayOperator_id)
                    InsertValuesList += "@PayOperator_id, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertOperatorType ? null : new MSSQL.Parameter("OperatorType", SqlDbType.Int, 0, ParameterDirection.Input, OperatorType),
                    !isInsertMoney ? null : new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    !isInsertCommission ? null : new MSSQL.Parameter("Commission", SqlDbType.Money, 0, ParameterDirection.Input, Commission),
                    !isInsertScheme_id ? null : new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    !isInsertPayNumber ? null : new MSSQL.Parameter("PayNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, PayNumber),
                    !isInsertPayBank ? null : new MSSQL.Parameter("PayBank", SqlDbType.VarChar, 0, ParameterDirection.Input, PayBank),
                    !isInsertPayRemark1 ? null : new MSSQL.Parameter("PayRemark1", SqlDbType.VarChar, 0, ParameterDirection.Input, PayRemark1),
                    !isInsertPayRemark2 ? null : new MSSQL.Parameter("PayRemark2", SqlDbType.VarChar, 0, ParameterDirection.Input, PayRemark2),
                    !isInsertMemo ? null : new MSSQL.Parameter("Memo", SqlDbType.VarChar, 0, ParameterDirection.Input, Memo),
                    !isInsertPayOperator_id ? null : new MSSQL.Parameter("PayOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, PayOperator_id)
                    );
            }

            public static int Update(string Condition, int User_id, bool isUpdateUser_id, DateTime DateTime, bool isUpdateDateTime, int OperatorType, bool isUpdateOperatorType, double Money, bool isUpdateMoney, double Commission, bool isUpdateCommission, int Scheme_id, bool isUpdateScheme_id, string PayNumber, bool isUpdatePayNumber, string PayBank, bool isUpdatePayBank, string PayRemark1, bool isUpdatePayRemark1, string PayRemark2, bool isUpdatePayRemark2, string Memo, bool isUpdateMemo, int PayOperator_id, bool isUpdatePayOperator_id)
            {
                Condition = Condition.Trim();

                string CommandText = "update [UsersDetail] set ";
                string UpdateFieldsList = "";

                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateOperatorType)
                    UpdateFieldsList += "[OperatorType] = @OperatorType, ";
                if (isUpdateMoney)
                    UpdateFieldsList += "[Money] = @Money, ";
                if (isUpdateCommission)
                    UpdateFieldsList += "[Commission] = @Commission, ";
                if (isUpdateScheme_id)
                    UpdateFieldsList += "[Scheme_id] = @Scheme_id, ";
                if (isUpdatePayNumber)
                    UpdateFieldsList += "[PayNumber] = @PayNumber, ";
                if (isUpdatePayBank)
                    UpdateFieldsList += "[PayBank] = @PayBank, ";
                if (isUpdatePayRemark1)
                    UpdateFieldsList += "[PayRemark1] = @PayRemark1, ";
                if (isUpdatePayRemark2)
                    UpdateFieldsList += "[PayRemark2] = @PayRemark2, ";
                if (isUpdateMemo)
                    UpdateFieldsList += "[Memo] = @Memo, ";
                if (isUpdatePayOperator_id)
                    UpdateFieldsList += "[PayOperator_id] = @PayOperator_id, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateOperatorType ? null : new MSSQL.Parameter("OperatorType", SqlDbType.Int, 0, ParameterDirection.Input, OperatorType),
                    !isUpdateMoney ? null : new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    !isUpdateCommission ? null : new MSSQL.Parameter("Commission", SqlDbType.Money, 0, ParameterDirection.Input, Commission),
                    !isUpdateScheme_id ? null : new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    !isUpdatePayNumber ? null : new MSSQL.Parameter("PayNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, PayNumber),
                    !isUpdatePayBank ? null : new MSSQL.Parameter("PayBank", SqlDbType.VarChar, 0, ParameterDirection.Input, PayBank),
                    !isUpdatePayRemark1 ? null : new MSSQL.Parameter("PayRemark1", SqlDbType.VarChar, 0, ParameterDirection.Input, PayRemark1),
                    !isUpdatePayRemark2 ? null : new MSSQL.Parameter("PayRemark2", SqlDbType.VarChar, 0, ParameterDirection.Input, PayRemark2),
                    !isUpdateMemo ? null : new MSSQL.Parameter("Memo", SqlDbType.VarChar, 0, ParameterDirection.Input, Memo),
                    !isUpdatePayOperator_id ? null : new MSSQL.Parameter("PayOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, PayOperator_id)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [UsersDetail]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [UsersDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class UsersPayDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [UsersPayDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int User_id, bool isInsertUser_id, DateTime DateTime, bool isInsertDateTime, string PayType, bool isInsertPayType, double Money, bool isInsertMoney, int Result, bool isInsertResult)
            {
                string CommandText = "insert into [UsersPayDetail] (";
                string InsertFieldsList = "";

                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertPayType)
                    InsertFieldsList += "[PayType], ";
                if (isInsertMoney)
                    InsertFieldsList += "[Money], ";
                if (isInsertResult)
                    InsertFieldsList += "[Result], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertPayType)
                    InsertValuesList += "@PayType, ";
                if (isInsertMoney)
                    InsertValuesList += "@Money, ";
                if (isInsertResult)
                    InsertValuesList += "@Result, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertPayType ? null : new MSSQL.Parameter("PayType", SqlDbType.VarChar, 0, ParameterDirection.Input, PayType),
                    !isInsertMoney ? null : new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    !isInsertResult ? null : new MSSQL.Parameter("Result", SqlDbType.Int, 0, ParameterDirection.Input, Result)
                    );
            }

            public static int Update(string Condition, int User_id, bool isUpdateUser_id, DateTime DateTime, bool isUpdateDateTime, string PayType, bool isUpdatePayType, double Money, bool isUpdateMoney, int Result, bool isUpdateResult)
            {
                Condition = Condition.Trim();

                string CommandText = "update [UsersPayDetail] set ";
                string UpdateFieldsList = "";

                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdatePayType)
                    UpdateFieldsList += "[PayType] = @PayType, ";
                if (isUpdateMoney)
                    UpdateFieldsList += "[Money] = @Money, ";
                if (isUpdateResult)
                    UpdateFieldsList += "[Result] = @Result, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdatePayType ? null : new MSSQL.Parameter("PayType", SqlDbType.VarChar, 0, ParameterDirection.Input, PayType),
                    !isUpdateMoney ? null : new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    !isUpdateResult ? null : new MSSQL.Parameter("Result", SqlDbType.Int, 0, ParameterDirection.Input, Result)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [UsersPayDetail]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [UsersPayDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class UsersPayOutDetail_99Bill
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [UsersPayOutDetail_99Bill]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int Distill_id, bool isInsertDistill_id, double DealCharge, bool isInsertDealCharge, double DebitCharge, bool isInsertDebitCharge, double CreditCharge, bool isInsertCreditCharge, string DealID, bool isInsertDealID, bool ResultFlag, bool isInsertResultFlag, string FailureCause, bool isInsertFailureCause)
            {
                string CommandText = "insert into [UsersPayOutDetail_99Bill] (";
                string InsertFieldsList = "";

                if (isInsertDistill_id)
                    InsertFieldsList += "[Distill_id], ";
                if (isInsertDealCharge)
                    InsertFieldsList += "[DealCharge], ";
                if (isInsertDebitCharge)
                    InsertFieldsList += "[DebitCharge], ";
                if (isInsertCreditCharge)
                    InsertFieldsList += "[CreditCharge], ";
                if (isInsertDealID)
                    InsertFieldsList += "[DealID], ";
                if (isInsertResultFlag)
                    InsertFieldsList += "[ResultFlag], ";
                if (isInsertFailureCause)
                    InsertFieldsList += "[FailureCause], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertDistill_id)
                    InsertValuesList += "@Distill_id, ";
                if (isInsertDealCharge)
                    InsertValuesList += "@DealCharge, ";
                if (isInsertDebitCharge)
                    InsertValuesList += "@DebitCharge, ";
                if (isInsertCreditCharge)
                    InsertValuesList += "@CreditCharge, ";
                if (isInsertDealID)
                    InsertValuesList += "@DealID, ";
                if (isInsertResultFlag)
                    InsertValuesList += "@ResultFlag, ";
                if (isInsertFailureCause)
                    InsertValuesList += "@FailureCause, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertDistill_id ? null : new MSSQL.Parameter("Distill_id", SqlDbType.Int, 0, ParameterDirection.Input, Distill_id),
                    !isInsertDealCharge ? null : new MSSQL.Parameter("DealCharge", SqlDbType.Money, 0, ParameterDirection.Input, DealCharge),
                    !isInsertDebitCharge ? null : new MSSQL.Parameter("DebitCharge", SqlDbType.Money, 0, ParameterDirection.Input, DebitCharge),
                    !isInsertCreditCharge ? null : new MSSQL.Parameter("CreditCharge", SqlDbType.Money, 0, ParameterDirection.Input, CreditCharge),
                    !isInsertDealID ? null : new MSSQL.Parameter("DealID", SqlDbType.VarChar, 0, ParameterDirection.Input, DealID),
                    !isInsertResultFlag ? null : new MSSQL.Parameter("ResultFlag", SqlDbType.Bit, 0, ParameterDirection.Input, ResultFlag),
                    !isInsertFailureCause ? null : new MSSQL.Parameter("FailureCause", SqlDbType.VarChar, 0, ParameterDirection.Input, FailureCause)
                    );
            }

            public static int Update(string Condition, int Distill_id, bool isUpdateDistill_id, double DealCharge, bool isUpdateDealCharge, double DebitCharge, bool isUpdateDebitCharge, double CreditCharge, bool isUpdateCreditCharge, string DealID, bool isUpdateDealID, bool ResultFlag, bool isUpdateResultFlag, string FailureCause, bool isUpdateFailureCause)
            {
                Condition = Condition.Trim();

                string CommandText = "update [UsersPayOutDetail_99Bill] set ";
                string UpdateFieldsList = "";

                if (isUpdateDistill_id)
                    UpdateFieldsList += "[Distill_id] = @Distill_id, ";
                if (isUpdateDealCharge)
                    UpdateFieldsList += "[DealCharge] = @DealCharge, ";
                if (isUpdateDebitCharge)
                    UpdateFieldsList += "[DebitCharge] = @DebitCharge, ";
                if (isUpdateCreditCharge)
                    UpdateFieldsList += "[CreditCharge] = @CreditCharge, ";
                if (isUpdateDealID)
                    UpdateFieldsList += "[DealID] = @DealID, ";
                if (isUpdateResultFlag)
                    UpdateFieldsList += "[ResultFlag] = @ResultFlag, ";
                if (isUpdateFailureCause)
                    UpdateFieldsList += "[FailureCause] = @FailureCause, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateDistill_id ? null : new MSSQL.Parameter("Distill_id", SqlDbType.Int, 0, ParameterDirection.Input, Distill_id),
                    !isUpdateDealCharge ? null : new MSSQL.Parameter("DealCharge", SqlDbType.Money, 0, ParameterDirection.Input, DealCharge),
                    !isUpdateDebitCharge ? null : new MSSQL.Parameter("DebitCharge", SqlDbType.Money, 0, ParameterDirection.Input, DebitCharge),
                    !isUpdateCreditCharge ? null : new MSSQL.Parameter("CreditCharge", SqlDbType.Money, 0, ParameterDirection.Input, CreditCharge),
                    !isUpdateDealID ? null : new MSSQL.Parameter("DealID", SqlDbType.VarChar, 0, ParameterDirection.Input, DealID),
                    !isUpdateResultFlag ? null : new MSSQL.Parameter("ResultFlag", SqlDbType.Bit, 0, ParameterDirection.Input, ResultFlag),
                    !isUpdateFailureCause ? null : new MSSQL.Parameter("FailureCause", SqlDbType.VarChar, 0, ParameterDirection.Input, FailureCause)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [UsersPayOutDetail_99Bill]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [UsersPayOutDetail_99Bill]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class UsersScoringDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [UsersScoringDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(int User_id, bool isInsertUser_id, DateTime DateTime, bool isInsertDateTime, int OperatorType, bool isInsertOperatorType, int Scoring, bool isInsertScoring, int Scheme_id, bool isInsertScheme_id, int SubordinateUser_id, bool isInsertSubordinateUser_id, string Memo, bool isInsertMemo)
            {
                string CommandText = "insert into [UsersScoringDetail] (";
                string InsertFieldsList = "";

                if (isInsertUser_id)
                    InsertFieldsList += "[User_id], ";
                if (isInsertDateTime)
                    InsertFieldsList += "[DateTime], ";
                if (isInsertOperatorType)
                    InsertFieldsList += "[OperatorType], ";
                if (isInsertScoring)
                    InsertFieldsList += "[Scoring], ";
                if (isInsertScheme_id)
                    InsertFieldsList += "[Scheme_id], ";
                if (isInsertSubordinateUser_id)
                    InsertFieldsList += "[SubordinateUser_id], ";
                if (isInsertMemo)
                    InsertFieldsList += "[Memo], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertUser_id)
                    InsertValuesList += "@User_id, ";
                if (isInsertDateTime)
                    InsertValuesList += "@DateTime, ";
                if (isInsertOperatorType)
                    InsertValuesList += "@OperatorType, ";
                if (isInsertScoring)
                    InsertValuesList += "@Scoring, ";
                if (isInsertScheme_id)
                    InsertValuesList += "@Scheme_id, ";
                if (isInsertSubordinateUser_id)
                    InsertValuesList += "@SubordinateUser_id, ";
                if (isInsertMemo)
                    InsertValuesList += "@Memo, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isInsertDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isInsertOperatorType ? null : new MSSQL.Parameter("OperatorType", SqlDbType.Int, 0, ParameterDirection.Input, OperatorType),
                    !isInsertScoring ? null : new MSSQL.Parameter("Scoring", SqlDbType.Int, 0, ParameterDirection.Input, Scoring),
                    !isInsertScheme_id ? null : new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    !isInsertSubordinateUser_id ? null : new MSSQL.Parameter("SubordinateUser_id", SqlDbType.Int, 0, ParameterDirection.Input, SubordinateUser_id),
                    !isInsertMemo ? null : new MSSQL.Parameter("Memo", SqlDbType.VarChar, 0, ParameterDirection.Input, Memo)
                    );
            }

            public static int Update(string Condition, int User_id, bool isUpdateUser_id, DateTime DateTime, bool isUpdateDateTime, int OperatorType, bool isUpdateOperatorType, int Scoring, bool isUpdateScoring, int Scheme_id, bool isUpdateScheme_id, int SubordinateUser_id, bool isUpdateSubordinateUser_id, string Memo, bool isUpdateMemo)
            {
                Condition = Condition.Trim();

                string CommandText = "update [UsersScoringDetail] set ";
                string UpdateFieldsList = "";

                if (isUpdateUser_id)
                    UpdateFieldsList += "[User_id] = @User_id, ";
                if (isUpdateDateTime)
                    UpdateFieldsList += "[DateTime] = @DateTime, ";
                if (isUpdateOperatorType)
                    UpdateFieldsList += "[OperatorType] = @OperatorType, ";
                if (isUpdateScoring)
                    UpdateFieldsList += "[Scoring] = @Scoring, ";
                if (isUpdateScheme_id)
                    UpdateFieldsList += "[Scheme_id] = @Scheme_id, ";
                if (isUpdateSubordinateUser_id)
                    UpdateFieldsList += "[SubordinateUser_id] = @SubordinateUser_id, ";
                if (isUpdateMemo)
                    UpdateFieldsList += "[Memo] = @Memo, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateUser_id ? null : new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    !isUpdateDateTime ? null : new MSSQL.Parameter("DateTime", SqlDbType.DateTime, 0, ParameterDirection.Input, DateTime),
                    !isUpdateOperatorType ? null : new MSSQL.Parameter("OperatorType", SqlDbType.Int, 0, ParameterDirection.Input, OperatorType),
                    !isUpdateScoring ? null : new MSSQL.Parameter("Scoring", SqlDbType.Int, 0, ParameterDirection.Input, Scoring),
                    !isUpdateScheme_id ? null : new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    !isUpdateSubordinateUser_id ? null : new MSSQL.Parameter("SubordinateUser_id", SqlDbType.Int, 0, ParameterDirection.Input, SubordinateUser_id),
                    !isUpdateMemo ? null : new MSSQL.Parameter("Memo", SqlDbType.VarChar, 0, ParameterDirection.Input, Memo)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [UsersScoringDetail]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [UsersScoringDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class WaitSendEmail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [WaitSendEmail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int Insert(byte[] MailTo, bool isInsertMailTo, byte[] Subject, bool isInsertSubject, byte[] Body, bool isInsertBody, bool isSended, bool isInsertisSended, int Result, bool isInsertResult)
            {
                string CommandText = "insert into [WaitSendEmail] (";
                string InsertFieldsList = "";

                if (isInsertMailTo)
                    InsertFieldsList += "[MailTo], ";
                if (isInsertSubject)
                    InsertFieldsList += "[Subject], ";
                if (isInsertBody)
                    InsertFieldsList += "[Body], ";
                if (isInsertisSended)
                    InsertFieldsList += "[isSended], ";
                if (isInsertResult)
                    InsertFieldsList += "[Result], ";

                if (InsertFieldsList == "")
                    return -101;

                CommandText += InsertFieldsList.Substring(0, InsertFieldsList.Length - 2) + ") values (";
                string InsertValuesList = "";

                if (isInsertMailTo)
                    InsertValuesList += "@MailTo, ";
                if (isInsertSubject)
                    InsertValuesList += "@Subject, ";
                if (isInsertBody)
                    InsertValuesList += "@Body, ";
                if (isInsertisSended)
                    InsertValuesList += "@isSended, ";
                if (isInsertResult)
                    InsertValuesList += "@Result, ";

                CommandText += InsertValuesList.Substring(0, InsertValuesList.Length - 2) + ")";

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isInsertMailTo ? null : new MSSQL.Parameter("MailTo", SqlDbType.Image, 0, ParameterDirection.Input, MailTo),
                    !isInsertSubject ? null : new MSSQL.Parameter("Subject", SqlDbType.Image, 0, ParameterDirection.Input, Subject),
                    !isInsertBody ? null : new MSSQL.Parameter("Body", SqlDbType.Image, 0, ParameterDirection.Input, Body),
                    !isInsertisSended ? null : new MSSQL.Parameter("isSended", SqlDbType.Bit, 0, ParameterDirection.Input, isSended),
                    !isInsertResult ? null : new MSSQL.Parameter("Result", SqlDbType.Int, 0, ParameterDirection.Input, Result)
                    );
            }

            public static int Update(string Condition, byte[] MailTo, bool isUpdateMailTo, byte[] Subject, bool isUpdateSubject, byte[] Body, bool isUpdateBody, bool isSended, bool isUpdateisSended, int Result, bool isUpdateResult)
            {
                Condition = Condition.Trim();

                string CommandText = "update [WaitSendEmail] set ";
                string UpdateFieldsList = "";

                if (isUpdateMailTo)
                    UpdateFieldsList += "[MailTo] = @MailTo, ";
                if (isUpdateSubject)
                    UpdateFieldsList += "[Subject] = @Subject, ";
                if (isUpdateBody)
                    UpdateFieldsList += "[Body] = @Body, ";
                if (isUpdateisSended)
                    UpdateFieldsList += "[isSended] = @isSended, ";
                if (isUpdateResult)
                    UpdateFieldsList += "[Result] = @Result, ";

                if (UpdateFieldsList == "")
                    return -101;

                CommandText += UpdateFieldsList.Substring(0, UpdateFieldsList.Length - 2) + (Condition == "" ? "" : " where " + Condition);

                return MSSQL.ExecuteNonQuery(CommandText,
                    !isUpdateMailTo ? null : new MSSQL.Parameter("MailTo", SqlDbType.Image, 0, ParameterDirection.Input, MailTo),
                    !isUpdateSubject ? null : new MSSQL.Parameter("Subject", SqlDbType.Image, 0, ParameterDirection.Input, Subject),
                    !isUpdateBody ? null : new MSSQL.Parameter("Body", SqlDbType.Image, 0, ParameterDirection.Input, Body),
                    !isUpdateisSended ? null : new MSSQL.Parameter("isSended", SqlDbType.Bit, 0, ParameterDirection.Input, isSended),
                    !isUpdateResult ? null : new MSSQL.Parameter("Result", SqlDbType.Int, 0, ParameterDirection.Input, Result)
                    );
            }

            public static int Delete(string Condition)
            {
                Condition = Condition.Trim();

                return MSSQL.ExecuteNonQuery("delete from [WaitSendEmail]" + (Condition == "" ? "" : " where " + Condition));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [WaitSendEmail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }
    }

    public class Views
    {
        public class V_Celeb
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_Celeb]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_Celeb]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_Chase
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_Chase]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_Chase]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_ChaseDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_ChaseDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_ChaseDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_ChaseTotal
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_ChaseTotal]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_ChaseTotal]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_City
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_City]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_City]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_Isuse
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_Isuse]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_Isuse]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_IsuseWithSumMoney
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_IsuseWithSumMoney]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_IsuseWithSumMoney]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_LoginLog
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_LoginLog]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_LoginLog]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_LotteryBuyDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_LotteryBuyDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_LotteryBuyDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_LotteryBuyDetailNonce
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_LotteryBuyDetailNonce]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_LotteryBuyDetailNonce]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_LotteryBuyDetailSum
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_LotteryBuyDetailSum]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_LotteryBuyDetailSum]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_LotteryBuyDetailWithQuashed
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_LotteryBuyDetailWithQuashed]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_LotteryBuyDetailWithQuashed]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_LotteryBuyDetailWithQuashedAll
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_LotteryBuyDetailWithQuashedAll]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_LotteryBuyDetailWithQuashedAll]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_LotteryBuyDetailWithUserName
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_LotteryBuyDetailWithUserName]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_LotteryBuyDetailWithUserName]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_LotteryBuyType
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_LotteryBuyType]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_LotteryBuyType]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_Message
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_Message]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_Message]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_Promotioners
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_Promotioners]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_Promotioners]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_Question
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_Question]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_Question]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_Scheme
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_Scheme]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_Scheme]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_SchemeChatUsers
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_SchemeChatUsers]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_SchemeChatUsers]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_SchemeCount
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_SchemeCount]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_SchemeCount]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_SchemeSchedule
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_SchemeSchedule]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_SchemeSchedule]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_SchemeScheduleWithQuashed
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_SchemeScheduleWithQuashed]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_SchemeScheduleWithQuashed]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_UserDistill
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_UserDistill]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_UserDistill]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_Users
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_Users]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_Users]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_UsersDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_UsersDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_UsersDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_UsersDetailWithScheme
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_UsersDetailWithScheme]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_UsersDetailWithScheme]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_UsersScoringDetail
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_UsersScoringDetail]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_UsersScoringDetail]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_UsersScoringDetailWithScheme
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_UsersScoringDetailWithScheme]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_UsersScoringDetailWithScheme]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_ZCDCLeagueType
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_ZCDCLeagueType]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_ZCDCLeagueType]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }

        public class V_ZCDCSchemeNumber
        {
            public static DataTable Select(string Fields, string Condition, string Sort)
            {
                Fields = Fields.Trim();
                Condition = Condition.Trim();
                Sort = Sort.Trim();

                return MSSQL.Select("select " + (Fields == "" ? "*" : Fields) + " from [V_ZCDCSchemeNumber]" + (Condition == "" ? "" : " where " + Condition) + (Sort == "" ? "" : " order by " + Sort));
            }

            public static int GetCount(string Condition)
            {
                Condition = Condition.Trim();

                object Result = MSSQL.ExecuteScalar("select count(*) from [V_ZCDCSchemeNumber]" + (Condition == "" ? "" : " where " + Condition));
                if (Result == null)
                    return 0;

                return int.Parse(Result.ToString());
            }
        }
    }

    public class Functions
    {
        public class F_GetChaseBuyTypeID
        {
            public static int Call(int Lottery_id)
            {
                object Result = MSSQL.ExecuteFunction("F_GetChaseBuyTypeID",
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id)
                    );

                return System.Convert.ToInt32(Result);
            }
        }

        public class F_GetChaseBuyTypeName
        {
            public static string Call(int Type)
            {
                object Result = MSSQL.ExecuteFunction("F_GetChaseBuyTypeName",
                    new MSSQL.Parameter("Type", SqlDbType.Int, 0, ParameterDirection.Input, Type)
                    );

                return System.Convert.ToString(Result);
            }
        }

        public class F_GetChaseExecuteTime
        {
            public static DateTime Call(int Lottery_id, DateTime StartTime)
            {
                object Result = MSSQL.ExecuteFunction("F_GetChaseExecuteTime",
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime)
                    );

                return System.Convert.ToDateTime(Result);
            }
        }

        public class F_GetIsUsedLotteryList
        {
            public static string Call()
            {
                object Result = MSSQL.ExecuteFunction("F_GetIsUsedLotteryList");

                return System.Convert.ToString(Result);
            }
        }

        public class F_GetLotteryBasePlayPage
        {
            public static string Call(int id)
            {
                object Result = MSSQL.ExecuteFunction("F_GetLotteryBasePlayPage",
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id)
                    );

                return System.Convert.ToString(Result);
            }
        }

        public class F_GetLotteryBuyType
        {
            public static string Call(int id)
            {
                object Result = MSSQL.ExecuteFunction("F_GetLotteryBuyType",
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id)
                    );

                return System.Convert.ToString(Result);
            }
        }

        public class F_GetLotteryCode
        {
            public static string Call(int id)
            {
                object Result = MSSQL.ExecuteFunction("F_GetLotteryCode",
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id)
                    );

                return System.Convert.ToString(Result);
            }
        }

        public class F_GetLotteryIsused
        {
            public static bool Call(int id)
            {
                object Result = MSSQL.ExecuteFunction("F_GetLotteryIsused",
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id)
                    );

                return System.Convert.ToBoolean(Result);
            }
        }

        public class F_GetLotteryName
        {
            public static string Call(int id)
            {
                object Result = MSSQL.ExecuteFunction("F_GetLotteryName",
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id)
                    );

                return System.Convert.ToString(Result);
            }
        }

        public class F_GetPlaceFromIPAddress
        {
            public static string Call(string IP)
            {
                object Result = MSSQL.ExecuteFunction("F_GetPlaceFromIPAddress",
                    new MSSQL.Parameter("IP", SqlDbType.VarChar, 0, ParameterDirection.Input, IP)
                    );

                return System.Convert.ToString(Result);
            }
        }

        public class F_GetSchemeSchedule
        {
            public static double Call(int Scheme_id, bool WithQuashed)
            {
                object Result = MSSQL.ExecuteFunction("F_GetSchemeSchedule",
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("WithQuashed", SqlDbType.Bit, 0, ParameterDirection.Input, WithQuashed)
                    );

                return System.Convert.ToDouble(Result);
            }
        }

        public class F_GetSystemEndTime
        {
            public static DateTime Call(int BuyType_id, DateTime EndTime)
            {
                object Result = MSSQL.ExecuteFunction("F_GetSystemEndTime",
                    new MSSQL.Parameter("BuyType_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyType_id),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime)
                    );

                return System.Convert.ToDateTime(Result);
            }
        }

        public class F_GetUserID
        {
            public static int Call(string UserName)
            {
                object Result = MSSQL.ExecuteFunction("F_GetUserID",
                    new MSSQL.Parameter("UserName", SqlDbType.VarChar, 0, ParameterDirection.Input, UserName)
                    );

                return System.Convert.ToInt32(Result);
            }
        }

        public class F_GetWinLotteryExemple
        {
            public static string Call(int id)
            {
                object Result = MSSQL.ExecuteFunction("F_GetWinLotteryExemple",
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id)
                    );

                return System.Convert.ToString(Result);
            }
        }

        public class F_IPAddressToInt64
        {
            public static long Call(string IP)
            {
                object Result = MSSQL.ExecuteFunction("F_IPAddressToInt64",
                    new MSSQL.Parameter("IP", SqlDbType.VarChar, 0, ParameterDirection.Input, IP)
                    );

                return System.Convert.ToInt64(Result);
            }
        }
    }

    public class Procedures
    {
        public class cvb_private_newrowtoreply
        {
            public static int Call(ref int replyid, int topicid, string content, string author, string userip, int usingtag, bool isformat)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("cvb_private_newrowtoreply", ref Outputs,
                    new MSSQL.Parameter("replyid", SqlDbType.Int, 4, ParameterDirection.Output, replyid),
                    new MSSQL.Parameter("topicid", SqlDbType.Int, 0, ParameterDirection.Input, topicid),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("userip", SqlDbType.NVarChar, 0, ParameterDirection.Input, userip),
                    new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag),
                    new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat)
                    );

                try
                {
                    replyid = System.Convert.ToInt32(Outputs["replyid"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(ref int replyid, int topicid, string content, string author, string userip, int usingtag, bool isformat)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("cvb_private_newrowtoreply", ref Outputs,
                    new MSSQL.Parameter("replyid", SqlDbType.Int, 4, ParameterDirection.Output, replyid),
                    new MSSQL.Parameter("topicid", SqlDbType.Int, 0, ParameterDirection.Input, topicid),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("userip", SqlDbType.NVarChar, 0, ParameterDirection.Input, userip),
                    new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag),
                    new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat)
                    );

                try
                {
                    replyid = System.Convert.ToInt32(Outputs["replyid"]);
                }
                catch { }

                return ds;
            }
        }

        public class cvb_private_newrowtotopic
        {
            public static int Call(ref int topicid, int boardid, int iconid, int voteid, string author, string title, string content, int limitexp, int money, int classid)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("cvb_private_newrowtotopic", ref Outputs,
                    new MSSQL.Parameter("topicid", SqlDbType.Int, 4, ParameterDirection.Output, topicid),
                    new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    new MSSQL.Parameter("iconid", SqlDbType.Int, 0, ParameterDirection.Input, iconid),
                    new MSSQL.Parameter("voteid", SqlDbType.Int, 0, ParameterDirection.Input, voteid),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp),
                    new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    new MSSQL.Parameter("classid", SqlDbType.Int, 0, ParameterDirection.Input, classid)
                    );

                try
                {
                    topicid = System.Convert.ToInt32(Outputs["topicid"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(ref int topicid, int boardid, int iconid, int voteid, string author, string title, string content, int limitexp, int money, int classid)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("cvb_private_newrowtotopic", ref Outputs,
                    new MSSQL.Parameter("topicid", SqlDbType.Int, 4, ParameterDirection.Output, topicid),
                    new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    new MSSQL.Parameter("iconid", SqlDbType.Int, 0, ParameterDirection.Input, iconid),
                    new MSSQL.Parameter("voteid", SqlDbType.Int, 0, ParameterDirection.Input, voteid),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp),
                    new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    new MSSQL.Parameter("classid", SqlDbType.Int, 0, ParameterDirection.Input, classid)
                    );

                try
                {
                    topicid = System.Convert.ToInt32(Outputs["topicid"]);
                }
                catch { }

                return ds;
            }
        }

        public class cvb_private_newrowtovote
        {
            public static int Call(ref int voteid, string voteitems, string tickets, bool ismultiable, int votedays, int limitexp)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("cvb_private_newrowtovote", ref Outputs,
                    new MSSQL.Parameter("voteid", SqlDbType.Int, 4, ParameterDirection.Output, voteid),
                    new MSSQL.Parameter("voteitems", SqlDbType.NText, 0, ParameterDirection.Input, voteitems),
                    new MSSQL.Parameter("tickets", SqlDbType.NVarChar, 0, ParameterDirection.Input, tickets),
                    new MSSQL.Parameter("ismultiable", SqlDbType.Bit, 0, ParameterDirection.Input, ismultiable),
                    new MSSQL.Parameter("votedays", SqlDbType.Int, 0, ParameterDirection.Input, votedays),
                    new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp)
                    );

                try
                {
                    voteid = System.Convert.ToInt32(Outputs["voteid"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(ref int voteid, string voteitems, string tickets, bool ismultiable, int votedays, int limitexp)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("cvb_private_newrowtovote", ref Outputs,
                    new MSSQL.Parameter("voteid", SqlDbType.Int, 4, ParameterDirection.Output, voteid),
                    new MSSQL.Parameter("voteitems", SqlDbType.NText, 0, ParameterDirection.Input, voteitems),
                    new MSSQL.Parameter("tickets", SqlDbType.NVarChar, 0, ParameterDirection.Input, tickets),
                    new MSSQL.Parameter("ismultiable", SqlDbType.Bit, 0, ParameterDirection.Input, ismultiable),
                    new MSSQL.Parameter("votedays", SqlDbType.Int, 0, ParameterDirection.Input, votedays),
                    new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp)
                    );

                try
                {
                    voteid = System.Convert.ToInt32(Outputs["voteid"]);
                }
                catch { }

                return ds;
            }
        }

        public class cvb_transaction_newattach
        {
            public static int Call(string username, string attachname, string attachpath, int attachsize, int attachtype)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("cvb_transaction_newattach", ref Outputs,
                    new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    new MSSQL.Parameter("attachname", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachname),
                    new MSSQL.Parameter("attachpath", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachpath),
                    new MSSQL.Parameter("attachsize", SqlDbType.Int, 0, ParameterDirection.Input, attachsize),
                    new MSSQL.Parameter("attachtype", SqlDbType.Int, 0, ParameterDirection.Input, attachtype)
                    );

                return CallResult;
            }

            public static DataSet Open(string username, string attachname, string attachpath, int attachsize, int attachtype)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("cvb_transaction_newattach", ref Outputs,
                    new MSSQL.Parameter("username", SqlDbType.NVarChar, 0, ParameterDirection.Input, username),
                    new MSSQL.Parameter("attachname", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachname),
                    new MSSQL.Parameter("attachpath", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachpath),
                    new MSSQL.Parameter("attachsize", SqlDbType.Int, 0, ParameterDirection.Input, attachsize),
                    new MSSQL.Parameter("attachtype", SqlDbType.Int, 0, ParameterDirection.Input, attachtype)
                    );

                return ds;
            }
        }

        public class cvb_transaction_newreply
        {
            public static int Call(int topicid, int boardid, string title, string content, string author, string userip, int usingtag, bool isformat, string attachidlist)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("cvb_transaction_newreply", ref Outputs,
                    new MSSQL.Parameter("topicid", SqlDbType.Int, 0, ParameterDirection.Input, topicid),
                    new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("userip", SqlDbType.NVarChar, 0, ParameterDirection.Input, userip),
                    new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag),
                    new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat),
                    new MSSQL.Parameter("attachidlist", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachidlist)
                    );

                return CallResult;
            }

            public static DataSet Open(int topicid, int boardid, string title, string content, string author, string userip, int usingtag, bool isformat, string attachidlist)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("cvb_transaction_newreply", ref Outputs,
                    new MSSQL.Parameter("topicid", SqlDbType.Int, 0, ParameterDirection.Input, topicid),
                    new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("userip", SqlDbType.NVarChar, 0, ParameterDirection.Input, userip),
                    new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag),
                    new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat),
                    new MSSQL.Parameter("attachidlist", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachidlist)
                    );

                return ds;
            }
        }

        public class cvb_transaction_newtopic
        {
            public static int Call(int boardid, int voteid, string author, string title, string content, string userip, int usingtag, bool isformat, int iconid, int limitexp, int money, string attachidlist, int classid)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("cvb_transaction_newtopic", ref Outputs,
                    new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    new MSSQL.Parameter("voteid", SqlDbType.Int, 0, ParameterDirection.Input, voteid),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("userip", SqlDbType.NVarChar, 0, ParameterDirection.Input, userip),
                    new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag),
                    new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat),
                    new MSSQL.Parameter("iconid", SqlDbType.Int, 0, ParameterDirection.Input, iconid),
                    new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp),
                    new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    new MSSQL.Parameter("attachidlist", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachidlist),
                    new MSSQL.Parameter("classid", SqlDbType.Int, 0, ParameterDirection.Input, classid)
                    );

                return CallResult;
            }

            public static DataSet Open(int boardid, int voteid, string author, string title, string content, string userip, int usingtag, bool isformat, int iconid, int limitexp, int money, string attachidlist, int classid)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("cvb_transaction_newtopic", ref Outputs,
                    new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    new MSSQL.Parameter("voteid", SqlDbType.Int, 0, ParameterDirection.Input, voteid),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("userip", SqlDbType.NVarChar, 0, ParameterDirection.Input, userip),
                    new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag),
                    new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat),
                    new MSSQL.Parameter("iconid", SqlDbType.Int, 0, ParameterDirection.Input, iconid),
                    new MSSQL.Parameter("limitexp", SqlDbType.Int, 0, ParameterDirection.Input, limitexp),
                    new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    new MSSQL.Parameter("attachidlist", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachidlist),
                    new MSSQL.Parameter("classid", SqlDbType.Int, 0, ParameterDirection.Input, classid)
                    );

                return ds;
            }
        }

        public class cvb_transaction_newvote
        {
            public static int Call(int boardid, string author, string title, string content, string userip, int usingtag, bool isformat, int iconid, int readrequireexp, string voteitems, string tickets, int votedays, bool ismultiable, int voterequireexp, int money, string attachidlist, int classid)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("cvb_transaction_newvote", ref Outputs,
                    new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("userip", SqlDbType.NVarChar, 0, ParameterDirection.Input, userip),
                    new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag),
                    new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat),
                    new MSSQL.Parameter("iconid", SqlDbType.Int, 0, ParameterDirection.Input, iconid),
                    new MSSQL.Parameter("readrequireexp", SqlDbType.Int, 0, ParameterDirection.Input, readrequireexp),
                    new MSSQL.Parameter("voteitems", SqlDbType.NText, 0, ParameterDirection.Input, voteitems),
                    new MSSQL.Parameter("tickets", SqlDbType.NVarChar, 0, ParameterDirection.Input, tickets),
                    new MSSQL.Parameter("votedays", SqlDbType.Int, 0, ParameterDirection.Input, votedays),
                    new MSSQL.Parameter("ismultiable", SqlDbType.Bit, 0, ParameterDirection.Input, ismultiable),
                    new MSSQL.Parameter("voterequireexp", SqlDbType.Int, 0, ParameterDirection.Input, voterequireexp),
                    new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    new MSSQL.Parameter("attachidlist", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachidlist),
                    new MSSQL.Parameter("classid", SqlDbType.Int, 0, ParameterDirection.Input, classid)
                    );

                return CallResult;
            }

            public static DataSet Open(int boardid, string author, string title, string content, string userip, int usingtag, bool isformat, int iconid, int readrequireexp, string voteitems, string tickets, int votedays, bool ismultiable, int voterequireexp, int money, string attachidlist, int classid)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("cvb_transaction_newvote", ref Outputs,
                    new MSSQL.Parameter("boardid", SqlDbType.Int, 0, ParameterDirection.Input, boardid),
                    new MSSQL.Parameter("author", SqlDbType.NVarChar, 0, ParameterDirection.Input, author),
                    new MSSQL.Parameter("title", SqlDbType.NVarChar, 0, ParameterDirection.Input, title),
                    new MSSQL.Parameter("content", SqlDbType.NText, 0, ParameterDirection.Input, content),
                    new MSSQL.Parameter("userip", SqlDbType.NVarChar, 0, ParameterDirection.Input, userip),
                    new MSSQL.Parameter("usingtag", SqlDbType.Int, 0, ParameterDirection.Input, usingtag),
                    new MSSQL.Parameter("isformat", SqlDbType.Bit, 0, ParameterDirection.Input, isformat),
                    new MSSQL.Parameter("iconid", SqlDbType.Int, 0, ParameterDirection.Input, iconid),
                    new MSSQL.Parameter("readrequireexp", SqlDbType.Int, 0, ParameterDirection.Input, readrequireexp),
                    new MSSQL.Parameter("voteitems", SqlDbType.NText, 0, ParameterDirection.Input, voteitems),
                    new MSSQL.Parameter("tickets", SqlDbType.NVarChar, 0, ParameterDirection.Input, tickets),
                    new MSSQL.Parameter("votedays", SqlDbType.Int, 0, ParameterDirection.Input, votedays),
                    new MSSQL.Parameter("ismultiable", SqlDbType.Bit, 0, ParameterDirection.Input, ismultiable),
                    new MSSQL.Parameter("voterequireexp", SqlDbType.Int, 0, ParameterDirection.Input, voterequireexp),
                    new MSSQL.Parameter("money", SqlDbType.Int, 0, ParameterDirection.Input, money),
                    new MSSQL.Parameter("attachidlist", SqlDbType.NVarChar, 0, ParameterDirection.Input, attachidlist),
                    new MSSQL.Parameter("classid", SqlDbType.Int, 0, ParameterDirection.Input, classid)
                    );

                return ds;
            }
        }

        public class P_AddForLeagueTypeForZCDC
        {
            public static int Call(string LeagueTypeName, string LeagueColor, ref int TypeId, ref string returnStr)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_AddForLeagueTypeForZCDC", ref Outputs,
                    new MSSQL.Parameter("LeagueTypeName", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueTypeName),
                    new MSSQL.Parameter("LeagueColor", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueColor),
                    new MSSQL.Parameter("TypeId", SqlDbType.Int, 4, ParameterDirection.Output, TypeId),
                    new MSSQL.Parameter("returnStr", SqlDbType.VarChar, 100, ParameterDirection.Output, returnStr)
                    );

                try
                {
                    TypeId = System.Convert.ToInt32(Outputs["TypeId"]);
                }
                catch { }

                try
                {
                    returnStr = System.Convert.ToString(Outputs["returnStr"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(string LeagueTypeName, string LeagueColor, ref int TypeId, ref string returnStr)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_AddForLeagueTypeForZCDC", ref Outputs,
                    new MSSQL.Parameter("LeagueTypeName", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueTypeName),
                    new MSSQL.Parameter("LeagueColor", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueColor),
                    new MSSQL.Parameter("TypeId", SqlDbType.Int, 4, ParameterDirection.Output, TypeId),
                    new MSSQL.Parameter("returnStr", SqlDbType.VarChar, 100, ParameterDirection.Output, returnStr)
                    );

                try
                {
                    TypeId = System.Convert.ToInt32(Outputs["TypeId"]);
                }
                catch { }

                try
                {
                    returnStr = System.Convert.ToString(Outputs["returnStr"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_Buy
        {
            public static int Call(int User_id, int Scheme_id, int Share, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_Buy", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("Share", SqlDbType.Int, 0, ParameterDirection.Input, Share),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, int Scheme_id, int Share, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_Buy", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("Share", SqlDbType.Int, 0, ParameterDirection.Input, Share),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_ChatInfo
        {
            public static int Call(int SchemeID, int UserID)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_ChatInfo", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID)
                    );

                return CallResult;
            }

            public static DataSet Open(int SchemeID, int UserID)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_ChatInfo", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID)
                    );

                return ds;
            }
        }

        public class P_ClearData
        {
            public static int Call(string CallPassword, ref int Result)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_ClearData", ref Outputs,
                    new MSSQL.Parameter("CallPassword", SqlDbType.VarChar, 0, ParameterDirection.Input, CallPassword),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(string CallPassword, ref int Result)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_ClearData", ref Outputs,
                    new MSSQL.Parameter("CallPassword", SqlDbType.VarChar, 0, ParameterDirection.Input, CallPassword),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_Distill
        {
            public static int Call(int User_id, double Money, string memo, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_Distill", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("memo", SqlDbType.VarChar, 0, ParameterDirection.Input, memo),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, double Money, string memo, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_Distill", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("memo", SqlDbType.VarChar, 0, ParameterDirection.Input, memo),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_DistillAccept
        {
            public static int Call(int User_id, int Distill_id, string PayBank, string PayCardNumber, string memo, int AcceptOperator_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_DistillAccept", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Distill_id", SqlDbType.Int, 0, ParameterDirection.Input, Distill_id),
                    new MSSQL.Parameter("PayBank", SqlDbType.VarChar, 0, ParameterDirection.Input, PayBank),
                    new MSSQL.Parameter("PayCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, PayCardNumber),
                    new MSSQL.Parameter("memo", SqlDbType.VarChar, 0, ParameterDirection.Input, memo),
                    new MSSQL.Parameter("AcceptOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, AcceptOperator_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, int Distill_id, string PayBank, string PayCardNumber, string memo, int AcceptOperator_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_DistillAccept", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Distill_id", SqlDbType.Int, 0, ParameterDirection.Input, Distill_id),
                    new MSSQL.Parameter("PayBank", SqlDbType.VarChar, 0, ParameterDirection.Input, PayBank),
                    new MSSQL.Parameter("PayCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, PayCardNumber),
                    new MSSQL.Parameter("memo", SqlDbType.VarChar, 0, ParameterDirection.Input, memo),
                    new MSSQL.Parameter("AcceptOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, AcceptOperator_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_DistillNoAccept
        {
            public static int Call(int User_id, int Distill_id, string memo, int AcceptOperator_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_DistillNoAccept", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Distill_id", SqlDbType.Int, 0, ParameterDirection.Input, Distill_id),
                    new MSSQL.Parameter("memo", SqlDbType.VarChar, 0, ParameterDirection.Input, memo),
                    new MSSQL.Parameter("AcceptOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, AcceptOperator_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, int Distill_id, string memo, int AcceptOperator_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_DistillNoAccept", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Distill_id", SqlDbType.Int, 0, ParameterDirection.Input, Distill_id),
                    new MSSQL.Parameter("memo", SqlDbType.VarChar, 0, ParameterDirection.Input, memo),
                    new MSSQL.Parameter("AcceptOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, AcceptOperator_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_DistillQuash
        {
            public static int Call(int User_id, int Distill_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_DistillQuash", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Distill_id", SqlDbType.Int, 0, ParameterDirection.Input, Distill_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, int Distill_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_DistillQuash", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Distill_id", SqlDbType.Int, 0, ParameterDirection.Input, Distill_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_ExecChase
        {
            public static int Call(int User_id, int ChaseDetail_id, int Isuse_id, string Title, byte[] Description, int Lottery_id, byte[] LotteryNumber, int Multiple, double IsuseMoney, int Type_id, int SecrecyLevel, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_ExecChase", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("ChaseDetail_id", SqlDbType.Int, 0, ParameterDirection.Input, ChaseDetail_id),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    new MSSQL.Parameter("IsuseMoney", SqlDbType.Money, 0, ParameterDirection.Input, IsuseMoney),
                    new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, int ChaseDetail_id, int Isuse_id, string Title, byte[] Description, int Lottery_id, byte[] LotteryNumber, int Multiple, double IsuseMoney, int Type_id, int SecrecyLevel, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_ExecChase", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("ChaseDetail_id", SqlDbType.Int, 0, ParameterDirection.Input, ChaseDetail_id),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    new MSSQL.Parameter("IsuseMoney", SqlDbType.Money, 0, ParameterDirection.Input, IsuseMoney),
                    new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_FreezeMoneyTune
        {
            public static int Call()
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_FreezeMoneyTune", ref Outputs);

                return CallResult;
            }

            public static DataSet Open()
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_FreezeMoneyTune", ref Outputs);

                return ds;
            }
        }

        public class P_FreezeMoneyTuneForUser
        {
            public static int Call(int User_id, double Money, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_FreezeMoneyTuneForUser", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, double Money, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_FreezeMoneyTuneForUser", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_GetAccountDetail
        {
            public static int Call(DateTime TimeFrom, DateTime TimeTo, ref double BalanceSum, ref double GainSum, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetAccountDetail", ref Outputs,
                    new MSSQL.Parameter("TimeFrom", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeFrom),
                    new MSSQL.Parameter("TimeTo", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeTo),
                    new MSSQL.Parameter("BalanceSum", SqlDbType.Money, 8, ParameterDirection.Output, BalanceSum),
                    new MSSQL.Parameter("GainSum", SqlDbType.Money, 8, ParameterDirection.Output, GainSum),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    BalanceSum = System.Convert.ToDouble(Outputs["BalanceSum"]);
                }
                catch { }

                try
                {
                    GainSum = System.Convert.ToDouble(Outputs["GainSum"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(DateTime TimeFrom, DateTime TimeTo, ref double BalanceSum, ref double GainSum, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetAccountDetail", ref Outputs,
                    new MSSQL.Parameter("TimeFrom", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeFrom),
                    new MSSQL.Parameter("TimeTo", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeTo),
                    new MSSQL.Parameter("BalanceSum", SqlDbType.Money, 8, ParameterDirection.Output, BalanceSum),
                    new MSSQL.Parameter("GainSum", SqlDbType.Money, 8, ParameterDirection.Output, GainSum),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    BalanceSum = System.Convert.ToDouble(Outputs["BalanceSum"]);
                }
                catch { }

                try
                {
                    GainSum = System.Convert.ToDouble(Outputs["GainSum"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_GetCelebSort
        {
            public static int Call(ref int Sort)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetCelebSort", ref Outputs,
                    new MSSQL.Parameter("Sort", SqlDbType.Int, 4, ParameterDirection.Output, Sort)
                    );

                try
                {
                    Sort = System.Convert.ToInt32(Outputs["Sort"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(ref int Sort)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetCelebSort", ref Outputs,
                    new MSSQL.Parameter("Sort", SqlDbType.Int, 4, ParameterDirection.Output, Sort)
                    );

                try
                {
                    Sort = System.Convert.ToInt32(Outputs["Sort"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_GetMemberAccountDetail
        {
            public static int Call(int User_id, int Year, int Month)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetMemberAccountDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Year", SqlDbType.Int, 0, ParameterDirection.Input, Year),
                    new MSSQL.Parameter("Month", SqlDbType.Int, 0, ParameterDirection.Input, Month)
                    );

                return CallResult;
            }

            public static DataSet Open(int User_id, int Year, int Month)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetMemberAccountDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Year", SqlDbType.Int, 0, ParameterDirection.Input, Year),
                    new MSSQL.Parameter("Month", SqlDbType.Int, 0, ParameterDirection.Input, Month)
                    );

                return ds;
            }
        }

        public class P_GetMemberAccountFreezeDetail
        {
            public static int Call(int User_id)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetMemberAccountFreezeDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id)
                    );

                return CallResult;
            }

            public static DataSet Open(int User_id)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetMemberAccountFreezeDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id)
                    );

                return ds;
            }
        }

        public class P_GetMemberMobileAccountDetail
        {
            public static int Call(int User_id, int Year, int Month)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetMemberMobileAccountDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Year", SqlDbType.Int, 0, ParameterDirection.Input, Year),
                    new MSSQL.Parameter("Month", SqlDbType.Int, 0, ParameterDirection.Input, Month)
                    );

                return CallResult;
            }

            public static DataSet Open(int User_id, int Year, int Month)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetMemberMobileAccountDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Year", SqlDbType.Int, 0, ParameterDirection.Input, Year),
                    new MSSQL.Parameter("Month", SqlDbType.Int, 0, ParameterDirection.Input, Month)
                    );

                return ds;
            }
        }

        public class P_GetMemberPromotionerDetail
        {
            public static int Call(int User_id, DateTime TimeFrom, DateTime TimeTo)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetMemberPromotionerDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("TimeFrom", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeFrom),
                    new MSSQL.Parameter("TimeTo", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeTo)
                    );

                return CallResult;
            }

            public static DataSet Open(int User_id, DateTime TimeFrom, DateTime TimeTo)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetMemberPromotionerDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("TimeFrom", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeFrom),
                    new MSSQL.Parameter("TimeTo", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeTo)
                    );

                return ds;
            }
        }

        public class P_GetMemberScoringDetail
        {
            public static int Call(int User_id, int Year, int Month)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetMemberScoringDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Year", SqlDbType.Int, 0, ParameterDirection.Input, Year),
                    new MSSQL.Parameter("Month", SqlDbType.Int, 0, ParameterDirection.Input, Month)
                    );

                return CallResult;
            }

            public static DataSet Open(int User_id, int Year, int Month)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetMemberScoringDetail", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Year", SqlDbType.Int, 0, ParameterDirection.Input, Year),
                    new MSSQL.Parameter("Month", SqlDbType.Int, 0, ParameterDirection.Input, Month)
                    );

                return ds;
            }
        }

        public class P_GetNewPayNumber
        {
            public static int Call(int User_id, string PayType, double Money, ref long id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetNewPayNumber", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("PayType", SqlDbType.VarChar, 0, ParameterDirection.Input, PayType),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("id", SqlDbType.BigInt, 8, ParameterDirection.Output, id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 50, ParameterDirection.Output, Return)
                    );

                try
                {
                    id = System.Convert.ToInt64(Outputs["id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, string PayType, double Money, ref long id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetNewPayNumber", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("PayType", SqlDbType.VarChar, 0, ParameterDirection.Input, PayType),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("id", SqlDbType.BigInt, 8, ParameterDirection.Output, id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 50, ParameterDirection.Output, Return)
                    );

                try
                {
                    id = System.Convert.ToInt64(Outputs["id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_GetUserBalance
        {
            public static int Call(int User_id, ref double Balance, ref double FreezeMoney, ref int Scoring, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetUserBalance", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Balance", SqlDbType.Money, 8, ParameterDirection.Output, Balance),
                    new MSSQL.Parameter("FreezeMoney", SqlDbType.Money, 8, ParameterDirection.Output, FreezeMoney),
                    new MSSQL.Parameter("Scoring", SqlDbType.Int, 4, ParameterDirection.Output, Scoring),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Balance = System.Convert.ToDouble(Outputs["Balance"]);
                }
                catch { }

                try
                {
                    FreezeMoney = System.Convert.ToDouble(Outputs["FreezeMoney"]);
                }
                catch { }

                try
                {
                    Scoring = System.Convert.ToInt32(Outputs["Scoring"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, ref double Balance, ref double FreezeMoney, ref int Scoring, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetUserBalance", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Balance", SqlDbType.Money, 8, ParameterDirection.Output, Balance),
                    new MSSQL.Parameter("FreezeMoney", SqlDbType.Money, 8, ParameterDirection.Output, FreezeMoney),
                    new MSSQL.Parameter("Scoring", SqlDbType.Int, 4, ParameterDirection.Output, Scoring),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Balance = System.Convert.ToDouble(Outputs["Balance"]);
                }
                catch { }

                try
                {
                    FreezeMoney = System.Convert.ToDouble(Outputs["FreezeMoney"]);
                }
                catch { }

                try
                {
                    Scoring = System.Convert.ToInt32(Outputs["Scoring"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_GetUserLoginCount
        {
            public static int Call(int Year, int Month)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetUserLoginCount", ref Outputs,
                    new MSSQL.Parameter("Year", SqlDbType.Int, 0, ParameterDirection.Input, Year),
                    new MSSQL.Parameter("Month", SqlDbType.Int, 0, ParameterDirection.Input, Month)
                    );

                return CallResult;
            }

            public static DataSet Open(int Year, int Month)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetUserLoginCount", ref Outputs,
                    new MSSQL.Parameter("Year", SqlDbType.Int, 0, ParameterDirection.Input, Year),
                    new MSSQL.Parameter("Month", SqlDbType.Int, 0, ParameterDirection.Input, Month)
                    );

                return ds;
            }
        }

        public class P_GetUserLoginStakeout
        {
            public static int Call(int Day, int Num)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetUserLoginStakeout", ref Outputs,
                    new MSSQL.Parameter("Day", SqlDbType.Int, 0, ParameterDirection.Input, Day),
                    new MSSQL.Parameter("Num", SqlDbType.Int, 0, ParameterDirection.Input, Num)
                    );

                return CallResult;
            }

            public static DataSet Open(int Day, int Num)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetUserLoginStakeout", ref Outputs,
                    new MSSQL.Parameter("Day", SqlDbType.Int, 0, ParameterDirection.Input, Day),
                    new MSSQL.Parameter("Num", SqlDbType.Int, 0, ParameterDirection.Input, Num)
                    );

                return ds;
            }
        }

        public class P_GetUserLoginStakeout_2
        {
            public static int Call(int Day, int Num)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetUserLoginStakeout_2", ref Outputs,
                    new MSSQL.Parameter("Day", SqlDbType.Int, 0, ParameterDirection.Input, Day),
                    new MSSQL.Parameter("Num", SqlDbType.Int, 0, ParameterDirection.Input, Num)
                    );

                return CallResult;
            }

            public static DataSet Open(int Day, int Num)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetUserLoginStakeout_2", ref Outputs,
                    new MSSQL.Parameter("Day", SqlDbType.Int, 0, ParameterDirection.Input, Day),
                    new MSSQL.Parameter("Num", SqlDbType.Int, 0, ParameterDirection.Input, Num)
                    );

                return ds;
            }
        }

        public class P_GetWinLotteryNumber
        {
            public static int Call()
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetWinLotteryNumber", ref Outputs);

                return CallResult;
            }

            public static DataSet Open()
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetWinLotteryNumber", ref Outputs);

                return ds;
            }
        }

        public class P_GetWinNameList
        {
            public static int Call()
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_GetWinNameList", ref Outputs);

                return CallResult;
            }

            public static DataSet Open()
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_GetWinNameList", ref Outputs);

                return ds;
            }
        }

        public class P_InitiateChase
        {
            public static int Call(int User_id, string Title, byte[] Description, int Lottery_id, int Type_id, int BuyType_id, byte[] LotteryNumber, int Multiple, double IsuseMoney, int Isuse1, int Isuse2, int Isuse3, int Isuse4, int Isuse5, int Isuse6, int Isuse7, int Isuse8, int Isuse9, int Isuse10, double AutoStopAtWinMoney, int SecrecyLevel, ref int Chase_id, ref int ChaseDetail_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_InitiateChase", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    new MSSQL.Parameter("BuyType_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyType_id),
                    new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    new MSSQL.Parameter("IsuseMoney", SqlDbType.Money, 0, ParameterDirection.Input, IsuseMoney),
                    new MSSQL.Parameter("Isuse1", SqlDbType.Int, 0, ParameterDirection.Input, Isuse1),
                    new MSSQL.Parameter("Isuse2", SqlDbType.Int, 0, ParameterDirection.Input, Isuse2),
                    new MSSQL.Parameter("Isuse3", SqlDbType.Int, 0, ParameterDirection.Input, Isuse3),
                    new MSSQL.Parameter("Isuse4", SqlDbType.Int, 0, ParameterDirection.Input, Isuse4),
                    new MSSQL.Parameter("Isuse5", SqlDbType.Int, 0, ParameterDirection.Input, Isuse5),
                    new MSSQL.Parameter("Isuse6", SqlDbType.Int, 0, ParameterDirection.Input, Isuse6),
                    new MSSQL.Parameter("Isuse7", SqlDbType.Int, 0, ParameterDirection.Input, Isuse7),
                    new MSSQL.Parameter("Isuse8", SqlDbType.Int, 0, ParameterDirection.Input, Isuse8),
                    new MSSQL.Parameter("Isuse9", SqlDbType.Int, 0, ParameterDirection.Input, Isuse9),
                    new MSSQL.Parameter("Isuse10", SqlDbType.Int, 0, ParameterDirection.Input, Isuse10),
                    new MSSQL.Parameter("AutoStopAtWinMoney", SqlDbType.Money, 0, ParameterDirection.Input, AutoStopAtWinMoney),
                    new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    new MSSQL.Parameter("Chase_id", SqlDbType.Int, 4, ParameterDirection.Output, Chase_id),
                    new MSSQL.Parameter("ChaseDetail_id", SqlDbType.Int, 4, ParameterDirection.Output, ChaseDetail_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Chase_id = System.Convert.ToInt32(Outputs["Chase_id"]);
                }
                catch { }

                try
                {
                    ChaseDetail_id = System.Convert.ToInt32(Outputs["ChaseDetail_id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, string Title, byte[] Description, int Lottery_id, int Type_id, int BuyType_id, byte[] LotteryNumber, int Multiple, double IsuseMoney, int Isuse1, int Isuse2, int Isuse3, int Isuse4, int Isuse5, int Isuse6, int Isuse7, int Isuse8, int Isuse9, int Isuse10, double AutoStopAtWinMoney, int SecrecyLevel, ref int Chase_id, ref int ChaseDetail_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_InitiateChase", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    new MSSQL.Parameter("BuyType_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyType_id),
                    new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    new MSSQL.Parameter("IsuseMoney", SqlDbType.Money, 0, ParameterDirection.Input, IsuseMoney),
                    new MSSQL.Parameter("Isuse1", SqlDbType.Int, 0, ParameterDirection.Input, Isuse1),
                    new MSSQL.Parameter("Isuse2", SqlDbType.Int, 0, ParameterDirection.Input, Isuse2),
                    new MSSQL.Parameter("Isuse3", SqlDbType.Int, 0, ParameterDirection.Input, Isuse3),
                    new MSSQL.Parameter("Isuse4", SqlDbType.Int, 0, ParameterDirection.Input, Isuse4),
                    new MSSQL.Parameter("Isuse5", SqlDbType.Int, 0, ParameterDirection.Input, Isuse5),
                    new MSSQL.Parameter("Isuse6", SqlDbType.Int, 0, ParameterDirection.Input, Isuse6),
                    new MSSQL.Parameter("Isuse7", SqlDbType.Int, 0, ParameterDirection.Input, Isuse7),
                    new MSSQL.Parameter("Isuse8", SqlDbType.Int, 0, ParameterDirection.Input, Isuse8),
                    new MSSQL.Parameter("Isuse9", SqlDbType.Int, 0, ParameterDirection.Input, Isuse9),
                    new MSSQL.Parameter("Isuse10", SqlDbType.Int, 0, ParameterDirection.Input, Isuse10),
                    new MSSQL.Parameter("AutoStopAtWinMoney", SqlDbType.Money, 0, ParameterDirection.Input, AutoStopAtWinMoney),
                    new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    new MSSQL.Parameter("Chase_id", SqlDbType.Int, 4, ParameterDirection.Output, Chase_id),
                    new MSSQL.Parameter("ChaseDetail_id", SqlDbType.Int, 4, ParameterDirection.Output, ChaseDetail_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Chase_id = System.Convert.ToInt32(Outputs["Chase_id"]);
                }
                catch { }

                try
                {
                    ChaseDetail_id = System.Convert.ToInt32(Outputs["ChaseDetail_id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_InitiateScheme
        {
            public static int Call(int User_id, string Title, byte[] Description, int Isuse_id, int Type_id, byte[] LotteryNumber, int Multiple, double Money, double AssureMoney, int Share, int BuyShare, string SchemeFileName, string OpenUserList, int SecrecyLevel, ref int Scheme_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_InitiateScheme", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("AssureMoney", SqlDbType.Money, 0, ParameterDirection.Input, AssureMoney),
                    new MSSQL.Parameter("Share", SqlDbType.Int, 0, ParameterDirection.Input, Share),
                    new MSSQL.Parameter("BuyShare", SqlDbType.Int, 0, ParameterDirection.Input, BuyShare),
                    new MSSQL.Parameter("SchemeFileName", SqlDbType.VarChar, 0, ParameterDirection.Input, SchemeFileName),
                    new MSSQL.Parameter("OpenUserList", SqlDbType.VarChar, 0, ParameterDirection.Input, OpenUserList),
                    new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 4, ParameterDirection.Output, Scheme_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Scheme_id = System.Convert.ToInt32(Outputs["Scheme_id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, string Title, byte[] Description, int Isuse_id, int Type_id, byte[] LotteryNumber, int Multiple, double Money, double AssureMoney, int Share, int BuyShare, string SchemeFileName, string OpenUserList, int SecrecyLevel, ref int Scheme_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_InitiateScheme", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("AssureMoney", SqlDbType.Money, 0, ParameterDirection.Input, AssureMoney),
                    new MSSQL.Parameter("Share", SqlDbType.Int, 0, ParameterDirection.Input, Share),
                    new MSSQL.Parameter("BuyShare", SqlDbType.Int, 0, ParameterDirection.Input, BuyShare),
                    new MSSQL.Parameter("SchemeFileName", SqlDbType.VarChar, 0, ParameterDirection.Input, SchemeFileName),
                    new MSSQL.Parameter("OpenUserList", SqlDbType.VarChar, 0, ParameterDirection.Input, OpenUserList),
                    new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 4, ParameterDirection.Output, Scheme_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Scheme_id = System.Convert.ToInt32(Outputs["Scheme_id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_IsuseAddForJQC
        {
            public static int Call(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, string Team1, string Time1, string Team2, string Time2, string Team3, string Time3, string Team4, string Time4, string Team5, string Time5, string Team6, string Time6, string Team7, string Time7, string Team8, string Time8)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseAddForJQC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("Team1", SqlDbType.VarChar, 0, ParameterDirection.Input, Team1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("Team2", SqlDbType.VarChar, 0, ParameterDirection.Input, Team2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("Team3", SqlDbType.VarChar, 0, ParameterDirection.Input, Team3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("Team4", SqlDbType.VarChar, 0, ParameterDirection.Input, Team4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("Team5", SqlDbType.VarChar, 0, ParameterDirection.Input, Team5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("Team6", SqlDbType.VarChar, 0, ParameterDirection.Input, Team6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6),
                    new MSSQL.Parameter("Team7", SqlDbType.VarChar, 0, ParameterDirection.Input, Team7),
                    new MSSQL.Parameter("Time7", SqlDbType.VarChar, 0, ParameterDirection.Input, Time7),
                    new MSSQL.Parameter("Team8", SqlDbType.VarChar, 0, ParameterDirection.Input, Team8),
                    new MSSQL.Parameter("Time8", SqlDbType.VarChar, 0, ParameterDirection.Input, Time8)
                    );

                return CallResult;
            }

            public static DataSet Open(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, string Team1, string Time1, string Team2, string Time2, string Team3, string Time3, string Team4, string Time4, string Team5, string Time5, string Team6, string Time6, string Team7, string Time7, string Team8, string Time8)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseAddForJQC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("Team1", SqlDbType.VarChar, 0, ParameterDirection.Input, Team1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("Team2", SqlDbType.VarChar, 0, ParameterDirection.Input, Team2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("Team3", SqlDbType.VarChar, 0, ParameterDirection.Input, Team3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("Team4", SqlDbType.VarChar, 0, ParameterDirection.Input, Team4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("Team5", SqlDbType.VarChar, 0, ParameterDirection.Input, Team5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("Team6", SqlDbType.VarChar, 0, ParameterDirection.Input, Team6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6),
                    new MSSQL.Parameter("Team7", SqlDbType.VarChar, 0, ParameterDirection.Input, Team7),
                    new MSSQL.Parameter("Time7", SqlDbType.VarChar, 0, ParameterDirection.Input, Time7),
                    new MSSQL.Parameter("Team8", SqlDbType.VarChar, 0, ParameterDirection.Input, Team8),
                    new MSSQL.Parameter("Time8", SqlDbType.VarChar, 0, ParameterDirection.Input, Time8)
                    );

                return ds;
            }
        }

        public class P_IsuseAddForLCBQC
        {
            public static int Call(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1, string HostTeam2, string QuestTeam2, string Time2, string HostTeam3, string QuestTeam3, string Time3, string HostTeam4, string QuestTeam4, string Time4, string HostTeam5, string QuestTeam5, string Time5, string HostTeam6, string QuestTeam6, string Time6)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseAddForLCBQC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("HostTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam2),
                    new MSSQL.Parameter("QuestTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("HostTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam3),
                    new MSSQL.Parameter("QuestTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("HostTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam4),
                    new MSSQL.Parameter("QuestTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("HostTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam5),
                    new MSSQL.Parameter("QuestTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("HostTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam6),
                    new MSSQL.Parameter("QuestTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6)
                    );

                return CallResult;
            }

            public static DataSet Open(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1, string HostTeam2, string QuestTeam2, string Time2, string HostTeam3, string QuestTeam3, string Time3, string HostTeam4, string QuestTeam4, string Time4, string HostTeam5, string QuestTeam5, string Time5, string HostTeam6, string QuestTeam6, string Time6)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseAddForLCBQC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("HostTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam2),
                    new MSSQL.Parameter("QuestTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("HostTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam3),
                    new MSSQL.Parameter("QuestTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("HostTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam4),
                    new MSSQL.Parameter("QuestTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("HostTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam5),
                    new MSSQL.Parameter("QuestTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("HostTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam6),
                    new MSSQL.Parameter("QuestTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6)
                    );

                return ds;
            }
        }

        public class P_IsuseAddForLCDC
        {
            public static int Call(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseAddForLCDC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1)
                    );

                return CallResult;
            }

            public static DataSet Open(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseAddForLCDC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1)
                    );

                return ds;
            }
        }

        public class P_IsuseAddForSFC
        {
            public static int Call(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1, string HostTeam2, string QuestTeam2, string Time2, string HostTeam3, string QuestTeam3, string Time3, string HostTeam4, string QuestTeam4, string Time4, string HostTeam5, string QuestTeam5, string Time5, string HostTeam6, string QuestTeam6, string Time6, string HostTeam7, string QuestTeam7, string Time7, string HostTeam8, string QuestTeam8, string Time8, string HostTeam9, string QuestTeam9, string Time9, string HostTeam10, string QuestTeam10, string Time10, string HostTeam11, string QuestTeam11, string Time11, string HostTeam12, string QuestTeam12, string Time12, string HostTeam13, string QuestTeam13, string Time13, string HostTeam14, string QuestTeam14, string Time14)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseAddForSFC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("HostTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam2),
                    new MSSQL.Parameter("QuestTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("HostTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam3),
                    new MSSQL.Parameter("QuestTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("HostTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam4),
                    new MSSQL.Parameter("QuestTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("HostTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam5),
                    new MSSQL.Parameter("QuestTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("HostTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam6),
                    new MSSQL.Parameter("QuestTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6),
                    new MSSQL.Parameter("HostTeam7", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam7),
                    new MSSQL.Parameter("QuestTeam7", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam7),
                    new MSSQL.Parameter("Time7", SqlDbType.VarChar, 0, ParameterDirection.Input, Time7),
                    new MSSQL.Parameter("HostTeam8", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam8),
                    new MSSQL.Parameter("QuestTeam8", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam8),
                    new MSSQL.Parameter("Time8", SqlDbType.VarChar, 0, ParameterDirection.Input, Time8),
                    new MSSQL.Parameter("HostTeam9", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam9),
                    new MSSQL.Parameter("QuestTeam9", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam9),
                    new MSSQL.Parameter("Time9", SqlDbType.VarChar, 0, ParameterDirection.Input, Time9),
                    new MSSQL.Parameter("HostTeam10", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam10),
                    new MSSQL.Parameter("QuestTeam10", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam10),
                    new MSSQL.Parameter("Time10", SqlDbType.VarChar, 0, ParameterDirection.Input, Time10),
                    new MSSQL.Parameter("HostTeam11", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam11),
                    new MSSQL.Parameter("QuestTeam11", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam11),
                    new MSSQL.Parameter("Time11", SqlDbType.VarChar, 0, ParameterDirection.Input, Time11),
                    new MSSQL.Parameter("HostTeam12", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam12),
                    new MSSQL.Parameter("QuestTeam12", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam12),
                    new MSSQL.Parameter("Time12", SqlDbType.VarChar, 0, ParameterDirection.Input, Time12),
                    new MSSQL.Parameter("HostTeam13", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam13),
                    new MSSQL.Parameter("QuestTeam13", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam13),
                    new MSSQL.Parameter("Time13", SqlDbType.VarChar, 0, ParameterDirection.Input, Time13),
                    new MSSQL.Parameter("HostTeam14", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam14),
                    new MSSQL.Parameter("QuestTeam14", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam14),
                    new MSSQL.Parameter("Time14", SqlDbType.VarChar, 0, ParameterDirection.Input, Time14)
                    );

                return CallResult;
            }

            public static DataSet Open(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1, string HostTeam2, string QuestTeam2, string Time2, string HostTeam3, string QuestTeam3, string Time3, string HostTeam4, string QuestTeam4, string Time4, string HostTeam5, string QuestTeam5, string Time5, string HostTeam6, string QuestTeam6, string Time6, string HostTeam7, string QuestTeam7, string Time7, string HostTeam8, string QuestTeam8, string Time8, string HostTeam9, string QuestTeam9, string Time9, string HostTeam10, string QuestTeam10, string Time10, string HostTeam11, string QuestTeam11, string Time11, string HostTeam12, string QuestTeam12, string Time12, string HostTeam13, string QuestTeam13, string Time13, string HostTeam14, string QuestTeam14, string Time14)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseAddForSFC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("HostTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam2),
                    new MSSQL.Parameter("QuestTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("HostTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam3),
                    new MSSQL.Parameter("QuestTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("HostTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam4),
                    new MSSQL.Parameter("QuestTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("HostTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam5),
                    new MSSQL.Parameter("QuestTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("HostTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam6),
                    new MSSQL.Parameter("QuestTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6),
                    new MSSQL.Parameter("HostTeam7", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam7),
                    new MSSQL.Parameter("QuestTeam7", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam7),
                    new MSSQL.Parameter("Time7", SqlDbType.VarChar, 0, ParameterDirection.Input, Time7),
                    new MSSQL.Parameter("HostTeam8", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam8),
                    new MSSQL.Parameter("QuestTeam8", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam8),
                    new MSSQL.Parameter("Time8", SqlDbType.VarChar, 0, ParameterDirection.Input, Time8),
                    new MSSQL.Parameter("HostTeam9", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam9),
                    new MSSQL.Parameter("QuestTeam9", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam9),
                    new MSSQL.Parameter("Time9", SqlDbType.VarChar, 0, ParameterDirection.Input, Time9),
                    new MSSQL.Parameter("HostTeam10", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam10),
                    new MSSQL.Parameter("QuestTeam10", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam10),
                    new MSSQL.Parameter("Time10", SqlDbType.VarChar, 0, ParameterDirection.Input, Time10),
                    new MSSQL.Parameter("HostTeam11", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam11),
                    new MSSQL.Parameter("QuestTeam11", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam11),
                    new MSSQL.Parameter("Time11", SqlDbType.VarChar, 0, ParameterDirection.Input, Time11),
                    new MSSQL.Parameter("HostTeam12", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam12),
                    new MSSQL.Parameter("QuestTeam12", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam12),
                    new MSSQL.Parameter("Time12", SqlDbType.VarChar, 0, ParameterDirection.Input, Time12),
                    new MSSQL.Parameter("HostTeam13", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam13),
                    new MSSQL.Parameter("QuestTeam13", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam13),
                    new MSSQL.Parameter("Time13", SqlDbType.VarChar, 0, ParameterDirection.Input, Time13),
                    new MSSQL.Parameter("HostTeam14", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam14),
                    new MSSQL.Parameter("QuestTeam14", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam14),
                    new MSSQL.Parameter("Time14", SqlDbType.VarChar, 0, ParameterDirection.Input, Time14)
                    );

                return ds;
            }
        }

        public class P_IsuseAddForZCDC
        {
            public static int Call(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, int CompetitionCount, string ScreeningsAndTime, ref int Isuse_id, ref string return_str)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseAddForZCDC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("CompetitionCount", SqlDbType.Int, 0, ParameterDirection.Input, CompetitionCount),
                    new MSSQL.Parameter("ScreeningsAndTime", SqlDbType.VarChar, 0, ParameterDirection.Input, ScreeningsAndTime),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 4, ParameterDirection.Output, Isuse_id),
                    new MSSQL.Parameter("return_str", SqlDbType.VarChar, 100, ParameterDirection.Output, return_str)
                    );

                try
                {
                    Isuse_id = System.Convert.ToInt32(Outputs["Isuse_id"]);
                }
                catch { }

                try
                {
                    return_str = System.Convert.ToString(Outputs["return_str"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, int CompetitionCount, string ScreeningsAndTime, ref int Isuse_id, ref string return_str)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseAddForZCDC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("CompetitionCount", SqlDbType.Int, 0, ParameterDirection.Input, CompetitionCount),
                    new MSSQL.Parameter("ScreeningsAndTime", SqlDbType.VarChar, 0, ParameterDirection.Input, ScreeningsAndTime),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 4, ParameterDirection.Output, Isuse_id),
                    new MSSQL.Parameter("return_str", SqlDbType.VarChar, 100, ParameterDirection.Output, return_str)
                    );

                try
                {
                    Isuse_id = System.Convert.ToInt32(Outputs["Isuse_id"]);
                }
                catch { }

                try
                {
                    return_str = System.Convert.ToString(Outputs["return_str"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_IsuseEditForJQC
        {
            public static int Call(int Isuse_id, string Isuse, DateTime StartTime, DateTime EndTime, string Team1, string Time1, string Team2, string Time2, string Team3, string Time3, string Team4, string Time4, string Team5, string Time5, string Team6, string Time6, string Team7, string Time7, string Team8, string Time8)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseEditForJQC", ref Outputs,
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("Team1", SqlDbType.VarChar, 0, ParameterDirection.Input, Team1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("Team2", SqlDbType.VarChar, 0, ParameterDirection.Input, Team2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("Team3", SqlDbType.VarChar, 0, ParameterDirection.Input, Team3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("Team4", SqlDbType.VarChar, 0, ParameterDirection.Input, Team4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("Team5", SqlDbType.VarChar, 0, ParameterDirection.Input, Team5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("Team6", SqlDbType.VarChar, 0, ParameterDirection.Input, Team6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6),
                    new MSSQL.Parameter("Team7", SqlDbType.VarChar, 0, ParameterDirection.Input, Team7),
                    new MSSQL.Parameter("Time7", SqlDbType.VarChar, 0, ParameterDirection.Input, Time7),
                    new MSSQL.Parameter("Team8", SqlDbType.VarChar, 0, ParameterDirection.Input, Team8),
                    new MSSQL.Parameter("Time8", SqlDbType.VarChar, 0, ParameterDirection.Input, Time8)
                    );

                return CallResult;
            }

            public static DataSet Open(int Isuse_id, string Isuse, DateTime StartTime, DateTime EndTime, string Team1, string Time1, string Team2, string Time2, string Team3, string Time3, string Team4, string Time4, string Team5, string Time5, string Team6, string Time6, string Team7, string Time7, string Team8, string Time8)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseEditForJQC", ref Outputs,
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("Team1", SqlDbType.VarChar, 0, ParameterDirection.Input, Team1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("Team2", SqlDbType.VarChar, 0, ParameterDirection.Input, Team2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("Team3", SqlDbType.VarChar, 0, ParameterDirection.Input, Team3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("Team4", SqlDbType.VarChar, 0, ParameterDirection.Input, Team4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("Team5", SqlDbType.VarChar, 0, ParameterDirection.Input, Team5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("Team6", SqlDbType.VarChar, 0, ParameterDirection.Input, Team6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6),
                    new MSSQL.Parameter("Team7", SqlDbType.VarChar, 0, ParameterDirection.Input, Team7),
                    new MSSQL.Parameter("Time7", SqlDbType.VarChar, 0, ParameterDirection.Input, Time7),
                    new MSSQL.Parameter("Team8", SqlDbType.VarChar, 0, ParameterDirection.Input, Team8),
                    new MSSQL.Parameter("Time8", SqlDbType.VarChar, 0, ParameterDirection.Input, Time8)
                    );

                return ds;
            }
        }

        public class P_IsuseEditForLCBQC
        {
            public static int Call(int Isuse_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1, string HostTeam2, string QuestTeam2, string Time2, string HostTeam3, string QuestTeam3, string Time3, string HostTeam4, string QuestTeam4, string Time4, string HostTeam5, string QuestTeam5, string Time5, string HostTeam6, string QuestTeam6, string Time6)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseEditForLCBQC", ref Outputs,
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("HostTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam2),
                    new MSSQL.Parameter("QuestTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("HostTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam3),
                    new MSSQL.Parameter("QuestTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("HostTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam4),
                    new MSSQL.Parameter("QuestTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("HostTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam5),
                    new MSSQL.Parameter("QuestTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("HostTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam6),
                    new MSSQL.Parameter("QuestTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6)
                    );

                return CallResult;
            }

            public static DataSet Open(int Isuse_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1, string HostTeam2, string QuestTeam2, string Time2, string HostTeam3, string QuestTeam3, string Time3, string HostTeam4, string QuestTeam4, string Time4, string HostTeam5, string QuestTeam5, string Time5, string HostTeam6, string QuestTeam6, string Time6)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseEditForLCBQC", ref Outputs,
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("HostTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam2),
                    new MSSQL.Parameter("QuestTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("HostTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam3),
                    new MSSQL.Parameter("QuestTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("HostTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam4),
                    new MSSQL.Parameter("QuestTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("HostTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam5),
                    new MSSQL.Parameter("QuestTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("HostTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam6),
                    new MSSQL.Parameter("QuestTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6)
                    );

                return ds;
            }
        }

        public class P_IsuseEditForLCDC
        {
            public static int Call(int Isuse_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseEditForLCDC", ref Outputs,
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1)
                    );

                return CallResult;
            }

            public static DataSet Open(int Isuse_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseEditForLCDC", ref Outputs,
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1)
                    );

                return ds;
            }
        }

        public class P_IsuseEditForSFC
        {
            public static int Call(int Isuse_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1, string HostTeam2, string QuestTeam2, string Time2, string HostTeam3, string QuestTeam3, string Time3, string HostTeam4, string QuestTeam4, string Time4, string HostTeam5, string QuestTeam5, string Time5, string HostTeam6, string QuestTeam6, string Time6, string HostTeam7, string QuestTeam7, string Time7, string HostTeam8, string QuestTeam8, string Time8, string HostTeam9, string QuestTeam9, string Time9, string HostTeam10, string QuestTeam10, string Time10, string HostTeam11, string QuestTeam11, string Time11, string HostTeam12, string QuestTeam12, string Time12, string HostTeam13, string QuestTeam13, string Time13, string HostTeam14, string QuestTeam14, string Time14)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseEditForSFC", ref Outputs,
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("HostTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam2),
                    new MSSQL.Parameter("QuestTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("HostTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam3),
                    new MSSQL.Parameter("QuestTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("HostTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam4),
                    new MSSQL.Parameter("QuestTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("HostTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam5),
                    new MSSQL.Parameter("QuestTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("HostTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam6),
                    new MSSQL.Parameter("QuestTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6),
                    new MSSQL.Parameter("HostTeam7", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam7),
                    new MSSQL.Parameter("QuestTeam7", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam7),
                    new MSSQL.Parameter("Time7", SqlDbType.VarChar, 0, ParameterDirection.Input, Time7),
                    new MSSQL.Parameter("HostTeam8", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam8),
                    new MSSQL.Parameter("QuestTeam8", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam8),
                    new MSSQL.Parameter("Time8", SqlDbType.VarChar, 0, ParameterDirection.Input, Time8),
                    new MSSQL.Parameter("HostTeam9", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam9),
                    new MSSQL.Parameter("QuestTeam9", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam9),
                    new MSSQL.Parameter("Time9", SqlDbType.VarChar, 0, ParameterDirection.Input, Time9),
                    new MSSQL.Parameter("HostTeam10", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam10),
                    new MSSQL.Parameter("QuestTeam10", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam10),
                    new MSSQL.Parameter("Time10", SqlDbType.VarChar, 0, ParameterDirection.Input, Time10),
                    new MSSQL.Parameter("HostTeam11", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam11),
                    new MSSQL.Parameter("QuestTeam11", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam11),
                    new MSSQL.Parameter("Time11", SqlDbType.VarChar, 0, ParameterDirection.Input, Time11),
                    new MSSQL.Parameter("HostTeam12", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam12),
                    new MSSQL.Parameter("QuestTeam12", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam12),
                    new MSSQL.Parameter("Time12", SqlDbType.VarChar, 0, ParameterDirection.Input, Time12),
                    new MSSQL.Parameter("HostTeam13", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam13),
                    new MSSQL.Parameter("QuestTeam13", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam13),
                    new MSSQL.Parameter("Time13", SqlDbType.VarChar, 0, ParameterDirection.Input, Time13),
                    new MSSQL.Parameter("HostTeam14", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam14),
                    new MSSQL.Parameter("QuestTeam14", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam14),
                    new MSSQL.Parameter("Time14", SqlDbType.VarChar, 0, ParameterDirection.Input, Time14)
                    );

                return CallResult;
            }

            public static DataSet Open(int Isuse_id, string Isuse, DateTime StartTime, DateTime EndTime, string HostTeam1, string QuestTeam1, string Time1, string HostTeam2, string QuestTeam2, string Time2, string HostTeam3, string QuestTeam3, string Time3, string HostTeam4, string QuestTeam4, string Time4, string HostTeam5, string QuestTeam5, string Time5, string HostTeam6, string QuestTeam6, string Time6, string HostTeam7, string QuestTeam7, string Time7, string HostTeam8, string QuestTeam8, string Time8, string HostTeam9, string QuestTeam9, string Time9, string HostTeam10, string QuestTeam10, string Time10, string HostTeam11, string QuestTeam11, string Time11, string HostTeam12, string QuestTeam12, string Time12, string HostTeam13, string QuestTeam13, string Time13, string HostTeam14, string QuestTeam14, string Time14)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseEditForSFC", ref Outputs,
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("HostTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam1),
                    new MSSQL.Parameter("QuestTeam1", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam1),
                    new MSSQL.Parameter("Time1", SqlDbType.VarChar, 0, ParameterDirection.Input, Time1),
                    new MSSQL.Parameter("HostTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam2),
                    new MSSQL.Parameter("QuestTeam2", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam2),
                    new MSSQL.Parameter("Time2", SqlDbType.VarChar, 0, ParameterDirection.Input, Time2),
                    new MSSQL.Parameter("HostTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam3),
                    new MSSQL.Parameter("QuestTeam3", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam3),
                    new MSSQL.Parameter("Time3", SqlDbType.VarChar, 0, ParameterDirection.Input, Time3),
                    new MSSQL.Parameter("HostTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam4),
                    new MSSQL.Parameter("QuestTeam4", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam4),
                    new MSSQL.Parameter("Time4", SqlDbType.VarChar, 0, ParameterDirection.Input, Time4),
                    new MSSQL.Parameter("HostTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam5),
                    new MSSQL.Parameter("QuestTeam5", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam5),
                    new MSSQL.Parameter("Time5", SqlDbType.VarChar, 0, ParameterDirection.Input, Time5),
                    new MSSQL.Parameter("HostTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam6),
                    new MSSQL.Parameter("QuestTeam6", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam6),
                    new MSSQL.Parameter("Time6", SqlDbType.VarChar, 0, ParameterDirection.Input, Time6),
                    new MSSQL.Parameter("HostTeam7", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam7),
                    new MSSQL.Parameter("QuestTeam7", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam7),
                    new MSSQL.Parameter("Time7", SqlDbType.VarChar, 0, ParameterDirection.Input, Time7),
                    new MSSQL.Parameter("HostTeam8", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam8),
                    new MSSQL.Parameter("QuestTeam8", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam8),
                    new MSSQL.Parameter("Time8", SqlDbType.VarChar, 0, ParameterDirection.Input, Time8),
                    new MSSQL.Parameter("HostTeam9", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam9),
                    new MSSQL.Parameter("QuestTeam9", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam9),
                    new MSSQL.Parameter("Time9", SqlDbType.VarChar, 0, ParameterDirection.Input, Time9),
                    new MSSQL.Parameter("HostTeam10", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam10),
                    new MSSQL.Parameter("QuestTeam10", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam10),
                    new MSSQL.Parameter("Time10", SqlDbType.VarChar, 0, ParameterDirection.Input, Time10),
                    new MSSQL.Parameter("HostTeam11", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam11),
                    new MSSQL.Parameter("QuestTeam11", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam11),
                    new MSSQL.Parameter("Time11", SqlDbType.VarChar, 0, ParameterDirection.Input, Time11),
                    new MSSQL.Parameter("HostTeam12", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam12),
                    new MSSQL.Parameter("QuestTeam12", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam12),
                    new MSSQL.Parameter("Time12", SqlDbType.VarChar, 0, ParameterDirection.Input, Time12),
                    new MSSQL.Parameter("HostTeam13", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam13),
                    new MSSQL.Parameter("QuestTeam13", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam13),
                    new MSSQL.Parameter("Time13", SqlDbType.VarChar, 0, ParameterDirection.Input, Time13),
                    new MSSQL.Parameter("HostTeam14", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam14),
                    new MSSQL.Parameter("QuestTeam14", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam14),
                    new MSSQL.Parameter("Time14", SqlDbType.VarChar, 0, ParameterDirection.Input, Time14)
                    );

                return ds;
            }
        }

        public class P_IsuseEditForZCDC
        {
            public static int Call(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, int CompetitionCount, string ScreeningsAndTime, int Isuse_id, ref int return_int, ref string return_str)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseEditForZCDC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("CompetitionCount", SqlDbType.Int, 0, ParameterDirection.Input, CompetitionCount),
                    new MSSQL.Parameter("ScreeningsAndTime", SqlDbType.VarChar, 0, ParameterDirection.Input, ScreeningsAndTime),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("return_int", SqlDbType.Int, 4, ParameterDirection.Output, return_int),
                    new MSSQL.Parameter("return_str", SqlDbType.VarChar, 100, ParameterDirection.Output, return_str)
                    );

                try
                {
                    return_int = System.Convert.ToInt32(Outputs["return_int"]);
                }
                catch { }

                try
                {
                    return_str = System.Convert.ToString(Outputs["return_str"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int Lottery_id, string Isuse, DateTime StartTime, DateTime EndTime, int CompetitionCount, string ScreeningsAndTime, int Isuse_id, ref int return_int, ref string return_str)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseEditForZCDC", ref Outputs,
                    new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id),
                    new MSSQL.Parameter("Isuse", SqlDbType.VarChar, 0, ParameterDirection.Input, Isuse),
                    new MSSQL.Parameter("StartTime", SqlDbType.DateTime, 0, ParameterDirection.Input, StartTime),
                    new MSSQL.Parameter("EndTime", SqlDbType.DateTime, 0, ParameterDirection.Input, EndTime),
                    new MSSQL.Parameter("CompetitionCount", SqlDbType.Int, 0, ParameterDirection.Input, CompetitionCount),
                    new MSSQL.Parameter("ScreeningsAndTime", SqlDbType.VarChar, 0, ParameterDirection.Input, ScreeningsAndTime),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("return_int", SqlDbType.Int, 4, ParameterDirection.Output, return_int),
                    new MSSQL.Parameter("return_str", SqlDbType.VarChar, 100, ParameterDirection.Output, return_str)
                    );

                try
                {
                    return_int = System.Convert.ToInt32(Outputs["return_int"]);
                }
                catch { }

                try
                {
                    return_str = System.Convert.ToString(Outputs["return_str"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_IsuseEditOneForZCDC
        {
            public static int Call(int id, int TypeId, string HostTeam, string QuestTeam, string Time, int Isuse_id, string LetBall, ref int return_int, ref string return_str)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseEditOneForZCDC", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("TypeId", SqlDbType.Int, 0, ParameterDirection.Input, TypeId),
                    new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    new MSSQL.Parameter("Time", SqlDbType.VarChar, 0, ParameterDirection.Input, Time),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("LetBall", SqlDbType.VarChar, 0, ParameterDirection.Input, LetBall),
                    new MSSQL.Parameter("return_int", SqlDbType.Int, 4, ParameterDirection.Output, return_int),
                    new MSSQL.Parameter("return_str", SqlDbType.VarChar, 100, ParameterDirection.Output, return_str)
                    );

                try
                {
                    return_int = System.Convert.ToInt32(Outputs["return_int"]);
                }
                catch { }

                try
                {
                    return_str = System.Convert.ToString(Outputs["return_str"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int id, int TypeId, string HostTeam, string QuestTeam, string Time, int Isuse_id, string LetBall, ref int return_int, ref string return_str)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseEditOneForZCDC", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("TypeId", SqlDbType.Int, 0, ParameterDirection.Input, TypeId),
                    new MSSQL.Parameter("HostTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, HostTeam),
                    new MSSQL.Parameter("QuestTeam", SqlDbType.VarChar, 0, ParameterDirection.Input, QuestTeam),
                    new MSSQL.Parameter("Time", SqlDbType.VarChar, 0, ParameterDirection.Input, Time),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("LetBall", SqlDbType.VarChar, 0, ParameterDirection.Input, LetBall),
                    new MSSQL.Parameter("return_int", SqlDbType.Int, 4, ParameterDirection.Output, return_int),
                    new MSSQL.Parameter("return_str", SqlDbType.VarChar, 100, ParameterDirection.Output, return_str)
                    );

                try
                {
                    return_int = System.Convert.ToInt32(Outputs["return_int"]);
                }
                catch { }

                try
                {
                    return_str = System.Convert.ToString(Outputs["return_str"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_IsuseInsertOneResultForZCDC
        {
            public static int Call(int id, string HalftimeResult, string Result, string LetBall, string SPFResult, double SPFSp, string ZJQResult, double ZJQSp, string SXDSResult, double SXDSSp, string ZQBFResult, double ZQBFSp, string BQCSPFResult, double BQCSPFSp, ref int return_int, ref string return_str)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_IsuseInsertOneResultForZCDC", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("HalftimeResult", SqlDbType.VarChar, 0, ParameterDirection.Input, HalftimeResult),
                    new MSSQL.Parameter("Result", SqlDbType.VarChar, 0, ParameterDirection.Input, Result),
                    new MSSQL.Parameter("LetBall", SqlDbType.VarChar, 0, ParameterDirection.Input, LetBall),
                    new MSSQL.Parameter("SPFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, SPFResult),
                    new MSSQL.Parameter("SPFSp", SqlDbType.Float, 0, ParameterDirection.Input, SPFSp),
                    new MSSQL.Parameter("ZJQResult", SqlDbType.VarChar, 0, ParameterDirection.Input, ZJQResult),
                    new MSSQL.Parameter("ZJQSp", SqlDbType.Float, 0, ParameterDirection.Input, ZJQSp),
                    new MSSQL.Parameter("SXDSResult", SqlDbType.VarChar, 0, ParameterDirection.Input, SXDSResult),
                    new MSSQL.Parameter("SXDSSp", SqlDbType.Float, 0, ParameterDirection.Input, SXDSSp),
                    new MSSQL.Parameter("ZQBFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, ZQBFResult),
                    new MSSQL.Parameter("ZQBFSp", SqlDbType.Float, 0, ParameterDirection.Input, ZQBFSp),
                    new MSSQL.Parameter("BQCSPFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, BQCSPFResult),
                    new MSSQL.Parameter("BQCSPFSp", SqlDbType.Float, 0, ParameterDirection.Input, BQCSPFSp),
                    new MSSQL.Parameter("return_int", SqlDbType.Int, 4, ParameterDirection.Output, return_int),
                    new MSSQL.Parameter("return_str", SqlDbType.VarChar, 100, ParameterDirection.Output, return_str)
                    );

                try
                {
                    return_int = System.Convert.ToInt32(Outputs["return_int"]);
                }
                catch { }

                try
                {
                    return_str = System.Convert.ToString(Outputs["return_str"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int id, string HalftimeResult, string Result, string LetBall, string SPFResult, double SPFSp, string ZJQResult, double ZJQSp, string SXDSResult, double SXDSSp, string ZQBFResult, double ZQBFSp, string BQCSPFResult, double BQCSPFSp, ref int return_int, ref string return_str)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_IsuseInsertOneResultForZCDC", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("HalftimeResult", SqlDbType.VarChar, 0, ParameterDirection.Input, HalftimeResult),
                    new MSSQL.Parameter("Result", SqlDbType.VarChar, 0, ParameterDirection.Input, Result),
                    new MSSQL.Parameter("LetBall", SqlDbType.VarChar, 0, ParameterDirection.Input, LetBall),
                    new MSSQL.Parameter("SPFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, SPFResult),
                    new MSSQL.Parameter("SPFSp", SqlDbType.Float, 0, ParameterDirection.Input, SPFSp),
                    new MSSQL.Parameter("ZJQResult", SqlDbType.VarChar, 0, ParameterDirection.Input, ZJQResult),
                    new MSSQL.Parameter("ZJQSp", SqlDbType.Float, 0, ParameterDirection.Input, ZJQSp),
                    new MSSQL.Parameter("SXDSResult", SqlDbType.VarChar, 0, ParameterDirection.Input, SXDSResult),
                    new MSSQL.Parameter("SXDSSp", SqlDbType.Float, 0, ParameterDirection.Input, SXDSSp),
                    new MSSQL.Parameter("ZQBFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, ZQBFResult),
                    new MSSQL.Parameter("ZQBFSp", SqlDbType.Float, 0, ParameterDirection.Input, ZQBFSp),
                    new MSSQL.Parameter("BQCSPFResult", SqlDbType.VarChar, 0, ParameterDirection.Input, BQCSPFResult),
                    new MSSQL.Parameter("BQCSPFSp", SqlDbType.Float, 0, ParameterDirection.Input, BQCSPFSp),
                    new MSSQL.Parameter("return_int", SqlDbType.Int, 4, ParameterDirection.Output, return_int),
                    new MSSQL.Parameter("return_str", SqlDbType.VarChar, 100, ParameterDirection.Output, return_str)
                    );

                try
                {
                    return_int = System.Convert.ToInt32(Outputs["return_int"]);
                }
                catch { }

                try
                {
                    return_str = System.Convert.ToString(Outputs["return_str"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_PromotionerAdd
        {
            public static int Call(int User_id, string Name, string Url, string LogoUrl, double BonusScale, bool ON, string Company, string Address, string PostCode, string ResponsiblePerson, string ContactPerson, string Telephone, string Fax, string Mobile, string Email, string QQ, string ServiceTelephone, ref int id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_PromotionerAdd", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("Url", SqlDbType.VarChar, 0, ParameterDirection.Input, Url),
                    new MSSQL.Parameter("LogoUrl", SqlDbType.VarChar, 0, ParameterDirection.Input, LogoUrl),
                    new MSSQL.Parameter("BonusScale", SqlDbType.Float, 0, ParameterDirection.Input, BonusScale),
                    new MSSQL.Parameter("ON", SqlDbType.Bit, 0, ParameterDirection.Input, ON),
                    new MSSQL.Parameter("Company", SqlDbType.VarChar, 0, ParameterDirection.Input, Company),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("PostCode", SqlDbType.VarChar, 0, ParameterDirection.Input, PostCode),
                    new MSSQL.Parameter("ResponsiblePerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ResponsiblePerson),
                    new MSSQL.Parameter("ContactPerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ContactPerson),
                    new MSSQL.Parameter("Telephone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telephone),
                    new MSSQL.Parameter("Fax", SqlDbType.VarChar, 0, ParameterDirection.Input, Fax),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("ServiceTelephone", SqlDbType.VarChar, 0, ParameterDirection.Input, ServiceTelephone),
                    new MSSQL.Parameter("id", SqlDbType.Int, 4, ParameterDirection.Output, id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    id = System.Convert.ToInt32(Outputs["id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, string Name, string Url, string LogoUrl, double BonusScale, bool ON, string Company, string Address, string PostCode, string ResponsiblePerson, string ContactPerson, string Telephone, string Fax, string Mobile, string Email, string QQ, string ServiceTelephone, ref int id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_PromotionerAdd", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("Url", SqlDbType.VarChar, 0, ParameterDirection.Input, Url),
                    new MSSQL.Parameter("LogoUrl", SqlDbType.VarChar, 0, ParameterDirection.Input, LogoUrl),
                    new MSSQL.Parameter("BonusScale", SqlDbType.Float, 0, ParameterDirection.Input, BonusScale),
                    new MSSQL.Parameter("ON", SqlDbType.Bit, 0, ParameterDirection.Input, ON),
                    new MSSQL.Parameter("Company", SqlDbType.VarChar, 0, ParameterDirection.Input, Company),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("PostCode", SqlDbType.VarChar, 0, ParameterDirection.Input, PostCode),
                    new MSSQL.Parameter("ResponsiblePerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ResponsiblePerson),
                    new MSSQL.Parameter("ContactPerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ContactPerson),
                    new MSSQL.Parameter("Telephone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telephone),
                    new MSSQL.Parameter("Fax", SqlDbType.VarChar, 0, ParameterDirection.Input, Fax),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("ServiceTelephone", SqlDbType.VarChar, 0, ParameterDirection.Input, ServiceTelephone),
                    new MSSQL.Parameter("id", SqlDbType.Int, 4, ParameterDirection.Output, id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    id = System.Convert.ToInt32(Outputs["id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_PromotionerEdit
        {
            public static int Call(int id, string Name, string Url, string LogoUrl, double BonusScale, bool ON, string Company, string Address, string PostCode, string ResponsiblePerson, string ContactPerson, string Telephone, string Fax, string Mobile, string Email, string QQ, string ServiceTelephone, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_PromotionerEdit", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("Url", SqlDbType.VarChar, 0, ParameterDirection.Input, Url),
                    new MSSQL.Parameter("LogoUrl", SqlDbType.VarChar, 0, ParameterDirection.Input, LogoUrl),
                    new MSSQL.Parameter("BonusScale", SqlDbType.Float, 0, ParameterDirection.Input, BonusScale),
                    new MSSQL.Parameter("ON", SqlDbType.Bit, 0, ParameterDirection.Input, ON),
                    new MSSQL.Parameter("Company", SqlDbType.VarChar, 0, ParameterDirection.Input, Company),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("PostCode", SqlDbType.VarChar, 0, ParameterDirection.Input, PostCode),
                    new MSSQL.Parameter("ResponsiblePerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ResponsiblePerson),
                    new MSSQL.Parameter("ContactPerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ContactPerson),
                    new MSSQL.Parameter("Telephone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telephone),
                    new MSSQL.Parameter("Fax", SqlDbType.VarChar, 0, ParameterDirection.Input, Fax),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("ServiceTelephone", SqlDbType.VarChar, 0, ParameterDirection.Input, ServiceTelephone),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int id, string Name, string Url, string LogoUrl, double BonusScale, bool ON, string Company, string Address, string PostCode, string ResponsiblePerson, string ContactPerson, string Telephone, string Fax, string Mobile, string Email, string QQ, string ServiceTelephone, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_PromotionerEdit", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("Url", SqlDbType.VarChar, 0, ParameterDirection.Input, Url),
                    new MSSQL.Parameter("LogoUrl", SqlDbType.VarChar, 0, ParameterDirection.Input, LogoUrl),
                    new MSSQL.Parameter("BonusScale", SqlDbType.Float, 0, ParameterDirection.Input, BonusScale),
                    new MSSQL.Parameter("ON", SqlDbType.Bit, 0, ParameterDirection.Input, ON),
                    new MSSQL.Parameter("Company", SqlDbType.VarChar, 0, ParameterDirection.Input, Company),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("PostCode", SqlDbType.VarChar, 0, ParameterDirection.Input, PostCode),
                    new MSSQL.Parameter("ResponsiblePerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ResponsiblePerson),
                    new MSSQL.Parameter("ContactPerson", SqlDbType.VarChar, 0, ParameterDirection.Input, ContactPerson),
                    new MSSQL.Parameter("Telephone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telephone),
                    new MSSQL.Parameter("Fax", SqlDbType.VarChar, 0, ParameterDirection.Input, Fax),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("ServiceTelephone", SqlDbType.VarChar, 0, ParameterDirection.Input, ServiceTelephone),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_Quash
        {
            public static int Call(int id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_Quash", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_Quash", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_QuashChase
        {
            public static int Call(int ChaseIsuse_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_QuashChase", ref Outputs,
                    new MSSQL.Parameter("ChaseIsuse_id", SqlDbType.Int, 0, ParameterDirection.Input, ChaseIsuse_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int ChaseIsuse_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_QuashChase", ref Outputs,
                    new MSSQL.Parameter("ChaseIsuse_id", SqlDbType.Int, 0, ParameterDirection.Input, ChaseIsuse_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_QuashChaseAll
        {
            public static int Call(int Chase_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_QuashChaseAll", ref Outputs,
                    new MSSQL.Parameter("Chase_id", SqlDbType.Int, 0, ParameterDirection.Input, Chase_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int Chase_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_QuashChaseAll", ref Outputs,
                    new MSSQL.Parameter("Chase_id", SqlDbType.Int, 0, ParameterDirection.Input, Chase_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_QuashScheme
        {
            public static int Call(int Scheme_id, bool isSystemQuashed, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_QuashScheme", ref Outputs,
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("isSystemQuashed", SqlDbType.Bit, 0, ParameterDirection.Input, isSystemQuashed),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int Scheme_id, bool isSystemQuashed, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_QuashScheme", ref Outputs,
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("isSystemQuashed", SqlDbType.Bit, 0, ParameterDirection.Input, isSystemQuashed),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_SchemeBuyed
        {
            public static int Call(int Scheme_id, byte[] LotteryCode, int ScoringOfSelfBuy, int ScoringOfCommendBuy, int BuyOperator_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SchemeBuyed", ref Outputs,
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("LotteryCode", SqlDbType.Image, 0, ParameterDirection.Input, LotteryCode),
                    new MSSQL.Parameter("ScoringOfSelfBuy", SqlDbType.Int, 0, ParameterDirection.Input, ScoringOfSelfBuy),
                    new MSSQL.Parameter("ScoringOfCommendBuy", SqlDbType.Int, 0, ParameterDirection.Input, ScoringOfCommendBuy),
                    new MSSQL.Parameter("BuyOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyOperator_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int Scheme_id, byte[] LotteryCode, int ScoringOfSelfBuy, int ScoringOfCommendBuy, int BuyOperator_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeBuyed", ref Outputs,
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("LotteryCode", SqlDbType.Image, 0, ParameterDirection.Input, LotteryCode),
                    new MSSQL.Parameter("ScoringOfSelfBuy", SqlDbType.Int, 0, ParameterDirection.Input, ScoringOfSelfBuy),
                    new MSSQL.Parameter("ScoringOfCommendBuy", SqlDbType.Int, 0, ParameterDirection.Input, ScoringOfCommendBuy),
                    new MSSQL.Parameter("BuyOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, BuyOperator_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_SchemeChatAddUser
        {
            public static int Call(int SchemeID, int UserID, byte[] Text, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SchemeChatAddUser", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID),
                    new MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, Text),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int SchemeID, int UserID, byte[] Text, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatAddUser", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID),
                    new MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, Text),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_SchemeChatContentAdd
        {
            public static int Call(int SchemeID, int FromUserID, int ToUserID, byte[] Text, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SchemeChatContentAdd", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("FromUserID", SqlDbType.Int, 0, ParameterDirection.Input, FromUserID),
                    new MSSQL.Parameter("ToUserID", SqlDbType.Int, 0, ParameterDirection.Input, ToUserID),
                    new MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, Text),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int SchemeID, int FromUserID, int ToUserID, byte[] Text, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatContentAdd", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("FromUserID", SqlDbType.Int, 0, ParameterDirection.Input, FromUserID),
                    new MSSQL.Parameter("ToUserID", SqlDbType.Int, 0, ParameterDirection.Input, ToUserID),
                    new MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, Text),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_SchemeChatDelUser
        {
            public static int Call(int SchemeID, int UserID, byte[] Text, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SchemeChatDelUser", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID),
                    new MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, Text),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int SchemeID, int UserID, byte[] Text, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatDelUser", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID),
                    new MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, Text),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_SchemeSystemDeal
        {
            public static int Call(ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SchemeSystemDeal", ref Outputs,
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeSystemDeal", ref Outputs,
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_SchemeSystemDealForZCDC
        {
            public static int Call(int SchemeID, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SchemeSystemDealForZCDC", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int SchemeID, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeSystemDealForZCDC", ref Outputs,
                    new MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_SchemeWinDispense
        {
            public static int Call(int Scheme_id, double WinMoney, double WinMoneyNoWithTax, int InitiateSchemeCommissionScale, byte[] WinDescription, int WinOperator_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SchemeWinDispense", ref Outputs,
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("WinMoney", SqlDbType.Money, 0, ParameterDirection.Input, WinMoney),
                    new MSSQL.Parameter("WinMoneyNoWithTax", SqlDbType.Money, 0, ParameterDirection.Input, WinMoneyNoWithTax),
                    new MSSQL.Parameter("InitiateSchemeCommissionScale", SqlDbType.Int, 0, ParameterDirection.Input, InitiateSchemeCommissionScale),
                    new MSSQL.Parameter("WinDescription", SqlDbType.Image, 0, ParameterDirection.Input, WinDescription),
                    new MSSQL.Parameter("WinOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, WinOperator_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int Scheme_id, double WinMoney, double WinMoneyNoWithTax, int InitiateSchemeCommissionScale, byte[] WinDescription, int WinOperator_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeWinDispense", ref Outputs,
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("WinMoney", SqlDbType.Money, 0, ParameterDirection.Input, WinMoney),
                    new MSSQL.Parameter("WinMoneyNoWithTax", SqlDbType.Money, 0, ParameterDirection.Input, WinMoneyNoWithTax),
                    new MSSQL.Parameter("InitiateSchemeCommissionScale", SqlDbType.Int, 0, ParameterDirection.Input, InitiateSchemeCommissionScale),
                    new MSSQL.Parameter("WinDescription", SqlDbType.Image, 0, ParameterDirection.Input, WinDescription),
                    new MSSQL.Parameter("WinOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, WinOperator_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_ScoringChange
        {
            public static int Call(int User_id, int Scoring, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_ScoringChange", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Scoring", SqlDbType.Int, 0, ParameterDirection.Input, Scoring),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, int Scoring, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_ScoringChange", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Scoring", SqlDbType.Int, 0, ParameterDirection.Input, Scoring),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_SetIsUsedLotteryList
        {
            public static int Call(string List)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SetIsUsedLotteryList", ref Outputs,
                    new MSSQL.Parameter("List", SqlDbType.VarChar, 0, ParameterDirection.Input, List)
                    );

                return CallResult;
            }

            public static DataSet Open(string List)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SetIsUsedLotteryList", ref Outputs,
                    new MSSQL.Parameter("List", SqlDbType.VarChar, 0, ParameterDirection.Input, List)
                    );

                return ds;
            }
        }

        public class P_SetZCDCBuyPageType
        {
            public static int Call(int Type)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SetZCDCBuyPageType", ref Outputs,
                    new MSSQL.Parameter("Type", SqlDbType.Int, 0, ParameterDirection.Input, Type)
                    );

                return CallResult;
            }

            public static DataSet Open(int Type)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SetZCDCBuyPageType", ref Outputs,
                    new MSSQL.Parameter("Type", SqlDbType.Int, 0, ParameterDirection.Input, Type)
                    );

                return ds;
            }
        }

        public class P_SurrogateBuy
        {
            public static int Call(int User_id, string Title, byte[] Description, int Isuse_id, int Type_id, byte[] LotteryNumber, int Multiple, double Money, string SchemeFileName, int SecrecyLevel, ref int Scheme_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_SurrogateBuy", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("SchemeFileName", SqlDbType.VarChar, 0, ParameterDirection.Input, SchemeFileName),
                    new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 4, ParameterDirection.Output, Scheme_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Scheme_id = System.Convert.ToInt32(Outputs["Scheme_id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, string Title, byte[] Description, int Isuse_id, int Type_id, byte[] LotteryNumber, int Multiple, double Money, string SchemeFileName, int SecrecyLevel, ref int Scheme_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_SurrogateBuy", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Title", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
                    new MSSQL.Parameter("Description", SqlDbType.Image, 0, ParameterDirection.Input, Description),
                    new MSSQL.Parameter("Isuse_id", SqlDbType.Int, 0, ParameterDirection.Input, Isuse_id),
                    new MSSQL.Parameter("Type_id", SqlDbType.Int, 0, ParameterDirection.Input, Type_id),
                    new MSSQL.Parameter("LotteryNumber", SqlDbType.Image, 0, ParameterDirection.Input, LotteryNumber),
                    new MSSQL.Parameter("Multiple", SqlDbType.Int, 0, ParameterDirection.Input, Multiple),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("SchemeFileName", SqlDbType.VarChar, 0, ParameterDirection.Input, SchemeFileName),
                    new MSSQL.Parameter("SecrecyLevel", SqlDbType.Int, 0, ParameterDirection.Input, SecrecyLevel),
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 4, ParameterDirection.Output, Scheme_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Scheme_id = System.Convert.ToInt32(Outputs["Scheme_id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_TrendChart_FC3D
        {
            public static int Call(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_TrendChart_FC3D", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return CallResult;
            }

            public static DataSet Open(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_TrendChart_FC3D", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return ds;
            }
        }

        public class P_TrendChart_QLC
        {
            public static int Call(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_TrendChart_QLC", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return CallResult;
            }

            public static DataSet Open(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_TrendChart_QLC", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return ds;
            }
        }

        public class P_TrendChart_QXC
        {
            public static int Call(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_TrendChart_QXC", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return CallResult;
            }

            public static DataSet Open(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_TrendChart_QXC", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return ds;
            }
        }

        public class P_TrendChart_SSQ
        {
            public static int Call(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_TrendChart_SSQ", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return CallResult;
            }

            public static DataSet Open(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_TrendChart_SSQ", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return ds;
            }
        }

        public class P_TrendChart_SZPL
        {
            public static int Call(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_TrendChart_SZPL", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return CallResult;
            }

            public static DataSet Open(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_TrendChart_SZPL", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return ds;
            }
        }

        public class P_TrendChart_SZPL_5
        {
            public static int Call(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_TrendChart_SZPL_5", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return CallResult;
            }

            public static DataSet Open(int IsuseNum)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_TrendChart_SZPL_5", ref Outputs,
                    new MSSQL.Parameter("IsuseNum", SqlDbType.Int, 0, ParameterDirection.Input, IsuseNum)
                    );

                return ds;
            }
        }

        public class P_UpdateForLeagueTypeForZCDC
        {
            public static int Call(int id, string LeagueTypeName, string LeagueColor, ref int returnInt, ref string returnStr)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_UpdateForLeagueTypeForZCDC", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("LeagueTypeName", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueTypeName),
                    new MSSQL.Parameter("LeagueColor", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueColor),
                    new MSSQL.Parameter("returnInt", SqlDbType.Int, 4, ParameterDirection.Output, returnInt),
                    new MSSQL.Parameter("returnStr", SqlDbType.VarChar, 100, ParameterDirection.Output, returnStr)
                    );

                try
                {
                    returnInt = System.Convert.ToInt32(Outputs["returnInt"]);
                }
                catch { }

                try
                {
                    returnStr = System.Convert.ToString(Outputs["returnStr"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int id, string LeagueTypeName, string LeagueColor, ref int returnInt, ref string returnStr)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_UpdateForLeagueTypeForZCDC", ref Outputs,
                    new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, id),
                    new MSSQL.Parameter("LeagueTypeName", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueTypeName),
                    new MSSQL.Parameter("LeagueColor", SqlDbType.VarChar, 0, ParameterDirection.Input, LeagueColor),
                    new MSSQL.Parameter("returnInt", SqlDbType.Int, 4, ParameterDirection.Output, returnInt),
                    new MSSQL.Parameter("returnStr", SqlDbType.VarChar, 100, ParameterDirection.Output, returnStr)
                    );

                try
                {
                    returnInt = System.Convert.ToInt32(Outputs["returnInt"]);
                }
                catch { }

                try
                {
                    returnStr = System.Convert.ToString(Outputs["returnStr"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_UserAdd
        {
            public static int Call(string Name, string RealityName, string Password, string Password_2, string Sex, DateTime BirthDay, string IDCardNumber, string Address, string Email, string QQ, string Telphone, string Mobile, bool MobileValid, bool Privacy, DateTime RegisterTime, int UserType, bool isAcceptMobileMessage, string AcceptMobileMessageList, bool isAcceptEmail, bool isAcceptMessage, int HigherUp_id, int Promotioner_id, bool isAlipayMember, string bbs_Password, ref int User_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_UserAdd", ref Outputs,
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 0, ParameterDirection.Input, RealityName),
                    new MSSQL.Parameter("Password", SqlDbType.VarChar, 0, ParameterDirection.Input, Password),
                    new MSSQL.Parameter("Password_2", SqlDbType.VarChar, 0, ParameterDirection.Input, Password_2),
                    new MSSQL.Parameter("Sex", SqlDbType.Char, 0, ParameterDirection.Input, Sex),
                    new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 0, ParameterDirection.Input, BirthDay),
                    new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, IDCardNumber),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 0, ParameterDirection.Input, MobileValid),
                    new MSSQL.Parameter("Privacy", SqlDbType.Bit, 0, ParameterDirection.Input, Privacy),
                    new MSSQL.Parameter("RegisterTime", SqlDbType.DateTime, 0, ParameterDirection.Input, RegisterTime),
                    new MSSQL.Parameter("UserType", SqlDbType.Int, 0, ParameterDirection.Input, UserType),
                    new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMobileMessage),
                    new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 0, ParameterDirection.Input, AcceptMobileMessageList),
                    new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptEmail),
                    new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMessage),
                    new MSSQL.Parameter("HigherUp_id", SqlDbType.Int, 0, ParameterDirection.Input, HigherUp_id),
                    new MSSQL.Parameter("Promotioner_id", SqlDbType.Int, 0, ParameterDirection.Input, Promotioner_id),
                    new MSSQL.Parameter("isAlipayMember", SqlDbType.Bit, 0, ParameterDirection.Input, isAlipayMember),
                    new MSSQL.Parameter("bbs_Password", SqlDbType.VarChar, 0, ParameterDirection.Input, bbs_Password),
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 4, ParameterDirection.Output, User_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    User_id = System.Convert.ToInt32(Outputs["User_id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(string Name, string RealityName, string Password, string Password_2, string Sex, DateTime BirthDay, string IDCardNumber, string Address, string Email, string QQ, string Telphone, string Mobile, bool MobileValid, bool Privacy, DateTime RegisterTime, int UserType, bool isAcceptMobileMessage, string AcceptMobileMessageList, bool isAcceptEmail, bool isAcceptMessage, int HigherUp_id, int Promotioner_id, bool isAlipayMember, string bbs_Password, ref int User_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_UserAdd", ref Outputs,
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 0, ParameterDirection.Input, RealityName),
                    new MSSQL.Parameter("Password", SqlDbType.VarChar, 0, ParameterDirection.Input, Password),
                    new MSSQL.Parameter("Password_2", SqlDbType.VarChar, 0, ParameterDirection.Input, Password_2),
                    new MSSQL.Parameter("Sex", SqlDbType.Char, 0, ParameterDirection.Input, Sex),
                    new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 0, ParameterDirection.Input, BirthDay),
                    new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, IDCardNumber),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 0, ParameterDirection.Input, MobileValid),
                    new MSSQL.Parameter("Privacy", SqlDbType.Bit, 0, ParameterDirection.Input, Privacy),
                    new MSSQL.Parameter("RegisterTime", SqlDbType.DateTime, 0, ParameterDirection.Input, RegisterTime),
                    new MSSQL.Parameter("UserType", SqlDbType.Int, 0, ParameterDirection.Input, UserType),
                    new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMobileMessage),
                    new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 0, ParameterDirection.Input, AcceptMobileMessageList),
                    new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptEmail),
                    new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMessage),
                    new MSSQL.Parameter("HigherUp_id", SqlDbType.Int, 0, ParameterDirection.Input, HigherUp_id),
                    new MSSQL.Parameter("Promotioner_id", SqlDbType.Int, 0, ParameterDirection.Input, Promotioner_id),
                    new MSSQL.Parameter("isAlipayMember", SqlDbType.Bit, 0, ParameterDirection.Input, isAlipayMember),
                    new MSSQL.Parameter("bbs_Password", SqlDbType.VarChar, 0, ParameterDirection.Input, bbs_Password),
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 4, ParameterDirection.Output, User_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    User_id = System.Convert.ToInt32(Outputs["User_id"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_UserAddMoney_1
        {
            public static int Call(int User_id, double AddMoney, double Commission, string PayNumber, string PayBank, string PayRemark1, string PayRemark2, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_UserAddMoney_1", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("AddMoney", SqlDbType.Money, 0, ParameterDirection.Input, AddMoney),
                    new MSSQL.Parameter("Commission", SqlDbType.Money, 0, ParameterDirection.Input, Commission),
                    new MSSQL.Parameter("PayNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, PayNumber),
                    new MSSQL.Parameter("PayBank", SqlDbType.VarChar, 0, ParameterDirection.Input, PayBank),
                    new MSSQL.Parameter("PayRemark1", SqlDbType.VarChar, 0, ParameterDirection.Input, PayRemark1),
                    new MSSQL.Parameter("PayRemark2", SqlDbType.VarChar, 0, ParameterDirection.Input, PayRemark2),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, double AddMoney, double Commission, string PayNumber, string PayBank, string PayRemark1, string PayRemark2, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_UserAddMoney_1", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("AddMoney", SqlDbType.Money, 0, ParameterDirection.Input, AddMoney),
                    new MSSQL.Parameter("Commission", SqlDbType.Money, 0, ParameterDirection.Input, Commission),
                    new MSSQL.Parameter("PayNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, PayNumber),
                    new MSSQL.Parameter("PayBank", SqlDbType.VarChar, 0, ParameterDirection.Input, PayBank),
                    new MSSQL.Parameter("PayRemark1", SqlDbType.VarChar, 0, ParameterDirection.Input, PayRemark1),
                    new MSSQL.Parameter("PayRemark2", SqlDbType.VarChar, 0, ParameterDirection.Input, PayRemark2),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_UserAddMoney_2
        {
            public static int Call(int User_id, int OperatorType, double AddMoney, string Memo, int PayOperator_id, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_UserAddMoney_2", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("OperatorType", SqlDbType.Int, 0, ParameterDirection.Input, OperatorType),
                    new MSSQL.Parameter("AddMoney", SqlDbType.Money, 0, ParameterDirection.Input, AddMoney),
                    new MSSQL.Parameter("Memo", SqlDbType.VarChar, 0, ParameterDirection.Input, Memo),
                    new MSSQL.Parameter("PayOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, PayOperator_id),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, int OperatorType, double AddMoney, string Memo, int PayOperator_id, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_UserAddMoney_2", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("OperatorType", SqlDbType.Int, 0, ParameterDirection.Input, OperatorType),
                    new MSSQL.Parameter("AddMoney", SqlDbType.Money, 0, ParameterDirection.Input, AddMoney),
                    new MSSQL.Parameter("Memo", SqlDbType.VarChar, 0, ParameterDirection.Input, Memo),
                    new MSSQL.Parameter("PayOperator_id", SqlDbType.Int, 0, ParameterDirection.Input, PayOperator_id),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_UserEditByID
        {
            public static int Call(string RealityName, string Password, string Password_2, string Sex, DateTime BirthDay, string IDCardNumber, string Address, string Email, string QQ, string Telphone, string Mobile, bool MobileValid, bool Privacy, bool Blacklist, bool ManagementRights, string ManagementRightsList, bool SuperManagementRights, int UserType, string Province, string City, string BankType, string BankName, string BankCardNumber, bool isAcceptMobileMessage, string AcceptMobileMessageList, bool isAcceptEmail, bool isAcceptMessage, string bbs_Password, int User_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_UserEditByID", ref Outputs,
                    new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 0, ParameterDirection.Input, RealityName),
                    new MSSQL.Parameter("Password", SqlDbType.VarChar, 0, ParameterDirection.Input, Password),
                    new MSSQL.Parameter("Password_2", SqlDbType.VarChar, 0, ParameterDirection.Input, Password_2),
                    new MSSQL.Parameter("Sex", SqlDbType.Char, 0, ParameterDirection.Input, Sex),
                    new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 0, ParameterDirection.Input, BirthDay),
                    new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, IDCardNumber),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 0, ParameterDirection.Input, MobileValid),
                    new MSSQL.Parameter("Privacy", SqlDbType.Bit, 0, ParameterDirection.Input, Privacy),
                    new MSSQL.Parameter("Blacklist", SqlDbType.Bit, 0, ParameterDirection.Input, Blacklist),
                    new MSSQL.Parameter("ManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, ManagementRights),
                    new MSSQL.Parameter("ManagementRightsList", SqlDbType.VarChar, 0, ParameterDirection.Input, ManagementRightsList),
                    new MSSQL.Parameter("SuperManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, SuperManagementRights),
                    new MSSQL.Parameter("UserType", SqlDbType.Int, 0, ParameterDirection.Input, UserType),
                    new MSSQL.Parameter("Province", SqlDbType.VarChar, 0, ParameterDirection.Input, Province),
                    new MSSQL.Parameter("City", SqlDbType.VarChar, 0, ParameterDirection.Input, City),
                    new MSSQL.Parameter("BankType", SqlDbType.VarChar, 0, ParameterDirection.Input, BankType),
                    new MSSQL.Parameter("BankName", SqlDbType.VarChar, 0, ParameterDirection.Input, BankName),
                    new MSSQL.Parameter("BankCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, BankCardNumber),
                    new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMobileMessage),
                    new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 0, ParameterDirection.Input, AcceptMobileMessageList),
                    new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptEmail),
                    new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMessage),
                    new MSSQL.Parameter("bbs_Password", SqlDbType.VarChar, 0, ParameterDirection.Input, bbs_Password),
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(string RealityName, string Password, string Password_2, string Sex, DateTime BirthDay, string IDCardNumber, string Address, string Email, string QQ, string Telphone, string Mobile, bool MobileValid, bool Privacy, bool Blacklist, bool ManagementRights, string ManagementRightsList, bool SuperManagementRights, int UserType, string Province, string City, string BankType, string BankName, string BankCardNumber, bool isAcceptMobileMessage, string AcceptMobileMessageList, bool isAcceptEmail, bool isAcceptMessage, string bbs_Password, int User_id, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_UserEditByID", ref Outputs,
                    new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 0, ParameterDirection.Input, RealityName),
                    new MSSQL.Parameter("Password", SqlDbType.VarChar, 0, ParameterDirection.Input, Password),
                    new MSSQL.Parameter("Password_2", SqlDbType.VarChar, 0, ParameterDirection.Input, Password_2),
                    new MSSQL.Parameter("Sex", SqlDbType.Char, 0, ParameterDirection.Input, Sex),
                    new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 0, ParameterDirection.Input, BirthDay),
                    new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, IDCardNumber),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 0, ParameterDirection.Input, MobileValid),
                    new MSSQL.Parameter("Privacy", SqlDbType.Bit, 0, ParameterDirection.Input, Privacy),
                    new MSSQL.Parameter("Blacklist", SqlDbType.Bit, 0, ParameterDirection.Input, Blacklist),
                    new MSSQL.Parameter("ManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, ManagementRights),
                    new MSSQL.Parameter("ManagementRightsList", SqlDbType.VarChar, 0, ParameterDirection.Input, ManagementRightsList),
                    new MSSQL.Parameter("SuperManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, SuperManagementRights),
                    new MSSQL.Parameter("UserType", SqlDbType.Int, 0, ParameterDirection.Input, UserType),
                    new MSSQL.Parameter("Province", SqlDbType.VarChar, 0, ParameterDirection.Input, Province),
                    new MSSQL.Parameter("City", SqlDbType.VarChar, 0, ParameterDirection.Input, City),
                    new MSSQL.Parameter("BankType", SqlDbType.VarChar, 0, ParameterDirection.Input, BankType),
                    new MSSQL.Parameter("BankName", SqlDbType.VarChar, 0, ParameterDirection.Input, BankName),
                    new MSSQL.Parameter("BankCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, BankCardNumber),
                    new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMobileMessage),
                    new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 0, ParameterDirection.Input, AcceptMobileMessageList),
                    new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptEmail),
                    new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMessage),
                    new MSSQL.Parameter("bbs_Password", SqlDbType.VarChar, 0, ParameterDirection.Input, bbs_Password),
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_UserEditByName
        {
            public static int Call(string RealityName, string Password, string Password_2, string Sex, DateTime BirthDay, string IDCardNumber, string Address, string Email, string QQ, string Telphone, string Mobile, bool MobileValid, bool Privacy, bool Blacklist, bool ManagementRights, string ManagementRightsList, bool SuperManagementRights, int UserType, string Province, string City, string BankType, string BankName, string BankCardNumber, bool isAcceptMobileMessage, string AcceptMobileMessageList, bool isAcceptEmail, bool isAcceptMessage, string bbs_Password, string Name, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_UserEditByName", ref Outputs,
                    new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 0, ParameterDirection.Input, RealityName),
                    new MSSQL.Parameter("Password", SqlDbType.VarChar, 0, ParameterDirection.Input, Password),
                    new MSSQL.Parameter("Password_2", SqlDbType.VarChar, 0, ParameterDirection.Input, Password_2),
                    new MSSQL.Parameter("Sex", SqlDbType.Char, 0, ParameterDirection.Input, Sex),
                    new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 0, ParameterDirection.Input, BirthDay),
                    new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, IDCardNumber),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 0, ParameterDirection.Input, MobileValid),
                    new MSSQL.Parameter("Privacy", SqlDbType.Bit, 0, ParameterDirection.Input, Privacy),
                    new MSSQL.Parameter("Blacklist", SqlDbType.Bit, 0, ParameterDirection.Input, Blacklist),
                    new MSSQL.Parameter("ManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, ManagementRights),
                    new MSSQL.Parameter("ManagementRightsList", SqlDbType.VarChar, 0, ParameterDirection.Input, ManagementRightsList),
                    new MSSQL.Parameter("SuperManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, SuperManagementRights),
                    new MSSQL.Parameter("UserType", SqlDbType.Int, 0, ParameterDirection.Input, UserType),
                    new MSSQL.Parameter("Province", SqlDbType.VarChar, 0, ParameterDirection.Input, Province),
                    new MSSQL.Parameter("City", SqlDbType.VarChar, 0, ParameterDirection.Input, City),
                    new MSSQL.Parameter("BankType", SqlDbType.VarChar, 0, ParameterDirection.Input, BankType),
                    new MSSQL.Parameter("BankName", SqlDbType.VarChar, 0, ParameterDirection.Input, BankName),
                    new MSSQL.Parameter("BankCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, BankCardNumber),
                    new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMobileMessage),
                    new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 0, ParameterDirection.Input, AcceptMobileMessageList),
                    new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptEmail),
                    new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMessage),
                    new MSSQL.Parameter("bbs_Password", SqlDbType.VarChar, 0, ParameterDirection.Input, bbs_Password),
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(string RealityName, string Password, string Password_2, string Sex, DateTime BirthDay, string IDCardNumber, string Address, string Email, string QQ, string Telphone, string Mobile, bool MobileValid, bool Privacy, bool Blacklist, bool ManagementRights, string ManagementRightsList, bool SuperManagementRights, int UserType, string Province, string City, string BankType, string BankName, string BankCardNumber, bool isAcceptMobileMessage, string AcceptMobileMessageList, bool isAcceptEmail, bool isAcceptMessage, string bbs_Password, string Name, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_UserEditByName", ref Outputs,
                    new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 0, ParameterDirection.Input, RealityName),
                    new MSSQL.Parameter("Password", SqlDbType.VarChar, 0, ParameterDirection.Input, Password),
                    new MSSQL.Parameter("Password_2", SqlDbType.VarChar, 0, ParameterDirection.Input, Password_2),
                    new MSSQL.Parameter("Sex", SqlDbType.Char, 0, ParameterDirection.Input, Sex),
                    new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 0, ParameterDirection.Input, BirthDay),
                    new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, IDCardNumber),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 0, ParameterDirection.Input, Address),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 0, ParameterDirection.Input, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 0, ParameterDirection.Input, QQ),
                    new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 0, ParameterDirection.Input, Telphone),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 0, ParameterDirection.Input, MobileValid),
                    new MSSQL.Parameter("Privacy", SqlDbType.Bit, 0, ParameterDirection.Input, Privacy),
                    new MSSQL.Parameter("Blacklist", SqlDbType.Bit, 0, ParameterDirection.Input, Blacklist),
                    new MSSQL.Parameter("ManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, ManagementRights),
                    new MSSQL.Parameter("ManagementRightsList", SqlDbType.VarChar, 0, ParameterDirection.Input, ManagementRightsList),
                    new MSSQL.Parameter("SuperManagementRights", SqlDbType.Bit, 0, ParameterDirection.Input, SuperManagementRights),
                    new MSSQL.Parameter("UserType", SqlDbType.Int, 0, ParameterDirection.Input, UserType),
                    new MSSQL.Parameter("Province", SqlDbType.VarChar, 0, ParameterDirection.Input, Province),
                    new MSSQL.Parameter("City", SqlDbType.VarChar, 0, ParameterDirection.Input, City),
                    new MSSQL.Parameter("BankType", SqlDbType.VarChar, 0, ParameterDirection.Input, BankType),
                    new MSSQL.Parameter("BankName", SqlDbType.VarChar, 0, ParameterDirection.Input, BankName),
                    new MSSQL.Parameter("BankCardNumber", SqlDbType.VarChar, 0, ParameterDirection.Input, BankCardNumber),
                    new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMobileMessage),
                    new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 0, ParameterDirection.Input, AcceptMobileMessageList),
                    new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptEmail),
                    new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 0, ParameterDirection.Input, isAcceptMessage),
                    new MSSQL.Parameter("bbs_Password", SqlDbType.VarChar, 0, ParameterDirection.Input, bbs_Password),
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_UserLogin
        {
            public static int Call(string Name, string InputPassword, string UnEncryptedPassword, string LoginIP, bool LoginWriteLog, bool isAliPayLogin, ref int id, ref string RealityName, ref string Sex, ref DateTime BirthDay, ref string IDCardNumber, ref string Address, ref string Email, ref string QQ, ref string Telphone, ref string Mobile, ref bool MobileValid, ref bool Privacy, ref bool Blacklist, ref DateTime RegisterTime, ref DateTime LastLoginTime, ref string LastLoginIP, ref bool ManagementRights, ref string ManagementRightsList, ref bool SuperManagementRights, ref int UserType, ref double Balance, ref double FreezeMoney, ref int Scoring, ref int LoginNum, ref string Province, ref string City, ref string BankType, ref string BankName, ref string BankCardNumber, ref bool isAcceptMobileMessage, ref string AcceptMobileMessageList, ref bool isAcceptEmail, ref bool isAcceptMessage, ref int HigherUp_id, ref int Promotioner_id, ref bool isAlipayMember, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_UserLogin", ref Outputs,
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("InputPassword", SqlDbType.VarChar, 0, ParameterDirection.Input, InputPassword),
                    new MSSQL.Parameter("UnEncryptedPassword", SqlDbType.VarChar, 0, ParameterDirection.Input, UnEncryptedPassword),
                    new MSSQL.Parameter("LoginIP", SqlDbType.VarChar, 0, ParameterDirection.Input, LoginIP),
                    new MSSQL.Parameter("LoginWriteLog", SqlDbType.Bit, 0, ParameterDirection.Input, LoginWriteLog),
                    new MSSQL.Parameter("isAliPayLogin", SqlDbType.Bit, 0, ParameterDirection.Input, isAliPayLogin),
                    new MSSQL.Parameter("id", SqlDbType.Int, 4, ParameterDirection.Output, id),
                    new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 50, ParameterDirection.Output, RealityName),
                    new MSSQL.Parameter("Sex", SqlDbType.Char, 2, ParameterDirection.Output, Sex),
                    new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 8, ParameterDirection.Output, BirthDay),
                    new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 50, ParameterDirection.Output, IDCardNumber),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 50, ParameterDirection.Output, Address),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 50, ParameterDirection.Output, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 50, ParameterDirection.Output, QQ),
                    new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 50, ParameterDirection.Output, Telphone),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 50, ParameterDirection.Output, Mobile),
                    new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 1, ParameterDirection.Output, MobileValid),
                    new MSSQL.Parameter("Privacy", SqlDbType.Bit, 1, ParameterDirection.Output, Privacy),
                    new MSSQL.Parameter("Blacklist", SqlDbType.Bit, 1, ParameterDirection.Output, Blacklist),
                    new MSSQL.Parameter("RegisterTime", SqlDbType.DateTime, 8, ParameterDirection.Output, RegisterTime),
                    new MSSQL.Parameter("LastLoginTime", SqlDbType.DateTime, 8, ParameterDirection.Output, LastLoginTime),
                    new MSSQL.Parameter("LastLoginIP", SqlDbType.VarChar, 50, ParameterDirection.Output, LastLoginIP),
                    new MSSQL.Parameter("ManagementRights", SqlDbType.Bit, 1, ParameterDirection.Output, ManagementRights),
                    new MSSQL.Parameter("ManagementRightsList", SqlDbType.VarChar, 1000, ParameterDirection.Output, ManagementRightsList),
                    new MSSQL.Parameter("SuperManagementRights", SqlDbType.Bit, 1, ParameterDirection.Output, SuperManagementRights),
                    new MSSQL.Parameter("UserType", SqlDbType.Int, 4, ParameterDirection.Output, UserType),
                    new MSSQL.Parameter("Balance", SqlDbType.Money, 8, ParameterDirection.Output, Balance),
                    new MSSQL.Parameter("FreezeMoney", SqlDbType.Money, 8, ParameterDirection.Output, FreezeMoney),
                    new MSSQL.Parameter("Scoring", SqlDbType.Int, 4, ParameterDirection.Output, Scoring),
                    new MSSQL.Parameter("LoginNum", SqlDbType.Int, 4, ParameterDirection.Output, LoginNum),
                    new MSSQL.Parameter("Province", SqlDbType.VarChar, 50, ParameterDirection.Output, Province),
                    new MSSQL.Parameter("City", SqlDbType.VarChar, 50, ParameterDirection.Output, City),
                    new MSSQL.Parameter("BankType", SqlDbType.VarChar, 50, ParameterDirection.Output, BankType),
                    new MSSQL.Parameter("BankName", SqlDbType.VarChar, 50, ParameterDirection.Output, BankName),
                    new MSSQL.Parameter("BankCardNumber", SqlDbType.VarChar, 50, ParameterDirection.Output, BankCardNumber),
                    new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 1, ParameterDirection.Output, isAcceptMobileMessage),
                    new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 1000, ParameterDirection.Output, AcceptMobileMessageList),
                    new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 1, ParameterDirection.Output, isAcceptEmail),
                    new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 1, ParameterDirection.Output, isAcceptMessage),
                    new MSSQL.Parameter("HigherUp_id", SqlDbType.Int, 4, ParameterDirection.Output, HigherUp_id),
                    new MSSQL.Parameter("Promotioner_id", SqlDbType.Int, 4, ParameterDirection.Output, Promotioner_id),
                    new MSSQL.Parameter("isAlipayMember", SqlDbType.Bit, 1, ParameterDirection.Output, isAlipayMember),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    id = System.Convert.ToInt32(Outputs["id"]);
                }
                catch { }

                try
                {
                    RealityName = System.Convert.ToString(Outputs["RealityName"]);
                }
                catch { }

                try
                {
                    Sex = System.Convert.ToString(Outputs["Sex"]);
                }
                catch { }

                try
                {
                    BirthDay = System.Convert.ToDateTime(Outputs["BirthDay"]);
                }
                catch { }

                try
                {
                    IDCardNumber = System.Convert.ToString(Outputs["IDCardNumber"]);
                }
                catch { }

                try
                {
                    Address = System.Convert.ToString(Outputs["Address"]);
                }
                catch { }

                try
                {
                    Email = System.Convert.ToString(Outputs["Email"]);
                }
                catch { }

                try
                {
                    QQ = System.Convert.ToString(Outputs["QQ"]);
                }
                catch { }

                try
                {
                    Telphone = System.Convert.ToString(Outputs["Telphone"]);
                }
                catch { }

                try
                {
                    Mobile = System.Convert.ToString(Outputs["Mobile"]);
                }
                catch { }

                try
                {
                    MobileValid = System.Convert.ToBoolean(Outputs["MobileValid"]);
                }
                catch { }

                try
                {
                    Privacy = System.Convert.ToBoolean(Outputs["Privacy"]);
                }
                catch { }

                try
                {
                    Blacklist = System.Convert.ToBoolean(Outputs["Blacklist"]);
                }
                catch { }

                try
                {
                    RegisterTime = System.Convert.ToDateTime(Outputs["RegisterTime"]);
                }
                catch { }

                try
                {
                    LastLoginTime = System.Convert.ToDateTime(Outputs["LastLoginTime"]);
                }
                catch { }

                try
                {
                    LastLoginIP = System.Convert.ToString(Outputs["LastLoginIP"]);
                }
                catch { }

                try
                {
                    ManagementRights = System.Convert.ToBoolean(Outputs["ManagementRights"]);
                }
                catch { }

                try
                {
                    ManagementRightsList = System.Convert.ToString(Outputs["ManagementRightsList"]);
                }
                catch { }

                try
                {
                    SuperManagementRights = System.Convert.ToBoolean(Outputs["SuperManagementRights"]);
                }
                catch { }

                try
                {
                    UserType = System.Convert.ToInt32(Outputs["UserType"]);
                }
                catch { }

                try
                {
                    Balance = System.Convert.ToDouble(Outputs["Balance"]);
                }
                catch { }

                try
                {
                    FreezeMoney = System.Convert.ToDouble(Outputs["FreezeMoney"]);
                }
                catch { }

                try
                {
                    Scoring = System.Convert.ToInt32(Outputs["Scoring"]);
                }
                catch { }

                try
                {
                    LoginNum = System.Convert.ToInt32(Outputs["LoginNum"]);
                }
                catch { }

                try
                {
                    Province = System.Convert.ToString(Outputs["Province"]);
                }
                catch { }

                try
                {
                    City = System.Convert.ToString(Outputs["City"]);
                }
                catch { }

                try
                {
                    BankType = System.Convert.ToString(Outputs["BankType"]);
                }
                catch { }

                try
                {
                    BankName = System.Convert.ToString(Outputs["BankName"]);
                }
                catch { }

                try
                {
                    BankCardNumber = System.Convert.ToString(Outputs["BankCardNumber"]);
                }
                catch { }

                try
                {
                    isAcceptMobileMessage = System.Convert.ToBoolean(Outputs["isAcceptMobileMessage"]);
                }
                catch { }

                try
                {
                    AcceptMobileMessageList = System.Convert.ToString(Outputs["AcceptMobileMessageList"]);
                }
                catch { }

                try
                {
                    isAcceptEmail = System.Convert.ToBoolean(Outputs["isAcceptEmail"]);
                }
                catch { }

                try
                {
                    isAcceptMessage = System.Convert.ToBoolean(Outputs["isAcceptMessage"]);
                }
                catch { }

                try
                {
                    HigherUp_id = System.Convert.ToInt32(Outputs["HigherUp_id"]);
                }
                catch { }

                try
                {
                    Promotioner_id = System.Convert.ToInt32(Outputs["Promotioner_id"]);
                }
                catch { }

                try
                {
                    isAlipayMember = System.Convert.ToBoolean(Outputs["isAlipayMember"]);
                }
                catch { }

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(string Name, string InputPassword, string UnEncryptedPassword, string LoginIP, bool LoginWriteLog, bool isAliPayLogin, ref int id, ref string RealityName, ref string Sex, ref DateTime BirthDay, ref string IDCardNumber, ref string Address, ref string Email, ref string QQ, ref string Telphone, ref string Mobile, ref bool MobileValid, ref bool Privacy, ref bool Blacklist, ref DateTime RegisterTime, ref DateTime LastLoginTime, ref string LastLoginIP, ref bool ManagementRights, ref string ManagementRightsList, ref bool SuperManagementRights, ref int UserType, ref double Balance, ref double FreezeMoney, ref int Scoring, ref int LoginNum, ref string Province, ref string City, ref string BankType, ref string BankName, ref string BankCardNumber, ref bool isAcceptMobileMessage, ref string AcceptMobileMessageList, ref bool isAcceptEmail, ref bool isAcceptMessage, ref int HigherUp_id, ref int Promotioner_id, ref bool isAlipayMember, ref int Result, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_UserLogin", ref Outputs,
                    new MSSQL.Parameter("Name", SqlDbType.VarChar, 0, ParameterDirection.Input, Name),
                    new MSSQL.Parameter("InputPassword", SqlDbType.VarChar, 0, ParameterDirection.Input, InputPassword),
                    new MSSQL.Parameter("UnEncryptedPassword", SqlDbType.VarChar, 0, ParameterDirection.Input, UnEncryptedPassword),
                    new MSSQL.Parameter("LoginIP", SqlDbType.VarChar, 0, ParameterDirection.Input, LoginIP),
                    new MSSQL.Parameter("LoginWriteLog", SqlDbType.Bit, 0, ParameterDirection.Input, LoginWriteLog),
                    new MSSQL.Parameter("isAliPayLogin", SqlDbType.Bit, 0, ParameterDirection.Input, isAliPayLogin),
                    new MSSQL.Parameter("id", SqlDbType.Int, 4, ParameterDirection.Output, id),
                    new MSSQL.Parameter("RealityName", SqlDbType.VarChar, 50, ParameterDirection.Output, RealityName),
                    new MSSQL.Parameter("Sex", SqlDbType.Char, 2, ParameterDirection.Output, Sex),
                    new MSSQL.Parameter("BirthDay", SqlDbType.DateTime, 8, ParameterDirection.Output, BirthDay),
                    new MSSQL.Parameter("IDCardNumber", SqlDbType.VarChar, 50, ParameterDirection.Output, IDCardNumber),
                    new MSSQL.Parameter("Address", SqlDbType.VarChar, 50, ParameterDirection.Output, Address),
                    new MSSQL.Parameter("Email", SqlDbType.VarChar, 50, ParameterDirection.Output, Email),
                    new MSSQL.Parameter("QQ", SqlDbType.VarChar, 50, ParameterDirection.Output, QQ),
                    new MSSQL.Parameter("Telphone", SqlDbType.VarChar, 50, ParameterDirection.Output, Telphone),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 50, ParameterDirection.Output, Mobile),
                    new MSSQL.Parameter("MobileValid", SqlDbType.Bit, 1, ParameterDirection.Output, MobileValid),
                    new MSSQL.Parameter("Privacy", SqlDbType.Bit, 1, ParameterDirection.Output, Privacy),
                    new MSSQL.Parameter("Blacklist", SqlDbType.Bit, 1, ParameterDirection.Output, Blacklist),
                    new MSSQL.Parameter("RegisterTime", SqlDbType.DateTime, 8, ParameterDirection.Output, RegisterTime),
                    new MSSQL.Parameter("LastLoginTime", SqlDbType.DateTime, 8, ParameterDirection.Output, LastLoginTime),
                    new MSSQL.Parameter("LastLoginIP", SqlDbType.VarChar, 50, ParameterDirection.Output, LastLoginIP),
                    new MSSQL.Parameter("ManagementRights", SqlDbType.Bit, 1, ParameterDirection.Output, ManagementRights),
                    new MSSQL.Parameter("ManagementRightsList", SqlDbType.VarChar, 1000, ParameterDirection.Output, ManagementRightsList),
                    new MSSQL.Parameter("SuperManagementRights", SqlDbType.Bit, 1, ParameterDirection.Output, SuperManagementRights),
                    new MSSQL.Parameter("UserType", SqlDbType.Int, 4, ParameterDirection.Output, UserType),
                    new MSSQL.Parameter("Balance", SqlDbType.Money, 8, ParameterDirection.Output, Balance),
                    new MSSQL.Parameter("FreezeMoney", SqlDbType.Money, 8, ParameterDirection.Output, FreezeMoney),
                    new MSSQL.Parameter("Scoring", SqlDbType.Int, 4, ParameterDirection.Output, Scoring),
                    new MSSQL.Parameter("LoginNum", SqlDbType.Int, 4, ParameterDirection.Output, LoginNum),
                    new MSSQL.Parameter("Province", SqlDbType.VarChar, 50, ParameterDirection.Output, Province),
                    new MSSQL.Parameter("City", SqlDbType.VarChar, 50, ParameterDirection.Output, City),
                    new MSSQL.Parameter("BankType", SqlDbType.VarChar, 50, ParameterDirection.Output, BankType),
                    new MSSQL.Parameter("BankName", SqlDbType.VarChar, 50, ParameterDirection.Output, BankName),
                    new MSSQL.Parameter("BankCardNumber", SqlDbType.VarChar, 50, ParameterDirection.Output, BankCardNumber),
                    new MSSQL.Parameter("isAcceptMobileMessage", SqlDbType.Bit, 1, ParameterDirection.Output, isAcceptMobileMessage),
                    new MSSQL.Parameter("AcceptMobileMessageList", SqlDbType.VarChar, 1000, ParameterDirection.Output, AcceptMobileMessageList),
                    new MSSQL.Parameter("isAcceptEmail", SqlDbType.Bit, 1, ParameterDirection.Output, isAcceptEmail),
                    new MSSQL.Parameter("isAcceptMessage", SqlDbType.Bit, 1, ParameterDirection.Output, isAcceptMessage),
                    new MSSQL.Parameter("HigherUp_id", SqlDbType.Int, 4, ParameterDirection.Output, HigherUp_id),
                    new MSSQL.Parameter("Promotioner_id", SqlDbType.Int, 4, ParameterDirection.Output, Promotioner_id),
                    new MSSQL.Parameter("isAlipayMember", SqlDbType.Bit, 1, ParameterDirection.Output, isAlipayMember),
                    new MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    id = System.Convert.ToInt32(Outputs["id"]);
                }
                catch { }

                try
                {
                    RealityName = System.Convert.ToString(Outputs["RealityName"]);
                }
                catch { }

                try
                {
                    Sex = System.Convert.ToString(Outputs["Sex"]);
                }
                catch { }

                try
                {
                    BirthDay = System.Convert.ToDateTime(Outputs["BirthDay"]);
                }
                catch { }

                try
                {
                    IDCardNumber = System.Convert.ToString(Outputs["IDCardNumber"]);
                }
                catch { }

                try
                {
                    Address = System.Convert.ToString(Outputs["Address"]);
                }
                catch { }

                try
                {
                    Email = System.Convert.ToString(Outputs["Email"]);
                }
                catch { }

                try
                {
                    QQ = System.Convert.ToString(Outputs["QQ"]);
                }
                catch { }

                try
                {
                    Telphone = System.Convert.ToString(Outputs["Telphone"]);
                }
                catch { }

                try
                {
                    Mobile = System.Convert.ToString(Outputs["Mobile"]);
                }
                catch { }

                try
                {
                    MobileValid = System.Convert.ToBoolean(Outputs["MobileValid"]);
                }
                catch { }

                try
                {
                    Privacy = System.Convert.ToBoolean(Outputs["Privacy"]);
                }
                catch { }

                try
                {
                    Blacklist = System.Convert.ToBoolean(Outputs["Blacklist"]);
                }
                catch { }

                try
                {
                    RegisterTime = System.Convert.ToDateTime(Outputs["RegisterTime"]);
                }
                catch { }

                try
                {
                    LastLoginTime = System.Convert.ToDateTime(Outputs["LastLoginTime"]);
                }
                catch { }

                try
                {
                    LastLoginIP = System.Convert.ToString(Outputs["LastLoginIP"]);
                }
                catch { }

                try
                {
                    ManagementRights = System.Convert.ToBoolean(Outputs["ManagementRights"]);
                }
                catch { }

                try
                {
                    ManagementRightsList = System.Convert.ToString(Outputs["ManagementRightsList"]);
                }
                catch { }

                try
                {
                    SuperManagementRights = System.Convert.ToBoolean(Outputs["SuperManagementRights"]);
                }
                catch { }

                try
                {
                    UserType = System.Convert.ToInt32(Outputs["UserType"]);
                }
                catch { }

                try
                {
                    Balance = System.Convert.ToDouble(Outputs["Balance"]);
                }
                catch { }

                try
                {
                    FreezeMoney = System.Convert.ToDouble(Outputs["FreezeMoney"]);
                }
                catch { }

                try
                {
                    Scoring = System.Convert.ToInt32(Outputs["Scoring"]);
                }
                catch { }

                try
                {
                    LoginNum = System.Convert.ToInt32(Outputs["LoginNum"]);
                }
                catch { }

                try
                {
                    Province = System.Convert.ToString(Outputs["Province"]);
                }
                catch { }

                try
                {
                    City = System.Convert.ToString(Outputs["City"]);
                }
                catch { }

                try
                {
                    BankType = System.Convert.ToString(Outputs["BankType"]);
                }
                catch { }

                try
                {
                    BankName = System.Convert.ToString(Outputs["BankName"]);
                }
                catch { }

                try
                {
                    BankCardNumber = System.Convert.ToString(Outputs["BankCardNumber"]);
                }
                catch { }

                try
                {
                    isAcceptMobileMessage = System.Convert.ToBoolean(Outputs["isAcceptMobileMessage"]);
                }
                catch { }

                try
                {
                    AcceptMobileMessageList = System.Convert.ToString(Outputs["AcceptMobileMessageList"]);
                }
                catch { }

                try
                {
                    isAcceptEmail = System.Convert.ToBoolean(Outputs["isAcceptEmail"]);
                }
                catch { }

                try
                {
                    isAcceptMessage = System.Convert.ToBoolean(Outputs["isAcceptMessage"]);
                }
                catch { }

                try
                {
                    HigherUp_id = System.Convert.ToInt32(Outputs["HigherUp_id"]);
                }
                catch { }

                try
                {
                    Promotioner_id = System.Convert.ToInt32(Outputs["Promotioner_id"]);
                }
                catch { }

                try
                {
                    isAlipayMember = System.Convert.ToBoolean(Outputs["isAlipayMember"]);
                }
                catch { }

                try
                {
                    Result = System.Convert.ToInt32(Outputs["Result"]);
                }
                catch { }

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_UserPayMobileMessageCost
        {
            public static int Call(int User_id, string Mobile, double Price, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_UserPayMobileMessageCost", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("Price", SqlDbType.Money, 0, ParameterDirection.Input, Price),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, string Mobile, double Price, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_UserPayMobileMessageCost", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Mobile", SqlDbType.VarChar, 0, ParameterDirection.Input, Mobile),
                    new MSSQL.Parameter("Price", SqlDbType.Money, 0, ParameterDirection.Input, Price),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }

        public class P_WinUser
        {
            public static int Call(int User_id, int Scheme_id, double Money, string memo, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                int CallResult = MSSQL.ExecuteStoredProcedureNonQuery("P_WinUser", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("memo", SqlDbType.VarChar, 0, ParameterDirection.Input, memo),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return CallResult;
            }

            public static DataSet Open(int User_id, int Scheme_id, double Money, string memo, ref string Return)
            {
                MSSQL.OutputParameter Outputs = new MSSQL.OutputParameter();

                DataSet ds = MSSQL.ExecuteStoredProcedureWithQuery("P_WinUser", ref Outputs,
                    new MSSQL.Parameter("User_id", SqlDbType.Int, 0, ParameterDirection.Input, User_id),
                    new MSSQL.Parameter("Scheme_id", SqlDbType.Int, 0, ParameterDirection.Input, Scheme_id),
                    new MSSQL.Parameter("Money", SqlDbType.Money, 0, ParameterDirection.Input, Money),
                    new MSSQL.Parameter("memo", SqlDbType.VarChar, 0, ParameterDirection.Input, memo),
                    new MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return)
                    );

                try
                {
                    Return = System.Convert.ToString(Outputs["Return"]);
                }
                catch { }

                return ds;
            }
        }
    }
}
