﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Web;
using System.Web.SessionState;
using System.Timers;
using System.IO;
using System.Data;
using System.Data.SqlClient;

using ShoveEL.Database;

public class Global : System.Web.HttpApplication
{
    private Task task;

    /// <summary>
    /// 必需的设计器变量。
    /// </summary>
    private System.ComponentModel.IContainer components = null;

    public Global()
    {
        InitializeComponent();
    }

    protected void Application_Start(Object sender, EventArgs e)
    {
        Application.Lock();
        Application[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "ISP_Handle"] = new IntPtr(0);
        Application[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "MID"] = PublicFunction.GetMID();
        Application.UnLock();

        #region 更新數據庫 如果是新装，检查并安装数据库 (太危险，未启用)

        /*
        if (GetDatabaseInstallState() == 0)
        {
            string SQLScriptFileName = System.AppDomain.CurrentDomain.BaseDirectory + "Database\\Install.sql";

            if (System.IO.File.Exists(SQLScriptFileName))
            {
                string SQLScript = System.IO.File.ReadAllText(SQLScriptFileName, System.Text.Encoding.Default);
                ShoveEL.Database.MSSQL.ExecuteSQLScript(SQLScript);
            }
        }
        */

        #endregion

        if (!PublicFunction.ValidEdition())
        {
            string OldEdition = PublicFunction.GetDatabaseEdition();

            #region 更新數據庫

            bool Updated = false;

            string SQLScriptFileName = System.AppDomain.CurrentDomain.BaseDirectory + "Database\\Update.sql";
            if (System.IO.File.Exists(SQLScriptFileName))
            {
                string SQLScript = System.IO.File.ReadAllText(SQLScriptFileName, System.Text.Encoding.Default);
                Updated = ShoveEL.Database.MSSQL.ExecuteSQLScript(SQLScript);
            }

            if (!Updated)
            {
                PublicFunction.GoError("应用程序版本号与数据库版本号不一致，继续使用可能会造成意想不到的后果。请联系软件开发商进行调整，谢谢！");
                return;
            }

            #endregion

            #region 將 web.config 中的設置轉到數據庫 Options 表(4.1.7的變化)

            if (OldEdition.CompareTo("4.01007") < 0)
            {
                UpdateOptionsFromWebConfig();
            }

            #endregion

            #region 4.2.3 以前的老注册信息换成4.2.4的新注册信息

            if (OldEdition.CompareTo("4.02004") < 0)
            {
                string SSLM = PublicFunction.GetMID_02();
                string LotteryList = PublicFunction.GetOptionsAsString("SystemRegisterInformation_LotteryList");
                string Version = PublicFunction.GetOptionsAsString("SystemRegisterInformation_VersionType");
                string SN = PublicFunction.GetOptionsAsString("SystemRegisterInformation_SN");
                string SN_2 = PublicFunction.GetOptionsAsString("SystemRegisterInformation_SN_2");

                if (PublicFunction.ValidSN_02(SSLM, LotteryList, Version, SN, SN_2))
                {
                    SSLM = PublicFunction.GetMID();
                    SN = ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", SSLM + Version + LotteryList + "!(&(!!#)", "SSL" + Version + "-", 5, 5, 0);
                    PublicFunction.SetOptions("SystemRegisterInformation_SN", SN);
                }

                Application.Remove(ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "OptionsDataTable");
            }

            #endregion
        }
        else if (PublicFunction.GetOptionsAsString("isRegisterSendEmail").Trim() == "")
        {
            UpdateOptionsFromWebConfig();
        }

        #region 如果没有注册或注册错误，使彩种不可用

        if (!PublicFunction.ValidSN())
        {
            MSSQL.ExecuteNonQuery("update Lottery set [isUsed] = 0");
        }
        else
        {
            string LotteryList = PublicFunction.GetOptionsAsString("SystemRegisterInformation_LotteryList");
            if (DAL.Functions.F_GetIsUsedLotteryList.Call() != LotteryList)
            {
                DAL.Procedures.P_SetIsUsedLotteryList.Call(LotteryList);
            }
        }

        #endregion

        #region 收集使用信息

        if (DateTime.Now.Millisecond > 700)
        {
            CherySoftWS.CherySoftWebService cws = new CherySoftWS.CherySoftWebService();
            try
            {
                cws.WS_SendUserInfo("127.0.0.1", "ShoveLottery" + PublicFunction.GetEdition() + PublicFunction.GetVersionName(), PublicFunction.GetSiteUrl(), "", PublicFunction.GetMID(), PublicFunction.ValidSN(), false);
            }
            catch
            {
                int a = 1;
            }

            cws.Dispose();
        }

        #endregion

        #region 自动任务

        // 设置自动任务
        Task task = new Task();
        task.Run();

        #endregion
    }

    #region 將 web.config 中的設置轉到數據庫 Options 表(4.1.7的變化)

    private void UpdateOptionsFromWebConfig()
    {
        PublicFunction.SetOptions("EmailServer_From", ShoveEL._Web.WebConfig.GetAppSettingsString("EmailServer_From"));
        PublicFunction.SetOptions("EmailServer_EmailServer", ShoveEL._Web.WebConfig.GetAppSettingsString("EmailServer_EmailServer"));
        PublicFunction.SetOptions("EmailServer_User", ShoveEL._Web.WebConfig.GetAppSettingsString("EmailServer_User"));
        PublicFunction.SetOptions("EmailServer_Password", ShoveEL._Web.WebConfig.GetAppSettingsString("EmailServer_Password"));

        PublicFunction.SetOptions("ISP_HostName", ShoveEL._Web.WebConfig.GetAppSettingsString("ISP_HostName"));
        PublicFunction.SetOptions("ISP_HostPort", ShoveEL._Web.WebConfig.GetAppSettingsString("ISP_HostPort"));
        PublicFunction.SetOptions("ISP_UserID", ShoveEL._Web.WebConfig.GetAppSettingsString("ISP_UserID"));
        PublicFunction.SetOptions("ISP_UserPassword", ShoveEL._Web.WebConfig.GetAppSettingsString("ISP_UserPassword"));
        PublicFunction.SetOptions("ISP_RegCode", ShoveEL._Web.WebConfig.GetAppSettingsString("ISP_RegCode"));
        PublicFunction.SetOptions("ISP_ServiceNumber", ShoveEL._Web.WebConfig.GetAppSettingsString("ISP_ServiceNumber"));

        PublicFunction.SetOptions("isRegisterSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isRegisterSendEmail"));
        PublicFunction.SetOptions("isRegisterAdvSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isRegisterAdvSendEmail"));
        PublicFunction.SetOptions("isForgetPasswordSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isForgetPasswordSendEmail"));
        PublicFunction.SetOptions("isUserEditSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isUserEditSendEmail"));
        PublicFunction.SetOptions("isUserEditAdvSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isUserEditAdvSendEmail"));
        PublicFunction.SetOptions("isBuy_InitiateSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_InitiateSendEmail"));
        PublicFunction.SetOptions("isBuy_DSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_DSendEmail"));
        PublicFunction.SetOptions("isBuy_JoinSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_JoinSendEmail"));
        PublicFunction.SetOptions("isChaseSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isChaseSendEmail"));
        PublicFunction.SetOptions("isChaseExecSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isChaseExecSendEmail"));
        PublicFunction.SetOptions("isDistillSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillSendEmail"));
        PublicFunction.SetOptions("isDistillAcceptSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillAcceptSendEmail"));
        PublicFunction.SetOptions("isDistillNoAcceptSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillNoAcceptSendEmail"));
        PublicFunction.SetOptions("isQuashSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashSendEmail"));
        PublicFunction.SetOptions("isQuashSchemeSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashSchemeSendEmail"));
        PublicFunction.SetOptions("isQuashChaseSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashChaseSendEmail"));
        PublicFunction.SetOptions("isQuashChaseAllSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashChaseAllSendEmail"));
        PublicFunction.SetOptions("isWinSendEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("isWinSendEmail"));

        PublicFunction.SetOptions("isRegisterSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isRegisterSendMobileMessage"));
        PublicFunction.SetOptions("isRegisterAdvSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isRegisterAdvSendMobileMessage"));
        PublicFunction.SetOptions("isForgetPasswordSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isForgetPasswordSendMobileMessage"));
        PublicFunction.SetOptions("isUserEditSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isUserEditSendMobileMessage"));
        PublicFunction.SetOptions("isUserEditAdvSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isUserEditAdvSendMobileMessage"));
        PublicFunction.SetOptions("isBuy_InitiateSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_InitiateSendMobileMessage"));
        PublicFunction.SetOptions("isBuy_DSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_DSendMobileMessage"));
        PublicFunction.SetOptions("isBuy_JoinSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_JoinSendMobileMessage"));
        PublicFunction.SetOptions("isChaseSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isChaseSendMobileMessage"));
        PublicFunction.SetOptions("isChaseExecSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isChaseExecSendMobileMessage"));
        PublicFunction.SetOptions("isDistillSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillSendMobileMessage"));
        PublicFunction.SetOptions("isDistillAcceptSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillAcceptSendMobileMessage"));
        PublicFunction.SetOptions("isDistillNoAcceptSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillNoAcceptSendMobileMessage"));
        PublicFunction.SetOptions("isQuashSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashSendMobileMessage"));
        PublicFunction.SetOptions("isQuashChaseSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashChaseSendMobileMessage"));
        PublicFunction.SetOptions("isQuashChaseAllSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashChaseAllSendMobileMessage"));
        PublicFunction.SetOptions("isQuashSchemeSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashSchemeSendMobileMessage"));
        PublicFunction.SetOptions("isWinSendMobileMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isWinSendMobileMessage"));

        PublicFunction.SetOptions("MobileMessagePayType", ShoveEL._Web.WebConfig.GetAppSettingsString("MobileMessagePayType"));
        PublicFunction.SetOptions("MobileMessagePrice", ShoveEL._Web.WebConfig.GetAppSettingsString("MobileMessagePrice"));

        PublicFunction.SetOptions("isRegisterSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isRegisterSendMessage"));
        PublicFunction.SetOptions("isRegisterAdvSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isRegisterAdvSendMessage"));
        PublicFunction.SetOptions("isForgetPasswordSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isForgetPasswordSendMessage"));
        PublicFunction.SetOptions("isUserEditSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isUserEditSendMessage"));
        PublicFunction.SetOptions("isUserEditAdvSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isUserEditAdvSendMessage"));
        PublicFunction.SetOptions("isBuy_InitiateSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_InitiateSendMessage"));
        PublicFunction.SetOptions("isBuy_DSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_DSendMessage"));
        PublicFunction.SetOptions("isBuy_JoinSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isBuy_JoinSendMessage"));
        PublicFunction.SetOptions("isChaseSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isChaseSendMessage"));
        PublicFunction.SetOptions("isChaseExecSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isChaseExecSendMessage"));
        PublicFunction.SetOptions("isDistillSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillSendMessage"));
        PublicFunction.SetOptions("isDistillAcceptSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillAcceptSendMessage"));
        PublicFunction.SetOptions("isDistillNoAcceptSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isDistillNoAcceptSendMessage"));
        PublicFunction.SetOptions("isQuashSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashSendMessage"));
        PublicFunction.SetOptions("isQuashChaseSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashChaseSendMessage"));
        PublicFunction.SetOptions("isQuashChaseAllSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashChaseAllSendMessage"));
        PublicFunction.SetOptions("isQuashSchemeSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isQuashSchemeSendMessage"));
        PublicFunction.SetOptions("isWinSendMessage", ShoveEL._Web.WebConfig.GetAppSettingsString("isWinSendMessage"));

        PublicFunction.SetOptions("OnlinePay_99Bill_Status_ON", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_99Bill_Status_ON"));
        PublicFunction.SetOptions("OnlinePay_99Bill_HomePage", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_99Bill_HomePage"));
        PublicFunction.SetOptions("OnlinePay_99Bill_UserName", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_99Bill_UserName"));
        PublicFunction.SetOptions("OnlinePay_99Bill_UserNumber", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_99Bill_UserNumber"));
        PublicFunction.SetOptions("OnlinePay_99Bill_UserPassword", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_99Bill_UserPassword"));
        PublicFunction.SetOptions("OnlinePay_99Bill_MD5", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_99Bill_MD5"));
        PublicFunction.SetOptions("OnlinePay_99Bill_CommissionScale", ShoveEL._Web.WebConfig.GetAppSettingsString("CommissionScale"));
        PublicFunction.SetOptions("OnlinePayOut_99Bill_MD5", ShoveEL._Web.WebConfig.GetAppSettingsString(""));
        PublicFunction.SetOptions("OnlinePayOut_99Bill_Commission", "3.5");
        //原支付方式没有证书，现增加证书
        if (ShoveEL._Web.WebConfig.GetAppSettingsBool("OnlinePay_99Bill_Status_ON", true))
        {
            PublicFunction.SetOptions("OnlinePay_99Bill_ON_Cert", PublicFunction.GetCert(ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_99Bill_UserNumber"), "SPAYC"));
        }
        else
        {
            PublicFunction.SetOptions("OnlinePay_99Bill_ON_Cert", "");
        }

        PublicFunction.SetOptions("OnlinePay_CBPayMent_Status_ON", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CBPayMent_Status_ON"));
        PublicFunction.SetOptions("OnlinePay_CBPayMent_HomePage", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CBPayMent_HomePage"));
        PublicFunction.SetOptions("OnlinePay_CBPayMent_UserName", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CBPayMent_UserName"));
        PublicFunction.SetOptions("OnlinePay_CBPayMent_UserNumber", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CBPayMent_UserNumber"));
        PublicFunction.SetOptions("OnlinePay_CBPayMent_UserPassword", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CBPayMent_UserPassword"));
        PublicFunction.SetOptions("OnlinePay_CBPayMent_MD5", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CBPayMent_MD5"));
        PublicFunction.SetOptions("OnlinePay_CBPayMent_CommissionScale", ShoveEL._Web.WebConfig.GetAppSettingsString("CommissionScale"));
        //原支付方式没有证书，现增加证书
        if (ShoveEL._Web.WebConfig.GetAppSettingsBool("OnlinePay_CBPayMent_Status_ON", true))
        {
            PublicFunction.SetOptions("OnlinePay_CBPayMent_ON_Cert", PublicFunction.GetCert(ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CBPayMent_UserNumber"), "SPAYC"));
        }
        else
        {
            PublicFunction.SetOptions("OnlinePay_CBPayMent_ON_Cert", "");
        }

        PublicFunction.SetOptions("OnlinePay_Tenpay_Status_ON", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Tenpay_Status_ON"));
        PublicFunction.SetOptions("OnlinePay_Tenpay_HomePage", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Tenpay_HomePage"));
        PublicFunction.SetOptions("OnlinePay_Tenpay_UserName", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Tenpay_UserName"));
        PublicFunction.SetOptions("OnlinePay_Tenpay_UserNumber", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Tenpay_UserNumber"));
        PublicFunction.SetOptions("OnlinePay_Tenpay_UserPassword", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Tenpay_UserPassword"));
        PublicFunction.SetOptions("OnlinePay_Tenpay_MD5", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Tenpay_MD5"));
        PublicFunction.SetOptions("OnlinePay_Tenpay_CommissionScale", ShoveEL._Web.WebConfig.GetAppSettingsString("CommissionScale"));
        //原支付方式没有证书，现增加证书
        if (ShoveEL._Web.WebConfig.GetAppSettingsBool("OnlinePay_Tenpay_Status_ON", true))
        {
            PublicFunction.SetOptions("OnlinePay_Tenpay_ON_Cert", PublicFunction.GetCert(ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Tenpay_UserNumber"), "SPAYC"));
        }
        else
        {
            PublicFunction.SetOptions("OnlinePay_Tenpay_ON_Cert", "");
        }

        PublicFunction.SetOptions("OnlinePay_Alipay_Status_ON", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Alipay_Status_ON"));
        PublicFunction.SetOptions("OnlinePay_Alipay_HomePage", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Alipay_HomePage"));
        PublicFunction.SetOptions("OnlinePay_Alipay_UserName", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Alipay_UserName"));
        PublicFunction.SetOptions("OnlinePay_Alipay_UserNumber", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Alipay_UserNumber"));
        PublicFunction.SetOptions("OnlinePay_Alipay_UserPassword", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Alipay_UserPassword"));
        PublicFunction.SetOptions("OnlinePay_Alipay_MD5", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Alipay_MD5"));
        PublicFunction.SetOptions("OnlinePay_Alipay_CommissionScale", ShoveEL._Web.WebConfig.GetAppSettingsString("CommissionScale"));
        //原支付方式没有证书，现增加证书
        if (ShoveEL._Web.WebConfig.GetAppSettingsBool("OnlinePay_Alipay_Status_ON", true))
        {
            PublicFunction.SetOptions("OnlinePay_Alipay_ON_Cert", PublicFunction.GetCert(ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_Alipay_UserNumber"), "SPAYC"));
        }
        else
        {
            PublicFunction.SetOptions("OnlinePay_Alipay_ON_Cert", "");
        }

        PublicFunction.SetOptions("OnlinePay_ICBC_Status_ON", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_Status_ON"));
        PublicFunction.SetOptions("OnlinePay_ICBC_HomePage", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_HomePage"));
        PublicFunction.SetOptions("OnlinePay_ICBC_interfaceName", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_interfaceName"));
        PublicFunction.SetOptions("OnlinePay_ICBC_interfaceVersion", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_interfaceVersion"));
        PublicFunction.SetOptions("OnlinePay_ICBC_merID", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_merID"));
        PublicFunction.SetOptions("OnlinePay_ICBC_merAcct", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_merAcct"));
        PublicFunction.SetOptions("OnlinePay_ICBC_PublicCertFile", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_PublicCertFile"));
        PublicFunction.SetOptions("OnlinePay_ICBC_PublicCertKeyFile", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_PublicCertKeyFile"));
        PublicFunction.SetOptions("OnlinePay_ICBC_UserCertFile", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_UserCertFile"));
        PublicFunction.SetOptions("OnlinePay_ICBC_UserCertKeyFile", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_UserCertKeyFile"));
        PublicFunction.SetOptions("OnlinePay_ICBC_UserCertPassword", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_UserCertPassword"));
        PublicFunction.SetOptions("OnlinePay_ICBC_CommissionScale", ShoveEL._Web.WebConfig.GetAppSettingsString("CommissionScale"));
        //原支付方式没有证书，现增加证书
        if (ShoveEL._Web.WebConfig.GetAppSettingsBool("OnlinePay_ICBC_Status_ON", true))
        {
            PublicFunction.SetOptions("OnlinePay_ICBC_ON_Cert", PublicFunction.GetCert(ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_ICBC_merID"), "SPAYC"));
        }
        else
        {
            PublicFunction.SetOptions("OnlinePay_ICBC_ON_Cert", "");
        }

        PublicFunction.SetOptions("OnlinePay_CMBChina_Status_ON", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CMBChina_Status_ON"));
        PublicFunction.SetOptions("OnlinePay_CMBChina_HomePage", ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CMBChina_HomePage"));
        PublicFunction.SetOptions("OnlinePay_CMBChina_ON_Cert", "");
        PublicFunction.SetOptions("OnlinePay_CMBChina_CommissionScale", ShoveEL._Web.WebConfig.GetAppSettingsString("CommissionScale"));
        //原支付方式没有证书，现增加证书
        if (ShoveEL._Web.WebConfig.GetAppSettingsBool("OnlinePay_CMBChina_Status_ON", true))
        {
            PublicFunction.SetOptions("OnlinePay_CMBChina_ON_Cert", PublicFunction.GetCert(ShoveEL._Web.WebConfig.GetAppSettingsString("OnlinePay_CMBChina_UserNumber"), "SPAYC"));
        }
        else
        {
            PublicFunction.SetOptions("OnlinePay_CMBChina_ON_Cert", "");
        }

        PublicFunction.SetOptions("ForumUrl", ShoveEL._Web.WebConfig.GetAppSettingsString("ForumUrl"));

        PublicFunction.SetOptions("MobileCheckCharset", ShoveEL._Web.WebConfig.GetAppSettingsString("MobileCheckCharset"));
        PublicFunction.SetOptions("MobileCheckStringLength", ShoveEL._Web.WebConfig.GetAppSettingsString("MobileCheckStringLength"));

        PublicFunction.SetOptions("isUseCheckCode", ShoveEL._Web.WebConfig.GetAppSettingsString("isUseCheckCode"));
        PublicFunction.SetOptions("CheckCodeCharset", ShoveEL._Web.WebConfig.GetAppSettingsString("CheckCodeCharset"));
        PublicFunction.SetOptions("LoginWriteLog", ShoveEL._Web.WebConfig.GetAppSettingsString("LoginWriteLog"));
        PublicFunction.SetOptions("InitiateSchemeCommissionScale", ShoveEL._Web.WebConfig.GetAppSettingsString("InitiateSchemeCommissionScale"));
        PublicFunction.SetOptions("InitiateSchemeMinBuyScale", ShoveEL._Web.WebConfig.GetAppSettingsString("InitiateSchemeMinBuyScale"));
        PublicFunction.SetOptions("InitiateSchemeMinBuyAndAssureScale", ShoveEL._Web.WebConfig.GetAppSettingsString("InitiateSchemeMinBuyAndAssureScale"));
        PublicFunction.SetOptions("DistillCommissionScale", ShoveEL._Web.WebConfig.GetAppSettingsString("DistillCommissionScale"));
        PublicFunction.SetOptions("isSurrogateBuyCanQuash", ShoveEL._Web.WebConfig.GetAppSettingsString("isSurrogateBuyCanQuash"));
        PublicFunction.SetOptions("isFirstPageUnionBuyWithAll", ShoveEL._Web.WebConfig.GetAppSettingsString("isFirstPageUnionBuyWithAll"));
        PublicFunction.SetOptions("isValidBuyPassword", ShoveEL._Web.WebConfig.GetAppSettingsString("isValidBuyPassword"));
        PublicFunction.SetOptions("SchemeGridMaxLotteryNumberRows", ShoveEL._Web.WebConfig.GetAppSettingsString("SchemeGridMaxLotteryNumberRows"));
        PublicFunction.SetOptions("SchemeMaxLotteryNumberRows", ShoveEL._Web.WebConfig.GetAppSettingsString("SchemeMaxLotteryNumberRows"));
        PublicFunction.SetOptions("MemberBuyQuickSchemeAll_RowsCount", ShoveEL._Web.WebConfig.GetAppSettingsString("MemberBuyQuickSchemeAll_RowsCount"));
        PublicFunction.SetOptions("LotteryMenuBarRowLotteryCount", ShoveEL._Web.WebConfig.GetAppSettingsString("LotteryMenuBarRowLotteryCount"));
        PublicFunction.SetOptions("LotteryResultAlign", ShoveEL._Web.WebConfig.GetAppSettingsString("LotteryResultAlign"));
        PublicFunction.SetOptions("ScoringOfSelfBuy", ShoveEL._Web.WebConfig.GetAppSettingsString("ScoringOfSelfBuy"));
        PublicFunction.SetOptions("ScoringOfCommendBuy", ShoveEL._Web.WebConfig.GetAppSettingsString("ScoringOfCommendBuy"));
        PublicFunction.SetOptions("LotteryBuyRequestCode", ShoveEL._Web.WebConfig.GetAppSettingsString("LotteryBuyRequestCode"));
        PublicFunction.SetOptions("LotteryBuyDefaultCode", ShoveEL._Web.WebConfig.GetAppSettingsString("LotteryBuyDefaultCode"));
        PublicFunction.SetOptions("SiteName", ShoveEL._Web.WebConfig.GetAppSettingsString("SiteName"));
        PublicFunction.SetOptions("SiteUrl", ShoveEL._Web.WebConfig.GetAppSettingsString("SiteUrl"));
        PublicFunction.SetOptions("SiteEmail", ShoveEL._Web.WebConfig.GetAppSettingsString("SiteEmail"));
        PublicFunction.SetOptions("ShowFloatAD", ShoveEL._Web.WebConfig.GetAppSettingsString("ShowFloatAD"));
        PublicFunction.SetOptions("ShowLotteryStationInfo", ShoveEL._Web.WebConfig.GetAppSettingsString("ShowLotteryStationInfo"));
        PublicFunction.SetOptions("PageTitle", ShoveEL._Web.WebConfig.GetAppSettingsString("PageTitle"));
        PublicFunction.SetOptions("PageKeywords", ShoveEL._Web.WebConfig.GetAppSettingsString("PageKeywords"));

        PublicFunction.SetOptions("Footer_ServiceTelephone", ShoveEL._Web.WebConfig.GetAppSettingsString("Footer_ServiceTelephone"));
        PublicFunction.SetOptions("Footer_Telephone", ShoveEL._Web.WebConfig.GetAppSettingsString("Footer_Telephone"));
        PublicFunction.SetOptions("Footer_Fax", ShoveEL._Web.WebConfig.GetAppSettingsString("Footer_Fax"));
        PublicFunction.SetOptions("Footer_Address", ShoveEL._Web.WebConfig.GetAppSettingsString("Footer_Address"));
        PublicFunction.SetOptions("Footer_PostCode", ShoveEL._Web.WebConfig.GetAppSettingsString("Footer_PostCode"));
        PublicFunction.SetOptions("Footer_SiteICP", ShoveEL._Web.WebConfig.GetAppSettingsString("Footer_SiteICP"));

        PublicFunction.SetOptions("SystemRegisterInformation_VersionType", ShoveEL._Web.WebConfig.GetAppSettingsString("SystemRegisterInformation_VersionType"));
        PublicFunction.SetOptions("SystemRegisterInformation_LotteryList", ShoveEL._Web.WebConfig.GetAppSettingsString("SystemRegisterInformation_LotteryList"));
        PublicFunction.SetOptions("SystemRegisterInformation_SN", ShoveEL._Web.WebConfig.GetAppSettingsString("SystemRegisterInformation_SN"));
        PublicFunction.SetOptions("SystemRegisterInformation_SN_2", ShoveEL._Web.WebConfig.GetAppSettingsString("SystemRegisterInformation_SN_2"));

        #region 老注册信息换成新注册信息

        string SSLM = PublicFunction.GetMID_01();
        string LotteryList = PublicFunction.GetOptionsAsString("SystemRegisterInformation_LotteryList");
        string Version = PublicFunction.GetOptionsAsString("SystemRegisterInformation_VersionType");
        string SN = PublicFunction.GetOptionsAsString("SystemRegisterInformation_SN");

        if (PublicFunction.ValidSN_01(SSLM, LotteryList, Version, SN))
        {
            SSLM = PublicFunction.GetMID();
            SN = ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", SSLM + Version + LotteryList, "SSL" + Version + "-", 5, 5, 0);
            PublicFunction.SetOptions("SystemRegisterInformation_SN", SN);
        }

        #endregion

        Application.Remove(ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "OptionsDataTable");
    }

    #endregion

    protected void Session_Start(Object sender, EventArgs e)
    {

    }

    protected void Application_BeginRequest(Object sender, EventArgs e)
    {

    }

    protected void Application_EndRequest(Object sender, EventArgs e)
    {

    }

    protected void Application_AuthenticateRequest(Object sender, EventArgs e)
    {

    }

    protected void Application_Error(Object sender, EventArgs e)
    {
        if (PublicFunction.GetOptionsAsBoolean("DEBUG", false))
            return;

        Exception objErr = Server.GetLastError().GetBaseException();

        if (objErr == null)
        {
            Server.ClearError();
            return;
        }

        string Url = "空";
        try
        {
            Url = HttpContext.Current.Request.Url.ToString();
        }
        catch { }

        string ErrorMsg = "Error, PageName: " + Url + "。 ErrorMsg: " + objErr.Message + " Source:" + objErr.Source + "。";

        PublicFunction.WriteException(ErrorMsg);

        Server.ClearError();
        //Response.Redirect("~/Error.htm", true);
    }

    protected void Session_End(Object sender, EventArgs e)
    {

    }

    protected void Application_End(Object sender, EventArgs e)
    {
        if (task != null)
        {
            task.Exit();
        }

        IntPtr pHandle = new IntPtr(0);
        try
        {
            pHandle = (IntPtr)Application[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "ISP_Handle"];
        }
        catch
        { }

        if (pHandle.ToInt32() != 0)
        {
            JL_ISP.JL_Logout(pHandle);
        }
    }

    #region Web 窗体设计器生成的代码
    /// <summary>
    /// 设计器支持所需的方法 - 不要使用代码编辑器修改
    /// 此方法的内容。
    /// </summary>
    private void InitializeComponent()
    {
        this.components = new System.ComponentModel.Container();
    }
    #endregion
}
