﻿using System;
using System.IO;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Runtime.InteropServices;
using System.Configuration;
using System.Text;
using System.Collections;
using System.Data;
using System.Data.SqlClient;

/// <summary>
/// 深圳巨澜短信接口
/// </summary>
[Serializable]
public class JL_ISP
{
    #region Dll Import

    //网关连接类型定义：
    public const int JL_MT = 1;
    public const int JL_MO = 2;

    //返回值定义
    //	所有函数的返回值都包含在以下类型中，如果函数运行正确则统一返回大于或者等于0的值，错误码都是小于0的值
    public const int JL_SUCCESS = 0;	//正常
    public const int JL_ERR_EPID = -1;	//EPID错误
    public const int JL_ERR_USER_PASS = -2;	//无该用户
    public const int JL_ERR_REGCODE = -3;	//注册码错
    public const int JL_ERR_STOP_USER = -4;	//用户被停用
    public const int JL_ERR_REG_FAILED = -5;	//未注册成功
    public const int JL_ERR_OUT_DATE = -6;	//超出使用日期
    public const int JL_ERR_OUT_PAY = -7;	//费用不足
    public const int JL_ERR_SRC_PHONE = -8;	//源手机错误
    public const int JL_ERR_DES_PHONE = -9;	//目的手机错误
    public const int JL_ERR_CONTENT = -10;	//信息内容错误
    public const int JL_ERR_SOCKET = -11;	//连接失败
    public const int JL_ERR_INTERNAL = -12;	//系统内部错误或者无效的客户状态
    public const int JL_ERR_LIMITS = -13;	//客户权限不对
    public const int JL_ERR_LIMITS_IP = -14;	//不是从指定的IP处登录
    public const int JL_ERR_ISLOGIN = -15;	//帐号已经登录(TCP)
    public const int JL_ERR_COMMUNICATION = -16;	//内部通讯错误
    public const int JL_ERR_FULL_ROUTE = -17;	//无可用的MT通道
    public const int JL_ERR_NOT_PROVIDE = -18;	//不支持该功能
    public const int JL_ERR_UNKNOWN = -20;	//未知错误

    [DllImport("JL_ISP.dll", EntryPoint = "JL_TCPLogin", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_TCPLogin(string strHost, int nPort, string strUserId, string strPassword, int nType, ref IntPtr pRtnHandle/*OUT*/);
    [DllImport("JL_ISP.dll", EntryPoint = "JL_HTTPLogin", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_HTTPLogin(string strHost, int nPort, string strUserId, string strPassword, string strRegCode, ref IntPtr pRtnHandle/*OUT*/);
    /*功能：与网关建立连接并登录系统
        JL_TCPLogin：以TCP方式登录
        JL_HTTPLogin：以HTTP方式登录
    参数： 
    strHost:	主机名称或者IP地址
    nPort:		端口号
    strUserId:	用户名
    strPassword:用户密码
    nType:		连接类型(仅 TCP 使用)，可用JL_MT或JL_MO, 默认为 JL_MO
    strRegCode:	注册码(仅 HTTP 使用)
    函数返回：正确返回0；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_ModifyPassword", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_ModifyPassword(IntPtr pHandle, string strNewPassword);
    /*
    功能：用户修改自己的密码 
    参数：
    pHandle：句柄，由登录函数获得
    strNewPassword：新密码
    函数返回：正确返回0；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_SendMsg", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_SendMsg(IntPtr pHandle, string strFromPhone, string strToPhone, string strContent, string strSendTime);
    /*功能：用户发送短信
    参数：
    pHandle：	句柄，由登录函数获得
    strFromPhone：短消息发送者手机号码
    strToPhone：	目的手机号码，本函数可以发送单条或者多条短信，多个号码之间用 “,” 隔开(注：多号码的个数是有限制的，请咨询巨澜技术部确定最多个数)。
    strContent：	信息内容，<=140字符。
    strSendTime：	定时发送时间。格式：yyyy-mm-dd hh:mm:ss， 为空时表示立即发送
    函数返回：正确返回0；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_SendMsgPID", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_SendMsgPID(IntPtr pHandle, string strFromPhone, string strToPhone, string strContent, string strSendTime, string strProductID);
    /*功能：用户发送短信，发送短信带产品号（巨澜内部使用）
    参数：
    pHandle：	句柄，由登录函数获得
    strFromPhone：短消息发送者手机号码
    strToPhone：	目的手机号码，本函数可以发送单条或者多条短信，多个号码之间用 “,” 隔开(注：多号码的个数是有限制的，请咨询巨澜技术部确定最多个数)。
    strContent：	信息内容，<=140字符。
    strSendTime：	定时发送时间。格式：yyyy-mm-dd hh:mm:ss， 为空时，表示立即发送
    strProductID：产品号，为LPCTSTR类型，可以用字符型代替；小秘书:”61”,短信通”62”,网上行”63”
    函数返回：正确返回0；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_ReceiveSM", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_ReceiveSM(IntPtr pHandle, int nLastMsgId);
    [DllImport("JL_ISP.dll", EntryPoint = "JL_GetOneSM", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_GetOneSM(IntPtr pHandle, ref int pnMsgID, StringBuilder strFrom, StringBuilder strCreateTime, StringBuilder strContent);
    /*功能：接收上行短信
    注意：在TCP方式下，如需获取MO，则需要定时直接调用JL_GetOneSM获取实时MO信息，在HTTP方式下，要获取MO，必须先调用JL_ReceiveSM从服务器获得消息，然后通过JL_GetOneSM逐条获取短消息的具体内容。
    参数：
    pHandle：句柄，由登录函数获得
    nLastMsgId：返回nLastMsgId指定的消息后的所有上行销息(0值表示获取全部上行信息)
    pnMsgID：返回接收的短信的编号
    strFrom：返回发送者的手机号码。
    strCreateTime：返回发送时间。
    strContent：返回消息内容。
    函数返回：
    JL_ReceiveSM：正确返回消息的条数(不一定是全部，只有当返回为0时，才说明已经全部接收完毕)，错误返回相应的错误码值。（只适用HTTP）
    JL_GetOneSM：正确返回1：表示有接收短信，0：表示没有可接收的短信；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_GetSendCount", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_GetSendCount(IntPtr pHandle, string strStartDate, string strEndDate, ref int nCountWaitSend, ref int nCountTestSend);
    /*功能：发送统计
    strStartDate，strEndDate 输入选择的日期范围,返回值为已发送的消息条数，只支持HTTP登录方式
    参数：
    pHandle：句柄，由登录函数获得
    strStartDate：起始时间
    strEndDate：结束时间
    函数返回：正确返回已发送的消息条数；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_Logout", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_Logout(IntPtr pHandle);
    /*功能：退出登录
    Login操作为pHandle分配了内存，需要在JL_Logout中进行释放。
    参数：
    pHandle：句柄，由登录函数获得
    函数返回：正确返回0；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_GetAccountBalance", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_GetAccountBalance(IntPtr pHandle, ref Single fBalance/*OUT*/);
    /*功能：用户查询帐户余额。
    参数：
    pHandle：句柄，由登录函数获得
    fBalance：float类型变量的地址，用来返回用户的帐户余额
    函数返回：正确返回0；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_GetAccountPrice", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_GetAccountPrice(IntPtr pHandle, ref Single fPrice/*OUT*/);
    /*功能：用户查询短信的单价。
    参数：
    pHandle：句柄，由登录函数获得
    fPrice：float类型变量的地址，用来查询发送每条消息的单价
    函数返回：正确返回0；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_GetAccountType", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_GetAccountType(IntPtr pHandle, ref int nType/*OUT*/);
    /*用户查询帐户类型。只支持HTTP登录的方式
    参数：
    pHandle：句柄，由登录函数获得
    nType：int 类型变量的地址，用来查询用户的类型
            1 表示正式用户
            2 表示用户停用
    函数返回：正确返回0；错误返回相应的错误码值。
    */
    [DllImport("JL_ISP.dll", EntryPoint = "JL_GetOneReport", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_GetOneReport(IntPtr pHandle, int pnReqID, string pstrPhone, int pnStatus, string pstrDescribe);
    /*功能：接收一条状态报告记录 ，只支持TCP登录方式 
    参数：
    pHandle：	句柄，由登录函数获得
    pnReqID：	int型变量的地址，返回MT短消息ID
    pstrPhone：字符串缓冲区，大小至少为21字节，返回接收手机号码
    pnStatus：	int型变量的地址，返回短信息接收状态 0：发送失败 1：信息已发送到网关 3：信息已发送到手机
    pstrDescribe：字符串缓冲区，大小至少为256字节，返回状态描述
    函数返回：正确返回0；错误返回相应的错误码值。
    */

    [DllImport("JL_ISP.dll", EntryPoint = "JL_GetAccountRegTime", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_GetAccountRegTime(IntPtr pHandle, StringBuilder strDate);

    [DllImport("JL_ISP.dll", EntryPoint = "JL_GetAccountDenyTime", CallingConvention = CallingConvention.StdCall)]
    public static extern int JL_GetAccountDenyTime(IntPtr pHandle, StringBuilder strDate);

    #endregion

    private IntPtr pHandle = new IntPtr(0);

    public JL_ISP()
    {
        pHandle = IntPtr.Zero;
        try
        {
            pHandle = (IntPtr)System.Web.HttpContext.Current.Application[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "ISP_Handle"];
        }
        catch
        { }

        if (pHandle.ToInt32() == 0)
        {
            int Result = JL_HTTPLogin(
                PublicFunction.GetOptionsAsString("ISP_HostName"),
                PublicFunction.GetOptionsAsInt("ISP_HostPort", 7001),
                PublicFunction.GetOptionsAsString("ISP_UserID"),
                PublicFunction.GetOptionsAsString("ISP_UserPassword"),
                PublicFunction.GetOptionsAsString("ISP_RegCode"),
                ref pHandle);

            if (Result == 0)
            {
                System.Web.HttpContext.Current.Application.Lock();
                System.Web.HttpContext.Current.Application[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "ISP_Handle"] = pHandle;
                System.Web.HttpContext.Current.Application.UnLock();
            }
        }
    }

    public void Dispose()
    {
        if (pHandle.ToInt32() != 0)
        {
            JL_Logout(pHandle);
        }
    }

    ~JL_ISP()
    {
        Dispose();
    }

    public int SendMessage(string strFromPhone, string strToPhone, string strContent, string strSendTime, int User_id)
    {
        int PhoneCount = 0;

        string[] strPhonies = SplitPhonies(strToPhone, ref PhoneCount);
        if ((strPhonies == null) || (strPhonies.Length < 1))
        {
            return -101;
        }

        string[] strContents = SplitContent(strContent);
        if ((strContents == null) || (strContents.Length < 1))
        {
            return -102;
        }

        string MobileMessagePayType = PublicFunction.GetOptionsAsString("MobileMessagePayType", "2");
        double Price = PublicFunction.GetOptionsAsDouble("MobileMessagePrice", 0);
        double Money = Price * PhoneCount * strContents.Length;

        string Return = "";
        int Result;
        Users tu = new Users();
        tu.ID = User_id;

        if ((User_id >= 0) && (MobileMessagePayType == "2") && (Price > 0))	//-1 为非会员订阅的短信
        {
            Result = tu.GetUserBalance(ref Return);

            if (Result != 0)
            {
                return -103;
            }
            if (tu.Balance < Money)
            {
                return -104;
            }
        }

        int Count = 0;
        Result = 0;

        foreach (string strPhone in strPhonies)
        {
            foreach (string str in strContents)
            {
                Result = JL_SendMsg(pHandle, strFromPhone, strPhone, str, strSendTime);
                if (Result != 0)
                {
                    break;
                }

                Count += (ShoveEL._String.StringAt(strPhone, ',') + 1);
            }
        }

        if (Count > 0)
        {
            //写入数据库
            DAL.Tables.MobileMessage.Insert(-1, true, "", false, strToPhone, true, ShoveEL._Convert.StrToDateTime(strSendTime, System.DateTime.Now.ToString()), true, strContent, true);

            if ((User_id >= 0) && (MobileMessagePayType == "2") && (Price > 0))
            {
                DAL.Procedures.P_UserPayMobileMessageCost.Call(tu.ID, strToPhone, Count * Price, ref Return);

                Users user = Users.GetSessionUser();
                if ((user != null) && (user.ID == tu.ID))
                {
                    user.GetUserBalance(ref Return);
                }
            }
        }

        return Result;
    }

    public int SendMessage(string strToPhone, string strContent, string strSendTime, int User_id)
    {
        //return SendMessage(PublicFunction.GetOptionsAsString("ISP_ServiceNumber"), strToPhone, strContent, strSendTime);
        return SendMessage("", strToPhone, strContent, strSendTime, User_id);
    }

    private string[] SplitPhonies(string PhoneList, ref int PhoneCount)
    {
        PhoneList = PhoneList.Trim();
        if (PhoneList == "")
            return null;

        string[] t_strs = PhoneList.Split(',');
        if (t_strs == null)
            return null;
        if (t_strs.Length < 1)
            return null;

        PhoneCount = t_strs.Length;

        ArrayList al = new ArrayList();
        for (int i = 0; i < t_strs.Length; i++)
        {
            if (t_strs[i].Trim() != "")
                al.Add(t_strs[i].Trim());
        }

        if (al.Count == 0)
            return null;

        string[] Result = new string[((int)(al.Count / 50)) + 1];
        for (int i = 0; i < Result.Length; i++)
        {
            Result[i] = "";
        }

        for (int i = 0; i < al.Count; i++)
        {
            Result[(int)(i / 50)] += al[i].ToString() + ",";
        }

        for (int i = 0; i < Result.Length; i++)
        {
            if (Result[i].EndsWith(","))
                Result[i] = Result[i].Substring(0, Result[i].Length - 1);
        }

        return Result;
    }

    private string[] SplitContent(string Content)
    {
        Content = Content.Trim();
        if (Content == "")
            return null;

        ArrayList al = new ArrayList();
        string t_str = "";

        for (int i = 0; i < Content.Length; i++)
        {
            string tt_str = Content[i].ToString();
            int t_len = tt_str.Length;
            if (t_str.Length + t_len > 70)
            {
                al.Add(t_str);
                t_str = tt_str;
            }
            else
            {
                t_str += tt_str;
            }
        }
        if (t_str != "")
            al.Add(t_str);

        if (al.Count == 0)
            return null;

        string[] Result = new string[al.Count];
        for (int i = 0; i < al.Count; i++)
        {
            Result[i] = al[i].ToString();
        }

        return Result;
    }

    public string[,] ReceiveMessage(int lastmsgid)
    {
        int LastMsgId = lastmsgid;
        int pnMsgID = lastmsgid;

        StringBuilder strFrom = new StringBuilder();
        StringBuilder strCreateTime = new StringBuilder();
        StringBuilder strContent = new StringBuilder();

        strFrom.Length = 21;
        strCreateTime.Length = 20;
        strContent.Length = 225;

        ArrayList al0 = new ArrayList();	//MsgID
        ArrayList al1 = new ArrayList();	//From
        ArrayList al2 = new ArrayList();	//CreateTime
        ArrayList al3 = new ArrayList();	//Content

        while (JL_ReceiveSM(pHandle, LastMsgId) > 0)
        {
            while (JL_GetOneSM(pHandle, ref pnMsgID, strFrom, strCreateTime, strContent) > 0)
            {
                al0.Add(pnMsgID);
                al1.Add(strFrom.ToString());
                al2.Add(strCreateTime.ToString());
                al3.Add(strContent.ToString());
            }
            LastMsgId = pnMsgID;
        }

        if (al0.Count == 0)
            return null;

        string[,] Result = new string[al1.Count, 4];
        for (int i = 0; i < al1.Count; i++)
        {
            Result[i, 0] = al0[i].ToString();
            Result[i, 1] = al1[i].ToString();
            Result[i, 2] = al2[i].ToString();
            Result[i, 3] = al3[i].ToString();
        }

        return Result;
    }

    public int ReceiveMessage()
    {
        object Value = ShoveEL.Database.MSSQL.ExecuteScalar("select isnull(max(MsgID), 0) as MaxID from MobileMessage");
        int LastMsgID = 0;
        try
        {
            LastMsgID = int.Parse(Value.ToString());
        }
        catch { }

        string[,] Msg = ReceiveMessage(LastMsgID);
        if (Msg == null)
            return 0;

        for (int i = 0; i <= Msg.GetUpperBound(0); i++)
            DAL.Tables.MobileMessage.Insert(int.Parse(Msg[i, 0]), true, Msg[i, 1], true, "", false, ShoveEL._Convert.StrToDateTime(Msg[i, 2], System.DateTime.Now.ToString()), true, Msg[i, 3], true);

        return Msg.GetUpperBound(0);
    }

    public int GetAccountInfo(ref Single Balance, ref Single Price, ref string Type, ref DateTime RegTime, ref DateTime DenyTime)
    {
        int Result;
        int nType = 1;
        StringBuilder strDate1 = new StringBuilder();
        StringBuilder strDate2 = new StringBuilder();
        strDate1.Length = 20;
        strDate2.Length = 20;

        Result = JL_GetAccountBalance(pHandle, ref Balance);
        if (Result != 0)
            return Result;
        Result = JL_GetAccountPrice(pHandle, ref Price);
        if (Result != 0)
            return Result;
        Result = JL_GetAccountType(pHandle, ref nType);
        if (Result != 0)
            return Result;
        Result = JL_GetAccountRegTime(pHandle, strDate1);
        if (Result != 0)
            return Result;
        Result = JL_GetAccountDenyTime(pHandle, strDate2);
        if (Result != 0)
            return Result;

        Type = GetType(nType);
        RegTime = ShoveEL._Convert.StrToDateTime(strDate1.ToString(), System.DateTime.Now.ToString());
        DenyTime = ShoveEL._Convert.StrToDateTime(strDate2.ToString(), System.DateTime.Now.ToString());
        return 0;
    }

    public int GetAccountUseCount(DateTime StartTime, DateTime EndTime, ref int SendCount, ref int CountWaitSend, ref int CountTestSend)
    {
        int Result = JL_GetSendCount(pHandle, StartTime.ToShortDateString(), EndTime.ToShortDateString(), ref CountWaitSend, ref CountTestSend);
        if (Result < 0)
            return Result;

        SendCount = Result;
        return 0;
    }

    public string GetMessage(int bRtn)
    {
        string Message = "";
        switch (bRtn)
        {
            case 0:
                Message = "正常.";
                break;
            case 1:
                Message = "TCP方式登录. ";
                break;
            case 2:
                Message = "HTTP方式登录. ";
                break;
            case -1:
                Message = "EPID错误. ";
                break;
            case -2:
                Message = "无该用户. ";
                break;
            case -3:
                Message = "注册码错 ";
                break;
            case -4:
                Message = "用户被停用. ";
                break;
            case -5:
                Message = "未注册成功.";
                break;
            case -6:
                Message = "超出使用日期";
                break;
            case -7:
                Message = "费用不足";
                break;
            case -8:
                Message = "源手机错误. ";
                break;
            case -9:
                Message = "目的手机错误. ";
                break;
            case -10:
                Message = "信息内容错误. ";
                break;
            case -11:
                Message = "连接失败. ";
                break;
            case -12:
                Message = "系统内部错误或者无效的客户状态.";
                break;
            case -13:
                Message = "客户权限不对";
                break;
            case -14:
                Message = "不是从指定的IP处登录";
                break;
            case -15:
                Message = "帐号已经登录(TCP). ";
                break;
            case -16:
                Message = "内部通讯错误. ";
                break;
            case -17:
                Message = "无可用的MT通道. ";
                break;
            case -18:
                Message = "不支持该功能";
                break;
            case -20:
                Message = "未知错误. ";
                break;
            default:
                Message = "未知错误.";
                break;
        }
        return Message;
    }

    public string GetType(int nType)
    {
        string Type = "";
        switch (nType)
        {
            case 1:
                Type = "正式用户";
                break;
            case 2:
                Type = "用户停用";
                break;
            case 3:
                Type = "测试用户";
                break;
            case 4:
                Type = "模拟测试用户";
                break;
            default:
                Type = "未知类型用户";
                break;
        }
        return Type;
    }
}