﻿using System;
using System.Web;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Data;

using ShoveEL.Database;


/// <summary>
/// ManageClientService 的摘要说明
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class ManageClientService : System.Web.Services.WebService {

    public ManageClientService () {

        //如果使用设计的组件，请取消注释以下行
        //InitializeComponent(); 
    }

    private string GenValidCode()
    {
        System.Random rd = new Random();

        int i = rd.Next(10000000, 99999999);
        int j = (int)(System.Math.Abs(System.Math.Sin((double)i)) * 100000000);
        int k = (int)(System.Math.Abs(System.Math.Cos((double)j)) * 100000000);

        return i.ToString().PadLeft(8, '0') + j.ToString().PadLeft(8, '0') + k.ToString().PadLeft(8, '0');
    }

    private bool CheckValidCode(string ValidCode)
    {
        if (ValidCode.Length != 24)
            return false;

        int i = ShoveEL._Convert.StrToInt(ValidCode.Substring(0, 8), 1);
        int j = (int)(System.Math.Abs(System.Math.Sin((double)i)) * 100000000);
        int k = (int)(System.Math.Abs(System.Math.Cos((double)j)) * 100000000);

        return ((i.ToString().PadLeft(8, '0') + j.ToString().PadLeft(8, '0') + k.ToString().PadLeft(8, '0')) == ValidCode);
    }

    [WebMethod]
    public string GetUserValidCode(string UserName, string UserPassword)
    {
        return "";
    }

    [WebMethod]
    public string GetUserValidCode403001(string ManageClientVersion, string UserName, string UserPassword)
    {
        if (ManageClientVersion.CompareTo("4.03001") < 0)
        {
            return "-1";
        }
        
        Users tu = new Users();
        tu.Name = UserName;
        if (tu.GetUserInfoByName() != 0)
        {
            return "";
        }

        if (tu.Password != ShoveEL._Security.Encrypt.UnEncryptString(UserPassword))
            return "";

        if (!tu.ManagementRights)
            return "";

        return GenValidCode();
    }

    [WebMethod]
    public string GetUserID(string UserName, string ValidCode)
    {
        if (!CheckValidCode(ValidCode))
        {
            return "非法用户调用";
        }

        Users tu = new Users();
        tu.Name = UserName;
        if (tu.GetUserInfoByName() != 0)
        {
            return "";
        }

        return tu.ID.ToString();
    }

    [WebMethod]
    public string GetUserRightsList(string UserName, string ValidCode)
    {
        if (!CheckValidCode(ValidCode))
        {
            return "非法用户调用";
        }

        Users tu = new Users();
        tu.Name = UserName;
        if (tu.GetUserInfoByName() != 0)
        {
            return "";
        }

        return tu.ManagementRightsList;
    }

    [WebMethod]
    public string GetUserLotteryBuyRightsList(string UserName, string ValidCode)
    {
        if (!CheckValidCode(ValidCode))
        {
            return "非法用户调用";
        }

        Users tu = new Users();
        tu.Name = UserName;
        if (tu.GetUserInfoByName() != 0)
        {
            return "";
        }

        object Value = MSSQL.ExecuteScalar("select LotteryBuyRightsList from Users where [id] = " + tu.ID.ToString());
        if (Value == null)
        {
            return "";
        }

        return Convert.ToString(Value);
    }

    [WebMethod]
    public string GetServerDateTime()
    {
        return DateTime.Now.ToString();
    }

    [WebMethod]
    public string GetServerDateTimeEncryptString()
    {
        return ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString());
    }

    [WebMethod]
    public DataSet GetLottery(string ValidCode)
    {
        if (!CheckValidCode(ValidCode))
        {
            return null;
        }

        DataTable dt = DAL.Views.V_SchemeCount.Select("", "", "[Sort]");
        if (dt == null)
            return null;

        DataSet ds = new DataSet();
        dt.TableName = "Lottery";
        ds.Tables.Add(dt);

        return ds;
    }

    [WebMethod]
    public DataSet GetIsuse(int Lottery_id, string ValidCode)
    {
        if (!CheckValidCode(ValidCode))
        {
            return null;
        }

        DataTable dt = MSSQL.Select("select top 1 [id], Isuse, StartTime, EndTime from Isuse where Lottery_id = " + Lottery_id.ToString() + " and GetDate() Between StartTime and EndTime order by StartTime");
        if (dt == null)
            return null;

        DataSet ds = new DataSet();
        dt.TableName = "Isuse";
        ds.Tables.Add(dt);

        return ds;
    }

    [WebMethod]
    public DataSet GetScheme(int Isuse_id, string ValidCode)
    {
        if (!CheckValidCode(ValidCode))
        {
            return null;
        }

        DataTable dt = DAL.Views.V_SchemeSchedule.Select("", "Isuse_id = " + Isuse_id.ToString() + " and Schedule >= 100 and Quashed = 0 and LotteryBuyed = 0", "[DateTime]");
        if (dt == null)
            return null;

        DataSet ds = new DataSet();
        dt.TableName = "Scheme";
        ds.Tables.Add(dt);

        return ds;
    }

    [WebMethod]
    public string LotteryBuy(int Scheme_id, string LotteryCode, int User_id, string ValidCode)
    {
        if (!CheckValidCode(ValidCode))
        {
            return "非法用户调用";
        }

        if (LotteryCode == "")
        {
            LotteryCode = PublicFunction.GetOptionsAsString("LotteryBuyDefaultCode");
        }

        string Return = "";
        if (DAL.Procedures.P_SchemeBuyed.Call(Scheme_id,
            ShoveEL._String.Compress(LotteryCode),
            PublicFunction.GetOptionsAsInt("ScoringOfSelfBuy", 0),
            PublicFunction.GetOptionsAsInt("ScoringOfCommendBuy", 0),
            User_id,
            ref Return) < 0)
        {
            return "数据读写错误";
        }

        if (Return != "")
        {
            return Return;
        }

        return "";
    }
}
