﻿using System;
using System.IO;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using System.Web.Configuration;

using ShoveEL.Database;

public class PublicFunction
{
    #region Email, Template 相关

    public static int SendEmail(string MailTo, string Subject, string Body)
    {
        Task_SendEmail task_sendemail = new Task_SendEmail(MailTo, Subject, Body);
        task_sendemail.Run();

        return 0;
    }

    public static string GetEmailTemplate(string FileName, ref string Subject, ref string Body)
    {
        string temp = "";
        Page p = new Page();
        string NewFileName = FileName;

        NewFileName = p.Server.MapPath(temp + FileName);
        while (!File.Exists(NewFileName) && (temp.Length <= 12))
        {
            temp += "../";
            NewFileName = p.Server.MapPath(temp + FileName);
        }

        if (!File.Exists(NewFileName))
            return "";

        StreamReader sr = File.OpenText(NewFileName);
        string Content = sr.ReadToEnd().Trim().Replace("[SiteName]", GetOptionsAsString("SiteName")).Replace("[SiteUrl]", GetOptionsAsString("SiteUrl"));
        sr.Close();

        Regex regex = new Regex(@"{Subject}(?<Subject>[^{]*?){/Subject}(?<Body>[\W\w]*)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
        Match m = regex.Match(Content);
        Subject = m.Groups["Subject"].ToString().Trim();
        Body = m.Groups["Body"].ToString().Trim();

        return Content;
    }

    public static string GetMobileMessageTemplate(string FileName)
    {
        string temp = "";
        string NewFileName = System.Web.HttpContext.Current.Server.MapPath(FileName);

        while (!File.Exists(NewFileName) && (temp.Length <= 12))
        {
            temp += "../";
            NewFileName = System.Web.HttpContext.Current.Server.MapPath(temp + FileName);
        }

        if (!File.Exists(NewFileName))
            return "";

        StreamReader sr = File.OpenText(NewFileName);
        string Content = sr.ReadToEnd().Trim().Replace("[SiteName]", GetOptionsAsString("SiteName")).Replace("[SiteUrl]", GetOptionsAsString("SiteUrl"));
        sr.Close();
        return Content;
    }

    public static string GetMessageTemplate(string FileName)
    {
        string temp = "";
        string NewFileName = System.Web.HttpContext.Current.Server.MapPath(FileName);

        while (!File.Exists(NewFileName) && (temp.Length <= 12))
        {
            temp += "../";
            NewFileName = System.Web.HttpContext.Current.Server.MapPath(temp + FileName);
        }

        if (!File.Exists(NewFileName))
            return "";

        StreamReader sr = File.OpenText(NewFileName);
        string Content = sr.ReadToEnd().Trim().Replace("[SiteName]", GetOptionsAsString("SiteName")).Replace("[SiteUrl]", GetOptionsAsString("SiteUrl"));
        sr.Close();
        return Content;
    }

    #endregion

    #region GoError()

    public static void GoError()
    {
        System.Web.HttpContext.Current.Response.Redirect("Error.aspx?ErrorNumber=01", true);
    }

    public static void GoError(string Tip)
    {
        System.Web.HttpContext.Current.Response.Redirect("Error.aspx?ErrorNumber=01&Tip=" + Tip.Trim(), true);
    }

    public static void GoError(string ErrorPageUrl, string Tip)
    {
        System.Web.HttpContext.Current.Response.Redirect(ErrorPageUrl + "?ErrorNumber=01&Tip=" + Tip.Trim(), true);
    }

    #endregion

    #region 注册相关

    #region 4.1.6 以及以前版本
    public static string GetMID_01()
    {
        return ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", ShoveEL._System.SystemInformation.GetNetCardMACAddress(), "SSLM-", 3, 4, 1);
    }

    public static bool ValidSN_01()
    {
        string SSLM = GetMID_01();
        string LotteryList = GetOptionsAsString("SystemRegisterInformation_LotteryList");
        string Version = GetOptionsAsString("SystemRegisterInformation_VersionType");
        string SN = GetOptionsAsString("SystemRegisterInformation_SN");

        return ValidSN_01(SSLM, LotteryList, Version, SN);
    }

    public static bool ValidSN_01(string SSLM, string LotteryList, string Version, string SN)
    {
        string RealitySN = ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", SSLM + LotteryList + Version, "SSL" + Version + "-", 5, 5, 0);
        return (RealitySN == SN);
    }
    #endregion

    #region 4.1.7 開始版本
    public static string GetMID_02()
    {
        SqlConnection conn = MSSQL.CreateDataConnection();
        if (conn == null)
        {
            return "";
        }

        string DataBaseName = conn.Database;
        conn.Close();

        return ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", DataBaseName + ShoveEL._System.SystemInformation.GetNetCardMACAddress(), "SSLM-", 3, 4, 1);
    }

    public static bool ValidSN_02()
    {
        string SSLM = GetMID();
        string LotteryList = GetOptionsAsString("SystemRegisterInformation_LotteryList");
        string Version = GetOptionsAsString("SystemRegisterInformation_VersionType");
        string SN = GetOptionsAsString("SystemRegisterInformation_SN");
        string SN_2 = GetOptionsAsString("SystemRegisterInformation_SN_2");

        return ValidSN_02(SSLM, LotteryList, Version, SN, SN_2);
    }

    public static bool ValidSN_02(string SSLM, string LotteryList, string Version, string SN, string SN_2)
    {
        string RealitySN = ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", SSLM + Version + LotteryList, "SSL" + Version + "-", 5, 5, 0);
        return ((RealitySN == SN) || (RealitySN == SN_2));
    }
    #endregion

    #region 4.2.4 開始版本
    public static string GetMID()
    {
        SqlConnection conn = MSSQL.CreateDataConnection();
        if (conn == null)
        {
            return "";
        }

        string DataBaseName = conn.Database;
        conn.Close();

        return ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", DataBaseName + ShoveEL._System.SystemInformation.GetNetCardMACAddress(), "SSLM-", 3, 4, 1);
    }

    public static bool ValidSN()
    {
        string SSLM = GetMID();
        string LotteryList = GetOptionsAsString("SystemRegisterInformation_LotteryList");
        string Version = GetOptionsAsString("SystemRegisterInformation_VersionType");
        string SN = GetOptionsAsString("SystemRegisterInformation_SN");
        string SN_2 = GetOptionsAsString("SystemRegisterInformation_SN_2");

        return ValidSN(SSLM, LotteryList, Version, SN, SN_2);
    }

    public static bool ValidSN(string SSLM, string LotteryList, string Version, string SN, string SN_2)
    {
        string RealitySN = ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", SSLM + Version + LotteryList + "!(&(!!#)", "SSL" + Version + "-", 5, 5, 0);
        return ((RealitySN == SN) || (RealitySN == SN_2));
    }
    #endregion

    public static string GetVersion()
    {
        string Version = GetOptionsAsString("SystemRegisterInformation_VersionType");
        if ((Version != "1") && (Version != "2") && (Version != "3") && (Version != "4"))
        {
            Version = "1";
        }

        return Version;
    }

    public static string GetVersionName()
    {
        string VersionName = "门户版";
        switch (GetVersion())
        {
            case "1":
                VersionName = "门户版";
                break;
            case "2":
                VersionName = "统一综合版";
                break;
            case "3":
                VersionName = "体彩普及版";
                break;
            case "4":
                VersionName = "福彩普及版";
                break;
        }

        return VersionName;
    }

    public static string GetLotteryListFromDatabase()
    {
        return DAL.Functions.F_GetIsUsedLotteryList.Call();
    }

    //校验各类证书
    public static string GetCert(string UserNumber, string CertType)
    {
        return ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", ShoveEL._String.Reverse(UserNumber) + "Shove", CertType, 1, 200, 1);
    }

    public static bool ValidCert(string UserNumber, string Cert, string CertType)
    {
        return (GetCert(UserNumber, CertType) == Cert);
    }

    #endregion

    #region 版本号相关

    public static string GetEdition()
    {
        return "4.04002";
    }

    public static string GetDatabaseEdition()
    {
        return GetOptionsAsString("DatabaseVersionNumber");
    }

    public static bool ValidEdition()
    {
        return (GetEdition() == GetDatabaseEdition());
    }

    #endregion

    public static int GetDatabaseInstallState()
    {
        //return:   -1 数据库连接失败   0 未安装    1 已安装
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            return -1;
        }

        SqlCommand Cmd = new SqlCommand("select [Key] from [Options] where [id] = 1", conn);
        SqlDataReader dr = null;

        try
        {
            dr = Cmd.ExecuteReader();
        }
        catch
        {
            conn.Close();
            return 0;
        }

        if (!dr.Read())
        {
            dr.Close();
            conn.Close();
            return 0;
        }

        if (dr[0].ToString() != "WinNameList_ID")
        {
            dr.Close();
            conn.Close();
            return 0;
        }

        dr.Close();
        conn.Close();
        return 1;
    }

    public static string GetSiteUrl()
    {
        string SiteUrl = GetOptionsAsString("SiteUrl");

        if (SiteUrl == "")
        {
            SiteUrl = ShoveEL._Web.Utility.GetSiteUrl();
        }

        return SiteUrl;
    }

    public static string GetSiteEmail()
    {
        return GetOptionsAsString("SiteEmail");
    }

    public static object ValidLotteryTime(string Time)
    {
        Time = Time.Trim();

        Regex regex = new Regex(@"[\d]{4}[-][\d]{1,2}[-][\d]{1,2}[\s][\d]{1,2}[:][\d]{1,2}[:][\d]{1,2}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
        if (!regex.IsMatch(Time))
            return null;

        System.DateTime dt;

        try
        {
            dt = System.DateTime.Parse(Time);
        }
        catch
        {
            return null;
        }

        return dt;
    }

    public static string BuilderLotteryMenu()
    {
        DataTable dt = DAL.Tables.Lottery.Select("[id],[Name]", "[isUsed]=1", "[Sort]");
        if (dt == null)
        {
            GoError();
            return "";
        }

        if (dt.Rows.Count == 0)
            return "";

        int LotteryMenuBarRowLotteryCount = GetOptionsAsInt("LotteryMenuBarRowLotteryCount", 8);
        if (LotteryMenuBarRowLotteryCount < 1)
            LotteryMenuBarRowLotteryCount = 8;

        int Rows = (int)((dt.Rows.Count + LotteryMenuBarRowLotteryCount - 1) / LotteryMenuBarRowLotteryCount);

        string LotteryMenu = "<table cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"0\">";

        for (int i = 0; i < Rows; i++)
        {
            int RowLotteryCount = LotteryMenuBarRowLotteryCount;
            if (i == Rows - 1)
                RowLotteryCount = dt.Rows.Count - (i * LotteryMenuBarRowLotteryCount);

            string TableWidth = "100%";
            if (RowLotteryCount < 9)
                TableWidth = (RowLotteryCount + 1).ToString() + "8%";
            else if (RowLotteryCount < 10)
                TableWidth = (RowLotteryCount + 1).ToString() + "0%";

            LotteryMenu += "<tr>";
            LotteryMenu += "<td height=\"6px\">";
            LotteryMenu += "</td>";
            LotteryMenu += "</tr>";

            LotteryMenu += "<tr>";
            LotteryMenu += "<td align=\"center\" background=\"Images/ToolBarBack_White.gif\" height=\"33px\">";

            LotteryMenu += "<table cellSpacing=\"0\" cellPadding=\"0\" border=\"0\" width=\"" + TableWidth + "\">";
            LotteryMenu += "<tr>";
            for (int j = 0; j < RowLotteryCount; j++)
            {
                LotteryMenu += "<td width=\"20px\"><img src=\"images/Lottery/" + dt.Rows[i * LotteryMenuBarRowLotteryCount + j]["id"].ToString() + ".gif\"></td>";
                LotteryMenu += "<td align=\"center\"><A class=\"li1\" href=\"Lottery.aspx?id=" + dt.Rows[i * LotteryMenuBarRowLotteryCount + j]["id"].ToString() + "\" target=\"_blank\">" + dt.Rows[i * LotteryMenuBarRowLotteryCount + j]["Name"].ToString() + "</A></td>";
            }
            LotteryMenu += "</tr>";
            LotteryMenu += "</table>";

            LotteryMenu += "</td>";
            LotteryMenu += "</tr>";
        }

        LotteryMenu += "</table>";
        return LotteryMenu;
    }

    //判断足彩单场的方案中是否有已过期的场次
    public static bool GetZCDCNoIsOverdue(int Isuse_id, string No)
    {
        bool IsOverdue = false;
        DataTable dt = DAL.Views.V_ZCDCLeagueType.Select("DateTime", "[Isuse_id]=" + Isuse_id.ToString() + " and [No]=" + No, "");

        if ((dt == null) || (dt.Rows.Count == 0))
        {
            return IsOverdue;
        }

        if (DateTime.Now < ShoveEL._Convert.StrToDateTime(dt.Rows[0][0].ToString(), DateTime.Now.ToString()))
        {
            IsOverdue = true;
        }

        return IsOverdue;
    }

    public static string ConvertDateTimeMMDDHHMM(string strDateTime)
    {
        DateTime dt;

        try
        {
            dt = DateTime.Parse(strDateTime);
        }
        catch
        {
            return "";
        }

        return dt.Month.ToString() + "-" + dt.Day.ToString() + " " + dt.Hour.ToString().PadLeft(2, '0') + ":" + dt.Minute.ToString().PadLeft(2, '0');
    }

    // 统计支付流量
    public static void WriteOnlinePays(string PayType, string PayNumber, double Money, double FormalitiesFees, long UserID)
    {
        ShovesoftService.OnlinePays ssOnlinePays = null;
        
        try
        {
            ssOnlinePays = new ShovesoftService.OnlinePays();
            ssOnlinePays.Url = "http://service.shovesoft.com/Service/OnlinePays.asmx";
        }
        catch
        {
            return;
        }

        ssOnlinePays.WriteOnlinePay("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", PayType, PayNumber, Money, FormalitiesFees, GetSiteUrl(), GetOptionsAsString("SiteName"), UserID);

        ssOnlinePays.Dispose();
    }

    #region Options 表的操作

    public static object GetOptions(string Key)
    {
        DataTable dtOptions = null;

        try
        {
            dtOptions = (DataTable)System.Web.HttpContext.Current.Application[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "OptionsDataTable"];
        }
        catch
        { }

        if (dtOptions == null)
        {
            dtOptions = DAL.Tables.Options.Select("", "", "[id]");

            try
            {
                System.Web.HttpContext.Current.Application.Lock();
                System.Web.HttpContext.Current.Application.Add(ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "OptionsDataTable", dtOptions);
                System.Web.HttpContext.Current.Application.UnLock();
            }
            catch { }
        }

        DataRow[] dr = dtOptions.Select("Key='" + Key + "'");
        if ((dr == null) || (dr.Length == 0))
        {
            return null;
        }

        return dr[0]["Value"];
    }

    public static string GetOptionsAsString(string Key)
    {
        return GetOptionsAsString(Key, "");
    }

    public static string GetOptionsAsString(string Key, string Default)
    {
        object Value = GetOptions(Key);

        string Result = Default;

        try
        {
            Result = Value.ToString();
        }
        catch { }

        return Result;
    }

    public static int GetOptionsAsInt(string Key, int Default)
    {
        object Value = GetOptions(Key);

        int Result = Default;

        try
        {
            Result = int.Parse(Value.ToString());
        }
        catch { }

        return Result;
    }

    public static long GetOptionsAsLong(string Key, long Default)
    {
        object Value = GetOptions(Key);

        long Result = Default;

        try
        {
            Result = long.Parse(Value.ToString());
        }
        catch { }

        return Result;
    }

    public static double GetOptionsAsDouble(string Key, double Default)
    {
        object Value = GetOptions(Key);

        double Result = Default;

        try
        {
            Result = double.Parse(Value.ToString());
        }
        catch { }

        return Result;
    }

    public static bool GetOptionsAsBoolean(string Key, bool Default)
    {
        object Value = GetOptions(Key);

        bool Result = Default;

        try
        {
            Result = Convert.ToBoolean(Value);
        }
        catch { }

        return Result;
    }

    public static DateTime GetOptionsAsDateTime(string Key, DateTime Default)
    {
        object Value = GetOptions(Key);

        DateTime Result = Default;

        try
        {
            Result = DateTime.Parse(Value.ToString());
        }
        catch { }

        return Result;
    }

    public static bool SetOptions(string Key, object Value)
    {
        string strValue = "";

        try
        {
            strValue = Value.ToString();
        }
        catch { }

        if (0 == DAL.Tables.Options.Update("[Key]='" + Key + "'", -1, false, "", false, null, false, strValue, true))
        {
            try
            {
                System.Web.HttpContext.Current.Application.Lock();
                System.Web.HttpContext.Current.Application.Remove(ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "OptionsDataTable");
                System.Web.HttpContext.Current.Application.UnLock();
            }
            catch { }

            return true;
        }

        return false;
    }

    public static string GetOptionsBin(string Key)
    {
        DataTable dtOptions = null;

        try
        {
            dtOptions = (DataTable)System.Web.HttpContext.Current.Application[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "OptionsDataTable"];
        }
        catch
        { }

        if (dtOptions == null)
        {
            dtOptions = DAL.Tables.Options.Select("", "", "[id]");

            try
            {
                System.Web.HttpContext.Current.Application.Lock();
                System.Web.HttpContext.Current.Application.Add(ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "OptionsDataTable", dtOptions);
                System.Web.HttpContext.Current.Application.UnLock();
            }
            catch { }
        }

        DataRow[] dr = dtOptions.Select("Key='" + Key + "'");
        if ((dr == null) || (dr.Length == 0))
        {
            return "";
        }

        string Result = "";
        try
        {
            Result = ShoveEL._String.Decompress((byte[])dr[0]["ValueImage"]);
        }
        catch { }

        return Result;
    }

    public static bool SetOptionsBin(string Key, object Value)
    {
        string strValue = "";

        try
        {
            strValue = Value.ToString();
        }
        catch { }

        if (0 == DAL.Tables.Options.Update("[Key]='" + Key + "'", -1, false, "", false, ShoveEL._String.Compress(strValue), true, "", false))
        {
            try
            {
                System.Web.HttpContext.Current.Application.Lock();
                System.Web.HttpContext.Current.Application.Remove(ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "OptionsDataTable");
                System.Web.HttpContext.Current.Application.UnLock();
            }
            catch { }

            return true;
        }

        return false;
    }

    #endregion

    #region 写 ini Task 日志、异常文件
    public static void WriteLog(string Text)
    {
        WriteIni(Text, "Log");
    }

    public static void WriteException(string Text)
    {
        WriteIni(Text, "Exception");
    }

    private static void WriteIni(string Text, string Section)
    {
        try
        {
            ShoveEL._IO.IniFile ini = new ShoveEL._IO.IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "Task.ini");
            ini.Write(Section, System.DateTime.Now.ToString(), Text);
        }
        catch { }
    }
    #endregion
}
