﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections;

using ShoveEL.Database;

/// <summary>
/// Task 的摘要说明
/// </summary>
public class Task
{
    private long gCount1 = 0;
    private long gCount2 = 0;
    private long gCount3 = 0;

    private System.Threading.Thread thread;

    public int State = 0;   // 0 停止 1 运行中 2 置为停止
    
    public Task()
	{
	}

    public void Run()
    {
        if (ShoveEL._Web.WebConfig.GetAppSettingsBool("DEBUG", false))
        {
            return;
        }

        // 已经启动
        if (State == 1)
        {
            return;
        }

        lock (this) // 确保临界区被一个 Thread 所占用
        {
            State = 1;

            gCount1 = 0;
            gCount2 = 0;
            gCount3 = 0;

            thread = new System.Threading.Thread(new System.Threading.ThreadStart(Do));
            thread.IsBackground = true;

            thread.Start();
        }
    }

    public void Exit()
    {
        State = 2;
    }

    public void Do()
    {
        while (true)
        {
            if (State == 2)
            {
                State = 0;
                thread = null;

                return;
            }

            System.Threading.Thread.Sleep(1000);   // 1秒为单位

            gCount1 += 1;
            gCount2 += 1;
            gCount3 += 1;

            #region 10 秒, 使用保底使方案满员，未成功方案系统撤单 & 执行追号任务
            if (gCount1 >= 10)
            {
                gCount1 = 0;

                try
                {
                    SchemeSystemDeal();
                    SchemeSystemDealForZCDC();  //For足彩单场(系统撤单)
                }
                catch { }

                try
                {
                    LotteryChaseExec();
                }
                catch { }
            }
            #endregion

            #region 10 分钟, 检测追号过期未执行的任务，以撤消此明细任务。
            if (gCount2 >= 60 * 10)
            {
                gCount2 = 0;

                try
                {
                    LotteryChaseExecCheck();
                }
                catch { }
            }
            #endregion

            #region 24小时, 备份数据库
            if (gCount3 >= 60 * 60 * 24)
            {
                gCount3 = 0;

                try
                {
                    DataBackup();
                }
                catch { }
            }
            #endregion
        }
    }

    #region 定时器执行的事件
    private void SchemeSystemDeal()	//使用保底使方案满员，未成功方案系统撤单
    {
        string Return = "";
        int Result = DAL.Procedures.P_SchemeSystemDeal.Call(ref Return);

        if (Result < 0)
        {
            PublicFunction.WriteLog("Exec SchemeSystemDeal: Procedure \"P_SchemeSystemDeal\" Fail.");
            return;
        }

        if (Return != "")
            PublicFunction.WriteLog("Exec SchemeSystemDeal: Procedure \"P_SchemeSystemDeal\" Return: " + Return);
    }

    private void SchemeSystemDealForZCDC()	//使用保底使方案满员，未成功方案系统撤单
    {
        string Return = "";
        int Result = 0;

        string LotteryNumber = "";
        string BuyContent = "";
        string vote = "";

        DataTable dt = MSSQL.Select("select [id], LotteryNumber, IsUse_Id,InitiateUser_id, [Money], isnull(AssureMoney, 0) as AssureMoney, Share, BuyedShare from V_SchemeSchedule where Quashed = 0 and LotteryBuyed = 0 and Schedule < 100 and Type_id between " + Lottery.ZCDC.BuyType_SPF + " and " + Lottery.ZCDC.BuyType_BQCSPF);

        if (dt == null || dt.Rows.Count == 0)
        {
            return;
        }

        for (int i = 0; i < dt.Rows.Count; i++)
        {
            int Scheme_id = int.Parse(dt.Rows[i]["id"].ToString());

            LotteryNumber = ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]);

            if (new Lottery()[Lottery.ZCDC.sID].GetSchemeSplit(LotteryNumber, ref BuyContent, ref vote))
            {
                string No1 = BuyContent.Split('|')[0].ToString();

                //判断是否过期
                if (!PublicFunction.GetZCDCNoIsOverdue(int.Parse(dt.Rows[i]["IsUse_Id"].ToString()), No1.Split('(')[0]))
                {
                    Result = DAL.Procedures.P_SchemeSystemDealForZCDC.Call(Scheme_id, ref Return);

                    if (Result < 0)
                    {
                        PublicFunction.WriteLog("Exec SchemeSystemDeal: Procedure \"P_SchemeSystemDealForZCDC\" Fail.");
                        continue;
                    }

                    if (Return != "")
                    {
                        PublicFunction.WriteLog("Exec SchemeSystemDeal: Procedure \"P_SchemeSystemDealForZCDC\" Return: " + Return);
                    }
                }
            }
            else
            {
                PublicFunction.WriteLog("Exec SchemeSystemDeal: Procedure 方案ID为\"" + Scheme_id.ToString() + "的方案，方案书写格式错误\" Fail.");
                continue;
            }
        }
    }


    private void LotteryChaseExec()	//执行追号任务
    {
        DataTable dt = DAL.Views.V_ChaseDetail.Select("[User_id], Chase_id, [id] as ChaseDetail_id, Lottery_id, Isuse_id, ChaseBuyType_id, BuyType_id, Multiple, [Money], Title, Description, LotteryNumber, SecrecyLevel",
            "ChaseQuashed = 0 and Quashed = 0 and Buyed = 0 and GetDate() >= ChaseExecuteTime and ChaseExecuted = 0", "");
        if (dt == null)
        {
            PublicFunction.WriteLog("Exec LotteryChaseExec Fail.");
            return;
        }

        string Return = "";
        ArrayList al = new ArrayList();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            DataRow dr = dt.Rows[i];

            Users tu = new Users();
            tu.ID = ShoveEL._Convert.StrToInt(dr["User_id"].ToString(), -1);
            int Result = tu.GetUserInfoByID();

            if ((Result != 0) && (Result != -3))
            {
                continue;
            }

            string LotteryNumber = "";
            try
            {
                LotteryNumber = ShoveEL._String.Decompress((byte[])dr["LotteryNumber"]);
            }
            catch { }

            if (tu.ChaseExec(int.Parse(dr["Chase_id"].ToString()),
                int.Parse(dr["ChaseDetail_id"].ToString()),
                int.Parse(dr["Lottery_id"].ToString()),
                int.Parse(dr["Isuse_id"].ToString()),
                int.Parse(dr["ChaseBuyType_id"].ToString()),
                int.Parse(dr["BuyType_id"].ToString()),
                int.Parse(dr["Multiple"].ToString()),
                double.Parse(dr["Money"].ToString()),
                dr["Title"].ToString(),
                (byte[])dr["Description"],
                LotteryNumber,
                int.Parse(dr["SecrecyLevel"].ToString()),
                ref Return) < 0)
            {
                continue;
            }

            if (!isExistNum(al, int.Parse(dr["Isuse_id"].ToString())))
                al.Add(dr["Isuse_id"].ToString());
        }

        if (al.Count > 0)
        {
            string IsuseList = "";
            for (int i = 0; i < al.Count; i++)
                IsuseList += al[i].ToString() + ",";
            IsuseList = IsuseList.Substring(0, IsuseList.Length - 1);

            MSSQL.ExecuteNonQuery("update Isuse set ChaseExecuted = 1 where [id] in (" + IsuseList + ")");
        }
    }

    private void LotteryChaseExecCheck()    // 检测追号过期未执行的任务，以撤消此明细任务。
    {
        DataTable dt = DAL.Views.V_ChaseDetail.Select("[User_id], [id] as ChaseDetail_id",
            "ChaseQuashed = 0 and Quashed = 0 and Buyed = 0 and EndTime <= GetDate() and ChaseExecuted = 0", "");
        if (dt == null)
        {
            PublicFunction.WriteLog("Exec LotteryChaseExecCheck Fail.");
            return;
        }

        string Return = "";
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            DataRow dr = dt.Rows[i];

            Users tu = new Users();
            tu.ID = ShoveEL._Convert.StrToInt(dr["User_id"].ToString(), -1);
            int Result = tu.GetUserInfoByID();

            if ((Result != 0) && (Result != -3))
            {
                continue;
            }

            int ChaseDetail_id = ShoveEL._Convert.StrToInt(dr["ChaseDetail_id"].ToString(), -1);
            if (ChaseDetail_id >= 0)
            {
                tu.QuashChase(ChaseDetail_id, ref Return);
            }
        }
    }

    private void DataBackup()	//备份数据库
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            PublicFunction.WriteLog("Exec DataBackup: Database Connect Fail.");
            return;
        }

        string DatabaseName = conn.Database;
        bool BreakLog = (new Random().Next(14) == 1);

        string CurrentPath = System.AppDomain.CurrentDomain.BaseDirectory;
        if (!CurrentPath.EndsWith("\\"))
            CurrentPath += "\\";

        //if (MSSQL.BackupDatabase(conn, CurrentPath + "Database\\" + DatabaseName + ".bak", BreakLog, BreakLog) < 0)
        if (MSSQL.BackupDatabase(conn, CurrentPath + "Database\\" + DatabaseName + ".bak", false, false) < 0)
            PublicFunction.WriteLog("Exec DataBackup Fail.");

        conn.Close();
        conn.Dispose();
    }

    private bool isExistNum(ArrayList al, int Num)
    {
        if (al.Count == 0)
        {
            return false;
        }

        for (int i = 0; i < al.Count; i++)
        {
            if (int.Parse(al[i].ToString()) == Num)
            {
                return true;
            }
        }

        return false;
    }
    #endregion
}
