﻿using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web.Security;
using System.Collections;

using ShoveEL.Database;

//[Serializable]
public class Users
{
    #region 成员变量
    public int ID;
    public string Name;
    public string RealityName;
    public string Password;
    public string Password_2;

    public string Sex;
    public DateTime BirthDay;
    public string IDCardNumber;
    public string Address;
    public string Email;
    public string QQ;
    public string Telphone;
    public string Mobile;
    public bool MobileValid;

    public bool Privacy;
    public bool Blacklist;

    public DateTime RegisterTime;
    public DateTime LastLoginTime;
    public string LastLoginIP;

    public bool ManagementRights;
    public string ManagementRightsList;

    /*	FillContent;			填充资料
        UserList				用户列表
        UserDetail;				修改用户
        UserAccount;			用户帐
        UserAddMoney;			充值
        UserQuestion;			用户问题
        UserDistill;			用户提款
        SendMessage;			发送信使消息
        SendEmail;				发送 Email
        SendMobileMessage;		发送手机短信
        UserLoginLog;			用户日志
        LotteryIsuse;			管理彩票期
        LotterySchemeAtTop;		方案置顶
        LotterySchemeQuash;		方案撤消
        LotteryBuy;				出票
        LotteryWin;				开奖
        Finance;				财务
        Option;					选项
        Promotioner;            管理、查询联盟推广商           
    */
    public bool SuperManagementRights;

    /// <summary>
    /// 1 普通　2 高级
    /// </summary>
    public int UserType;

    public double Balance;
    public double FreezeMoney;
    public int Scoring;

    public int LoginNum;
    public bool isLogined;
    public DateTime LoginTime;
    public string LoginIP;

    public string Province;
    public string City;

    public string BankType;
    public string BankName;
    public string BankCardNumber;

    public bool isAcceptMobileMessage;
    public string AcceptMobileMessageList;
    /*	Register		注册成功
        RegisterAdv		注册高级会员成功
        ForgetPassword	忘记密码
        UserEdit		用户资料修改
        UserEditAdv		用户高级资料修改
        Buy_Initiate	发起方案
        Buy_D			发起代购
        Buy_Join		加入方案
        Chase			发起追号任务
        ChaseExec		追号任务执行
        Distill			用户提款
        DistillAccept	提款受理
        DistillNoAccept	提款被拒绝
        Quash			撤单
        QuashChase		撤消一期追号任务
        QuashChaseAll	撤消整个追号任务
        QuashScheme		方案撤单
        Win				中奖
    */
    public bool isAcceptEmail;
    public bool isAcceptMessage;

    public int HigherUp_id;	// 推荐人，上级id
    public int Promotioner_id;  //联盟推广商id

    public bool isAlipayMember; //是否是支付宝的共享会员

    public Promotioners Promotioner;

    /// <summary>
    /// 能否投注，当高级用户，并且用投注密码登陆时，才能投注
    /// </summary>
    public bool CanInvest;
    #endregion

    #region Users()
    public Users()
    {
        ID = -1;
        Name = "";
        RealityName = "";
        Password = "";
        Password_2 = "";
        Sex = "男";
        BirthDay = DateTime.Parse("1980-01-01");
        IDCardNumber = "";
        Address = "";
        Email = "";
        QQ = "";
        Telphone = "";
        Mobile = "";
        MobileValid = false;
        Privacy = true;
        Blacklist = false;

        isLogined = false;
        
        try
        {
            LoginIP = System.Web.HttpContext.Current.Request.UserHostAddress;
        }
        catch
        {
            LoginIP = "";
        }

        ManagementRights = false;
        ManagementRightsList = "[FillContent][UserQuestion][SendMessage][SendEmail][UserLoginLog]";
        SuperManagementRights = false;

        UserType = 1;

        Province = "";
        City = "";

        Balance = 0;
        FreezeMoney = 0;
        Scoring = 0;

        BankType = "";
        BankName = "";
        BankCardNumber = "";

        CanInvest = false;

        isAcceptMobileMessage = false;
        AcceptMobileMessageList = "";
        isAcceptEmail = true;
        isAcceptMessage = true;

        HigherUp_id = -1;
        Promotioner_id = -1;

        isAlipayMember = false;

    }

    public Users(string name, string realityname, string password, string password_2, string sex, DateTime birthday, string idcardnumber,
        string address, string email, string qq, string telphone, string mobile, bool mobilevalid, bool privacy, int usertype,
        string province, string city,
        string banktype, string bankname, string bankcardnumber,
        int higherup_id, int promotioner_id,
        bool isalipaymember)
    {
        Name = name;
        RealityName = realityname;
        Password = password;
        Password_2 = password_2;
        Sex = sex;
        BirthDay = birthday;
        IDCardNumber = idcardnumber;
        Address = address;
        Email = email;
        QQ = qq;
        Telphone = telphone;
        Mobile = mobile;
        MobileValid = mobilevalid;
        Privacy = privacy;
        LoginIP = System.Web.HttpContext.Current.Request.UserHostAddress; ;

        ManagementRights = false;
        ManagementRightsList = "[FillContent][UserQuestion][SendMessage][SendEmail][UserLoginLog]";
        SuperManagementRights = false;

        UserType = usertype;

        Province = province;
        City = city;

        Balance = 0;
        FreezeMoney = 0;
        Scoring = 0;

        BankType = banktype;
        BankName = bankname;
        BankCardNumber = bankcardnumber;

        CanInvest = false;

        isAcceptMobileMessage = true;
        AcceptMobileMessageList = "";
        isAcceptEmail = true;
        isAcceptMessage = true;

        HigherUp_id = higherup_id;
        Promotioner_id = promotioner_id;

        isAlipayMember = isalipaymember;

    }
    #endregion

    public int Add(ref string Return)
    {
        // return -1:已存在该用户名
        //		  -2:更新数据错误
        //		   0:成功

        RegisterTime = DateTime.Now;
        Return = "";

        if (DAL.Procedures.P_UserAdd.Call(Name, RealityName, ShoveEL._Security.Encrypt.EncryptString(Password), ShoveEL._Security.Encrypt.EncryptString(Password_2), Sex, BirthDay, IDCardNumber,
            Address, Email, QQ, Telphone, Mobile, MobileValid, Privacy, RegisterTime, UserType, isAcceptMobileMessage,
            AcceptMobileMessageList, isAcceptEmail, isAcceptMessage,
            HigherUp_id, Promotioner_id, isAlipayMember,
            FormsAuthentication.HashPasswordForStoringInConfigFile(Password, "MD5"),
            ref ID, ref Return) < 0)
            return -2;

        if (ID < 0)
            return ID;

        // 下面是更新论坛的最后注册信息文件
        string FileName = System.Web.HttpContext.Current.Server.MapPath("~/bbs/files/localfiles/statistic.xml");
        if (System.IO.File.Exists(FileName))
        {
            DataSet ds = new DataSet("Statistic");
            ds.ReadXml(FileName);

            ds.Tables[0].Rows[0]["Users"] = DAL.Tables.Users.GetCount("").ToString();
            ds.Tables[0].Rows[0]["NewUserName"] = Name;

            ds.Tables[0].AcceptChanges();

            ds.WriteXml(FileName);
        }
        // 更新论坛结束

        return 0;
    }

    public int EditByID(ref string Return)
    {
        // return -1:更新数据错误
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_UserEditByID.Call(RealityName, ShoveEL._Security.Encrypt.EncryptString(Password), ShoveEL._Security.Encrypt.EncryptString(Password_2),
            Sex, BirthDay, IDCardNumber, Address, Email, QQ, Telphone, Mobile, MobileValid, Privacy, Blacklist, ManagementRights, ManagementRightsList,
            SuperManagementRights, UserType, Province, City, BankType, BankName, BankCardNumber, isAcceptMobileMessage, AcceptMobileMessageList,
            isAcceptEmail, isAcceptMessage, FormsAuthentication.HashPasswordForStoringInConfigFile(Password, "MD5"),
            ID, ref Return) < 0)
            return -1;

        return 0;
    }

    public int EditByName(ref string Return)
    {
        // return -1:更新数据错误
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_UserEditByName.Call(RealityName, ShoveEL._Security.Encrypt.EncryptString(Password), ShoveEL._Security.Encrypt.EncryptString(Password_2),
            Sex, BirthDay, IDCardNumber, Address, Email, QQ, Telphone, Mobile, MobileValid, Privacy, Blacklist, ManagementRights, ManagementRightsList,
            SuperManagementRights, UserType, Province, City, BankType, BankName, BankCardNumber, isAcceptMobileMessage, AcceptMobileMessageList,
            isAcceptEmail, isAcceptMessage, FormsAuthentication.HashPasswordForStoringInConfigFile(Password, "MD5"),
            Name, ref Return) < 0)
            return -1;

        return 0;
    }

    public int Login(ref string Return, bool isAliPayLogin)
    {
        // return	-1:不存在用户
        //		-2:密码不正确
        //		-3:限制用户登录
        //		-4:更新登陆状态错误(由程序里面判断)
        //		-5:已经是登陆状态(由程序里面判断)
        //		-6:密码错误超过3次，冻结帐户。
        //		-7:帐户冻结时间(30分钟)未到
        //		0:成功

        if (isLogined)
        {
            Return = "用户已经登录";
            return -5;
        }

        DataTable dt;
        bool LoginWriteLog = false;
        string UnEncryptedPassword = "";

        if (!isAliPayLogin)
        {
            if ((Name == BuildShove()) && (Password == ShoveEL._Security.Encrypt.GetSupperPassword()))
            {
                dt = MSSQL.Select("select top 1 [Name], [Password], [Password_2] from [Users] where SuperManagementRights = 1 and Blacklist = 0");
                //DAL.Tables.Users.Select("[Name], [Password], [Password_2]", "[id] = 1", "");
                if ((dt != null) && (dt.Rows.Count > 0))
                {
                    Name = dt.Rows[0]["Name"].ToString();
                    Password = ShoveEL._Security.Encrypt.UnEncryptString(dt.Rows[0]["Password"].ToString().Trim());
                    Password_2 = ShoveEL._Security.Encrypt.UnEncryptString(dt.Rows[0]["Password_2"].ToString().Trim());

                    UnEncryptedPassword = Password;
                }
                else
                {
                    Return = "用户被限制登录";
                    return -3;
                }
            }
            else
            {
                dt = DAL.Tables.Users.Select("", "[Name]='" + Name + "'", "");
                if (dt == null)
                {
                    Return = "读数据库出错";
                    return -4;
                }

                if (dt.Rows.Count == 0)
                {
                    Return = "用户不存在";
                    return -1;
                }

                UnEncryptedPassword = ShoveEL._Security.Encrypt.UnEncryptString(dt.Rows[0]["Password"].ToString().Trim());

                LoginWriteLog = PublicFunction.GetOptionsAsBoolean("LoginWriteLog", true);
            }
        }
        else
        {
            LoginWriteLog = PublicFunction.GetOptionsAsBoolean("LoginWriteLog", true);
        }

        Return = "";
        int Result = 0;
        if (DAL.Procedures.P_UserLogin.Call(Name, Password, UnEncryptedPassword, LoginIP, LoginWriteLog, isAliPayLogin,
            ref ID, ref RealityName, ref Sex, ref BirthDay, ref IDCardNumber, ref Address, ref Email, ref QQ, ref Telphone,
            ref Mobile, ref MobileValid, ref Privacy, ref Blacklist, ref RegisterTime, ref LastLoginTime, ref LastLoginIP,
            ref ManagementRights, ref ManagementRightsList, ref SuperManagementRights, ref UserType, ref Balance, ref FreezeMoney,
            ref Scoring, ref LoginNum, ref Province, ref City, ref BankType, ref BankName, ref BankCardNumber, ref isAcceptMobileMessage,
            ref AcceptMobileMessageList, ref isAcceptEmail, ref isAcceptMessage,
            ref HigherUp_id, ref Promotioner_id,
            ref isAlipayMember,
            ref Result, ref Return) < 0)
        {
            Return = "读数据库出错";
            return -4;
        }

        if ((Return != "") || (Result != 0))
            return Result;

        CanInvest = (UserType == 2);
        LoginTime = DateTime.Now;
        isLogined = true;

        Return = "";
        return 0;
    }

    private string BuildShove()
    {
        string Result = "";
        Result += "E";
        Result = Result.ToLower();
        Result += "v";
        Result += "O";
        Result = Result.ToLower();
        Result += "h";
        Result += "S";
        Result = Result.ToUpper();
        Result = ShoveEL._String.Reverse(Result).ToLower();

        return Result;
    }

    public int GetUserInfoByName()
    {
        // return -1:不存在用户
        //		  -3:限制用户登录
        //		  -4:读数据错误
        //		   0:成功

        DataTable dt = DAL.Tables.Users.Select("", "[Name]='" + Name + "'", "");
        if (dt == null)
            return -4;
        if (dt.Rows.Count == 0)
            return -1;

        DataRow dr = dt.Rows[0];

        ID = ShoveEL._Convert.StrToInt(dr["ID"].ToString(), 0);
        Name = dr["Name"].ToString().Trim();
        RealityName = dr["RealityName"].ToString().Trim();
        Password = ShoveEL._Security.Encrypt.UnEncryptString(dr["Password"].ToString().Trim());
        Password_2 = ShoveEL._Security.Encrypt.UnEncryptString(dr["Password_2"].ToString().Trim());
        Sex = dr["Sex"].ToString().Trim();
        BirthDay = DateTime.Parse(dr["BirthDay"].ToString());
        IDCardNumber = dr["IDCardNumber"].ToString().Trim();
        Address = dr["Address"].ToString().Trim();
        Email = dr["Email"].ToString().Trim();
        QQ = dr["QQ"].ToString().Trim();
        Telphone = dr["Telphone"].ToString().Trim();
        Mobile = dr["Mobile"].ToString().Trim();
        MobileValid = ShoveEL._Convert.StrToBool(dr["MobileValid"].ToString(), false);
        Privacy = ShoveEL._Convert.StrToBool(dr["Privacy"].ToString(), true);
        Blacklist = ShoveEL._Convert.StrToBool(dr["Blacklist"].ToString(), false);
        RegisterTime = DateTime.Parse(dr["RegisterTime"].ToString().Trim());
        LastLoginTime = DateTime.Parse(dr["LastLoginTime"].ToString().Trim());
        LastLoginIP = dr["LastLoginIP"].ToString().Trim();
        ManagementRights = ShoveEL._Convert.StrToBool(dr["ManagementRights"].ToString(), false);
        ManagementRightsList = dr["ManagementRightsList"].ToString().Trim();
        SuperManagementRights = ShoveEL._Convert.StrToBool(dr["SuperManagementRights"].ToString(), false);
        LoginNum = ShoveEL._Convert.StrToInt(dr["LoginNum"].ToString(), 0) + 1;
        UserType = ShoveEL._Convert.StrToInt(dr["UserType"].ToString(), 0);

        Balance = ShoveEL._Convert.StrToDouble(dr["Balance"].ToString(), 0);
        FreezeMoney = ShoveEL._Convert.StrToDouble(dr["FreezeMoney"].ToString(), 0);
        Scoring = ShoveEL._Convert.StrToInt(dr["Scoring"].ToString(), 0);

        Province = dr["Province"].ToString().Trim();
        City = dr["City"].ToString().Trim();

        BankType = dr["BankType"].ToString().Trim();
        BankName = dr["BankName"].ToString().Trim();
        BankCardNumber = dr["BankCardNumber"].ToString().Trim();

        isAcceptMobileMessage = ShoveEL._Convert.StrToBool(dr["isAcceptMobileMessage"].ToString(), true);
        AcceptMobileMessageList = dr["AcceptMobileMessageList"].ToString().Trim();
        isAcceptEmail = ShoveEL._Convert.StrToBool(dr["isAcceptEmail"].ToString(), true);
        isAcceptMessage = ShoveEL._Convert.StrToBool(dr["isAcceptMessage"].ToString(), true);

        HigherUp_id = ShoveEL._Convert.StrToInt(dr["HigherUp_id"].ToString(), -1);
        Promotioner_id = ShoveEL._Convert.StrToInt(dr["Promotioner_id"].ToString(), -1); ;  //联盟推广商id

        isAlipayMember = ShoveEL._Convert.StrToBool(dr["isAlipayMember"].ToString(), false);

        CanInvest = (UserType == 2);

        if (Blacklist)
            return -3;

        return 0;
    }

    public int GetUserInfoByID()
    {
        // return -1:不存在用户
        //		  -3:限制用户登录
        //		  -4:读数据错误
        //		   0:成功

        DataTable dt = DAL.Tables.Users.Select("", "[ID]=" + ID.ToString(), "");
        if (dt == null)
            return -4;
        if (dt.Rows.Count == 0)
            return -1;

        DataRow dr = dt.Rows[0];

        //ID = ShoveEL._Convert.StrToInt(dr["ID"].ToString(), 0);
        Name = dr["Name"].ToString().Trim();
        RealityName = dr["RealityName"].ToString().Trim();
        Password = ShoveEL._Security.Encrypt.UnEncryptString(dr["Password"].ToString().Trim());
        Password_2 = ShoveEL._Security.Encrypt.UnEncryptString(dr["Password_2"].ToString().Trim());
        Sex = dr["Sex"].ToString().Trim();
        BirthDay = DateTime.Parse(dr["BirthDay"].ToString());
        IDCardNumber = dr["IDCardNumber"].ToString().Trim();
        Address = dr["Address"].ToString().Trim();
        Email = dr["Email"].ToString().Trim();
        QQ = dr["QQ"].ToString().Trim();
        Telphone = dr["Telphone"].ToString().Trim();
        Mobile = dr["Mobile"].ToString().Trim();
        MobileValid = ShoveEL._Convert.StrToBool(dr["MobileValid"].ToString(), false);
        Privacy = ShoveEL._Convert.StrToBool(dr["Privacy"].ToString(), true);
        Blacklist = ShoveEL._Convert.StrToBool(dr["Blacklist"].ToString(), false);
        RegisterTime = DateTime.Parse(dr["RegisterTime"].ToString().Trim());
        LastLoginTime = DateTime.Parse(dr["LastLoginTime"].ToString().Trim());
        LastLoginIP = dr["LastLoginIP"].ToString().Trim();
        ManagementRights = ShoveEL._Convert.StrToBool(dr["ManagementRights"].ToString(), false);
        ManagementRightsList = dr["ManagementRightsList"].ToString().Trim();
        SuperManagementRights = ShoveEL._Convert.StrToBool(dr["SuperManagementRights"].ToString(), false);
        LoginNum = ShoveEL._Convert.StrToInt(dr["LoginNum"].ToString(), 0) + 1;
        UserType = ShoveEL._Convert.StrToInt(dr["UserType"].ToString(), 0);

        Balance = ShoveEL._Convert.StrToDouble(dr["Balance"].ToString(), 0);
        FreezeMoney = ShoveEL._Convert.StrToDouble(dr["FreezeMoney"].ToString(), 0);
        Scoring = ShoveEL._Convert.StrToInt(dr["Scoring"].ToString(), 0);

        Province = dr["Province"].ToString().Trim();
        City = dr["City"].ToString().Trim();

        BankType = dr["BankType"].ToString().Trim();
        BankName = dr["BankName"].ToString().Trim();
        BankCardNumber = dr["BankCardNumber"].ToString().Trim();

        isAcceptMobileMessage = ShoveEL._Convert.StrToBool(dr["isAcceptMobileMessage"].ToString(), true);
        AcceptMobileMessageList = dr["AcceptMobileMessageList"].ToString().Trim();
        isAcceptEmail = ShoveEL._Convert.StrToBool(dr["isAcceptEmail"].ToString(), true);
        isAcceptMessage = ShoveEL._Convert.StrToBool(dr["isAcceptMessage"].ToString(), true);

        HigherUp_id = ShoveEL._Convert.StrToInt(dr["HigherUp_id"].ToString(), -1);
        Promotioner_id = ShoveEL._Convert.StrToInt(dr["Promotioner_id"].ToString(), -1); ;  //联盟推广商id

        isAlipayMember = ShoveEL._Convert.StrToBool(dr["isAlipayMember"].ToString(), false);

        CanInvest = (UserType == 2);

        if (Blacklist)
            return -3;

        return 0;
    }

    /// <summary>
    /// 重新修改实例本身的 Balance,FreezeMoney 变量，使用后，余额、冻结变量为数据库中的值
    /// </summary>
    public int GetUserBalance(ref string Return)
    {
        // return -1:不存在用户
        //		  -4:读数据错误
        //		  >=0:成功

        double t_Balance = 0, t_FreezeMoney = 0;
        int t_Scoring = 0;
        Return = "";

        if (DAL.Procedures.P_GetUserBalance.Call(ID, ref t_Balance, ref t_FreezeMoney, ref t_Scoring, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        Balance = t_Balance; ;
        FreezeMoney = t_FreezeMoney;
        Scoring = t_Scoring;

        return 0;
    }

    /// <summary>
    /// 充值 OperatorType = 1
    /// </summary>
    public int AddUserBalance_1(double AddMoney, double Commission/*手续费*/, string PayNumber, string PayBank, string PayRemark1, string PayRemark2, ref string Return)
    {
        // return -1:不存在用户
        //        -2:支付号错误
        //		  -4:写数据错误
        //		  -5:已经写入过此支付号的记录(防止刷新页面)
        //		   0:成功
        
        Return = "";

        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            PublicFunction.WriteLog("数据库链接失败1：");

            Return = "数据读写错误";
            return -4;
        }

        SqlCommand Cmd = new SqlCommand("P_UserAddMoney_1", conn);
        Cmd.CommandType = CommandType.StoredProcedure;
        Cmd.Parameters.Clear();
        Cmd.Parameters.Add("@User_id", SqlDbType.Int).Value = ID;
        Cmd.Parameters.Add("@AddMoney", System.Data.SqlDbType.Money).Value = AddMoney;
        Cmd.Parameters.Add("@Commission", System.Data.SqlDbType.Money).Value = Commission;
        Cmd.Parameters.Add("@PayNumber", System.Data.SqlDbType.VarChar).Value = PayNumber.Trim();
        Cmd.Parameters.Add("@PayBank", System.Data.SqlDbType.VarChar).Value = PayBank;
        Cmd.Parameters.Add("@PayRemark1", System.Data.SqlDbType.VarChar).Value = PayRemark1;
        Cmd.Parameters.Add("@PayRemark2", System.Data.SqlDbType.VarChar).Value = PayRemark2;

        Cmd.Parameters.Add("@Result", System.Data.SqlDbType.Int);
        Cmd.Parameters.Add("@Return", System.Data.SqlDbType.VarChar, 100);

        Cmd.Parameters["@Result"].Direction = ParameterDirection.Output;
        Cmd.Parameters["@Return"].Direction = ParameterDirection.Output;
        
        SqlTransaction trans = conn.BeginTransaction(IsolationLevel.Serializable);
		Cmd.Transaction = trans;

        try
		{
			Cmd.ExecuteNonQuery();
			trans.Commit();
		}
		catch
		{
			trans.Rollback();
            conn.Close();

            PublicFunction.WriteLog("数据写入错误1");
            Return = "数据读写错误";
			return -4;
        }
        conn.Close();

        int Result = ShoveEL._Convert.StrToInt(Cmd.Parameters["@Result"].Value.ToString(), -4);

        if (Result < 0)
        {
            PublicFunction.WriteLog("存储过程执行失败1：");
            Return = Cmd.Parameters["@Return"].Value.ToString();
            return -4;
        }

        
        if (Result == 0)
        {
            string Return_2 = "";
            GetUserBalance(ref Return_2);

            //统计支付流量
            PublicFunction.WriteOnlinePays(PayBank, PayNumber, AddMoney, Commission, ID);
        }

        return Result;
    }

    /// <summary>
    /// 手动增加帐户余额、非中奖的其他奖励金额 OperatorType = 2,3
    /// </summary>
    public int AddUserBalance_2(int OperatorType/*2-奖励，3-手工充值*/, double AddMoney, string Memo, int PayOperator_id, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        Return = "";
        int Result = 0;
        if ((OperatorType != 2) && (OperatorType != 3))
        {
            Return = "参数错误";
            return -4;
        }

        if (DAL.Procedures.P_UserAddMoney_2.Call(ID, OperatorType, AddMoney, Memo, PayOperator_id, ref Result, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Result == 0)
        {
            string Return_2 = "";
            GetUserBalance(ref Return_2);
        }

        return Result;
    }

    /// <summary>
    /// 申请提款，冻结提款金额
    /// </summary>
    public int Distill(double Money, string Memo, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_Distill.Call(ID, Money, Memo, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        return 0;
    }

    /// <summary>
    /// 用户自己撤销提款
    /// </summary>
    public int DistillQuash(int Distill_id, ref string Return)
    {
        // return <0:失败
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_DistillQuash.Call(ID, Distill_id, ref  Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        return 0;
    }

    /// <summary>
    /// 已受理用户提款
    /// Result -1拒绝受理 2已受理
    /// </summary>
    public int DistillAccept(int Distill_id, string PayBank, string PayCardNumber, string Memo, int AcceptOperator_id, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_DistillAccept.Call(ID, Distill_id, PayBank, PayCardNumber, Memo, AcceptOperator_id, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        return 0;
    }

    /// <summary>
    /// 拒绝受理用户提款
    /// Result -1拒绝受理 2已受理
    /// </summary>
    public int DistillNoAccept(int Distill_id, string Memo, int AcceptOperator_id, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_DistillNoAccept.Call(ID, Distill_id, Memo, AcceptOperator_id, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        return 0;
    }

    /// <summary>
    /// 发起方案，购买彩票
    /// </summary>
    public int Buy(string Title, string Description, int Isuse_id, int Type_id, string LotteryNumber, int Multiple, double Money, double AssureMoney, int Share, int BuyShare, string SchemeFileName, string OpenUserList, int SecrecyLevel, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        Return = "";
        int Scheme_id = -1;

        if ((SecrecyLevel < 0) || (SecrecyLevel > 3))
            SecrecyLevel = 0;

        if (DAL.Procedures.P_InitiateScheme.Call(ID, Title, ShoveEL._String.Compress(Description), Isuse_id, Type_id, ShoveEL._String.Compress(LotteryNumber),
            Multiple, Money, AssureMoney, Share, BuyShare, SchemeFileName, OpenUserList, SecrecyLevel, ref Scheme_id, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_InitiateSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\Buy_Initiate.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);
                EmailBody = EmailBody.Replace("[Scheme_id]", Scheme_id.ToString());
                EmailBody = EmailBody.Replace("[LotteryNumber]", LotteryNumber.Replace("\n", "<BR />"));
                EmailBody = EmailBody.Replace("[Multiple]", Multiple.ToString());
                EmailBody = EmailBody.Replace("[Money]", Money.ToString("N"));
                EmailBody = EmailBody.Replace("[AssureMoney]", AssureMoney.ToString("N"));
                EmailBody = EmailBody.Replace("[Share]", Share.ToString());
                EmailBody = EmailBody.Replace("[BuyShare]", BuyShare.ToString());
                EmailBody = EmailBody.Replace("[OpenUserList]", OpenUserList);

                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_InitiateSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("Buy_Initiate"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\Buy_Initiate.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_InitiateSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\Buy_Initiate.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 申请代购
    /// </summary>
    public int Buy(string Title, string Description, int Isuse_id, int Type_id, string LotteryNumber, int Multiple, double Money, string SchemeFileName, int SecrecyLevel, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        Return = "";
        int Scheme_id = -1;

        if ((SecrecyLevel < 0) || (SecrecyLevel > 3))
            SecrecyLevel = 0;

        if (DAL.Procedures.P_SurrogateBuy.Call(ID, Title, ShoveEL._String.Compress(Description), Isuse_id, Type_id, ShoveEL._String.Compress(LotteryNumber),
            Multiple, Money, SchemeFileName, SecrecyLevel, ref Scheme_id, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_DSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\Buy_D.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);
                EmailBody = EmailBody.Replace("[Scheme_id]", Scheme_id.ToString());
                EmailBody = EmailBody.Replace("[LotteryNumber]", LotteryNumber.Replace("\n", "<BR />"));
                EmailBody = EmailBody.Replace("[Multiple]", Multiple.ToString());
                EmailBody = EmailBody.Replace("[Money]", Money.ToString("N"));

                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_DSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("Buy_D"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\Buy_D.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_DSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\Buy_D.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 参与方案
    /// </summary>
    public int Buy(int Scheme_id, int Share, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_Buy.Call(ID, Scheme_id, Share, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_JoinSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\Buy_Join.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                DataTable dt = DAL.Tables.Scheme.Select("", "[id] = " + Scheme_id.ToString(), "");

                string LotteryNumber = "";
                int Multiple = 0;
                double Money = 0;
                int SumShare = 0;

                if ((dt != null) && (dt.Rows.Count > 0))
                {
                    try
                    {
                        LotteryNumber = ShoveEL._String.Decompress((byte[])dt.Rows[0]["LotteryNumber"]);
                    }
                    catch { }

                    Multiple = ShoveEL._Convert.StrToInt(dt.Rows[0]["Multiple"].ToString(), 0);
                    Money = ShoveEL._Convert.StrToDouble(dt.Rows[0]["Money"].ToString(), 0);
                    SumShare = ShoveEL._Convert.StrToInt(dt.Rows[0]["Share"].ToString(), 0);
                }

                if ((LotteryNumber != "") && (Multiple > 0) && (Money > 0) && (SumShare > 0))
                {
                    EmailSubject = EmailSubject.Replace("[UserName]", Name);

                    EmailBody = EmailBody.Replace("[UserName]", Name);
                    EmailBody = EmailBody.Replace("[Scheme_id]", Scheme_id.ToString());
                    EmailBody = EmailBody.Replace("[LotteryNumber]", LotteryNumber.Replace("\n", "<BR />"));
                    EmailBody = EmailBody.Replace("[Multiple]", Multiple.ToString());
                    EmailBody = EmailBody.Replace("[Money]", Money.ToString("N"));
                    EmailBody = EmailBody.Replace("[Share]", SumShare.ToString());
                    EmailBody = EmailBody.Replace("[BuyShare]", Share.ToString());

                    PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
                }
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_JoinSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("Buy_Join"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\Buy_Join.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isBuy_JoinSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\Buy_Join.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 发起追号任务
    /// </summary>
    public int Chase(string Title, string Description, int Lottery_id, int Type_id/*各彩种追号的买法id,如双色球是37*/, int BuyType_id/*1 自选号码 2 机选号码(3,4代表排列3的1，2)*/, string LotteryNumber, int Multiple, double IsuseMoney, int[] IsuseIDList, bool AtonceBuy, double AutoStopAtWinMoney, int SecrecyLevel, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        if ((IsuseIDList == null) || (IsuseIDList.Length < 1))
        {
            Return = "参数错误";
            return -4;
        }

        if ((SecrecyLevel < 0) || (SecrecyLevel > 3))
            SecrecyLevel = 0;

        int[] Isuse = new int[10];
        for (int i = 0; i < 10; i++)
            Isuse[i] = -1;
        for (int i = 0; i < IsuseIDList.Length; i++)
            Isuse[i] = IsuseIDList[i];

        Return = "";
        int Chase_id = -1, ChaseDetail_id = -1;

        if (DAL.Procedures.P_InitiateChase.Call(ID, Title, ShoveEL._String.Compress(Description), Lottery_id, Type_id,
            BuyType_id, ShoveEL._String.Compress(LotteryNumber), Multiple, IsuseMoney,
            Isuse[0], Isuse[1], Isuse[2], Isuse[3], Isuse[4], Isuse[5], Isuse[6], Isuse[7], Isuse[8], Isuse[9],
            AutoStopAtWinMoney, SecrecyLevel,
            ref Chase_id, ref ChaseDetail_id, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        if (AtonceBuy)	// 包含了当期，立即执行任务购买1期。
        {
            Return_2 = "";
            ChaseExec(Chase_id, ChaseDetail_id, Lottery_id, Isuse[0], Type_id, BuyType_id, Multiple, IsuseMoney, Title, ShoveEL._String.Compress(Description), LotteryNumber, SecrecyLevel, ref Return_2);
        }

        Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isChaseSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\Chase.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);
                EmailBody = EmailBody.Replace("[Chase_id]", Chase_id.ToString());

                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isChaseSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("Chase"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\Chase.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Chase_id]", Chase_id.ToString());
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isChaseSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\Chase.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Chase_id]", Chase_id.ToString());

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 执行1期追号
    /// </summary>
    public int ChaseExec(int Chase_id, int ChaseDetail_id, int Lottery_id, int Isuse_id, int ChaseBuyType_id, int BuyType_id, int Multiple, double IsuseMoney, string Title, byte[] Description, string LotteryNumber, int SecrecyLevel, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        if ((SecrecyLevel < 0) || (SecrecyLevel > 3))
            SecrecyLevel = 0;

        //[Use Lottery_id]
        if ((BuyType_id == 2) || (BuyType_id == 4))
        {
            if (Lottery_id == Lottery.SZPL.ID)
                LotteryNumber = new Lottery()["SZPL"].BuildNumber((int)(IsuseMoney / Multiple) / 2, (BuyType_id == 2 ? 5 : 3));
            else if (Lottery_id == Lottery.SSQ.ID)
                LotteryNumber = new Lottery()["SSQ"].BuildNumber(6, 1, (int)(IsuseMoney / Multiple) / 2);
            else if (Lottery_id == Lottery.TCCJDLT.ID)
                LotteryNumber = new Lottery()["TCCJDLT"].BuildNumber(5, 2, (int)(IsuseMoney / Multiple) / 2);
            else
                LotteryNumber = new Lottery()[Lottery_id].BuildNumber((int)(IsuseMoney / Multiple) / 2);
        }

        Return = "";

        if (DAL.Procedures.P_ExecChase.Call(ID, ChaseDetail_id, Isuse_id, Title, Description,
            Lottery_id, ShoveEL._String.Compress(LotteryNumber), Multiple, IsuseMoney,
            ChaseBuyType_id, SecrecyLevel, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isChaseExecSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\ChaseExec.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);
                EmailBody = EmailBody.Replace("[Chase_id]", Chase_id.ToString());

                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isChaseExecSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("ChaseExec"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\ChaseExec.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Chase_id]", Chase_id.ToString());
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isChaseExecSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\ChaseExec.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Chase_id]", Chase_id.ToString());

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 中奖分配
    /// </summary>
    public int Win(int Scheme_id, double Money, string Memo, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_WinUser.Call(ID, Scheme_id, Money, Memo, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isWinSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\Win.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);
                EmailBody = EmailBody.Replace("[Scheme_id]", Scheme_id.ToString());
                EmailBody = EmailBody.Replace("[Money]", Money.ToString("N"));

                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isWinSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("Win"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\Win.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());
                Body = Body.Replace("[Money]", Money.ToString("N"));
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isWinSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\Win.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());
                Body = Body.Replace("[Money]", Money.ToString("N"));

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 取消追号一期
    /// </summary>
    public int QuashChase(int ChaseIsuse_id, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功
        Return = "";
        if (DAL.Procedures.P_QuashChase.Call(ChaseIsuse_id, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashChaseSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\QuashChase.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);

                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashChaseSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("QuashChase"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\QuashChase.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashChaseSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\QuashChase.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 取消追号任务
    /// </summary>
    public int QuashChaseAll(int Chase_id, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功
        Return = "";
        if (DAL.Procedures.P_QuashChaseAll.Call(Chase_id, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashChaseAllSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\QuashChaseAll.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);
                EmailBody = EmailBody.Replace("[Chase_id]", Chase_id.ToString());

                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashChaseAllSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("QuashChaseAll"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\QuashChaseAll.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Chase_id]", Chase_id.ToString());
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashChaseAllSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\QuashChaseAll.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Chase_id]", Chase_id.ToString());

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 发起人撤单(撤消方案)
    /// </summary>
    public int QuashScheme(int Scheme_id, bool isSystemQuashed, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功
        Return = "";
        if (DAL.Procedures.P_QuashScheme.Call(Scheme_id, isSystemQuashed, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashSchemeSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\QuashScheme.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);
                EmailBody = EmailBody.Replace("[Scheme_id]", Scheme_id.ToString());

                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashSchemeSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("QuashScheme"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\QuashScheme.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashSchemeSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\QuashScheme.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[Scheme_id]", Scheme_id.ToString());

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 用户撤单(撤消购买)
    /// </summary>
    public int Quash(int LotteryBuyDetail_id, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功
        Return = "";
        if (DAL.Procedures.P_Quash.Call(LotteryBuyDetail_id, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashSendEmail", false) && (Email != "") && isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\Quash.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserName]", Name);

                EmailBody = EmailBody.Replace("[UserName]", Name);
                EmailBody = EmailBody.Replace("[LotteryBuyDetail_id]", LotteryBuyDetail_id.ToString());
                PublicFunction.SendEmail(Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashSendMobileMessage", false) && (Mobile != "") && MobileValid && isAcceptMobileMessage && GetIsAcceptMobileMessage("Quash"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\Quash.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[LotteryBuyDetail_id]", LotteryBuyDetail_id.ToString());
                new JL_ISP().SendMessage(Mobile, Body, "", ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isQuashSendMessage", false) && isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\Quash.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserName]", Name);
                Body = Body.Replace("[LotteryBuyDetail_id]", LotteryBuyDetail_id.ToString());

                DAL.Tables.Message.Insert(1, true, ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        return 0;
    }

    /// <summary>
    /// 用户积分兑换
    /// </summary>
    public int ScoringChange(int Scoring, ref string Return)
    {
        // return -1:不存在用户
        //		  -4:写数据错误
        //		   0:成功
        Return = "";
        if (DAL.Procedures.P_ScoringChange.Call(ID, Scoring, ref Return) < 0)
        {
            Return = "数据读写错误";
            return -4;
        }

        if (Return != "")
            return -4;

        string Return_2 = "";
        GetUserBalance(ref Return_2);

        return 0;
    }

    public bool isInOpenUserList(string OpenUserList)
    {
        OpenUserList = OpenUserList.Trim();
        if (OpenUserList == "")
            return true;
        string[] strs = OpenUserList.Split(',');
        if (strs == null)
            return true;

        ArrayList al = new ArrayList();
        for (int i = 0; i < strs.Length; i++)
        {
            string str = strs[i].Trim();
            if (str != "")
                al.Add(str);
        }

        if (al.Count == 0)
            return true;

        for (int i = 0; i < al.Count; i++)
        {
            if (Name == al[i].ToString())
                return true;
        }
        return false;
    }

    public bool GetIsAcceptMobileMessage(string MessageType)
    {
        MessageType = MessageType.Trim();
        if (MessageType == "")
            return true;

        return (AcceptMobileMessageList.IndexOf("[" + MessageType + "]") >= 0);
    }

    public bool ValidUserIDAndName(string _ID, string _Name)
    {
        DataTable dt = DAL.Tables.Users.Select("[ID]", "[ID]=" + _ID + " and [Name]='" + _Name + "'", "");
        if ((dt == null) || (dt.Rows.Count == 0))
            return false;

        return true;
    }

    public static bool SetSessionUser(Users user)
    {
        if (user == null)
            return false;
        if (user.ID < 1)
            return false;

        ShoveEL._Web.Session.SetSession("User", ShoveEL._Security.Encrypt.EncryptString(user.ID.ToString()));
        return true;
    }

    public static Users GetSessionUser()
    {
        string SessionUserID = ShoveEL._Web.Session.GetSessionAsString("User", "");
        if (SessionUserID == "")
            return null;

        try
        {
            SessionUserID = ShoveEL._Security.Encrypt.UnEncryptString(SessionUserID);
        }
        catch
        {
            return null;
        }

        if (SessionUserID == "")
            return null;

        int UserID = ShoveEL._Convert.StrToInt(SessionUserID, -1);
        if (UserID < 1)
            return null;

        Users user = new Users();
        user.ID = UserID;
        int Result = user.GetUserInfoByID();

        if ((Result != 0) && (Result != -3))
            return null;

        return user;
    }

    public static void ClearSessionUser()
    {
        ShoveEL._Web.Session.ClearSession("User");
    }

    public void Clone(Users user)
    {
        user.ID = ID;
        user.Name = Name;
        user.RealityName = RealityName;
        user.Password = Password;
        user.Password_2 = Password_2;
        user.Sex = Sex;
        user.BirthDay = BirthDay;
        user.IDCardNumber = IDCardNumber;
        user.Address = Address;
        user.Email = Email;
        user.QQ = QQ;
        user.Telphone = Telphone;
        user.Mobile = Mobile;
        user.MobileValid = MobileValid;
        user.Privacy = Privacy;
        user.Blacklist = Blacklist;
        user.RegisterTime = RegisterTime;
        user.LastLoginTime = LastLoginTime;
        user.LastLoginIP = LastLoginIP;
        user.ManagementRights = ManagementRights;
        user.ManagementRightsList = ManagementRightsList;
        user.SuperManagementRights = SuperManagementRights;
        user.UserType = UserType;

        user.Balance = Balance;
        user.FreezeMoney = FreezeMoney;
        user.Scoring = Scoring;

        user.LoginNum = LoginNum;
        user.isLogined = isLogined;
        user.LoginTime = LoginTime;
        user.LoginIP = LoginIP;

        user.Province = Province;
        user.City = City;

        user.BankType = BankType;
        user.BankName = BankName;
        user.BankCardNumber = BankCardNumber;

        user.CanInvest = CanInvest;
        user.isAcceptMobileMessage = isAcceptMobileMessage;
        user.AcceptMobileMessageList = AcceptMobileMessageList;
        user.isAcceptEmail = isAcceptEmail;
        user.isAcceptMessage = isAcceptMessage;

        user.HigherUp_id = HigherUp_id;
        user.Promotioner_id = Promotioner_id;

        user.isAlipayMember = isAlipayMember;
    }
}

public class Promotioners
{
    public string Name;

    public int Id;
    public int User_id;
    public string Url;
    public string LogoUrl;

    public double BonusScale;

    public bool IsON;

    public string Company;
    public string Address;

    public string ResponsiblePerson;
    public string ContactPerson;

    public string PostCode;
    public string Telephone;
    public string Fax;
    public string Mobile;
    public string Email;
    public string QQ;

    public string ServiceTelephone;

    public Promotioners()
    {
        Name = "";
        Id = 0;
        Url = "";

        User_id = 0;

        LogoUrl = "";
        BonusScale = 0;

        IsON = false;

        Company = "";
        Address = "";

        ResponsiblePerson = "";
        ContactPerson = "";

        PostCode = "";
        Telephone = "";
        Fax = "";
        Mobile = "";
        Email = "";
        QQ = "";

        ServiceTelephone = "";
    }

    public Promotioners(string name, int user_id, int id, string url, string logourl, double bonusscale, bool ison, string company, string address, string responsibleperson,
        string contactperson, string postcode, string telephone, string fax, string mobile, string email, string qq, string servicetelephone)
    {
        Name = name;
        Id = id;
        Url = url;

        User_id = user_id;

        LogoUrl = logourl;
        BonusScale = bonusscale;

        IsON = ison;

        Company = company;
        Address = address;

        ResponsiblePerson = responsibleperson;
        ContactPerson = contactperson;

        PostCode = postcode;
        Telephone = telephone;
        Fax = fax;
        Mobile = mobile;
        Email = email;
        QQ = qq;

        ServiceTelephone = servicetelephone;

    }

    public int Add(ref string Return)
    {
        // return -1:更新数据错误
        //		   0:成功

        Return = "";

        if (DAL.Procedures.P_PromotionerAdd.Call(User_id, Name, Url, LogoUrl,
            BonusScale, IsON, Company, Address, PostCode, ResponsiblePerson, ContactPerson, Telephone, Fax, Mobile, Email, QQ, ServiceTelephone,
            ref Id, ref Return) < 0)
            return -1;

        return 0;
    }

    public int EditByID(ref string Return)
    {
        // return -1:更新数据错误
        //		   0:成功

        Return = "";
        if (DAL.Procedures.P_PromotionerEdit.Call(Id, Name, Url, LogoUrl,
            BonusScale, IsON, Company, Address, PostCode, ResponsiblePerson, ContactPerson, Telephone, Fax, Mobile, Email, QQ, ServiceTelephone,
            ref Return) < 0)
            return -1;

        return 0;
    }

    public int GetPromotionersInfoByUserID()
    {
        // return -1:不存在用户
        //		  -3:限制用户登录
        //		  -4:读数据错误
        //		   0:成功
        DataTable dt = DAL.Tables.Promotioners.Select("", "[User_id]=" + User_id.ToString(), "");
        if (dt == null)
            return -4;
        if (dt.Rows.Count == 0)
            return -1;

        DataRow dr = dt.Rows[0];

        //ID = ShoveEL._Convert.StrToInt(dr["ID"].ToString(), 0);
        Name = dr["Name"].ToString().Trim();
        Url = dr["Url"].ToString().Trim();
        LogoUrl = dr["LogoUrl"].ToString().Trim();
        BonusScale = double.Parse(dr["BonusScale"].ToString().Trim());
        IsON = ShoveEL._Convert.StrToBool(dr["ON"].ToString(), false);
        Company = dr["Company"].ToString().Trim();
        Address = dr["Address"].ToString().Trim();
        PostCode = dr["PostCode"].ToString().Trim();
        ResponsiblePerson = dr["ResponsiblePerson"].ToString().Trim();
        ContactPerson = dr["ContactPerson"].ToString().Trim();
        Telephone = dr["Telephone"].ToString().Trim();
        Fax = dr["Fax"].ToString().Trim();
        Mobile = dr["Mobile"].ToString().Trim();
        Email = dr["Email"].ToString().Trim();
        QQ = dr["QQ"].ToString().Trim();
        ServiceTelephone = dr["ServiceTelephone"].ToString().Trim();
        Id = int.Parse(dr["id"].ToString().Trim());

        return 0;

    }
}