﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class BuyMenu : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindData();
        }
    }

    private void BindData()
    {
        DataTable dt = DAL.Tables.Lottery.Select("[id], [Name], [Type_id]", "isUsed = 1", "[Sort]");
        if (dt == null)
        {
            PublicFunction.GoError();
            return;
        }

        foreach (DataRow dr in dt.Rows)
        {
            Infragistics.WebUI.UltraWebTab.UltraWebTab uwt = null;

            switch (dr["Type_id"].ToString())
            {
                case "2":
                    uwt = uwtLottery3;
                    break;
                case "3":
                    uwt = uwtLottery4;
                    break;
                case "4":
                    uwt = uwtLottery0;
                    break;
                case "5":
                    uwt = uwtLottery1;
                    break;
                case "6":
                    uwt = uwtLottery2;
                    break;
                case "8":
                    uwt = uwtLottery5;
                    break;
                case "9":
                    uwt = uwtLottery6;
                    break;
                case "10":
                    uwt = uwtLottery7;
                    break;
            }

            if (uwt == null)
                continue;

            Infragistics.WebUI.UltraWebTab.Tab tab = new Infragistics.WebUI.UltraWebTab.Tab(dr["Name"].ToString());

            uwt.Tabs.Add(tab);

            // 在新增加的彩票里面增加买法菜单

            DataTable dt_2 = DAL.Tables.LotteryBuyType.Select("", "Lottery_id = " + dr["id"].ToString(), "[id]");
            if (dt_2 == null)
            {
                PublicFunction.GoError();
                return;
            }

            string BuyMenu = "";
            int MenuCount = 0;

            Lottery lottery = new Lottery();

            foreach (DataRow dr_2 in dt_2.Rows)
            {
                string str = dr_2["BuyFileName"].ToString();
                if ((str == null) || (str == ""))
                {
                    continue;
                }

                if (((MenuCount % 4) == 0) && (MenuCount > 0))
                {
                    BuyMenu += "<br />";
                }
                MenuCount++;

                bool isChase = (str == "Chase.aspx?id=[ID]");

                if (dr["id"].ToString() == Lottery.ZCDC.sID)
                {
                    str = "MemberOfZCDC.aspx?SubPage=MemberBuy/" + str;
                    BuyMenu += "&nbsp;&nbsp;<a href='" + str + "' class='li" + (isChase ? "4" : "3") + "' target='_top'>【" + dr_2["Type"].ToString() + "】</a>";
                }
                else
                {
                    str = "MemberBuy/" + str.Replace("[ID]", dr["id"].ToString().ToString()).Replace("[Lottery]", dr["id"].ToString().ToString()).Replace("[BuyType]", dr_2["id"].ToString());
                    BuyMenu += "&nbsp;&nbsp;<a href='" + str + "' class='li" + (isChase ? "4" : "3") + "' target='MemberIframe'>【" + dr_2["Type"].ToString() + "】</a>";
                }
            }

            if ((MenuCount % 4) != 0)
            {
                BuyMenu += "<br />";
            }
            BuyMenu += "<br />";

            Label label = new Label();
            label.Text = BuyMenu;

            tab.ContentPane.Controls.Add(label);           
        }

        // 隐藏没有彩种的 Tab
        if (uwtLottery0.Tabs.Count < 1)
            uwtLottery0.Visible = false;
        else
            uwtLottery0.SelectedTabIndex = 0;

        if (uwtLottery1.Tabs.Count < 1)
            uwtLottery1.Visible = false;
        else
            uwtLottery1.SelectedTabIndex = 0;

        if (uwtLottery2.Tabs.Count < 1)
            uwtLottery2.Visible = false;
        else
            uwtLottery2.SelectedTabIndex = 0;
        
        if (uwtLottery3.Tabs.Count < 1)
            uwtLottery3.Visible = false;
        else
            uwtLottery3.SelectedTabIndex = 0;
        
        if (uwtLottery4.Tabs.Count < 1)
            uwtLottery4.Visible = false;
        else
            uwtLottery4.SelectedTabIndex = 0;
        
        if (uwtLottery5.Tabs.Count < 1)
            uwtLottery5.Visible = false;
        else
            uwtLottery5.SelectedTabIndex = 0;
        
        if (uwtLottery6.Tabs.Count < 1)
            uwtLottery6.Visible = false;
        else
            uwtLottery6.SelectedTabIndex = 0;
        
        if (uwtLottery7.Tabs.Count < 1)
            uwtLottery7.Visible = false;
        else
            uwtLottery7.SelectedTabIndex = 0;
    }
}
