﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Celeb : System.Web.UI.Page
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    private void BindData()
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        SqlDataAdapter da = new SqlDataAdapter("select * from V_Celeb where [Sort] > 0 order by [Sort]", conn);
        DataTable dt = new DataTable();

        try
        {
            da.Fill(dt);
        }
        catch
        {
            conn.Close();
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }
        conn.Close();

        dt.Columns.Add("Intro2", System.Type.GetType("System.String"));
        dt.Columns.Add("Say2", System.Type.GetType("System.String"));
        dt.Columns.Add("Comment2", System.Type.GetType("System.String"));
        dt.Columns.Add("Score2", System.Type.GetType("System.String"));
        foreach (DataRow dr in dt.Rows)
        {
            try
            {
                dr["Intro2"] = ShoveEL._String.Decompress((byte[])dr["Intro"]);
            }
            catch
            {
                dr["Intro2"] = "";
            }
            try
            {
                dr["Say2"] = ShoveEL._String.Decompress((byte[])dr["Say"]);
            }
            catch
            {
                dr["Say2"] = "";
            }
            try
            {
                dr["Comment2"] = ShoveEL._String.Decompress((byte[])dr["Comment"]);
            }
            catch
            {
                dr["Comment2"] = "";
            }
            try
            {
                dr["Score2"] = ShoveEL._String.Decompress((byte[])dr["Score"]);
            }
            catch
            {
                dr["Score2"] = "";
            }
            dt.AcceptChanges();
        }

        g.DataSource = dt;
        g.DataBind();

        if (dt.Rows.Count == 0)
        {
            labTip.Text = "</BR><center>暂无数据！</center></br>";
            labTip.Visible = true;
        }
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataListItemEventArgs e)
    {
        int User_id = ShoveEL._Convert.StrToInt(((HtmlInputHidden)e.Item.FindControl("tbUser_id")).Value, 0);
        if (User_id < 1)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        SqlDataAdapter da = new SqlDataAdapter("select * from V_SchemeSchedule where InitiateUser_id = " + User_id.ToString() + " and GetDate() Between StartTime and SystemEndTime order by [DateTime]", conn);
        DataTable dt = new DataTable();
        try
        {
            da.Fill(dt);
        }
        catch
        {
            conn.Close();
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        dt.Columns.Add("State", System.Type.GetType("System.String"));
        dt.Columns.Add("Join", System.Type.GetType("System.String"));
        dt.Columns.Add("ShareMoney", System.Type.GetType("System.Double"));
        
        foreach(DataRow row in dt.Rows)
        {
            bool Quashed = ShoveEL._Convert.StrToBool(row["Quashed"].ToString(), false);
            double Money = ShoveEL._Convert.StrToDouble(row["Money"].ToString(), 0);
            int Share = ShoveEL._Convert.StrToInt(row["Share"].ToString(), 0);
            int Schedule = ShoveEL._Convert.StrToInt(row["Schedule"].ToString(), 0);
            bool LotteryBuyed = ShoveEL._Convert.StrToBool(row["LotteryBuyed"].ToString(), false);

            row["ShareMoney"] = Money / Share;

            if (Quashed)
            {
                row["State"] = "已撤单";
                row["Join"] = "--";
            }
            else
            {
                if (LotteryBuyed)
                {
                    row["State"] = "<font color='red'>已成功</font>";
                    row["Join"] = "--";
                }
                else
                {
                    if (Schedule >= 100)
                    {
                        row["State"] = "<font color='red'>已满员</font>";
                        row["Join"] = "--";
                    }
                    else
                    {
                        row["State"] = "未满员";
                        row["Join"] = "<font color='red'>入伙</font>";
                    }
                }
            }
            dt.AcceptChanges();
        }

        DataGrid g2 = (DataGrid)e.Item.FindControl("g2");
        g2.DataSource = dt;
        g2.DataBind();
        conn.Close();
    }
}