﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;

public partial class Chat_SchemeChat : System.Web.UI.Page
{
    public Users user;

    public int ClientInterval = 2;
    public int ClientNoSpeakStopChatTimes = 1200;
    public int OnlineTimeout = 20;
    public int SchemeID = -1;
    public int SiteValidSum = -1;
    public static int SysServerUserID = 0;

    public string Welcome;
    public string IPAddress = "";
    public string Place;
    public string UserID;
    public string UserName;
    public string SessionID;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(Chat_SchemeChat));
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        SchemeID = ShoveEL._Convert.StrToInt("" + this.Request["ID"], -1);
        if (SchemeID < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "无此聊天室信息。", "../index.aspx");
            return;
        }

        user = Users.GetSessionUser();

        if (user == null)
        {
            Response.Redirect("../Error.aspx?ErrorNumber=02&LastRequestPage=Chat/SchemeChat.aspx?id=" + SchemeID.ToString(), true);
            return;
        }

        IPAddress = this.Request.UserHostAddress;
        SessionID = this.Session.SessionID;
        UserID = user.ID.ToString();
        UserName = user.Name;

        SchemeBindData(SchemeID, user);

        tbScheme_id.Text = SchemeID.ToString();
        labBalance.Text = user.Balance.ToString("N");

        CheckUser(SchemeID, user, ref Welcome);
    }

    private void SchemeBindData(int SchemeID, Users user)
    {
        DataTable dt = DAL.Views.V_SchemeScheduleWithQuashed.Select("", "[id] = " + SchemeID.ToString(), "");
        if ((dt == null) || (dt.Rows.Count < 1))
        {
            PublicFunction.GoError();
            return;
        }

        DataRow dr = dt.Rows[0];

        int InitiateUser_id = ShoveEL._Convert.StrToInt(dr["InitiateUser_id"].ToString(), 0);

        //既不是发起人，也不在招股对象之内
        if ((!user.isInOpenUserList(dr["OpenUserList"].ToString().Trim())) && (InitiateUser_id != user.ID))
        {
            string Tip = "对不起，您不在此方案的招股对象之内。";

            Response.Redirect("../Error.aspx?ErrorNumber=01&Tip=" + Tip, true);
            return;
        }

        bool Quashed = ShoveEL._Convert.StrToBool(dr["Quashed"].ToString(), false);
        bool isSystemQuashed = ShoveEL._Convert.StrToBool(dr["isSystemQuashed"].ToString(), false);
        bool LotteryBuyed = ShoveEL._Convert.StrToBool(dr["LotteryBuyed"].ToString(), false);

        int Share = ShoveEL._Convert.StrToInt(dr["Share"].ToString(), 0);
        int BuyedShare = ShoveEL._Convert.StrToInt(dr["BuyedShare"].ToString(), 0);

        double Schedule = Math.Round((double.Parse(BuyedShare.ToString()) / double.Parse(Share.ToString())) * 100, 2);
        double Money = ShoveEL._Convert.StrToDouble(dr["Money"].ToString(), 0);

        labEndTime.Text = dr["SystemEndTime"].ToString();

        bool CanBuy = false;
        bool Stop = false;
        System.DateTime EndTime = DateTime.Parse(labEndTime.Text);
        if (DateTime.Now >= EndTime)
        {
            Stop = true;
            tbStop.Text = Stop.ToString();
        }

        if (Quashed)
        {
            if (isSystemQuashed)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "系统已撤单，聊天室已被取消。", "../index.aspx");
                return;
            }
            else
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "系统已撤单，聊天室已被取消。", "../index.aspx");
                return;
            }
        }
        else
        {
            if (Stop)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "本期方案已截止，聊天室取消。", "../index.aspx");
                return;
            }
            else
            {
                if (LotteryBuyed)
                {
                    labState.Text = "已成功";
                }
                else
                {
                    if (Share <= BuyedShare)
                    {
                        labState.Text = "已满员";
                    }
                    else
                    {
                        labState.Text = "抢购中..";
                        CanBuy = true;
                    }
                }
            }
        }

        if (CanBuy)
        {
            tbShare.Enabled = true;
            tbInvestPassword.Enabled = true;
            imgBuy.Disabled = false;
        }
        else
        {
            tbShare.Enabled = false;
            tbInvestPassword.Enabled = false;
            imgBuy.Disabled = true;
        }

        //填充内容
        labSchemeNum.Text = dr["SchemeNumber"].ToString();
        labSchemeNum1.Text = dr["SchemeNumber"].ToString();
        labInitiateUser.Text = dr["InitiateUser"].ToString();
        labSchemeMoney.Text = ShoveEL._Convert.StrToDouble(dr["Money"].ToString(), 0).ToString("N");
        labMultiple.Text = dr["Multiple"].ToString();
        labShareCount.Text = Share.ToString();
        labBuyedShare.Text = BuyedShare.ToString();
        labSchedule.Text = Schedule.ToString() + "%";
        labShare.Text = (Share - BuyedShare).ToString();
        labShareMoney.Text = (Money / Share).ToString("N");

        try
        {
            labSchemeDescription.Text = "方案描述：" + ShoveEL._Convert.ToHtmlCode(ShoveEL._String.Decompress((byte[])dr["Description"])) + "&nbsp;";
        }
        catch
        {
            labSchemeDescription.Text = "&nbsp;";
        }
    }

    private void CheckUser(int SchemeID, Users user, ref string Welcome)
    {
        string AllUser = "";
        string Return = "";

        int Result = 0;

        DataTable dt = ShoveEL.Database.MSSQL.Select("Select * From SchemeChat Where SchemeID = " + SchemeID.ToString());

        if (dt == null || dt.Rows.Count == 0)
        {
            ShoveEL.Database.MSSQL.OutputParameter Outputs = new ShoveEL.Database.MSSQL.OutputParameter();
            ShoveEL.Database.MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatAddUser", ref Outputs,
                new ShoveEL.Database.MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                new ShoveEL.Database.MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, user.ID),
                new ShoveEL.Database.MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress("欢迎" + user.Name + "加入本方案聊天室!")),
                new ShoveEL.Database.MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                new ShoveEL.Database.MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return));

            Result = System.Convert.ToInt32(Outputs["Result"]);
            Return = System.Convert.ToString(Outputs["Return"]);

            Welcome = UserName + "：欢迎您加入本方案聊天室！";

            return;
        }

        for (int i = 0; i < dt.Rows.Count; i++)
        {
            if (dt.Rows[0]["UserID"].ToString() != user.ID.ToString())
            {
                if (AllUser != "")
                {
                    AllUser += ",";
                }

                AllUser += dt.Rows[0]["UserID"];
            }
            else
            {
                ShoveEL.Database.MSSQL.OutputParameter Outputs = new ShoveEL.Database.MSSQL.OutputParameter();
                ShoveEL.Database.MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatAddUser", ref Outputs,
                    new ShoveEL.Database.MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                    new ShoveEL.Database.MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, user.ID),
                    new ShoveEL.Database.MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress("欢迎" + user.Name + "再次回到本方案聊天室!")),
                    new ShoveEL.Database.MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                    new ShoveEL.Database.MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return));

                Result = System.Convert.ToInt32(Outputs["Result"]);
                Return = System.Convert.ToString(Outputs["Return"]);

                Welcome = UserName + "：欢迎您再次回到本方案聊天室！";

                return;
            }
        }

        AllUser += "," + user.ID.ToString();
        if (AllUser.Length >= 8000)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，无此聊天室会员已经爆满。", "../index.aspx");
            return;
        }
        else
        {
            ShoveEL.Database.MSSQL.OutputParameter Outputs = new ShoveEL.Database.MSSQL.OutputParameter();
            ShoveEL.Database.MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatAddUser", ref Outputs,
                new ShoveEL.Database.MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                new ShoveEL.Database.MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, user.ID),
                new ShoveEL.Database.MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress("欢迎" + user.Name + "加入本方案聊天室!")),
                new ShoveEL.Database.MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                new ShoveEL.Database.MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return));

            Result = System.Convert.ToInt32(Outputs["Result"]);
            Return = System.Convert.ToString(Outputs["Return"]);

            Welcome = UserName + "：欢迎您加入本方案聊天室！";
        }
    }

    //[Ajax.AjaxMethod()]
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public string btnOK_Click(int SchemeID, string InvestPassword, double SumMoney, int BuyShare, double labShareMoney, string EndTime)
    {
        string Return = "";

        user = Users.GetSessionUser();

        if (user == null)
        {
            Return = "-1";
            return Return;
        }

        if (!user.CanInvest)
        {
            Return = "对不起，您还不是高级会员，请先免费升级为高级会员。谢谢！";
            return Return;
        }

        if (InvestPassword != user.Password_2)
        {
            Return = "投注密码错误！";
            return Return;
        }

        DateTime EndTime1 = DateTime.Parse(EndTime);
        if (DateTime.Now > EndTime1)
        {
            Return = "投注时间已经截止，不能认购。";
            return Return;
        }

        double ShareMoney = 0;
        int Share = 0;

        try
        {
            ShareMoney = labShareMoney;
            Share = BuyShare;
        }
        catch
        {
            Return = "输入有错误，请仔细检查。";
            return Return;
        }

        if ((ShareMoney <= 0) || (Share < 1))
        {
            Return = "输入有错误，请仔细检查。";
            return Return;
        }

        if (SumMoney != (ShareMoney * Share))
        {
            Return = "输入有错误，请仔细检查。";
            return Return;
        }

        Return = "";
        user.GetUserBalance(ref Return);
        if ((ShareMoney * Share) > user.Balance)
        {
            Return = "您的帐户余额不足，请先增加预付款，谢谢。";
            return Return;
        }

        Return = "";
        int Result = user.Buy(SchemeID, Share, ref Return);
        if ((Return != "") || (Result != 0))
        {
            //PublicFunction.GoError(Return);
            return Return;
        }

        return Return;
    }

    /// <summary>
    /// 获取聊天室的在线用户列表
    /// </summary>
    /// <param name="UserID"></param>
    /// <param name="SchemeID"></param>
    /// <param name="UserName"></param>
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public RequestUserList GetUserList(int SchemeID, int ServerUserID)
    {
        RequestUserList r = new RequestUserList();

        DataTable dt = ShoveEL.Database.MSSQL.Select("select UserID,[Name],Quashed,UserShare,SchemeShare,LastJoinTime from V_SchemeChatUsers where Talking = 1 and SchemeID = " + SchemeID.ToString() + " order by Quashed asc, UserShare desc, LastJoinTime desc");

        if (dt == null || dt.Rows.Count == 0)
        {
            return r;
        }

        r.UserNum = dt.Rows.Count;

        r.UserID = new string[dt.Rows.Count];
        r.UserName = new string[dt.Rows.Count];
        r.Share = new int[dt.Rows.Count];
        r.Quashed = new bool[dt.Rows.Count];

        for (int i = 0; i < dt.Rows.Count; i++)
        {
            if (i == 0)
            {
                if ((ServerUserID != 0) && (ServerUserID != int.Parse(dt.Rows[i]["UserID"].ToString())))
                {
                    int Result = 0;

                    string Return = "";

                    ShoveEL.Database.MSSQL.OutputParameter Outputs = new ShoveEL.Database.MSSQL.OutputParameter();
                    ShoveEL.Database.MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatContentAdd", ref Outputs,
                        new ShoveEL.Database.MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                        new ShoveEL.Database.MSSQL.Parameter("FromUserID", SqlDbType.Int, 0, ParameterDirection.Input, 0),
                        new ShoveEL.Database.MSSQL.Parameter("ToUserID", SqlDbType.Int, 0, ParameterDirection.Input, 0),
                        new ShoveEL.Database.MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress("祝贺" + dt.Rows[i]["Name"].ToString() + "被授予本方案管理员身份，负责维护本聊天室的秩序。")),
                        new ShoveEL.Database.MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                        new ShoveEL.Database.MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return));

                    Result = System.Convert.ToInt32(Outputs["Result"]);
                    Return = System.Convert.ToString(Outputs["Return"]);
                }

                r.ServerUserID = int.Parse(dt.Rows[i]["UserID"].ToString());
                r.ServerUserName = dt.Rows[i]["Name"].ToString();
            }

            SysServerUserID = int.Parse(dt.Rows[i]["UserID"].ToString());     //聊天室管理员ID

            r.UserID[i] = dt.Rows[i]["UserID"].ToString();
            r.UserName[i] = dt.Rows[i]["Name"].ToString();
            r.Share[i] = ShoveEL._Convert.StrToInt(dt.Rows[i]["UserShare"].ToString(), 0);
            r.Quashed[i] = ShoveEL._Convert.StrToBool(dt.Rows[i]["Quashed"].ToString(), true);
        }

        return r;
    }

    /// <summary>
    /// 删除过期用户
    /// </summary>
    /// <param name="UserID"></param>
    /// <param name="SchemeID"></param>
    /// <param name="UserName"></param>
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public bool GetUserOnline(int SchemeID, int UserID, string UserName)
    {
        bool IsOnLine = false;
        string Return = "";

        int Result = 0;

        int TmpUserID = 0;

        user = Users.GetSessionUser();

        if (user == null)
        {
            TmpUserID = -1;
        }
        else
        {
            TmpUserID = user.ID;
        }
        
        if (TmpUserID != UserID)     //如果聊天室传过来的用户ID不等于Session中的用户ID
        {
            ShoveEL.Database.MSSQL.OutputParameter Outputs = new ShoveEL.Database.MSSQL.OutputParameter();
            ShoveEL.Database.MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatDelUser", ref Outputs,
                new ShoveEL.Database.MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                new ShoveEL.Database.MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID),
                new ShoveEL.Database.MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress("由于" + UserName + "潜水时间过长，已经溺水身亡!")),
                new ShoveEL.Database.MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                new ShoveEL.Database.MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return));

            Result = System.Convert.ToInt32(Outputs["Result"]);
            Return = System.Convert.ToString(Outputs["Return"]);

            IsOnLine = false;
        }
        else
        {
            IsOnLine = true;
        }

        return IsOnLine;
    }

    /// <summary>
    /// 获取未浏览过的信息
    /// </summary>
    /// <param name="SchemeID"></param>
    /// <param name="UserID"></param>
    /// <returns></returns>
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public RequestChatInfo GetSchemeChatInfoList(int SchemeID, int UserID)
    {
        RequestChatInfo r = new RequestChatInfo();

        ShoveEL.Database.MSSQL.OutputParameter Outputs = new ShoveEL.Database.MSSQL.OutputParameter();
        DataSet ds = ShoveEL.Database.MSSQL.ExecuteStoredProcedureWithQuery("P_ChatInfo", ref Outputs,
            new ShoveEL.Database.MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
            new ShoveEL.Database.MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, UserID));

        DataTable dt = ds.Tables[0];

        if (dt.Rows.Count > 0)
        {
            r.InfoNum = dt.Rows.Count;
            r.Time = new string[dt.Rows.Count];
            r.Text = new string[dt.Rows.Count];
            r.FromUserName = new string[dt.Rows.Count];
            r.ToUserName = new string[dt.Rows.Count];
            r.InfoType = new string[dt.Rows.Count];

            for (int i = 0; i < dt.Rows.Count; i++)
            {
                r.Time[i] = dt.Rows[i]["Time"].ToString();
                r.Text[i] = ShoveEL._String.Decompress((byte[]) dt.Rows[i]["Text"]);
                r.FromUserName[i] = dt.Rows[i]["FromUserName"].ToString() == "" ? "系统消息" : dt.Rows[i]["FromUserName"].ToString();
                r.ToUserName[i] = dt.Rows[i]["ToUserName"].ToString() == "" ? "所有人" : dt.Rows[i]["ToUserName"].ToString();
                r.InfoType[i] = dt.Rows[i]["Type"].ToString();
            }
        }

        return r;
    }

    /// <summary>
    /// 添加聊天信息
    /// </summary>
    /// <param name="SchemeID"></param>
    /// <param name="FromUserID"></param>
    /// <param name="ToUserID"></param>
    /// <param name="Msg"></param>
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public void SendClientChatInfo(int SchemeID, int FromUserID, int ToUserID, string Msg)
    {
        string Return = "";

        int Result = 0;

        ShoveEL.Database.MSSQL.OutputParameter Outputs = new ShoveEL.Database.MSSQL.OutputParameter();
        ShoveEL.Database.MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatContentAdd", ref Outputs,
            new ShoveEL.Database.MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
            new ShoveEL.Database.MSSQL.Parameter("FromUserID", SqlDbType.Int, 0, ParameterDirection.Input, FromUserID),
            new ShoveEL.Database.MSSQL.Parameter("ToUserID", SqlDbType.Int, 0, ParameterDirection.Input, ToUserID),
            new ShoveEL.Database.MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(Msg)),
            new ShoveEL.Database.MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
            new ShoveEL.Database.MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return));

        Result = System.Convert.ToInt32(Outputs["Result"]);
        Return = System.Convert.ToString(Outputs["Return"]);
    }

    /// <summary>
    /// 用户离开聊天室
    /// </summary>
    /// <param name="SchemeID"></param>
    /// <param name="UserID"></param>
    /// <returns></returns>
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public bool ExitChat(int SchemeID, int UserID)
    {
        bool IsOK = true;

        int Result = ShoveEL.Database.MSSQL.ExecuteNonQuery("Update SchemeChat set Talking = 0 where SchemeID = @p1 and UserID = @p2", new ShoveEL.Database.MSSQL.Parameter("@p1", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID), new ShoveEL.Database.MSSQL.Parameter("@p2", SqlDbType.Int, 0, ParameterDirection.Input, UserID));

        if (Result != 0)
        {
            IsOK = false;
        }

        return IsOK;
    }

    /// <summary>
    /// 剔除用户
    /// </summary>
    /// <param name="SchemeID"></param>
    /// <param name="UserID"></param>
    /// <param name="ServerUserID"></param>
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public void DelUser(int SchemeID, int UserID, int ServerUserID, int DelUserID, string DelUserName)
    {
        string Return = "";

        int Result = 0;

        int TmpUserID = 0;

        user = Users.GetSessionUser();

        if (user == null)
        {
            TmpUserID = -1;
        }
        else
        {
            TmpUserID = user.ID;
        }

        if ((TmpUserID == UserID) && (UserID == ServerUserID) && (DelUserID > 0))
        {
            ShoveEL.Database.MSSQL.OutputParameter Outputs = new ShoveEL.Database.MSSQL.OutputParameter();
            ShoveEL.Database.MSSQL.ExecuteStoredProcedureWithQuery("P_SchemeChatDelUser", ref Outputs,
                new ShoveEL.Database.MSSQL.Parameter("SchemeID", SqlDbType.Int, 0, ParameterDirection.Input, SchemeID),
                new ShoveEL.Database.MSSQL.Parameter("UserID", SqlDbType.Int, 0, ParameterDirection.Input, DelUserID),
                new ShoveEL.Database.MSSQL.Parameter("Text", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress("由于" + DelUserName + "言行不检，备管理员踢出聊天室!")),
                new ShoveEL.Database.MSSQL.Parameter("Result", SqlDbType.Int, 4, ParameterDirection.Output, Result),
                new ShoveEL.Database.MSSQL.Parameter("Return", SqlDbType.VarChar, 100, ParameterDirection.Output, Return));

            Result = System.Convert.ToInt32(Outputs["Result"]);
            Return = System.Convert.ToString(Outputs["Return"]);
        }
    }
}