﻿
/*
    带软键盘的密码输入控件
    作者：shove
    时间：2007-8-24
*/

var CheryWebUI_CheryPasswordTextBox_UpperLowerState = "lower";
var CheryWebUI_CheryPasswordTextBox_MouseAtObject = null;

function CheryWebUI_CheryPasswordTextBox_OnClick(sender)
{
    var objDiv = document.getElementById(sender.id + "_DivKeyBoard");
    if (!objDiv)
    {
        return;
    }
    
    var pos = CheryWebUI_CheryPasswordTextBox_GetControlPosAtWindow(sender);
    objDiv.style.left = pos.left;
    objDiv.style.top = pos.bottom;
    
    objDiv.style.display = "";
    
    var objUpperLowerStatus = document.getElementById(sender.id + "_DivKeyBoard_UpperLowerStatus");
    if (objUpperLowerStatus)
    {
        objUpperLowerStatus.innerText = (CheryWebUI_CheryPasswordTextBox_UpperLowerState == "lower") ? "[小写]" : "[大写]";
    }
}

function CheryWebUI_CheryPasswordTextBox_OnBlur(sender)
{
    var objDiv = document.getElementById(sender.id + "_DivKeyBoard");
    if (!objDiv)
    {
        return;
    }

    if (CheryWebUI_CheryPasswordTextBox_MouseAtObject != objDiv)
    {
        objDiv.style.display = "none";
    }
}

function CheryWebUI_CheryPasswordInputKeyBoard_OnKeyPress(Key, objTextBox_id)
{
    var objTextBox = document.getElementById(objTextBox_id);
    if (!objTextBox)
    {
        return;
    }

    objTextBox.focus();
    
    var objUpperLowerStatus = document.getElementById(objTextBox_id + "_DivKeyBoard_UpperLowerStatus");
    if (!objUpperLowerStatus)
    {
        return;
    }
    
    var objDiv = document.getElementById(objTextBox_id + "_DivKeyBoard");
    if (!objDiv)
    {
        return;
    }

    var KeyChar = Key;
    
    if (Key == "Backspace")
    {
        if (objTextBox.value != "")
        {
            objTextBox.value = objTextBox.value.substring(0, objTextBox.value.length - 1);
        }
        return;
    }
    else if (Key == "CapsLock")
    {
        CheryWebUI_CheryPasswordTextBox_UpperLowerState = (CheryWebUI_CheryPasswordTextBox_UpperLowerState == "lower") ? "upper" : "lower";
        objUpperLowerStatus.innerText = (CheryWebUI_CheryPasswordTextBox_UpperLowerState == "lower") ? "[小写]" : "[大写]";
        return;
    }
    else if (Key == "Quotes")
    {
        KeyChar = "'" + '"';
    }
    else if (Key == "Enter")
    {
        objDiv.style.display = "none";
        objTextBox.focus();
        return;
    }
    else if (Key == "Shift")
    {
        CheryWebUI_CheryPasswordTextBox_UpperLowerState = (CheryWebUI_CheryPasswordTextBox_UpperLowerState == "lower") ? "upper" : "lower";
        objUpperLowerStatus.innerText = (CheryWebUI_CheryPasswordTextBox_UpperLowerState == "lower") ? "[小写]" : "[大写]";
        return;
    }
    
    if (KeyChar.length != 2)
    {
        return;
    }
    
    if (CheryWebUI_CheryPasswordTextBox_UpperLowerState == "lower")
    {
        objTextBox.value += KeyChar.substring(0, 1);
    }
    else
    {
        objTextBox.value += KeyChar.substring(1, 2);
    }
}

function CheryWebUI_CheryPasswordInputKeyBoard_OnClear(objTextBox_id)
{
    var objTextBox = document.getElementById(objTextBox_id);
    if (!objTextBox)
    {
        return;
    }

    objTextBox.value = "";
}

function CheryWebUI_CheryPasswordInputKeyBoard_OnClose(objDiv_id, objTextBox_id)
{
    var objTextBox = document.getElementById(objTextBox_id);
    if (!objTextBox)
    {
        return;
    }

    var objDiv = document.getElementById(objTextBox_id + "_DivKeyBoard");
    if (!objDiv)
    {
        return;
    }

    objDiv.style.display = "none";
    objTextBox.focus();
}

function CheryWebUI_CheryPasswordTextBox_SetMouseAtObject(sender, value)
{
    if (value)
    {
        CheryWebUI_CheryPasswordTextBox_MouseAtObject = sender;
    }
    else
    {
        CheryWebUI_CheryPasswordTextBox_MouseAtObject = null;
    }
}

function CheryWebUI_CheryPasswordTextBox_GetControlPosAtWindow(sender)
{
    var oRect = sender.getBoundingClientRect();

    var oLTRB =
    {
        "left": oRect.left + document.body.scrollLeft + document.documentElement.scrollLeft,
        "top": oRect.top + document.body.scrollTop + document.documentElement.scrollTop,
        "right": oRect.right + document.body.scrollTop + document.documentElement.scrollTop,
        "bottom": oRect.bottom + document.body.scrollTop + document.documentElement.scrollTop
    };

    return oLTRB;
}
