﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ClientLogin : System.Web.UI.Page
{
    public Users user;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
            Login();
    }

    private void Login()
    {
        string UserName = this.Request["UN"];
        string UserPassword = this.Request["UP"];
        string Key = this.Request["Key"];

        if (UserName == null)
            UserName = "";
        if (UserPassword == null)
            UserPassword = "";
        if (Key == null)
            Key = "";

        UserName = System.Web.HttpUtility.UrlDecode(UserName);

        if ((UserName == "") || (UserPassword == "") || (Key == ""))
        {
            PublicFunction.GoError("客户端登录异常！");
            return;
        }

        DateTime RequestDateTime = DateTime.Now.AddYears(-20);
        try
        {
            RequestDateTime = DateTime.Parse(ShoveEL._Security.Encrypt.UnEncryptString(Key));
        }
        catch
        {}

        // 判断客户端时间戳
        TimeSpan ts = DateTime.Now - RequestDateTime;
        if (Math.Abs(ts.TotalSeconds) > 60)
        {
            PublicFunction.GoError("客户端登录异常！");
            return;
        }

        System.Threading.Thread.Sleep(200);

        Users.ClearSessionUser();

        user = new Users();
        user.Name = UserName;

        int Result = user.GetUserInfoByName();
        if ((Result != 0) && (Result != -3))
        {
            PublicFunction.GoError("用户名不存在！");
            return;
        }

        string PasswordMD5 = System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(user.Password + "iloveshovesoft-a8g502shovee-shove-!(&(!!#)", "MD5");
        if (PasswordMD5.ToUpper() != UserPassword.ToUpper())
        {
            PublicFunction.GoError("密码错误！");
            return;
        }

        string Return = "";
        bool isAliPayLogin = false;
        Result = user.Login(ref Return, isAliPayLogin);

        if (Result != 0)
            PublicFunction.GoError(Return);
        else
        {
            Users.SetSessionUser(user);
            this.Response.Redirect("Member.aspx", true);
        }
    }
}