﻿if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_admin]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_admin]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_attach]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_attach]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_board]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_board]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_board_role]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_board_role]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_category]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_category]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_class]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_class]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_consume]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_consume]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_exexp]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_exexp]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_favourite]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_favourite]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_friend]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_friend]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_group]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_group]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_log]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_log]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_medal]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_medal]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_message]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_message]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_online]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_online]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_refuseip]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_refuseip]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_reply]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_reply]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_robotsadvent]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_robotsadvent]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_role]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_role]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_topic]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_topic]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_user]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_user]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[bbs_vote]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[bbs_vote]
GO

CREATE TABLE [dbo].[bbs_admin] (
	[admin] [nvarchar] (16) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[password] [nvarchar] (32) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[lasttime] [datetime] NOT NULL ,
	[logins] [int] NOT NULL ,
	[lastip] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[addtime] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_attach] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[replyid] [int] NOT NULL ,
	[topicid] [int] NOT NULL ,
	[boardid] [int] NOT NULL ,
	[name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[attachname] [nvarchar] (64) COLLATE Chinese_PRC_CI_AS NULL ,
	[attachpath] [nvarchar] (150) COLLATE Chinese_PRC_CI_AS NULL ,
	[attachtype] [int] NOT NULL ,
	[attachsize] [int] NOT NULL ,
	[downs] [int] NOT NULL ,
	[downloadrequire] [int] NOT NULL ,
	[uploadtime] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_board] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[categoryid] [int] NOT NULL ,
	[sortid] [int] NOT NULL ,
	[boardname] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[subject] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[logo] [nvarchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[admins] [nvarchar] (150) COLLATE Chinese_PRC_CI_AS NULL ,
	[browserequire] [int] NOT NULL ,
	[topicrequire] [int] NOT NULL ,
	[replyrequire] [int] NOT NULL ,
	[topics] [int] NOT NULL ,
	[lasttopicid] [int] NOT NULL ,
	[lasttopictitle] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[lasttopictime] [datetime] NOT NULL ,
	[lasttopicuser] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[parentid] [int] NOT NULL ,
	[parentsortid] [int] NOT NULL ,
	[childboards] [int] NOT NULL ,
	[replies] [int] NOT NULL ,
	[announce] [ntext] COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_board_role] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[roleid] [int] NOT NULL ,
	[boardid] [int] NOT NULL ,
	[strategy] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_category] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[categoryname] [nvarchar] (24) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[sortid] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_class] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[classname] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[description] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[boardid] [int] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_consume] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[type] [int] NOT NULL ,
	[productid] [int] NOT NULL ,
	[money] [int] NOT NULL ,
	[addtime] [datetime] NOT NULL ,
	[expire] [datetime] NULL ,
	[ip] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_exexp] (
	[username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[ExExp1] [int] NULL ,
	[ExExp2] [int] NULL ,
	[ExExp3] [int] NULL ,
	[ExExp4] [int] NULL ,
	[ExExp5] [int] NULL ,
	[ExExp6] [int] NULL ,
	[ExExp7] [int] NULL ,
	[ExExp8] [int] NULL ,
	[ExExp9] [int] NULL ,
	[ExExp10] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_favourite] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[item] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[itemid] [int] NOT NULL ,
	[addtime] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_friend] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[friendname] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[addtime] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_group] (
	[GroupID] [int] NULL ,
	[GroupName] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[IconPath] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Enabled] [bit] NULL ,
	[Required] [bit] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_log] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[action] [nvarchar] (100) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[addtime] [datetime] NOT NULL ,
	[ip] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[isforbacksystem] [bit] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_medal] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[medal] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[addtime] [datetime] NOT NULL ,
	[remark] [ntext] COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_message] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[sender] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[recipient] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[title] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[content] [ntext] COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[isread] [bit] NOT NULL ,
	[issenderdel] [bit] NOT NULL ,
	[isrecipientdel] [bit] NOT NULL ,
	[sendtime] [datetime] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_online] (
	[sessionid] [nvarchar] (24) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[power] [int] NOT NULL ,
	[ip] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[boardid] [int] NOT NULL ,
	[action] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[activetime] [datetime] NOT NULL ,
	[agent] [nvarchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[isfade] [bit] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_refuseip] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[startip] [bigint] NOT NULL ,
	[endip] [bigint] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_reply] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[topicid] [int] NOT NULL ,
	[content] [ntext] COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[ip] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[addtime] [datetime] NOT NULL ,
	[isdelete] [bit] NOT NULL ,
	[isformat] [bit] NULL ,
	[usingtag] [int] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_robotsadvent] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[agentinfo] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[pagetitle] [nvarchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[realurl] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[rawurl] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[happentime] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_role] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[type] [int] NOT NULL ,
	[rolename] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[limexp] [int] NOT NULL ,
	[rank] [int] NOT NULL ,
	[color] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[badge] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[pop_strategy] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[mng_strategy] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[exp_strategy] [ntext] COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_topic] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[boardid] [int] NOT NULL ,
	[classid] [int] NOT NULL ,
	[title] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[content] [ntext] COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[addtime] [datetime] NOT NULL ,
	[clicks] [int] NOT NULL ,
	[istop] [bit] NOT NULL ,
	[istopall] [bit] NOT NULL ,
	[isclassical] [bit] NOT NULL ,
	[islock] [bit] NOT NULL ,
	[isdelete] [bit] NOT NULL ,
	[lastreplyuser] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[lastreplytime] [datetime] NULL ,
	[lastreplypreview] [nvarchar] (36) COLLATE Chinese_PRC_CI_AS NULL ,
	[voteid] [int] NOT NULL ,
	[titlecolor] [int] NOT NULL ,
	[limitexp] [int] NOT NULL ,
	[money] [int] NOT NULL ,
	[icon] [int] NOT NULL ,
	[replies] [int] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_user] (
	[name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[password] [nvarchar] (32) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[sex] [bit] NOT NULL ,
	[email] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[info] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[face] [nvarchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[signature] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[roleid] [int] NOT NULL ,
	[power] [int] NOT NULL ,
	[experience] [int] NOT NULL ,
	[money] [int] NOT NULL ,
	[rank] [nvarchar] (16) COLLATE Chinese_PRC_CI_AS NULL ,
	[islock] [bit] NOT NULL ,
	[unlocktime] [datetime] NULL ,
	[logins] [int] NOT NULL ,
	[lastip] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[lasttime] [datetime] NOT NULL ,
	[jointime] [datetime] NOT NULL ,
	[isonline] [bit] NOT NULL ,
	[topics] [int] NOT NULL ,
	[deletes] [int] NOT NULL ,
	[todayuploads] [int] NOT NULL ,
	[todayuploadcount] [int] NOT NULL ,
	[firstip] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
	[timezone] [int] NOT NULL ,
	[isdelete] [bit] NOT NULL ,
	[truename] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[referrer] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[isactivated] [bit] NOT NULL ,
	[replies] [int] NOT NULL ,
	[question] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[answer] [nvarchar] (32) COLLATE Chinese_PRC_CI_AS NULL ,
	[ishide] [bit] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[bbs_vote] (
	[id] [int] IDENTITY (1, 1) NOT NULL ,
	[items] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[tickets] [nvarchar] (120) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[users] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[ismultiable] [bit] NOT NULL ,
	[addtime] [datetime] NOT NULL ,
	[days] [int] NOT NULL ,
	[limitexp] [int] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

ALTER TABLE [dbo].[bbs_admin] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_admin] PRIMARY KEY  CLUSTERED 
	(
		[admin]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_attach] WITH NOCHECK ADD 
	CONSTRAINT [PK__bbs_attach__2B0A656D] PRIMARY KEY  CLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_board] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_board] PRIMARY KEY  CLUSTERED 
	(
		[id]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_board_role] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_board_role] PRIMARY KEY  CLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_category] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_category] PRIMARY KEY  CLUSTERED 
	(
		[id]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_class] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_class] PRIMARY KEY  CLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_consume] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_consume] PRIMARY KEY  CLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_exexp] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_exexp] PRIMARY KEY  CLUSTERED 
	(
		[username]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_favourite] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_favourite] PRIMARY KEY  CLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_friend] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_friend] PRIMARY KEY  CLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_log] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_log] PRIMARY KEY  CLUSTERED 
	(
		[id]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_message] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_message] PRIMARY KEY  CLUSTERED 
	(
		[id]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_online] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_online] PRIMARY KEY  CLUSTERED 
	(
		[sessionid]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_refuseip] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_refuseip] PRIMARY KEY  CLUSTERED 
	(
		[id]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_reply] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_reply] PRIMARY KEY  CLUSTERED 
	(
		[id]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_role] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_role] PRIMARY KEY  CLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_vote] WITH NOCHECK ADD 
	CONSTRAINT [PK_bbs_vote] PRIMARY KEY  CLUSTERED 
	(
		[id]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

 CREATE  UNIQUE  CLUSTERED  INDEX [IX_bbs_topic] ON [dbo].[bbs_topic]([lastreplytime] DESC ) ON [PRIMARY]
GO

 CREATE  CLUSTERED  INDEX [IX_bbs_user] ON [dbo].[bbs_user]([jointime] DESC ) ON [PRIMARY]
GO

ALTER TABLE [dbo].[bbs_admin] ADD 
	CONSTRAINT [DF_bbs_admin_lastlogin] DEFAULT (getdate()) FOR [lasttime],
	CONSTRAINT [DF_bbs_admin_logincount] DEFAULT (0) FOR [logins],
	CONSTRAINT [DF_bbs_admin_addtime] DEFAULT (getdate()) FOR [addtime],
	CONSTRAINT [IX_bbs_admin] UNIQUE  NONCLUSTERED 
	(
		[username]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_attach] ADD 
	CONSTRAINT [DF__bbs_attac__reply__2BFE89A6] DEFAULT (0) FOR [replyid],
	CONSTRAINT [DF__bbs_attac__topic__2CF2ADDF] DEFAULT (0) FOR [topicid],
	CONSTRAINT [DF__bbs_attac__board__2DE6D218] DEFAULT (0) FOR [boardid],
	CONSTRAINT [DF__bbs_attac__attac__2EDAF651] DEFAULT (0) FOR [attachtype],
	CONSTRAINT [DF__bbs_attac__attac__2FCF1A8A] DEFAULT (0) FOR [attachsize],
	CONSTRAINT [DF__bbs_attac__downs__30C33EC3] DEFAULT (0) FOR [downs],
	CONSTRAINT [DF_bbs_attach_downloadrequire] DEFAULT (0) FOR [downloadrequire],
	CONSTRAINT [DF__bbs_attac__uploa__31B762FC] DEFAULT (getdate()) FOR [uploadtime]
GO

ALTER TABLE [dbo].[bbs_board] ADD 
	CONSTRAINT [DF_bbs_board_categoryid] DEFAULT (0) FOR [categoryid],
	CONSTRAINT [DF_bbs_board_sortid] DEFAULT (0) FOR [sortid],
	CONSTRAINT [DF_bbs_board_islock] DEFAULT (0) FOR [browserequire],
	CONSTRAINT [DF_bbs_board_isvip] DEFAULT (1) FOR [topicrequire],
	CONSTRAINT [DF_bbs_board_ishidden] DEFAULT (1) FOR [replyrequire],
	CONSTRAINT [DF_bbs_board_topiccount] DEFAULT (0) FOR [topics],
	CONSTRAINT [DF_bbs_board_lasttopicid] DEFAULT (0) FOR [lasttopicid],
	CONSTRAINT [DF_bbs_board_lasttopictime] DEFAULT (getdate()) FOR [lasttopictime],
	CONSTRAINT [DF__bbs_board__paren__2645B050] DEFAULT (0) FOR [parentid],
	CONSTRAINT [DF__bbs_board__paren__2739D489] DEFAULT (0) FOR [parentsortid],
	CONSTRAINT [DF__bbs_board__child__282DF8C2] DEFAULT (0) FOR [childboards],
	CONSTRAINT [DF__bbs_board__repli__339FAB6E] DEFAULT (0) FOR [replies]
GO

ALTER TABLE [dbo].[bbs_category] ADD 
	CONSTRAINT [DF_bbs_category_sortid] DEFAULT (0) FOR [sortid]
GO

ALTER TABLE [dbo].[bbs_consume] ADD 
	CONSTRAINT [DF_bbs_consume_type] DEFAULT (0) FOR [type],
	CONSTRAINT [DF_bbs_consume_time] DEFAULT (getdate()) FOR [addtime]
GO

ALTER TABLE [dbo].[bbs_exexp] ADD 
	CONSTRAINT [DF_bbs_exexp_ExExp1] DEFAULT (0) FOR [ExExp1],
	CONSTRAINT [DF_bbs_exexp_ExExp2] DEFAULT (0) FOR [ExExp2],
	CONSTRAINT [DF_bbs_exexp_ExExp3] DEFAULT (0) FOR [ExExp3],
	CONSTRAINT [DF_bbs_exexp_ExExp4] DEFAULT (0) FOR [ExExp4],
	CONSTRAINT [DF_bbs_exexp_ExExp5] DEFAULT (0) FOR [ExExp5],
	CONSTRAINT [DF_bbs_exexp_ExExp6] DEFAULT (0) FOR [ExExp6],
	CONSTRAINT [DF_bbs_exexp_ExExp7] DEFAULT (0) FOR [ExExp7],
	CONSTRAINT [DF_bbs_exexp_ExExp8] DEFAULT (0) FOR [ExExp8],
	CONSTRAINT [DF_bbs_exexp_ExExp9] DEFAULT (0) FOR [ExExp9],
	CONSTRAINT [DF_bbs_exexp_ExExp10] DEFAULT (0) FOR [ExExp10]
GO

ALTER TABLE [dbo].[bbs_favourite] ADD 
	CONSTRAINT [DF_bbs_favourite_addtime] DEFAULT (getdate()) FOR [addtime]
GO

ALTER TABLE [dbo].[bbs_friend] ADD 
	CONSTRAINT [DF_bbs_friend_addtime] DEFAULT (getdate()) FOR [addtime]
GO

ALTER TABLE [dbo].[bbs_log] ADD 
	CONSTRAINT [DF_bbs_log_addtime] DEFAULT (getdate()) FOR [addtime],
	CONSTRAINT [DF_bbs_log_isforbacksystem] DEFAULT (0) FOR [isforbacksystem]
GO

ALTER TABLE [dbo].[bbs_medal] ADD 
	CONSTRAINT [DF_bbs_medal_addtime] DEFAULT (getdate()) FOR [addtime]
GO

ALTER TABLE [dbo].[bbs_message] ADD 
	CONSTRAINT [DF_bbs_message_isread] DEFAULT (0) FOR [isread],
	CONSTRAINT [DF_bbs_message_issenderdel] DEFAULT (0) FOR [issenderdel],
	CONSTRAINT [DF_bbs_message_isrecipientdel] DEFAULT (0) FOR [isrecipientdel],
	CONSTRAINT [DF_bbs_message_sendtime] DEFAULT (getdate()) FOR [sendtime]
GO

ALTER TABLE [dbo].[bbs_online] ADD 
	CONSTRAINT [DF_bbs_online_power] DEFAULT (0) FOR [power],
	CONSTRAINT [DF_bbs_online_boardid] DEFAULT ((-1)) FOR [boardid],
	CONSTRAINT [DF_bbs_online_activetime] DEFAULT (getdate()) FOR [activetime],
	CONSTRAINT [DF__bbs_onlin__agent__6754599E] DEFAULT (N'unknown') FOR [agent],
	CONSTRAINT [DF__bbs_onlin__isfad__7F2BE32F] DEFAULT (0) FOR [isfade]
GO

ALTER TABLE [dbo].[bbs_refuseip] ADD 
	CONSTRAINT [DF_bbs_refuseip_startip] DEFAULT (0) FOR [startip],
	CONSTRAINT [DF_bbs_refuseip_endip] DEFAULT (0) FOR [endip]
GO

ALTER TABLE [dbo].[bbs_reply] ADD 
	CONSTRAINT [DF_bbs_reply_topicid] DEFAULT (0) FOR [topicid],
	CONSTRAINT [DF_bbs_reply_addtime] DEFAULT (getdate()) FOR [addtime],
	CONSTRAINT [DF_bbs_reply_isdelete] DEFAULT (0) FOR [isdelete],
	CONSTRAINT [DF__bbs_reply__isfor__02084FDA] DEFAULT (0) FOR [isformat],
	CONSTRAINT [DF__bbs_reply__using__32AB8735] DEFAULT (0) FOR [usingtag]
GO

ALTER TABLE [dbo].[bbs_robotsadvent] ADD 
	CONSTRAINT [DF_bbs_robotsadvent_happentime] DEFAULT (getdate()) FOR [happentime]
GO

ALTER TABLE [dbo].[bbs_role] ADD 
	CONSTRAINT [DF_bbs_role_rank] DEFAULT (0) FOR [rank]
GO

ALTER TABLE [dbo].[bbs_topic] ADD 
	CONSTRAINT [DF_bbs_topic_boardid] DEFAULT (0) FOR [boardid],
	CONSTRAINT [DF_bbs_topic_classid] DEFAULT (0) FOR [classid],
	CONSTRAINT [DF_bbs_topic_addtime] DEFAULT (getdate()) FOR [addtime],
	CONSTRAINT [DF_bbs_topic_clickcount] DEFAULT (0) FOR [clicks],
	CONSTRAINT [DF_bbs_topic_istop] DEFAULT (0) FOR [istop],
	CONSTRAINT [DF_bbs_topic_istopall] DEFAULT (0) FOR [istopall],
	CONSTRAINT [DF_bbs_topic_isclassical] DEFAULT (0) FOR [isclassical],
	CONSTRAINT [DF_bbs_topic_islock] DEFAULT (0) FOR [islock],
	CONSTRAINT [DF_bbs_topic_isdelete] DEFAULT (0) FOR [isdelete],
	CONSTRAINT [DF_bbs_topic_lastreplytime] DEFAULT (getdate()) FOR [lastreplytime],
	CONSTRAINT [DF__bbs_topic__votei__5FB337D6] DEFAULT (0) FOR [voteid],
	CONSTRAINT [DF__bbs_topic__title__74AE54BC] DEFAULT (0) FOR [titlecolor],
	CONSTRAINT [DF__bbs_topic__limit__00200768] DEFAULT (0) FOR [limitexp],
	CONSTRAINT [DF_bbs_topic_money] DEFAULT (0) FOR [money],
	CONSTRAINT [DF__bbs_topic__icon__01142BA1] DEFAULT (0) FOR [icon],
	CONSTRAINT [DF__bbs_topic__repli__3493CFA7] DEFAULT (0) FOR [replies],
	CONSTRAINT [PK_bbs_topic] PRIMARY KEY  NONCLUSTERED 
	(
		[id]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_user] ADD 
	CONSTRAINT [DF_user_sex] DEFAULT (0) FOR [sex],
	CONSTRAINT [DF_bbs_user_groupid] DEFAULT (0) FOR [roleid],
	CONSTRAINT [DF_user_power] DEFAULT (1) FOR [power],
	CONSTRAINT [DF_user_experience] DEFAULT (0) FOR [experience],
	CONSTRAINT [DF_bbs_user_money] DEFAULT (0) FOR [money],
	CONSTRAINT [DF_user_islock] DEFAULT (0) FOR [islock],
	CONSTRAINT [DF_user_logincount] DEFAULT (0) FOR [logins],
	CONSTRAINT [DF_bbs_user_lastip] DEFAULT (N'unknown') FOR [lastip],
	CONSTRAINT [DF_user_lasttime] DEFAULT (getdate()) FOR [lasttime],
	CONSTRAINT [DF_user_jointime] DEFAULT (getdate()) FOR [jointime],
	CONSTRAINT [DF_user_isonline] DEFAULT (0) FOR [isonline],
	CONSTRAINT [DF_user_topiccount] DEFAULT (0) FOR [topics],
	CONSTRAINT [DF_user_deletecount] DEFAULT (0) FOR [deletes],
	CONSTRAINT [DF_user_todayuploadcount] DEFAULT (0) FOR [todayuploads],
	CONSTRAINT [DF_bbs_user_todayuploadtimes] DEFAULT (0) FOR [todayuploadcount],
	CONSTRAINT [DF__bbs_user__timezo__73BA3083] DEFAULT (8) FOR [timezone],
	CONSTRAINT [DF__bbs_user__isdele__02FC7413] DEFAULT (0) FOR [isdelete],
	CONSTRAINT [DF__bbs_user__isacti__29221CFB] DEFAULT (1) FOR [isactivated],
	CONSTRAINT [DF__bbs_user__replie__3587F3E0] DEFAULT (0) FOR [replies],
	CONSTRAINT [DF_bbs_user_ishide] DEFAULT (0) FOR [ishide],
	CONSTRAINT [PK_user] PRIMARY KEY  NONCLUSTERED 
	(
		[name]
	) WITH  FILLFACTOR = 90  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[bbs_vote] ADD 
	CONSTRAINT [DF_bbs_vote_ismultiable] DEFAULT (0) FOR [ismultiable],
	CONSTRAINT [DF_bbs_vote_addtime] DEFAULT (getdate()) FOR [addtime],
	CONSTRAINT [DF_bbs_vote_days] DEFAULT (0) FOR [days],
	CONSTRAINT [DF_bbs_vote_limitexp] DEFAULT (0) FOR [limitexp]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cvb_private_newrowtoreply]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cvb_private_newrowtoreply]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cvb_private_newrowtotopic]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cvb_private_newrowtotopic]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cvb_private_newrowtovote]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cvb_private_newrowtovote]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cvb_transaction_newattach]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cvb_transaction_newattach]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cvb_transaction_newreply]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cvb_transaction_newreply]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cvb_transaction_newtopic]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cvb_transaction_newtopic]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cvb_transaction_newvote]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cvb_transaction_newvote]
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure cvb_private_newrowtoreply
	@replyid int out,
	@topicid int,
	@content ntext,
	@author nvarchar(50),
	@userip nvarchar(15),
	@usingtag int,
	@isformat bit
as 
	insert into bbs_reply (topicid, content, name, ip, usingtag, isformat) values (@topicid, @content, @author, @userip, @usingtag, @isformat)
	select @replyid = @@identity
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure cvb_private_newrowtotopic
	@topicid int out,
	@boardid int,
	@iconid int,
	@voteid int,
	@author nvarchar(50),
	@title nvarchar(50),
	@content ntext,
	@limitexp int,
	@money int,
	@classid int
as
	insert into bbs_topic (boardid, icon, voteid, name, title, content, limitexp, money, classid) values (@boardid, @iconid, @voteid, @author, @title, @content, @limitexp, @money, @classid)
	select @topicid = @@identity
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

create procedure cvb_private_newrowtovote
	@voteid int out,
	@voteitems ntext,
	@tickets nvarchar(120),
	@ismultiable bit,
	@votedays int,
	@limitexp int
as
	insert into bbs_vote (items, tickets, ismultiable, days, limitexp) values (@voteitems, @tickets, @ismultiable, @votedays, @limitexp)
	select @voteid = @@identity
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure cvb_transaction_newattach
	@username nvarchar(50),
	@attachname nvarchar(50),
	@attachpath nvarchar(200),
	@attachsize int,
	@attachtype int
as
	declare @attachid int

	insert into bbs_attach ([name], attachname, attachpath, attachsize, attachtype) values (@username, @attachname, @attachpath, @attachsize, @attachtype)
	set @attachid = @@identity
	update bbs_user set todayuploads=todayuploads+(@attachsize/1024) where [name]=@username
	select @attachid as attachid
	return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure cvb_transaction_newreply
	@topicid int,
	@boardid int,
	@title nvarchar(50),
	@content ntext,
	@author nvarchar(50),
	@userip nvarchar(15),
	@usingtag int,
	@isformat bit,
	@attachidlist nvarchar(255) = null
as
	declare @replyid int

	exec cvb_private_newrowtoreply @replyid output, @topicid, @content, @author, @userip, @usingtag, @isformat

	update bbs_topic set replies=replies+1, lastreplytime=getdate(), lastreplyuser=@author where id=@topicid
	update bbs_board set lasttopicid=@topicid, lasttopictitle=@title, lasttopicuser=@author, lasttopictime=getdate(), replies=replies+1 where id=@boardid
	update bbs_user set replies=replies+1 where name=@author
	if (@attachidlist is not null) and (@attachidlist <> '-1')
	begin
		execute( 'update bbs_attach set boardid=' + @boardid + ', topicid=' + @topicid + ', replyid=' + @replyid + '  where id in (' + @attachidlist + ')')
	end
	select @replyid as replyid
	return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure cvb_transaction_newtopic
	@boardid int,
	@voteid int = 0,
	@author nvarchar(50),
	@title nvarchar(50),
	@content ntext,
	@userip nvarchar(15),
	@usingtag int,
	@isformat bit,
	@iconid int,
	@limitexp int,
	@money int,
	@attachidlist nvarchar(255) = null	,
	@classid int
as
	declare @topicid int
	declare @replyid int
	
	exec cvb_private_newrowtotopic @topicid output, @boardid, @iconid, @voteid, @author, @title, @content, @limitexp, @money, @classid
	exec cvb_private_newrowtoreply @replyid output, @topicid, @content, @author, @userip, @usingtag, @isformat

	update bbs_board set lasttopicid=@topicid, lasttopictitle=@title, lasttopicuser=@author, lasttopictime=getdate(), topics=topics+1 where id=@boardid
	update bbs_user set topics=topics+1 where name=@author

	if (@attachidlist is not null) and (@attachidlist <> '-1')
	begin
		execute( 'update bbs_attach set boardid=' + @boardid + ', topicid=' + @topicid + ', replyid=' + @replyid + '  where id in (' + @attachidlist + ')')
	end
	select @topicid as topicid
	return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure cvb_transaction_newvote
	@boardid int,
	@author nvarchar(50),
	@title nvarchar(50),
	@content ntext,
	@userip nvarchar(15),
	@usingtag int,
	@isformat bit,
	@iconid int,
	@readrequireexp int,
	@voteitems ntext = null,
	@tickets nvarchar(120),
	@votedays int,
	@ismultiable bit,
	@voterequireexp int,
	@money int,
	@attachidlist nvarchar(255) = null	,
	@classid int
as
	declare @voteid int
	declare @topicid int
	declare @replyid int

	exec cvb_private_newrowtovote @voteid output, @voteitems, @tickets, @ismultiable, @votedays, @voterequireexp
	exec cvb_private_newrowtotopic @topicid output, @boardid, @iconid, @voteid, @author, @title, @content, @readrequireexp, @money, @classid
	exec cvb_private_newrowtoreply @replyid output, @topicid, @content, @author, @userip, @usingtag, @isformat

	update bbs_board set lasttopicid=@topicid, lasttopictitle=@title, lasttopicuser=@author, lasttopictime=getdate(), topics=topics+1 where id=@boardid
	update bbs_user set topics=topics+1 where name=@author

	if (@attachidlist is not null) and (@attachidlist <> '-1')
	begin
		execute( 'update bbs_attach set boardid=' + @boardid + ', topicid=' + @topicid + ', replyid=' + @replyid + '  where id in (' + @attachidlist + ')')
	end
	select @topicid as topicid
	return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO


--------  增加数据
insert into bbs_admin values ('admin', 'admin', 'C4CA4238A0B923820DCC509A6F75849B', '2007-2-28 18:08:11', 5, '127.0.0.1', '2007-2-28 10:04:50')

insert into bbs_group values (0, '游客', 'skin/$skin/icon/online_guest.gif', 1, 1)
insert into bbs_group values (1, '注册会员', 'skin/$skin/icon/online_member.gif', 1, 1)
insert into bbs_group values (2, '贵宾', 'skin/$skin/icon/online_honor.gif', 1, 0)
insert into bbs_group values (3, '商业用户', 'skin/$skin/icon/online_vip.gif', 1, 0)
insert into bbs_group values (4, '', '', 0, 0)
insert into bbs_group values (5, '', '', 0, 0)
insert into bbs_group values (6, '', '', 0, 0)
insert into bbs_group values (7, '版主', 'skin/$skin/icon/online_mod.gif', 1, 1)
insert into bbs_group values (8, '超级版主', 'skin/$skin/icon/online_supermod.gif', 1, 1)
insert into bbs_group values (9, '管理员', 'skin/$skin/icon/online_admin.gif', 1, 1)

insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '士兵', 0, 0, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '准尉', 100, 1, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '少尉', 200, 2, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '中尉', 300, 3, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '上尉', 400, 4, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '少校', 500, 5, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '中校', 600, 6, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '上校', 700, 7, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '少将', 800, 8, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '中将', 900, 9, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (3, '上将', 1000, 10, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (0, '管理员', 0, 45, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (0, '超级版主', 0, 30, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')
insert into bbs_role (type, rolename, limexp, rank, color, badge, pop_strategy, mng_strategy, exp_strategy) values (0, '版主', 0, 20, '#000000', null, '1;1;1;1;1;1;1;0;1;1;7;3;255;1;255;20;20;1;1;1;1;100;100;65535;65535;.rar|.gif.|.jpg;1024;10;1;1', '1;1;1;1;1;1;1;1;1;1;1;1', '2;2;1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;-2;-2;-2;0;0;0;0;0;0;0;0;0;-1;-1;-1;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;2;2;2;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0')

insert into bbs_user values ('admin', 'C4CA4238A0B923820DCC509A6F75849B', 0, 'webmatster@cnvery.com', '', 'userface/1.gif', '', 0, 9, 0, 0, '', 0, null, 3, '127.0.0.1', '2007-2-28 16:50:32', '2007-2-28 10:04:50', 1, 0, 0, 0, 0, '127.0.0.1', 8, 0, null, null, 1, 0, null, null, 0)