﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class DownLoadSchemeFile : System.Web.UI.Page
{
    public Users user;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        int Scheme_id = -1;
        Scheme_id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
        if (Scheme_id < 1)
        {
            this.Response.Redirect("Index.aspx", true);
            return;
        }

        user = Users.GetSessionUser();

        if (user == null)
        {
            Response.Redirect("Error.aspx?ErrorNumber=02&LastRequestPage=DownLoadSchemeFile.aspx?id=" + Scheme_id.ToString(), true);
            return;
        }

        if (!this.IsPostBack)
            BindData(Scheme_id);
    }

    private void BindData(int Scheme_id)
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            PublicFunction.GoError();
            return;
        }

        SqlCommand Cmd = new SqlCommand("select top 1 * from V_Scheme where [id] = " + Scheme_id.ToString(), conn);
        SqlDataReader dr = null;

        try
        {
            dr = Cmd.ExecuteReader();
        }
        catch
        {
            conn.Close();
            Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        if (!dr.Read())
        {
            dr.Close();
            conn.Close();
            labSchemeFile.Text = "未找到相关数据。";
            return;
        }

        //既不是发起人，也不在招股对象之内
        if ((!user.isInOpenUserList(dr["OpenUserList"].ToString().Trim())) && (ShoveEL._Convert.StrToInt(dr["InitiateUser_id"].ToString(), 0) != user.ID))
        {
            dr.Close();
            conn.Close();
            PublicFunction.GoError("对不起，您不在此方案的招股对象之内。");
            return;
        }

        string SchemeFile = "", SchemeFileContent = "";

        try
        {
            SchemeFile = ShoveEL._String.Decompress((byte[])dr["FileName"]);
        }
        catch
        {
        }

        if (SchemeFile != "")
        {
            SchemeFile = this.Server.MapPath("SchemeFile/" + dr["Name"].ToString() + "/" + dr["Isuse"].ToString() + "/" + dr["Type"].ToString() + "/" + SchemeFile);
            
            if (System.IO.File.Exists(SchemeFile))
            {
                SchemeFileContent = System.IO.File.ReadAllText(SchemeFile, System.Text.Encoding.Default);
            }
        }

        if (SchemeFileContent == "")
        {
            try
            {
                SchemeFileContent = ShoveEL._Convert.ToHtmlCode(ShoveEL._String.Decompress((byte[])dr["LotteryNumber"]));
            }
            catch
            { }
        }

        dr.Close();
        conn.Close();

        labSchemeFile.Text = (SchemeFileContent == "") ? "未找到相关数据。" : SchemeFileContent;
    }
}