﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class ForgetPassword : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Users user = Users.GetSessionUser();
        if (user != null)
        {
            ShoveEL._Web.JavaScript.ClosePage(this.Page);
            return;
        }
    }

    protected void btnGO_ServerClick(object sender, EventArgs e)
    {
        if (tbUserName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入用户名。");
            return;
        }

        if (PublicFunction.GetOptionsAsBoolean("isUseCheckCode", false))
        {
            string CheckCode = "";
            try
            {
                CheckCode = this.Session["CheryWebUI_CheckCode_CheckCode"].ToString();
            }
            catch
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "验证码输入错误！");
                return;
            }

            if (tbCheckCode.Text.ToUpper() != CheckCode.ToUpper())
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "验证码输入错误！");
                return;
            }
        }

        Users tu = new Users();
        tu.Name = tbUserName.Text.Trim();
        int Result = tu.GetUserInfoByName();

        if (Result == -3)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "用户被限制登录！");
            return;
        }

        if (Result != 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "用户名不存在。");
            return;
        }

        if (tu.Email == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "您注册时没有留下可以接收密码的邮箱地址。请与客服中心联系。");
            return;
        }

        if (tu.UserType == 2)   //检查输入是否正确
        {
            if (tu.RealityName != tbUserRealityName.Text.Trim())
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户真实姓名输入错误。");
                return;
            }

            if (tu.IDCardNumber != tbUserIDCardNumber.Text.Trim())
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户身份证号输入错误。");
                return;
            }

            if (tbUserBankCardNumber.Text.Trim().Length != 6)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入银行卡号后 6 位数字。");
                return;
            }

            if (!tu.BankCardNumber.EndsWith(tbUserBankCardNumber.Text.Trim()))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "银行卡号后 6 位数字输入错误。");
                return;
            }
        }

        // 判断当天是否超过 2 次
        object Value = MSSQL.ExecuteScalar("select count([User_id]) from LoginLog where [User_id]=" + tu.ID.ToString() + " and [Description]=2 and year([Datetime])=" + System.DateTime.Now.Year.ToString() + " and month([Datetime])=" + System.DateTime.Now.Month.ToString() + " and day([Datetime])=" + System.DateTime.Now.Day.ToString());
        int Count = 0;
        try
        {
            Count = int.Parse(Value.ToString());
        }
        catch { }

        if (Count >= 2)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "今天已经超过取回密码次数限制。");
            return;
        }

        string Return = "";
        tu.Password = GetRandPassword();
        if (tu.UserType == 2)
            tu.Password_2 = GetRandPassword();
        Result = tu.EditByID(ref Return);
        if (Result != 0 || Return != "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, Return);
            return;
        }

        //插入取回密码记录，以判断每天只能取 2 次
        if (PublicFunction.GetOptionsAsBoolean("LoginWriteLog", true))
        {
            DAL.Tables.LoginLog.Insert(tu.ID, true, DateTime.Now, false, tu.LoginIP, true, 2, true);
        }

        //Send Email.......................
        string EmailSubject = "", EmailBody = "";
        PublicFunction.GetEmailTemplate("Template\\Email\\ForgetPassword.txt", ref EmailSubject, ref EmailBody);
        if ((EmailSubject != "") && (EmailBody != ""))
        {
            EmailSubject = EmailSubject.Replace("[UserName]", tu.Name);
            EmailBody = EmailBody.Replace("[UserName]", tu.Name);
            EmailBody = EmailBody.Replace("[UserPassword]", tu.Password);
            if (tu.UserType == 1)
                EmailBody = EmailBody.Replace("[UserPassword_2]", "(您是普通用户，无投注密码)");
            else
                EmailBody = EmailBody.Replace("[UserPassword_2]", tu.Password_2);

            if (PublicFunction.SendEmail(tu.Email, EmailSubject, EmailBody) == 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "密码已经发送到您的注册邮箱中，请查收并及时修改密码。");
                return;
            }
            else
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "邮件发送失败，请检查您的邮箱是否正确。");
                return;
            }
        }
    }


    private string GetRandPassword()
    {
        string str = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!@#$%^&*()";
        Random rd = new Random();
        string Result = "";

        for (int i = 0; i < 6; i++)
        {
            Result += str[rd.Next(str.Length)].ToString();
        }

        return Result;
    }
}