﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using ShoveEL.Database;

public partial class Header2 : System.Web.UI.UserControl
{
    public string ChatUrl = "", ForumUrl = "";
    public string FirstIsUsedLotteryBasePlayPage = "";
    public int FirstIsUsedLotteryID = -1;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        string Version = PublicFunction.GetVersion();
        if (Version != "2")
        {
            this.Visible = false;
            return;
        }

        if (!this.IsPostBack)
        {
            ChatUrl = PublicFunction.GetOptionsAsString("ChatUrl");
            ForumUrl = PublicFunction.GetOptionsAsString("ForumUrl");

            BindDataForLotteryMenu();

            //绑定 Logo
            string UserLogo = PublicFunction.GetOptionsAsString("UserLogo");
            if (UserLogo == "")
                UserLogo = "Images/Logo/Logo" + Version + ".gif";
            else
                UserLogo = "Images/Logo/" + UserLogo;
            imgLogo.ImageUrl = UserLogo;

            //绑定第一个代购合买菜单的彩种
            Lottery lottery = new Lottery();
            FirstIsUsedLotteryID = lottery.GetFirstUsedLotteryID();
            if (FirstIsUsedLotteryID >= 1)
            {
                string D_Surrogate = "";
                string D_Join = "";
                string D_Initiate = "";
                string F_Surrogate = "";
                string F_Join = "";
                string F_Initiate = "";

                if (!lottery.GetBasePlayPage(FirstIsUsedLotteryID, ref D_Surrogate, ref D_Join, ref D_Initiate, ref F_Surrogate, ref F_Join, ref F_Initiate))
                {
                    FirstIsUsedLotteryBasePlayPage = "MemberAccount.aspx";
                }
                else
                {
                    if (D_Surrogate == "")
                    {
                        FirstIsUsedLotteryBasePlayPage = "MemberAccount.aspx";
                    }
                    else
                    {
                        FirstIsUsedLotteryBasePlayPage = "MemberBuy/" + D_Surrogate;
                    }
                }
            }
        }
    }

    private void BindDataForLotteryMenu()
    {
        string LotteryMenu = PublicFunction.BuilderLotteryMenu();
        if (LotteryMenu != "")
        {
            panelLotteryMenu.Visible = true;
            labLotteryMenu.Text = LotteryMenu;
        }
    }
}