﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Index2 : System.Web.UI.Page
{
    public string strLotteryMenu = "";
    public string strLotteryBuyQuick = "";
    public string FirstUsedLotteryPlayPageForBuyQuick = "";
    public string FirstUsedLotteryIDForSchemeAll = "";

    protected void Page_Load(object sender, System.EventArgs e)
    {
        string Version = PublicFunction.GetVersion();
        if (Version == "1")
        {
            this.Response.Redirect("Index.aspx", true);
            return;
        }

        if (!this.IsPostBack)
        {
            BindDataForLotteryMenu();
        }
    }

    private void BindDataForLotteryMenu()
    {
        // 快速区、合买区的默认框架页
        Lottery lottery = new Lottery();
        FirstUsedLotteryPlayPageForBuyQuick = lottery.GetFirstUsedLotteryPlayPageForBuyQuick();
        FirstUsedLotteryIDForSchemeAll = lottery.GetFirstUsedLotteryID().ToString();

        // 判断快速区几个彩种
        hl_SZPL3_ZhiF.Visible = lottery.GetIsUsed(Lottery.SZPL.ID);
        hl_SZPL3_ZhiH.Visible = hl_SZPL3_ZhiF.Visible;

        hl_FC3D_ZhiF.Visible = lottery.GetIsUsed(Lottery.FC3D.ID);
        hl_FC3D_ZhiB.Visible = hl_FC3D_ZhiF.Visible;

        hl_SSQ_F.Visible = lottery.GetIsUsed(Lottery.SSQ.ID);

        // 合买代购区彩种
        DataTable dt = DAL.Tables.Lottery.Select("[id],[Name],[Code]", "[isUsed]=1", "[Sort]");
        if (dt == null)
        {
            PublicFunction.GoError();
            return;
        }

        if (dt.Rows.Count == 0)
        {
            strLotteryMenu = "<font color='red'>对不起，各彩票玩法本站暂未开放，请稍候再访问。谢谢！</font>";
            strLotteryBuyQuick = "<font color='red'>对不起，各彩票玩法本站暂未开放，请稍候再访问。谢谢！</font>";
            return;
        }

        strLotteryMenu = "";
        strLotteryBuyQuick = "";
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strLotteryMenu += "<A class=\"li3\" href=\"MemberBuyQuick/SchemeAll.aspx?id=" + dt.Rows[i]["id"].ToString() + "\" target=\"MemberBuyQuickSchemeAll\">" + dt.Rows[i]["Name"].ToString() + "</A>";
            if (i < dt.Rows.Count - 1)
            {
                strLotteryMenu += "&nbsp;&nbsp;";
            }

            string BuyQuickFileName = this.Server.MapPath("MemberBuyQuick/" + dt.Rows[i]["Code"].ToString() + "_D.aspx");
            if (!System.IO.File.Exists(BuyQuickFileName))
            {
                BuyQuickFileName = "";
            }

            if (BuyQuickFileName != "")
            {
                strLotteryBuyQuick += "<a ID='hl_" + dt.Rows[i]["Code"].ToString() + "_D'  class=\"li4\"  href='MemberBuyQuick/" + dt.Rows[i]["Code"].ToString() + "_D.aspx' Target='MemberBuyQuick'>" + dt.Rows[i]["Name"].ToString() + "单式</a>&nbsp;";
                strLotteryBuyQuick += "<a ID='hl_" + dt.Rows[i]["Code"].ToString() + "_F'  class=\"li4\"  href='MemberBuyQuick/" + dt.Rows[i]["Code"].ToString() + "_F.aspx' Target='MemberBuyQuick'>" + dt.Rows[i]["Name"].ToString() + "复式</a>&nbsp;";
            }
        }
    }
}