﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Login : System.Web.UI.UserControl
{
    public Users user;
    public string labCheckCode = "验证码：";

    protected void Page_Load(object sender, EventArgs e)
    {
        user = Users.GetSessionUser();
        if (user != null)
        {
            Panel1.Visible = false;
            Panel2.Visible = true;

            lbUserName.Text = user.Name + "，您好！";

            if (user.isAlipayMember)
            {
                lbUserType.Text = "支付宝会员";
                btnRegisterAdv.Visible = false;
            }
            else
            {
                switch (user.UserType)
                {
                    case 1:
                        lbUserType.Text = "级别：普通会员";
                        btnRegisterAdv.Visible = true;
                        break;

                    case 2:
                        lbUserType.Text = "级别：高级会员";
                        btnRegisterAdv.Visible = false;
                        break;
                }
            }

            btnAdmin.Visible = user.ManagementRights;
        }
        else
        {
            Panel1.Visible = true;
            Panel2.Visible = false;
        }

        bool MemberSharing_Alipay_Status_ON = PublicFunction.GetOptionsAsBoolean("MemberSharing_Alipay_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetMID() + PublicFunction.GetOptionsAsString("MemberSharing_Alipay_Maturity"), PublicFunction.GetOptionsAsString("MemberSharing_Alipay_ON_Cert"), "SLMSC");

        if (MemberSharing_Alipay_Status_ON)
        {
            tblAliPayLogin.Visible = true;
            imgbtnAliPayLogin.Visible = true;
        }

        switch (PublicFunction.GetOptionsAsString("CheckCodeCharset"))
        {
            case "0":
                CheryCheckCode1.Charset = Chery.Web.UI.CheryCheckCode.CharSet.All;
                break;
            case "1":
                CheryCheckCode1.Charset = Chery.Web.UI.CheryCheckCode.CharSet.OnlyLetter;
                break;
            case "2":
                CheryCheckCode1.Charset = Chery.Web.UI.CheryCheckCode.CharSet.OnlyLetterLower;
                break;
            case "3":
                CheryCheckCode1.Charset = Chery.Web.UI.CheryCheckCode.CharSet.OnlyLetterUpper;
                break;
            case "4":
                CheryCheckCode1.Charset = Chery.Web.UI.CheryCheckCode.CharSet.OnlyNumeric;
                break;
            default:
                CheryCheckCode1.Charset = Chery.Web.UI.CheryCheckCode.CharSet.All;
                break;
        }

        if (!PublicFunction.GetOptionsAsBoolean("isUseCheckCode", true))
        {
            labCheckCode = "";
            tbCheckCode.Visible = false;
            CheryCheckCode1.Visible = false;
        }

        tbUserPassword.Attributes.Add("value", tbUserPassword.Text);
    }

    protected void btnLogin_Click(object sender, System.EventArgs e)
    {
        bool LoginOK = false;

        if (Users.GetSessionUser() != null)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "用户已经登录！要更换用户登录请先用“安全退出”退出登录。");
            return;
        }

        if (PublicFunction.GetOptionsAsBoolean("isUseCheckCode", false))
        {
            string CheckCode = "";
            try
            {
                CheckCode = this.Session["CheryWebUI_CheckCode_CheckCode"].ToString();
            }
            catch
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "验证码输入错误！");
                return;
            }

            if (tbCheckCode.Text.ToUpper() != CheckCode.ToUpper())
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "验证码输入错误！");
                return;
            }
        }

        if ((tbUserName.Text.Trim() == "") || (tbUserPassword.Text.Trim() == ""))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "用户名和密码都不能为空！");
            return;
        }

        System.Threading.Thread.Sleep(100);

        user = new Users();
        user.Name = tbUserName.Text.Trim();
        user.Password = tbUserPassword.Text;

        string Return = "";
        bool isAliPayLogin = false;
        int Result = user.Login(ref Return, isAliPayLogin);
        if (Result != 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, Return);
        }
        else
        {
            Users.SetSessionUser(user);
            LoginOK = true;
        }

        if (LoginOK)
        {
            string LastRequestPage = this.Request["LastRequestPage"];
            if (LastRequestPage == null)
                LastRequestPage = "";

            string SubPage = this.Request["SubPage"];
            if (SubPage == null)
                SubPage = "";

            if (LastRequestPage != "")
                this.Response.Redirect(LastRequestPage + (SubPage == "" ? "" : "?SubPage=" + SubPage), true);
            else
                this.Response.Redirect(this.Request.Url.AbsoluteUri, true);
        }
    }

    protected void btnLogout_Click(object sender, System.EventArgs e)
    {
        Users.ClearSessionUser();
        this.Response.Redirect(this.Request.Url.AbsoluteUri, true);
    }

    protected void btnRegister_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("MemberRegister.aspx", true);
    }

    protected void btnAdmin_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("Admin/Index.aspx", true);
    }

    protected void btnEditUserInfo_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("Member.aspx?SubPage=MemberEdit1.aspx", true);
    }

    protected void btnRegisterAdv_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("MemberRegisterAdv.aspx", true);
    }

    protected void btnMemberAccount_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("Member.aspx?SubPage=MemberInvest.aspx", true);
    }

    protected void imgbtnAliPayLogin_Click(object sender, ImageClickEventArgs e)
    {
        this.Response.Redirect("MemberSharing/Alipay/Login.aspx", true);
    }
}