﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class LotteryResultDetail : System.Web.UI.Page
{
    public int Lottery_id;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForLottery();

            if (ddlLottery.Items.Count > 0)
            {
                Lottery_id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
                if (new Lottery().ValidID(Lottery_id))
                    ShoveEL.ControlExt.SetDownListBoxTextFromValue(ddlLottery, Lottery_id.ToString());
                else
                    Lottery_id = int.Parse(ddlLottery.Items[0].Value);

                ddlLottery_SelectedIndexChanged(ddlLottery, new EventArgs());
            }
            else
            {
                this.Response.Redirect("Index.aspx", true);
                return;
            }

            panelSumBuyMoney.Visible = PublicFunction.GetOptionsAsBoolean("ShowSumBuyMoney", true);
        }
    }

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                PublicFunction.GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));
    }

    private void BindDataForIsuse(string Lottery_id)
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery_HistoryIsuse");

        if (dt == null)
        {
            dt = DAL.Tables.Isuse.Select("", "EndTime < GetDate() and IsOpen = 1", "EndTime desc");
            if (dt == null)
            {
                PublicFunction.GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery_HistoryIsuse", dt);
        }

        DataRow[] dr = dt.Select("Lottery_id=" + Lottery_id);
        ddlIsuse.Items.Clear();
        for (int i = 0; i < dr.Length; i++)
            ddlIsuse.Items.Add(new ListItem(dr[i]["Isuse"].ToString(), dr[i]["id"].ToString()));

        if (ddlIsuse.Items.Count > 0)
            ddlIsuse_SelectedIndexChanged(ddlIsuse, new EventArgs());
    }

    private void BindData()
    {
        if ((ddlLottery.Items.Count < 1) || (ddlIsuse.Items.Count < 1))
            return;

        labLotteryName.Text = ddlLottery.SelectedItem.Text;
        labIsuse.Text = "第" + ddlIsuse.SelectedItem.Text + "期";
        Lottery_id = int.Parse(ddlLottery.SelectedValue);

        DataTable dt = DAL.Views.V_IsuseWithSumMoney.Select("", "[id] = " + ddlIsuse.SelectedValue, "");
        if (dt == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        // 填写开奖公告
        try
        {
            labResult.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["OpenAffiche"]);
        }
        catch
        {
            labResult.Text = "";
        }

        // 填写本站此期投注、中奖金额总额
        labSumBuyMoney.Text = ShoveEL._Convert.StrToDouble(dt.Rows[0]["SumBuyMoney"].ToString(), 0).ToString("N") + " 元";
        labSumWinMoney.Text = ShoveEL._Convert.StrToDouble(dt.Rows[0]["SumWinMoney"].ToString(), 0).ToString("N") + " 元";

        // 填写本站此期中奖明细
        BindDataForWinDetail();
    }

    private void BindDataForWinDetail()
    {
        if ((ddlLottery.Items.Count < 1) || (ddlIsuse.Items.Count < 1))
            return;

        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("LotteryWinDetail_" + ddlLottery.SelectedValue + "_" + ddlIsuse.SelectedValue);

        if (dt == null)
        {
            if (Lottery.ZCDC.ID == int.Parse(ddlLottery.SelectedValue))
            {
                dt = DAL.Views.V_SchemeSchedule.Select("", "Lottery_id = " + Lottery.ZCDC.ID + " and WinMoney > 0", "DateTime");
            }
            else
            {
                dt = DAL.Views.V_SchemeSchedule.Select("", "Isuse_id = " + ddlIsuse.SelectedValue + " and WinMoney > 0", "EndTime");
            }

            if (dt == null)
            {
                this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
                return;
            }


            dt.Columns.Add("WinDescription2", System.Type.GetType("System.String"));
            dt.Columns.Add("ShareWinMoney", System.Type.GetType("System.String"));

            Lottery.LotteryBase lottery = new Lottery()[int.Parse(ddlLottery.SelectedValue)];

            for (int i = 0; i < dt.Rows.Count; i++)
            {
                string str = "";

                try
                {
                    str = ShoveEL._String.Decompress((byte[])dt.Rows[i]["WinDescription"]);
                }
                catch
                {
                    str = "";
                }
                
                dt.Rows[i]["WinDescription2"] = str;
                double WinMoneyNoWithTax = ShoveEL._Convert.StrToDouble(dt.Rows[i]["WinMoneyNoWithTax"].ToString(), 0);
                double WinCommission = ShoveEL._Convert.StrToDouble(dt.Rows[i]["WinCommission"].ToString(), 0);
                int Share = ShoveEL._Convert.StrToInt(dt.Rows[i]["Share"].ToString(), 0);
                int BuyType = ShoveEL._Convert.StrToInt(dt.Rows[i]["Type_id"].ToString(), -1);
                
                if ((lottery.isSurrogateBuyType(BuyType) || (BuyType == lottery.buytype_c)) && (Share == 1))
                {
                    dt.Rows[i]["ShareWinMoney"] = WinMoneyNoWithTax.ToString("N");
                }
                else
                {
                    dt.Rows[i]["ShareWinMoney"] = Math.Round((WinMoneyNoWithTax - WinCommission) / Share, 2).ToString("N");
                }

                dt.Rows[i]["Money"] = ShoveEL._Convert.StrToDouble(dt.Rows[i]["Money"].ToString(), 0).ToString("N");
                dt.Rows[i]["WinMoneyNoWithTax"] = WinMoneyNoWithTax.ToString("N");
                dt.AcceptChanges();
            }

            ShoveEL._Web.Cache.SetCache("LotteryWinDetail_" + ddlLottery.SelectedValue + "_" + ddlIsuse.SelectedValue, dt);
        }

        g2.DataSource = dt;
        g2.DataBind();
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, EventArgs e)
    {
        Lottery_id = int.Parse(ddlLottery.SelectedValue);

        BindDataForIsuse(ddlLottery.SelectedValue);

        // 画各种买的链接

        DataTable dt = DAL.Tables.LotteryBuyType.Select("", "Lottery_id = " + ddlLottery.SelectedValue, "[id]");
        if (dt == null)
        {
            PublicFunction.GoError();
            return;
        }

        DataTable dtBuyMenu = new DataTable();
        dtBuyMenu.Columns.Add("BuyType", typeof(string));

        Lottery lottery = new Lottery();

        string Version = PublicFunction.GetVersion();
        if (Version == "1")
        {
            string TrendChartFileName = this.Server.MapPath("TrendChart/TrendChart_" + lottery[Lottery_id].code + ".aspx");
            if (!System.IO.File.Exists(TrendChartFileName))
            {
                TrendChartFileName = "";
            }


            if (TrendChartFileName != "")
            {
                DataRow dr = dtBuyMenu.NewRow();

                dr["BuyType"] = "<a href='" + "TrendChart/TrendChart_" + lottery[Lottery_id].code + ".aspx' class='li4'>" + lottery[Lottery_id].name + "走势图</a>";
                dtBuyMenu.Rows.Add(dr);
            }
        }

        foreach (DataRow dr in dt.Rows)
        {
            string str = dr["BuyFileName"].ToString();
            if ((str == null) || (str == ""))
            {
                continue;
            }

            bool isChase = (str == "Chase.aspx?id=[ID]");

            if (dr["Lottery_id"].ToString() == Lottery.ZCDC.sID)
            {
                str = "MemberOfZCDC.aspx?SubPage=MemberBuy/" + str;
            }
            else
            {
                str = "Member.aspx?SubPage=MemberBuy/" + str.Replace("[ID]", dr["Lottery_id"].ToString()).Replace("[Lottery]", dr["Lottery_id"].ToString()).Replace("[BuyType]", dr["id"].ToString());
            }
            DataRow t_dr = dtBuyMenu.NewRow();
            t_dr["BuyType"] = "<a href='" + str + "' class='li" + (isChase ? "4" : "3") + "'>" + dr["Type"].ToString() + "</a>";
            dtBuyMenu.Rows.Add(t_dr);
        }

        dlBuyMenu.DataSource = dtBuyMenu;
        dlBuyMenu.DataBind();
    }

    protected void ddlIsuse_SelectedIndexChanged(object sender, EventArgs e)
    {
        BindData();
    }
    protected void DataList1_SelectedIndexChanged(object sender, EventArgs e)
    {

    }
}