﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class LotteryExemple : System.Web.UI.Page
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (this.IsPostBack)
            return;

        int id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
        if (id < 1)
            id = 1;

        BindData(id);
    }

    private void BindData(int id)
    {
        DataTable dt = DAL.Tables.Lottery.Select("[id],[Name],[LotteryExemple]", "[isUsed] = 1", "[Sort]");
        if (dt == null)
        {
            Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        if (dt.Rows.Count == 0)
        {
            ShoveEL._Web.JavaScript.ClosePage(this.Page);
            return;
        }

        string strMenu = "<table style=\"WIDTH: 100%;\" cellSpacing=\"0\" cellPadding=\"0\" border=\"0\">";
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strMenu += "<tr>";
            strMenu += "<td class=\"line2\" align=\"left\">·<A href=\"LotteryExemple.aspx?id=" + dt.Rows[i]["id"].ToString() + "\">" + dt.Rows[i]["Name"].ToString() + "书写格式规范</A></td>";
            strMenu += "</tr>";

            if (int.Parse(dt.Rows[i]["id"].ToString()) == id)
            {
                labLocate.Text = dt.Rows[i]["Name"].ToString() + "书写格式规范";
                try
                {
                    labContent.Text = ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryExemple"]);
                }
                catch { }

                labContent.Text = labContent.Text.Replace("[SiteName]", PublicFunction.GetOptionsAsString("SiteName")).Replace("[SiteUrl]", PublicFunction.GetOptionsAsString("SiteUrl"));
            }
        }

        strMenu += "<tr>";
        strMenu += "<td align=\"left\" height=\"20\">·<A href=\"Member.aspx?SubPage=MemberService.aspx\" target=\"_blank\"><font color=\"#ff0000\">客户服务</font></A></td>";
        strMenu += "</tr>";
        strMenu += "</table>";

        labMenu.Text = strMenu;
    }
}