﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class LotteryResult : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    private void BindData()
    {
        DataSet ds = DAL.Procedures.P_GetWinLotteryNumber.Open();
        if ((ds == null) || (ds.Tables.Count == 0))
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        if (ds.Tables[0].Rows.Count == 0)
        {
            return;
        }

        string LotteryResultAlign = PublicFunction.GetOptionsAsString("LotteryResultAlign").Trim().ToLower();
        if ((LotteryResultAlign != "left") && (LotteryResultAlign != "center") && (LotteryResultAlign != "right"))
        {
            LotteryResultAlign = "center";
        }

        string[] Content = new string[5];
        for (int i = 0; i < 5; i++)
        {
            Content[i] = "<table cellSpacing=\"0\" cellPadding=\"0\" width=\"195\" border=\"0\">";
            Content[i] += " <tr>";
            Content[i] += "     <td height=\"0\">";
            Content[i] += "     </td>";
            Content[i] += " </tr>";
        }

        for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
        {
            DataRow dr = ds.Tables[0].Rows[i];
            int Type_id = 0;

            switch (dr["Type_id"].ToString())
            {
                case "2":
                    Type_id = 3;
                    break;
                case "3":
                    Type_id = 4;
                    break;
                case "4":
                    Type_id = 0;
                    break;
                case "5":
                    Type_id = 1;
                    break;
                case "6":
                    Type_id = 2;
                    break;
                case "8":
                    Type_id = 0;
                    break;
                case "9":
                    Type_id = 1;
                    break;
                case "10":
                    Type_id = 2;
                    break;
            }

            Content[Type_id] += "<tr>";
            Content[Type_id] += "    <td vAlign=\"middle\" align=\"center\" height=\"52\">";
            Content[Type_id] += "        <table class=\"css\" cellSpacing=\"0\" cellPadding=\"0\" width=\"195\" border=\"0\">";
            Content[Type_id] += "            <tr>";
            Content[Type_id] += "                <td class=\"zw4\" vAlign=\"middle\" align=\"" + LotteryResultAlign + "\" width=\"175\" height=\"18\"><strong>" + dr["Name"].ToString() + "&nbsp;<font color='red'>" + dr["Isuse"].ToString() + "</font>期</strong></td>";
            Content[Type_id] += "                <td class=\"zw4\" vAlign=\"middle\" align=\"right\" width=\"59\"><A class=\"li3\" href=\"Lottery.aspx?id=" + dr["Lottery_id"].ToString() + "\" target=\"_blank\">更多</A></td>";
            Content[Type_id] += "            </tr>";
            Content[Type_id] += "            <tr>";
            Content[Type_id] += "                <td class=\"zw3\" vAlign=\"middle\" align=\"" + LotteryResultAlign + "\" colSpan=\"2\" height=\"18\"><strong>" + new Lottery()[int.Parse(dr["Lottery_id"].ToString())].ShowNumber(dr["WinLotteryNumber"].ToString()) + "</strong></td>";
            Content[Type_id] += "            </tr>";
            Content[Type_id] += "        </table>";
            Content[Type_id] += "    </td>";
            Content[Type_id] += "</tr>";
            Content[Type_id] += "<tr>";
            Content[Type_id] += "    <td vAlign=\"middle\" align=\"center\" background=\"images/ic.gif\" height=\"1\"></td>";
            Content[Type_id] += "</tr>";
        }

        for (int i = 0; i < 5; i++)
        {
            Content[i] += "</table>";
        }

        labContent0.Text = Content[0];
        labContent1.Text = Content[1];
        labContent2.Text = Content[2];
        labContent3.Text = Content[3];
        labContent4.Text = Content[4];
    }
}