﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class LotteryStation : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        bool ShowLotteryStationInfo = PublicFunction.GetOptionsAsBoolean("ShowLotteryStationInfo", true);
        if (!ShowLotteryStationInfo)
        {
            this.Visible = false;
            return;
        }

        if (!this.IsPostBack)
            BindData();
    }

    private void BindData()
    {
        DataTable dt = DAL.Tables.Options.Select("[id],[Key],[Value]", "[Key] like 'Station%'", "");
        if ((dt == null) || (dt.Rows.Count < 1))
            return;

        DataRow[] dr = dt.Select("Key=\'StationName\'");
        if (dr.Length > 0)
            labStationName.Text = dr[0]["Value"].ToString();

        dr = dt.Select("Key=\'StationNum\'");
        if (dr.Length > 0)
            labStationNum.Text = dr[0]["Value"].ToString();

        dr = dt.Select("Key=\'StationAddress\'");
        if (dr.Length > 0)
            labStationAddress.Text = dr[0]["Value"].ToString();

        dr = dt.Select("Key=\'StationTelephone\'");
        if (dr.Length > 0)
            labStationTelephone.Text = dr[0]["Value"].ToString();
    }
}