﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberAccountFreezeDetail : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberAccountFreezeDetail.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("MemberAccountFreezeDetail_" + user.ID.ToString());

        if (dt == null)
        {
            DataSet ds = DAL.Procedures.P_GetMemberAccountFreezeDetail.Open(user.ID);

            if ((ds == null) || (ds.Tables.Count < 1))
            {
                GoError();
                return;
            }

            dt = ds.Tables[0];
            ShoveEL._Web.Cache.SetCache("MemberAccountFreezeDetail_" + user.ID.ToString(), dt);
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
            e.Item.Cells[1].Text = ShoveEL._Convert.StrToDouble(e.Item.Cells[1].Text, 0).ToString("N");
    }
}