﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;
using ShoveEL.Database;

public partial class MemberBuy_Chase : MemberPage
{
    public int Lottery_id;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(MemberBuy_Chase));
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        Lottery_id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);

        if (!new Lottery().ValidID(Lottery_id))
        {
            GoError("参数错误。");
            return;
        }

        tbLottery_id.Text = Lottery_id.ToString();
        labBalance.Text = user.Balance.ToString("N");

        //取追号买类别
        int ChaseType_id = -1;
        try
        {
            ChaseType_id = DAL.Functions.F_GetChaseBuyTypeID.Call(Lottery_id);
        }
        catch { }

        if (ChaseType_id < 1)
        {
            GoError("参数错误。");
            return;
        }
        tbChaseType_id.Text = ChaseType_id.ToString();

        if (!this.IsPostBack)
        {
            BindDataForIsuse();
            btnOK.Attributes.Add("onclick", "return btnOKClick();");
            btnOK.Enabled = (user.UserType == 2);

            if (Lottery_id == Lottery.SZPL.ID)
            {
                rbSZPL5.Visible = true;
                rbSZPL3.Visible = true;
            }

            bool isValidBuyPassword = PublicFunction.GetOptionsAsBoolean("isValidBuyPassword", true);
            if (isValidBuyPassword && user.isAlipayMember)  //如果普通用户需要输入投注密码，支付宝会员不需要
            {
                isValidBuyPassword = false;
            }
            panelInvestPassword.Visible = isValidBuyPassword;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberBuy/Chase.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForIsuse()
    {
        DataTable dt = MSSQL.Select("select top 10 *, dbo.F_GetSystemEndTime(" + tbChaseType_id.Text + ", EndTime) as SystemEndTime from V_Isuse where Lottery_id = " + tbLottery_id.Text + " and dbo.F_GetSystemEndTime(" + tbChaseType_id.Text + ", EndTime) > GetDate() order by EndTime");

        if (dt == null)
        {
            GoError();
            return;
        }

        if (dt.Rows.Count < 1)
        {
            GoError("系统没有设置此彩种的期号，不能进行追号。");
            return;
        }

        string LotteryName = dt.Rows[0]["Name"].ToString();
        Label1.Text = LotteryName + "追号";
        Label2.Text = LotteryName + "追号";
        Label3.Text = LotteryName + "追号代购";
        labTitle.Text = LotteryName + "第 " + dt.Rows[0]["Isuse"].ToString() + " 期";
        labStartTime.Text = dt.Rows[0]["StartTime"].ToString();
        labEndTime.Text = dt.Rows[0]["SystemEndTime"].ToString();
        tbIsuse_id.Text = dt.Rows[0]["id"].ToString();

        int IsuseCount = 0;
        foreach(DataRow dr in dt.Rows)
        {
            IsuseCount++;
            string IsuseName = dr["Isuse"].ToString().Trim();

            CheckBox cb = (CheckBox)this.FindControl("cbIsuse" + IsuseCount.ToString());
            cb.Text = "第 " + IsuseName + " 期";
            cb.ToolTip = dr["id"].ToString();	//记录 Isuse 的 ID
            cb.Checked = true;
            cb.Visible = true;

            if (IsuseCount > 10)
                break;
        }

        Label4.Text = "《<A class=li3 href='../Agreement.aspx?id=" + tbLottery_id.Text + "' target='_blank'>" + LotteryName + "代购、合买协议</A>》";
    }

    protected void btnOK_Click(object sender, System.EventArgs e)
    {
        if (!user.CanInvest)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，您还不是高级会员，请先免费升级为高级会员。谢谢！");
            return;
        }

        if (panelInvestPassword.Visible)
        {
            if (tbInvestPassword.Text != user.Password_2)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "投注密码错误！");
                return;
            }
        }

        ArrayList al = new ArrayList();
        string SelectIsuseList = "";
        for (int i = 1; i <= 10; i++)
        {
            CheckBox cb = (CheckBox)this.FindControl("cbIsuse" + i.ToString());
            if (cb.Checked && cb.Visible)
            {
                //al.Add(GetIsuseFromCheckBoxText(cb.Text));
                //SelectIsuseList += "\'" + GetIsuseFromCheckBoxText(cb.Text) + "\',";
                al.Add(cb.ToolTip);
                SelectIsuseList += cb.ToolTip + ",";
            }
        }
        SelectIsuseList = SelectIsuseList.Substring(0, SelectIsuseList.Length - 1);

        DataTable dt = MSSQL.Select("select top 1 * from Isuse where id in (" + SelectIsuseList + ") and dbo.F_GetSystemEndTime(" + tbChaseType_id.Text + ", EndTime) < GetDate() and Lottery_id = " + tbLottery_id.Text);
        if (dt == null)
        {
            GoError();
            return;
        }
        if (dt.Rows.Count > 0)
        {
            cbRand.Checked = false;
            ShoveEL._Web.JavaScript.Alert(this.Page, "您选择的追号任务包含当期，但当期已经截止，请重新选择。谢谢。");
            return;
        }

        double IsuseMoney = 0;
        int Multiple = 0;

        try
        {
            IsuseMoney = double.Parse(tbIsuseMoney.Text);
            Multiple = int.Parse(tbMultiple.Text);
        }
        catch
        {
            cbRand.Checked = false;
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        if ((IsuseMoney <= 0) || (Multiple < 1))
        {
            cbRand.Checked = false;
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        string Return = "";
        user.GetUserBalance(ref Return);
        if ((IsuseMoney * al.Count) > user.Balance)
        {
            cbRand.Checked = false;
            ShoveEL._Web.JavaScript.Alert(this.Page, "您的帐户余额不足，请先增加预付款，谢谢。");
            return;
        }

        btnOK.Enabled = false;

        int[] IsuseList = new int[al.Count];
        for (int i = 0; i < al.Count; i++)
            IsuseList[i] = int.Parse(al[i].ToString());

        string LotteryNumber = "";
        if (!cbRand.Checked)
            LotteryNumber = tbLotteryNumber.Text;
        DateTime StartTime = DateTime.Parse(labStartTime.Text);
        DateTime EndTime = DateTime.Parse(labEndTime.Text);
        DateTime now = DateTime.Now;
        bool AtonceBuy = false;
        if ((now >= StartTime) && (now < EndTime) && cbIsuse1.Checked && cbIsuse1.Visible)
            AtonceBuy = true;

        int RandType;
        if ((int.Parse(tbLottery_id.Text) == Lottery.SZPL.ID) && rbSZPL3.Checked)
            RandType = cbRand.Checked ? 4 : 3;
        else
            RandType = cbRand.Checked ? 2 : 1;

        int SecrecyLevel = rbSecrecy1.Checked ? 0 : (rbSecrecy2.Checked ? 1 : (rbSecrecy3.Checked ? 2 : 3));

        Return = "";
        int Result = user.Chase(tbTitle.Text.Trim() == "" ? "(无标题)" : tbTitle.Text.Trim(), tbDescription.Text.Trim(), int.Parse(tbLottery_id.Text), int.Parse(tbChaseType_id.Text), RandType, LotteryNumber, Multiple, IsuseMoney, IsuseList, AtonceBuy, ShoveEL._Convert.StrToDouble(tbAutoStopAtWinMoney.Text, 0), SecrecyLevel, ref Return);
        if ((Return != "") || (Result != 0))
        {
            GoError(Return);
            return;
        }

        this.Response.Redirect("OK.aspx?Alert=1&Tip=" + System.Web.HttpUtility.UrlEncode("您发起的追号任务已经提交成功，预祝您早中大奖！"), true);
    }

    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public string AnalyseScheme(string strLotteryID, string Content, int ExtType)
    {
        Lottery_id = ShoveEL._Convert.StrToInt(strLotteryID, -1);
        if (!new Lottery().ValidID(Lottery_id))
            return "";

        //[Use Lottery_id]
        string Result = "";
        if (Lottery_id == Lottery.SZPL.ID)
            Result = new Lottery()[Lottery_id].AnalyseScheme(Content, new Lottery()[Lottery_id].buytype_c, ExtType);
        else
            Result = new Lottery()[Lottery_id].AnalyseScheme(Content, new Lottery()[Lottery_id].buytype_c);

        return Result.Trim();
    }
}