﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class MemberBuy_Initiate : MemberPage
{
    public int Lottery_id, BuyType_id;
    public string LotteryName, BuyTypeName, BuyFileName;

    public double Price = 2;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        if (!this.IsPostBack)
        {
            tbLottery_id.Value = this.Request["Lottery"];
            tbBuyType_id.Value = this.Request["BuyType"];
            tbBuyFileName.Value = this.Request["Page"];
            tbPrice.Value = this.Request["Price"];
        }

        try
        {
            Price = ShoveEL._Convert.StrToDouble(tbPrice.Value, 2);
        }
        catch
        {
            Price = 2;
        }
        tbPrice.Value = Price.ToString();

        GetID();

        if (!this.IsPostBack)
        {
            BindDataForIsuse();

            btn_OK.Attributes.Add("onclick", "return btn_OKClick();");

            if (user.UserType != 2)
                btn_OK.Enabled = false;

            bool isValidBuyPassword = PublicFunction.GetOptionsAsBoolean("isValidBuyPassword", true);
            if (isValidBuyPassword && user.isAlipayMember)  //如果普通用户需要输入投注密码，支付宝会员不需要
            {
                isValidBuyPassword = false;
            }
            panel_InvestPassword.Visible = isValidBuyPassword;

            BindDataForAddone();
        }
        
        lab_Balance.Text = user.Balance.ToString("N");
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberBuy/Initiate.aspx";
        base.OnInit(e);
    }
    #endregion

    private void GetID()
    {
        Lottery_id = ShoveEL._Convert.StrToInt(tbLottery_id.Value, -1);
        BuyType_id = ShoveEL._Convert.StrToInt(tbBuyType_id.Value, -1);
        BuyFileName = tbBuyFileName.Value;

        Lottery lottery = new Lottery();
        if (!lottery.ValidID(Lottery_id))
        {
            GoError("参数错误，系统异常。");
            return;
        }

        if (!lottery[Lottery_id].CheckBuyType(BuyType_id))
        {
            GoError("参数错误，系统异常。");
            return;
        }

        LotteryName = lottery[Lottery_id].name;
        BuyTypeName = lottery.GetBuyTypeName(BuyType_id);
    }

    private void BindDataForIsuse()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("MemberBuy_Isuse_" + Lottery_id.ToString());

        if (dt == null)
        {
            dt = DAL.Tables.Isuse.Select("", "Lottery_id = " + Lottery_id.ToString() + " and StartTime < GetDate()", "EndTime desc");
            if (dt == null)
            {
                GoError();
                return;
            }

            dt.Columns.Add("SystemEndTime", typeof(System.DateTime));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                System.DateTime EndTime, SystemEndTime;
                EndTime = System.DateTime.Parse(dt.Rows[i]["EndTime"].ToString());
                try
                {
                    SystemEndTime = DAL.Functions.F_GetSystemEndTime.Call(BuyType_id, EndTime);
                }
                catch
                {
                    SystemEndTime = EndTime.AddMinutes(-60);
                }
                dt.Rows[i]["SystemEndTime"] = SystemEndTime;
                dt.AcceptChanges();
            }

            ShoveEL._Web.Cache.SetCache("MemberBuy_Isuse" + Lottery_id.ToString(), dt);
        }

        if (dt.Rows.Count > 0)
        {
            labIsuse.Text = dt.Rows[0]["Isuse"].ToString();
            labStartTime.Text = dt.Rows[0]["StartTime"].ToString();
            labEndTime.Text = dt.Rows[0]["SystemEndTime"].ToString();

            tbIsuse_id.Value = dt.Rows[0]["id"].ToString();

            // 判断是否当期，并正在投注
            System.DateTime dtStart = DateTime.Parse(labStartTime.Text);
            System.DateTime dtEnd = DateTime.Parse(labEndTime.Text);
            if ((DateTime.Now < dtStart) || (DateTime.Now >= dtEnd))
            {
                btn1.Disabled = true;
                btn2.Disabled = true;
                btn3.Disabled = true;

                btn_OK.Enabled = false;
            }
        }
        else
        {
            btn1.Disabled = true;
            btn2.Disabled = true;
            btn3.Disabled = true;

            btn_OK.Enabled = false;
            
            GoError("系统没有设置此彩种的期号，不能进行认购。");
            return;
        }
    }

    private void BindDataForAddone()
    {
        //为胜负、进球、蓝彩单场等写附加信息
        string Isuse_id = tbIsuse_id.Value;

        if (Lottery_id == Lottery.SFC.ID)
        {
            DataTable dt = MSSQL.Select("select top 14 * from IsuseForSFC where Isuse_id = " + Isuse_id.ToString() + " order by [No]");
            if ((dt == null) || (dt.Rows.Count != 14))
            {
                GoError();
                return;
            }

            string t_str = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                t_str += dt.Rows[i]["HostTeam"].ToString().Trim() + "," + dt.Rows[i]["QuestTeam"].ToString().Trim() + "," + dt.Rows[i]["DateTime"].ToString();
                if (i < dt.Rows.Count - 1)
                    t_str += ";";
            }
            tbAddone.Value = t_str;
        }
        else if (Lottery_id == Lottery.JQC.ID)
        {
            DataTable dt = MSSQL.Select("select top 8 * from IsuseForJQC where Isuse_id = " + Isuse_id.ToString() + " order by [No]");
            if ((dt == null) || (dt.Rows.Count != 8))
            {
                GoError();
                return;
            }

            string t_str = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                t_str += dt.Rows[i]["Team"].ToString().Trim() + "," + dt.Rows[i]["DateTime"].ToString();
                if (i < dt.Rows.Count - 1)
                    t_str += ";";
            }
            tbAddone.Value = t_str;
        }
        else if (Lottery_id == Lottery.LCBQC.ID)
        {
            DataTable dt = MSSQL.Select("select top 6 * from IsuseForLCBQC where Isuse_id = " + Isuse_id.ToString() + " order by [No]");
            if ((dt == null) || (dt.Rows.Count != 6))
            {
                GoError();
                return;
            }

            string t_str = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                t_str += dt.Rows[i]["HostTeam"].ToString().Trim() + "," + dt.Rows[i]["QuestTeam"].ToString().Trim() + "," + dt.Rows[i]["DateTime"].ToString();
                if (i < dt.Rows.Count - 1)
                    t_str += ";";
            }
            tbAddone.Value = t_str;
        }
        else if (Lottery_id == Lottery.LCDC.ID)
        {
            DataTable dt = MSSQL.Select("select top 1 * from IsuseForLCDC where Isuse_id = " + Isuse_id.ToString() + " order by [No]");
            if ((dt == null) || (dt.Rows.Count != 1))
            {
                GoError();
                return;
            }

            string t_str = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                t_str += dt.Rows[i]["HostTeam"].ToString().Trim() + "," + dt.Rows[i]["QuestTeam"].ToString().Trim() + "," + dt.Rows[i]["DateTime"].ToString();
                if (i < dt.Rows.Count - 1)
                    t_str += ";";
            }
            tbAddone.Value = t_str;
        }
    }

    protected void btn_OK_Click(object sender, System.EventArgs e)
    {
        if (!user.CanInvest)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，您还不是高级会员，请先免费升级为高级会员。谢谢！");
            return;
        }

        if (panel_InvestPassword.Visible)
        {
            if (tb_InvestPassword.Text != user.Password_2)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "投注密码错误！");
                return;
            }
        }

        System.DateTime dt = DateTime.Parse(labEndTime.Text);
        if (DateTime.Now >= dt)
        {
            this.btn1.Disabled = true;
            this.btn2.Disabled = true;
            this.btn3.Disabled = true;
            ShoveEL._Web.JavaScript.Alert(this.Page, "本期投注已截止，谢谢。");
            return;
        }

        double SumMoney = 0;
        int Share = 0;
        int BuyShare = 0;
        double AssureMoney = 0;
        int Multiple = 0;
        int SumNum = 0;

        try
        {
            SumMoney = double.Parse(tb_hide_SumMoney.Value);
            Share = int.Parse(tb_Share.Text);
            BuyShare = int.Parse(tb_BuyShare.Text);
            AssureMoney = double.Parse(tb_hide_AssureMoney.Value);
            Multiple = int.Parse(tb_Multiple.Text);
            SumNum = int.Parse(tb_hide_SumNum.Value);
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        if ((SumMoney <= 0) || (Share < 1) || (BuyShare < 1) || (Multiple < 1))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        if (SumNum * Multiple * Price != SumMoney)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        string Return = "";
        user.GetUserBalance(ref Return);
        if ((((SumMoney / Share) * BuyShare) + AssureMoney) > user.Balance)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "您的帐户余额不足，请先增加预付款，谢谢。");
            return;
        }

        btn_OK.Enabled = false;

        string LotteryNumber = tb_LotteryNumber.Value.Trim();
        if (LotteryNumber[LotteryNumber.Length - 1] == '\n')
            LotteryNumber = LotteryNumber.Substring(0, LotteryNumber.Length - 1);

        int SecrecyLevel = rbSecrecy1.Checked ? 0 : (rbSecrecy2.Checked ? 1 : (rbSecrecy3.Checked ? 2 : 3));

        Return = "";
        int Result = user.Buy(tb_Title.Text.Trim() == "" ? "(无标题)" : tb_Title.Text.Trim(), tb_Description.Text.Trim(), int.Parse(tbIsuse_id.Value), BuyType_id, LotteryNumber, Multiple, SumMoney, AssureMoney, Share, BuyShare, tb_SchemeFileName.Value.Trim(), tb_OpenUserList.Text.Trim(), SecrecyLevel, ref Return);
        if ((Return != "") || (Result != 0))
        {
            GoError(Return);
            return;
        }

        this.Response.Redirect("OK.aspx?Alert=1&Tip=" + System.Web.HttpUtility.UrlEncode("您发起的" + LotteryName + BuyTypeName + "方案已经提交成功，预祝您早中大奖！"), true);
    }

    protected void btn1_ServerClick(object sender, EventArgs e)
    {
        this.Response.Redirect(String.Format("Join.aspx?Lottery={0}&BuyType={1}&Page={2}&Price={3}", Lottery_id, BuyType_id, BuyFileName, Price), true);
    }

    protected void btn2_ServerClick(object sender, EventArgs e)
    {
        this.Response.Redirect(String.Format("Initiate.aspx?Lottery={0}&BuyType={1}&Page={2}&Price={3}", Lottery_id, BuyType_id, BuyFileName, Price), true);
    }

    protected void btn3_ServerClick(object sender, EventArgs e)
    {
        this.Response.Redirect(String.Format("Surrogate.aspx?Lottery={0}&BuyType={1}&Page={2}&Price={3}", Lottery_id, BuyType_id - 1, BuyFileName, Price), true);
    }
}