﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class MemberBuy_Join : MemberPage
{
    public int Lottery_id, BuyType_id;
    public string LotteryName, BuyTypeName, BuyFileName;

    public double Price = 2;

    public DataGrid grid;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        if (!this.IsPostBack)
        {
            tbLottery_id.Value = this.Request["Lottery"];
            tbBuyType_id.Value = this.Request["BuyType"];
            tbBuyFileName.Value = this.Request["Page"];
            tbPrice.Value = this.Request["Price"];
        }

        try
        {
            Price = ShoveEL._Convert.StrToDouble(tbPrice.Value, 2);
        }
        catch
        {
            Price = 2;
        }
        tbPrice.Value = Price.ToString();

        GetID();

        if (!this.IsPostBack)
        {
            this.ViewState.Remove(ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "MemberBuy_Join_Type");
            BindDataForIsuse();
        }

        if (Lottery_id == Lottery.SFC.ID)
        {
            g.Visible = false;
            gPager.Visible = false;

            gSFC.Visible = true;
            gPagerSFC.Visible = true;

            grid = gSFC;
        }
        else if (Lottery_id == Lottery.JQC.ID)
        {
            g.Visible = false;
            gPager.Visible = false;

            gJQC.Visible = true;
            gPagerJQC.Visible = true;

            grid = gJQC;
        }
        else if (Lottery_id == Lottery.LCBQC.ID)
        {
            g.Visible = false;
            gPager.Visible = false;

            gLCBQC.Visible = true;
            gPagerLCBQC.Visible = true;

            grid = gLCBQC;
        }
        else if (Lottery_id == Lottery.LCDC.ID)
        {
            g.Visible = false;
            gPager.Visible = false;

            gLCDC.Visible = true;
            gPagerLCDC.Visible = true;

            grid = gLCDC;
        }
        else
        {
            grid = g;
        }

        BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberBuy/Join.aspx";
        base.OnInit(e);
    }
    #endregion

    private void GetID()
    {
        Lottery_id = ShoveEL._Convert.StrToInt(tbLottery_id.Value, -1);
        BuyType_id = ShoveEL._Convert.StrToInt(tbBuyType_id.Value, -1);
        BuyFileName = tbBuyFileName.Value;

        Lottery lottery = new Lottery();
        if (!lottery.ValidID(Lottery_id))
        {
            GoError("参数错误，系统异常。");
            return;
        }

        if (!lottery[Lottery_id].CheckBuyType(BuyType_id))
        {
            GoError("参数错误，系统异常。");
            return;
        }

        LotteryName = lottery[Lottery_id].name;
        BuyTypeName = lottery.GetBuyTypeName(BuyType_id);
    }

    private void BindDataForIsuse()
    {
        DataTable dt = DAL.Tables.Isuse.Select("", "Lottery_id = " + Lottery_id.ToString() + " and StartTime < GetDate()", "EndTime desc");
        if (dt == null)
        {
            GoError();
            return;
        }

        dt.Columns.Add("SystemEndTime", typeof(System.DateTime));
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            System.DateTime EndTime, SystemEndTime;
            EndTime = System.DateTime.Parse(dt.Rows[i]["EndTime"].ToString());
            try
            {
                SystemEndTime = DAL.Functions.F_GetSystemEndTime.Call(BuyType_id, EndTime);
            }
            catch
            {
                SystemEndTime = EndTime.AddMinutes(-60);
            }
            dt.Rows[i]["SystemEndTime"] = SystemEndTime;
            dt.AcceptChanges();
        }

        ddlIsuse.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlIsuse.Items.Add(new ListItem(dt.Rows[i]["Isuse"].ToString(), dt.Rows[i]["id"].ToString()));

        if (dt.Rows.Count > 0)
        {
            labIsuse.Text = dt.Rows[0]["Isuse"].ToString();
            labStartTime.Text = dt.Rows[0]["StartTime"].ToString();
            labEndTime.Text = dt.Rows[0]["SystemEndTime"].ToString();

            tbIsuse_id.Value = dt.Rows[0]["id"].ToString();
        }
        else
        {
            btn1.Disabled = true;
            btn2.Disabled = true;
            btn3.Disabled = true;

            GoError("系统没有设置此彩种的期号，不能进行认购。");
            return;
        }
    }

    private void BindData()
    {
        int Type = 7;
        try
        {
            Type = int.Parse(this.ViewState[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "MemberBuy_Join_Type"].ToString());
        }
        catch
        {
            Type = 7;
        }

        if ((Type < 1) || (Type > 7))
        {
            GoError();
            return;
        }

        BindData(Type);
    }

    private void BindData(int Type)
    {
        DateTime EndTime;
        try
        {
            EndTime = DateTime.Parse(labEndTime.Text);
        }
        catch
        {
            EndTime = DateTime.Now.AddYears(-1);
        }

        TimeSpan ts = System.DateTime.Now - EndTime;
        long Seconds = (ts.Ticks / 10000000);
        if (Seconds >= 0)	// 已超过投注截止时间
        {
            btn1.Disabled = true;
            btn2.Disabled = true;
            btn3.Disabled = true;
        }

        if (ddlIsuse.Items.Count < 1)
            return;
        string Isuse_id = ddlIsuse.SelectedItem.Value;

        DataTable dt = null;
        string Condition = "Type_id = " + BuyType_id.ToString() + " and Lottery_id = " + Lottery_id.ToString() + " and Isuse_id = " + Isuse_id + " ";

        switch (Type)
        {
            case 1:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and [Money] >= 1000 order by AtTop desc, [Money] desc");
                break;
            case 2:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and [Money] < 1000 order by AtTop desc, [Money] desc");
                break;
            case 3:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and Share = BuyedShare order by AtTop desc, [DateTime]");
                break;
            case 4:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and Share > BuyedShare order by AtTop desc, [DateTime]");
                break;
            case 5:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and Quashed = 1 order by [DateTime]");
                break;
            case 6:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and AssureMoney > 0 order by AtTop desc, [DateTime]");
                break;
            case 7:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " order by AtTop desc, [DateTime]");
                break;
        }

        if (dt == null)
        {
            GoError();
            return;
        }

        dt.Columns.Add("LotteryNumber2", typeof(System.String));
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            try
            {
                dt.Rows[i]["LotteryNumber2"] = ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]);
            }
            catch
            {
                dt.Rows[i]["LotteryNumber2"] = "";
            }
            dt.AcceptChanges();
        }

        grid.DataSource = dt;
        grid.DataBind();
    }

    #region 绑定球队等等附加信息的几个函数 BindDataForTeam()
    private DataTable BindDataForTeam()
    {
        if (ddlIsuse.Items.Count < 1)
            return null;
        string Isuse_id = ddlIsuse.SelectedItem.Value;

        DataTable dtTeam = null;

        if (Lottery_id == Lottery.SFC.ID)
        {
            dtTeam = ShoveEL._Web.Cache.GetCacheAsDataTable("SFC_Team_" + Isuse_id);

            if (dtTeam == null)
            {
                dtTeam = MSSQL.Select("select top 14 * from IsuseForSFC where Isuse_id = " + Isuse_id + " order by [No]");
                if (dtTeam == null)
                    return null;

                ShoveEL._Web.Cache.SetCache("SFC_Team_" + Isuse_id, dtTeam);
            }
        }
        else if (Lottery_id == Lottery.JQC.ID)
        {
            dtTeam = ShoveEL._Web.Cache.GetCacheAsDataTable("JQC_Team_" + Isuse_id);

            if (dtTeam == null)
            {
                dtTeam = MSSQL.Select("select top 8 * from IsuseForJQC where Isuse_id = " + Isuse_id + " order by [No]");
                if (dtTeam == null)
                    return null;

                ShoveEL._Web.Cache.SetCache("JQC_Team_" + Isuse_id, dtTeam);
            }
        }
        else if (Lottery_id == Lottery.LCBQC.ID)
        {
            dtTeam = ShoveEL._Web.Cache.GetCacheAsDataTable("LCBQC_Team_" + Isuse_id);

            if (dtTeam == null)
            {
                dtTeam = MSSQL.Select("select top 6 * from IsuseForLCBQC where Isuse_id = " + Isuse_id.ToString() + " order by [No]");
                if (dtTeam == null)
                    return null;

                ShoveEL._Web.Cache.SetCache("LCBQC_Team_" + Isuse_id, dtTeam);
            }
        }
        else if (Lottery_id == Lottery.LCDC.ID)
        {
            dtTeam = ShoveEL._Web.Cache.GetCacheAsDataTable("LCDC_Team_" + Isuse_id);

            if (dtTeam == null)
            {
                dtTeam = DAL.Tables.IsuseForLCDC.Select("", "Isuse_id = " + Isuse_id.ToString(), "[No]");
                if (dtTeam == null)
                    return null;

                ShoveEL._Web.Cache.SetCache("LCDC_Team_" + Isuse_id, dtTeam);
            }
        }

        return dtTeam;
    }
    #endregion

    protected void btnType_1_Click(object sender, System.EventArgs e)
    {
        int Type = ShoveEL._Convert.StrToInt(((LinkButton)sender).ID.Substring(8, 1), 7);
        this.ViewState[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "MemberBuy_Join_Type"] = Type;

        BindData(Type);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Attributes["onmouseover"] = "this.name=this.style.backgroundColor;this.style.backgroundColor='MistyRose'";
            e.Item.Attributes["onmouseout"] = "this.style.backgroundColor=this.name;";

            e.Item.Cells[0].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[11].Text + "' target='_blank'>" + e.Item.Cells[0].Text + "</a>";

            e.Item.Cells[1].Text = "<a href='../Score.aspx?id=" + e.Item.Cells[12].Text + "&LotteryType=" + Lottery_id.ToString() + "' target='_blank'>" + e.Item.Cells[1].Text + "</a>";
            if (ShoveEL._Convert.StrToDouble(e.Item.Cells[10].Text, 0) > 0)
                e.Item.Cells[1].Text += "<font color=\'red\'>(保)</font>";

            double InitiateUserScore = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            if (InitiateUserScore <= 0)
                InitiateUserScore = 1;
            int Score = (int)Math.Log10(InitiateUserScore) - 1;
            e.Item.Cells[2].Text = "";
            for (int i = 0; i < Score; i++)
                e.Item.Cells[2].Text += "<img src='../Images/gold.gif' border='0'>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            e.Item.Cells[3].Text = (money == 0) ? "" : money.ToString("N");

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[13].Text, false);
            bool isSystemQuashed = ShoveEL._Convert.StrToBool(e.Item.Cells[14].Text, false);
            bool isBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[18].Text, false);
            int SecrecyLevel = ShoveEL._Convert.StrToInt(e.Item.Cells[19].Text, 0);
            bool Stop = (ShoveEL._Convert.StrToDateTime(e.Item.Cells[20].Text, System.DateTime.Now.ToString()) <= System.DateTime.Now);
            bool IsuseOpenWined = (ShoveEL._Convert.StrToInt(e.Item.Cells[21].Text, -1) >= 0);

            int InitiateUser_id = ShoveEL._Convert.StrToInt(e.Item.Cells[12].Text, 0);

            // 投住内容
            //  SecrecyLevel 0 不保密 1 到截止 2 到开奖 3 永远
            if ((SecrecyLevel == 1) && !Stop && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].Text = "已保密，截止后公开";
            }
            else if ((SecrecyLevel == 2) && !IsuseOpenWined && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].Text = "已保密，开奖后公开";
            }
            else if ((SecrecyLevel == 3) && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].Text = "已保密";
            }
            else
            {
                e.Item.ToolTip = e.Item.Cells[4].Text.Trim();
                if ((e.Item.Cells[15].Text.Trim() != "") && (ShoveEL._Convert.ToTextCode(e.Item.Cells[15].Text).Trim() != ""))
                    e.Item.Cells[4].Text = "<a href='../SchemeFiles/" + new Lottery()[Lottery_id].name + "/" + labIsuse.Text + "/" + e.Item.Cells[17].Text.Trim() + "/" + e.Item.Cells[15].Text.Trim() + "' target='_blank'>下载方案</a>";
                else
                {
                    string str = e.Item.Cells[4].Text;
                    if (ShoveEL._String.StringAt(str, '\n') >= PublicFunction.GetOptionsAsInt("SchemeGridMaxLotteryNumberRows", 0))
                    {
                        e.Item.Cells[4].Text = "<a href='../DownLoadSchemeFile.aspx?id=" + e.Item.Cells[11].Text + "' target='_blank'>下载方案</a>";
                    }
                    else
                    {
                        str = e.Item.Cells[4].Text.Replace("\r\n", ", ");
                        if (str.Length > 25)
                        {
                            str = str.Substring(0, 23) + "..";
                        }
                        e.Item.Cells[4].Text = str;
                    }
                }
            }

            int Share = ShoveEL._Convert.StrToInt(e.Item.Cells[5].Text, 1);
            e.Item.Cells[6].Text = Math.Round(money / Share, 2).ToString("N");
            e.Item.Cells[7].Text += "%";
            
            if (Quashed)
            {
                if (isSystemQuashed)
                    e.Item.Cells[8].Text = "<font color='blue'>撤单</font>";
                else
                    e.Item.Cells[8].Text = "撤单";
                e.Item.Cells[9].Text = "--";
            }
            else
            {
                if (isBuyed)
                {
                    e.Item.Cells[8].Text = "<Font color=\'Red\'>已成功</font>";
                    e.Item.Cells[9].Text = "--";
                }
                else
                {
                    if (e.Item.Cells[7].Text == "100%")
                    {
                        e.Item.Cells[8].Text = "<Font color=\'Red\'>满员</font>";
                        e.Item.Cells[9].Text = "--";
                    }
                    else
                    {
                        if (Stop) // 历史期
                        {
                            e.Item.Cells[8].Text = "未成功";
                            e.Item.Cells[9].Text = "--";
                        }
                        else
                        {
                            e.Item.Cells[8].Text = "未满";
                            e.Item.Cells[9].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[11].Text + "' target='_blank'><font color=\"red\">入伙</Font></a>";
                        }
                    }
                }
            }
        }
    }

    #region 几个特殊的彩种表格的 ItemDataBound 事件

    protected void gSFC_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        DataTable dtTeam = BindDataForTeam();
        if (dtTeam == null)
        {
            GoError();
            return;
        }

        if (e.Item.ItemType == ListItemType.Header)
        {
            for (int i = 0; i < dtTeam.Rows.Count; i++)
                e.Item.Cells[4 + i].Text = CoordinateTeamName(dtTeam.Rows[i]["HostTeam"].ToString());
        }
        else if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Attributes["onmouseover"] = "this.name=this.style.backgroundColor;this.style.backgroundColor='MistyRose'";
            e.Item.Attributes["onmouseout"] = "this.style.backgroundColor=this.name;";

            e.Item.Cells[0].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[24].Text + "' target='_blank'>" + e.Item.Cells[0].Text + "</a>";

            e.Item.Cells[1].Text = "<a href='../Score.aspx?id=" + e.Item.Cells[25].Text + "&LotteryType=" + Lottery_id.ToString() + "' target='_blank'>" + e.Item.Cells[1].Text + "</a>";
            if (ShoveEL._Convert.StrToDouble(e.Item.Cells[23].Text, 0) > 0)
                e.Item.Cells[1].Text += "<font color=\'red\'>(保)</font>";

            double InitiateUserScore = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            if (InitiateUserScore <= 0)
                InitiateUserScore = 1;
            int Score = (int)Math.Log10(InitiateUserScore) - 1;
            e.Item.Cells[2].Text = "";
            for (int i = 0; i < Score; i++)
                e.Item.Cells[2].Text += "<img src='../Images/gold.gif' border='0'>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            e.Item.Cells[3].Text = (money == 0) ? "" : money.ToString("N");

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[26].Text, false);
            bool isSystemQuashed = ShoveEL._Convert.StrToBool(e.Item.Cells[27].Text, false);
            bool isBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[32].Text, false);
            int SecrecyLevel = ShoveEL._Convert.StrToInt(e.Item.Cells[33].Text, 0);
            bool Stop = (ShoveEL._Convert.StrToDateTime(e.Item.Cells[34].Text, System.DateTime.Now.ToString()) <= System.DateTime.Now);
            bool IsuseOpenWined = (ShoveEL._Convert.StrToInt(e.Item.Cells[35].Text, -1) >= 0);

            int InitiateUser_id = ShoveEL._Convert.StrToInt(e.Item.Cells[25].Text, 0);

            // 投住内容
            //  SecrecyLevel 0 不保密 1 到截止 2 到开奖 3 永远
            if ((SecrecyLevel == 1) && !Stop && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 14;
                for (int i = 5; i <= 17; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密，截止后公开";
            }
            else if ((SecrecyLevel == 2) && !IsuseOpenWined && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 14;
                for (int i = 5; i <= 17; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密，开奖后公开";
            }
            else if ((SecrecyLevel == 3) && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 14;
                for (int i = 5; i <= 17; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密";
            }
            else
            {
                e.Item.ToolTip = e.Item.Cells[27].Text.Trim();
                if ((e.Item.Cells[29].Text.Trim() != "") && (ShoveEL._Convert.ToTextCode(e.Item.Cells[29].Text).Trim() != ""))
                {
                    e.Item.Cells[4].ColumnSpan = 14;
                    for (int i = 5; i <= 17; i++)
                        e.Item.Cells[i].Visible = false;
                    e.Item.Cells[4].Text = "<a href='../SchemeFiles/" + new Lottery()[Lottery_id].name + "/" + labIsuse.Text + "/" + e.Item.Cells[31].Text.Trim() + "/" + e.Item.Cells[29].Text.Trim() + "' target='_blank'>下载方案</a>";
                }
                else
                {
                    string str = e.Item.Cells[27].Text;
                    if (ShoveEL._String.StringAt(str, '\n') >= PublicFunction.GetOptionsAsInt("SchemeGridMaxLotteryNumberRows", 0))
                    {
                        e.Item.Cells[4].ColumnSpan = 14;
                        for (int i = 5; i <= 17; i++)
                        {
                            e.Item.Cells[i].Visible = false;
                        }
                        e.Item.Cells[4].Text = "<a href='../DownLoadSchemeFile.aspx?id=" + e.Item.Cells[24].Text + "' target='_blank'>下载方案</a>";
                    }
                    else
                    {
                        string[,] NumberList = new Lottery.SFC().SplitLotteryNumberForGrid(e.Item.Cells[27].Text.Trim());
                        if (NumberList != null)
                        {
                            for (int i = 0; i < 14; i++)
                            {
                                string temp = "";
                                for (int j = 0; j <= NumberList.GetUpperBound(0); j++)
                                {
                                    temp += NumberList[j, i];
                                    if (j < NumberList.GetUpperBound(0))
                                        temp += "<BR>";
                                }
                                e.Item.Cells[4 + i].Text = temp;
                            }
                        }
                    }
                }
            }

            int Share = ShoveEL._Convert.StrToInt(e.Item.Cells[18].Text, 1);
            e.Item.Cells[19].Text = Math.Round(money / Share, 2).ToString("N");

            e.Item.Cells[20].Text += "%";

            if (Quashed)
            {
                if (isSystemQuashed)
                    e.Item.Cells[21].Text = "<font color='blue'>撤单</font>";
                else
                    e.Item.Cells[21].Text = "撤单";
                e.Item.Cells[22].Text = "--";
            }
            else
            {
                if (isBuyed)
                {
                    e.Item.Cells[21].Text = "<Font color=\'Red\'>已成功</font>";
                    e.Item.Cells[22].Text = "--";
                }
                else
                {
                    if (e.Item.Cells[20].Text == "100%")
                    {
                        e.Item.Cells[21].Text = "<Font color=\'Red\'>满员</font>";
                        e.Item.Cells[22].Text = "--";
                    }
                    else
                    {
                        if (ddlIsuse.SelectedIndex > 0) // 历史期
                        {
                            e.Item.Cells[21].Text = "未成功";
                            e.Item.Cells[22].Text = "--";
                        }
                        else
                        {
                            e.Item.Cells[21].Text = "未满";
                            e.Item.Cells[22].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[24].Text + "' target='_blank'><font color=\"red\">入伙</Font></a>";
                        }
                    }
                }
            }
        }
    }

    protected void gJQC_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        DataTable dtTeam = BindDataForTeam();
        if (dtTeam == null)
        {
            GoError();
            return;
        }

        if (e.Item.ItemType == ListItemType.Header)
        {
            for (int i = 0; i < dtTeam.Rows.Count; i++)
                e.Item.Cells[4 + i].Text = CoordinateTeamName(dtTeam.Rows[i]["Team"].ToString());
        }
        else if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Attributes["onmouseover"] = "this.name=this.style.backgroundColor;this.style.backgroundColor='MistyRose'";
            e.Item.Attributes["onmouseout"] = "this.style.backgroundColor=this.name;";

            e.Item.Cells[0].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[18].Text + "' target='_blank'>" + e.Item.Cells[0].Text + "</a>";

            e.Item.Cells[1].Text = "<a href='../Score.aspx?id=" + e.Item.Cells[19].Text + "&LotteryType=" + Lottery_id.ToString() + "' target='_blank'>" + e.Item.Cells[1].Text + "</a>";
            if (ShoveEL._Convert.StrToDouble(e.Item.Cells[17].Text, 0) > 0)
                e.Item.Cells[1].Text += "<font color=\'red\'>(保)</font>";

            double InitiateUserScore = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            if (InitiateUserScore <= 0)
                InitiateUserScore = 1;
            int Score = (int)Math.Log10(InitiateUserScore) - 1;
            e.Item.Cells[2].Text = "";
            for (int i = 0; i < Score; i++)
                e.Item.Cells[2].Text += "<img src='../Images/gold.gif' border='0'>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            e.Item.Cells[3].Text = (money == 0) ? "" : money.ToString("N");

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[20].Text, false);
            bool isSystemQuashed = ShoveEL._Convert.StrToBool(e.Item.Cells[21].Text, false);
            bool isBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[26].Text, false);
            int SecrecyLevel = ShoveEL._Convert.StrToInt(e.Item.Cells[27].Text, 0);
            bool Stop = (ShoveEL._Convert.StrToDateTime(e.Item.Cells[28].Text, System.DateTime.Now.ToString()) <= System.DateTime.Now);
            bool IsuseOpenWined = (ShoveEL._Convert.StrToInt(e.Item.Cells[29].Text, -1) >= 0);

            int InitiateUser_id = ShoveEL._Convert.StrToInt(e.Item.Cells[19].Text, 0);

            // 投住内容
            //  SecrecyLevel 0 不保密 1 到截止 2 到开奖 3 永远
            if ((SecrecyLevel == 1) && !Stop && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 8;
                for (int i = 5; i <= 11; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密，截止后公开";
            }
            else if ((SecrecyLevel == 2) && !IsuseOpenWined && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 8;
                for (int i = 5; i <= 11; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密，开奖后公开";
            }
            else if ((SecrecyLevel == 3) && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 8;
                for (int i = 5; i <= 11; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密";
            }
            else
            {
                e.Item.ToolTip = e.Item.Cells[21].Text.Trim();
                if ((e.Item.Cells[23].Text.Trim() != "") && (ShoveEL._Convert.ToTextCode(e.Item.Cells[23].Text).Trim() != ""))
                {
                    e.Item.Cells[4].ColumnSpan = 8;
                    for (int i = 5; i <= 11; i++)
                        e.Item.Cells[i].Visible = false;
                    e.Item.Cells[4].Text = "<a href='../SchemeFiles/" + new Lottery()[Lottery_id].name + "/" + labIsuse.Text + "/" + e.Item.Cells[25].Text.Trim() + "/" + e.Item.Cells[25].Text.Trim() + "' target='_blank'>下载方案</a>";
                }
                else
                {
                    string str = e.Item.Cells[21].Text;
                    if (ShoveEL._String.StringAt(str, '\n') >= PublicFunction.GetOptionsAsInt("SchemeGridMaxLotteryNumberRows", 0))
                    {
                        e.Item.Cells[4].ColumnSpan = 8;
                        for (int i = 5; i <= 11; i++)
                        {
                            e.Item.Cells[i].Visible = false;
                        }
                        e.Item.Cells[4].Text = "<a href='../DownLoadSchemeFile.aspx?id=" + e.Item.Cells[18].Text + "' target='_blank'>下载方案</a>";
                    }
                    else
                    {
                        string[,] NumberList = new Lottery.JQC().SplitLotteryNumberForGrid(e.Item.Cells[21].Text.Trim());
                        if (NumberList != null)
                        {
                            for (int i = 0; i < 8; i++)
                            {
                                string temp = "";
                                for (int j = 0; j <= NumberList.GetUpperBound(0); j++)
                                {
                                    temp += NumberList[j, i];
                                    if (j < NumberList.GetUpperBound(0))
                                        temp += "<BR>";
                                }
                                e.Item.Cells[4 + i].Text = temp;
                            }
                        }
                    }
                }
            }

            int Share = ShoveEL._Convert.StrToInt(e.Item.Cells[12].Text, 1);
            e.Item.Cells[13].Text = Math.Round(money / Share, 2).ToString("N");

            e.Item.Cells[14].Text += "%";

            if (Quashed)
            {
                if (isSystemQuashed)
                    e.Item.Cells[15].Text = "<font color='blue'>撤单</font>";
                else
                    e.Item.Cells[15].Text = "撤单";
                e.Item.Cells[16].Text = "--";
            }
            else
            {
                if (isBuyed)
                {
                    e.Item.Cells[15].Text = "<Font color=\'Red\'>已成功</font>";
                    e.Item.Cells[16].Text = "--";
                }
                else
                {
                    if (e.Item.Cells[14].Text == "100%")
                    {
                        e.Item.Cells[15].Text = "<Font color=\'Red\'>满员</font>";
                        e.Item.Cells[16].Text = "--";
                    }
                    else
                    {
                        if (ddlIsuse.SelectedIndex > 0) // 历史期
                        {
                            e.Item.Cells[15].Text = "未成功";
                            e.Item.Cells[16].Text = "--";
                        }
                        else
                        {
                            e.Item.Cells[15].Text = "未满";
                            e.Item.Cells[16].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[18].Text + "' target='_blank'><font color=\"red\">入伙</Font></a>";
                        }
                    }
                }
            }
        }
    }

    protected void gLCBQC_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        DataTable dtTeam = BindDataForTeam();
        if (dtTeam == null)
        {
            GoError();
            return;
        }

        if (e.Item.ItemType == ListItemType.Header)
        {
            for (int i = 0; i < dtTeam.Rows.Count; i++)
            {
                e.Item.Cells[4 + i * 2].Text = dtTeam.Rows[i]["HostTeam"].ToString().Trim() + "<font color='red'>半</font>";
                e.Item.Cells[4 + i * 2 + 1].Text = dtTeam.Rows[i]["HostTeam"].ToString().Trim() + "<font color='red'>全</font>";
            }
        }
        else if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Attributes["onmouseover"] = "this.name=this.style.backgroundColor;this.style.backgroundColor='MistyRose'";
            e.Item.Attributes["onmouseout"] = "this.style.backgroundColor=this.name;";

            e.Item.Cells[0].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[22].Text + "' target='_blank'>" + e.Item.Cells[0].Text + "</a>";

            e.Item.Cells[1].Text = "<a href='../Score.aspx?id=" + e.Item.Cells[23].Text + "&LotteryType=" + Lottery_id.ToString() + "' target='_blank'>" + e.Item.Cells[1].Text + "</a>";
            if (ShoveEL._Convert.StrToDouble(e.Item.Cells[21].Text, 0) > 0)
                e.Item.Cells[1].Text += "<font color=\'red\'>(保)</font>";

            double InitiateUserScore = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            if (InitiateUserScore <= 0)
                InitiateUserScore = 1;
            int Score = (int)Math.Log10(InitiateUserScore) - 1;
            e.Item.Cells[2].Text = "";
            for (int i = 0; i < Score; i++)
                e.Item.Cells[2].Text += "<img src='../Images/gold.gif' border='0'>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            e.Item.Cells[3].Text = (money == 0) ? "" : money.ToString("N");

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[24].Text, false);
            bool isSystemQuashed = ShoveEL._Convert.StrToBool(e.Item.Cells[25].Text, false);
            bool isBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[30].Text, false);
            int SecrecyLevel = ShoveEL._Convert.StrToInt(e.Item.Cells[31].Text, 0);
            bool Stop = (ShoveEL._Convert.StrToDateTime(e.Item.Cells[32].Text, System.DateTime.Now.ToString()) <= System.DateTime.Now);
            bool IsuseOpenWined = (ShoveEL._Convert.StrToInt(e.Item.Cells[33].Text, -1) >= 0);

            int InitiateUser_id = ShoveEL._Convert.StrToInt(e.Item.Cells[23].Text, 0);

            // 投住内容
            //  SecrecyLevel 0 不保密 1 到截止 2 到开奖 3 永远
            if ((SecrecyLevel == 1) && !Stop && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 12;
                for (int i = 5; i <= 15; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密，截止后公开";
            }
            else if ((SecrecyLevel == 2) && !IsuseOpenWined && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 12;
                for (int i = 5; i <= 15; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密，开奖后公开";
            }
            else if ((SecrecyLevel == 3) && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 12;
                for (int i = 5; i <= 15; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密";
            }
            else
            {
                e.Item.ToolTip = e.Item.Cells[25].Text.Trim();
                if ((e.Item.Cells[27].Text.Trim() != "") && (ShoveEL._Convert.ToTextCode(e.Item.Cells[27].Text).Trim() != ""))
                {
                    e.Item.Cells[4].ColumnSpan = 12;
                    for (int i = 5; i <= 15; i++)
                        e.Item.Cells[i].Visible = false;
                    e.Item.Cells[4].Text = "<a href='../SchemeFiles/" + new Lottery()[Lottery_id].name + "/" + labIsuse.Text + "/" + e.Item.Cells[29].Text.Trim() + "/" + e.Item.Cells[27].Text.Trim() + "' target='_blank'>下载方案</a>";
                }
                else
                {
                    string str = e.Item.Cells[25].Text;
                    if (ShoveEL._String.StringAt(str, '\n') >= PublicFunction.GetOptionsAsInt("SchemeGridMaxLotteryNumberRows", 0))
                    {
                        e.Item.Cells[4].ColumnSpan = 12;
                        for (int i = 5; i <= 15; i++)
                        {
                            e.Item.Cells[i].Visible = false;
                        }
                        e.Item.Cells[4].Text = "<a href='../DownLoadSchemeFile.aspx?id=" + e.Item.Cells[22].Text + "' target='_blank'>下载方案</a>";
                    }
                    else
                    {
                        string[,] NumberList = new Lottery.LCBQC().SplitLotteryNumberForGrid(e.Item.Cells[25].Text.Trim());
                        if (NumberList != null)
                        {
                            for (int i = 0; i < 12; i++)
                            {
                                string temp = "";
                                for (int j = 0; j <= NumberList.GetUpperBound(0); j++)
                                {
                                    temp += NumberList[j, i];
                                    if (j < NumberList.GetUpperBound(0))
                                        temp += "<BR>";
                                }
                                e.Item.Cells[4 + i].Text = temp;
                            }
                        }
                    }
                }
            }

            int Share = ShoveEL._Convert.StrToInt(e.Item.Cells[16].Text, 1);
            e.Item.Cells[17].Text = Math.Round(money / Share, 2).ToString("N");

            e.Item.Cells[18].Text += "%";

            if (Quashed)
            {
                if (isSystemQuashed)
                    e.Item.Cells[19].Text = "<font color='blue'>撤单</font>";
                else
                    e.Item.Cells[19].Text = "撤单";
                e.Item.Cells[20].Text = "--";
            }
            else
            {
                if (isBuyed)
                {
                    e.Item.Cells[19].Text = "<Font color=\'Red\'>已成功</font>";
                    e.Item.Cells[20].Text = "--";
                }
                else
                {
                    if (e.Item.Cells[18].Text == "100%")
                    {
                        e.Item.Cells[19].Text = "<Font color=\'Red\'>满员</font>";
                        e.Item.Cells[20].Text = "--";
                    }
                    else
                    {
                        if (ddlIsuse.SelectedIndex > 0) // 历史期
                        {
                            e.Item.Cells[19].Text = "未成功";
                            e.Item.Cells[20].Text = "--";
                        }
                        else
                        {
                            e.Item.Cells[19].Text = "未满";
                            e.Item.Cells[20].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[22].Text + "' target='_blank'><font color=\"red\">入伙</Font></a>";
                        }
                    }
                }
            }
        }
    }

    protected void gLCDC_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        DataTable dtTeam = BindDataForTeam();
        if (dtTeam == null)
        {
            GoError();
            return;
        }

        if (e.Item.ItemType == ListItemType.Header)
        {
            e.Item.Cells[4].Text = dtTeam.Rows[0]["HostTeam"].ToString().Trim() + "<font color='red'>半</font>";
            e.Item.Cells[5].Text = dtTeam.Rows[0]["HostTeam"].ToString().Trim() + "<font color='red'>全</font>";
            e.Item.Cells[6].Text = dtTeam.Rows[0]["QuestTeam"].ToString().Trim() + "<font color='red'>半</font>";
            e.Item.Cells[7].Text = dtTeam.Rows[0]["QuestTeam"].ToString().Trim() + "<font color='red'>全</font>";
        }
        else if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Attributes["onmouseover"] = "this.name=this.style.backgroundColor;this.style.backgroundColor='MistyRose'";
            e.Item.Attributes["onmouseout"] = "this.style.backgroundColor=this.name;";

            e.Item.Cells[0].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[14].Text + "' target='_blank'>" + e.Item.Cells[0].Text + "</a>";

            e.Item.Cells[1].Text = "<a href='../Score.aspx?id=" + e.Item.Cells[15].Text + "&LotteryType=" + Lottery_id.ToString() + "' target='_blank'>" + e.Item.Cells[1].Text + "</a>";
            if (ShoveEL._Convert.StrToDouble(e.Item.Cells[13].Text, 0) > 0)
                e.Item.Cells[1].Text += "<font color=\'red\'>(保)</font>";

            double InitiateUserScore = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            if (InitiateUserScore <= 0)
                InitiateUserScore = 1;
            int Score = (int)Math.Log10(InitiateUserScore) - 1;
            e.Item.Cells[2].Text = "";
            for (int i = 0; i < Score; i++)
                e.Item.Cells[2].Text += "<img src='../Images/gold.gif' border='0'>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            e.Item.Cells[3].Text = (money == 0) ? "" : money.ToString("N");

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[16].Text, false);
            bool isSystemQuashed = ShoveEL._Convert.StrToBool(e.Item.Cells[18].Text, false);
            bool isBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[22].Text, false);
            int SecrecyLevel = ShoveEL._Convert.StrToInt(e.Item.Cells[23].Text, 0);
            bool Stop = (ShoveEL._Convert.StrToDateTime(e.Item.Cells[24].Text, System.DateTime.Now.ToString()) <= System.DateTime.Now);
            bool IsuseOpenWined = (ShoveEL._Convert.StrToInt(e.Item.Cells[25].Text, -1) >= 0);

            int InitiateUser_id = ShoveEL._Convert.StrToInt(e.Item.Cells[15].Text, 0);

            // 投住内容
            //  SecrecyLevel 0 不保密 1 到截止 2 到开奖 3 永远
            if ((SecrecyLevel == 1) && !Stop && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 4;
                for (int i = 5; i <= 7; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密，截止后公开";
            }
            else if ((SecrecyLevel == 2) && !IsuseOpenWined && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 4;
                for (int i = 5; i <= 7; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密，开奖后公开";
            }
            else if ((SecrecyLevel == 3) && (InitiateUser_id != user.ID))
            {
                e.Item.Cells[4].ColumnSpan = 4;
                for (int i = 5; i <= 7; i++)
                    e.Item.Cells[i].Visible = false;
                e.Item.Cells[4].Text = "已保密";
            }
            else
            {
                e.Item.ToolTip = e.Item.Cells[17].Text.Trim();
                if ((e.Item.Cells[19].Text.Trim() != "") && (ShoveEL._Convert.ToTextCode(e.Item.Cells[19].Text).Trim() != ""))
                {
                    e.Item.Cells[4].ColumnSpan = 4;
                    for (int i = 5; i <= 7; i++)
                        e.Item.Cells[i].Visible = false;
                    e.Item.Cells[4].Text = "<a href='../SchemeFiles/" + new Lottery()[Lottery_id].name + "/" + labIsuse.Text + "/" + e.Item.Cells[21].Text.Trim() + "/" + e.Item.Cells[19].Text.Trim() + "' target='_blank'>下载方案</a>";
                }
                else
                {
                    string str = e.Item.Cells[17].Text;
                    if (ShoveEL._String.StringAt(str, '\n') >= PublicFunction.GetOptionsAsInt("SchemeGridMaxLotteryNumberRows", 0))
                    {
                        e.Item.Cells[4].ColumnSpan = 4;
                        for (int i = 5; i <= 7; i++)
                        {
                            e.Item.Cells[i].Visible = false;
                        }
                        e.Item.Cells[4].Text = "<a href='../DownLoadSchemeFile.aspx?id=" + e.Item.Cells[14].Text + "' target='_blank'>下载方案</a>";
                    }
                    else
                    {
                        string[,] NumberList = new Lottery.LCDC().SplitLotteryNumberForGrid(e.Item.Cells[17].Text.Trim());
                        if (NumberList != null)
                        {
                            for (int i = 0; i < 4; i++)
                            {
                                string temp = "";
                                for (int j = 0; j <= NumberList.GetUpperBound(0); j++)
                                {
                                    temp += NumberList[j, i];
                                    if (j < NumberList.GetUpperBound(0))
                                        temp += "<BR>";
                                }
                                e.Item.Cells[4 + i].Text = temp;
                            }
                        }
                    }
                }
            }

            int Share = ShoveEL._Convert.StrToInt(e.Item.Cells[8].Text, 1);
            e.Item.Cells[9].Text = Math.Round(money / Share, 2).ToString("N");

            e.Item.Cells[10].Text += "%";

            if (Quashed)
            {
                if (isSystemQuashed)
                    e.Item.Cells[11].Text = "<font color='blue'>撤单</font>";
                else
                    e.Item.Cells[11].Text = "撤单";
                e.Item.Cells[12].Text = "--";
            }
            else
            {
                if (isBuyed)
                {
                    e.Item.Cells[11].Text = "<Font color=\'Red\'>已成功</font>";
                    e.Item.Cells[12].Text = "--";
                }
                else
                {
                    if (e.Item.Cells[10].Text == "100%")
                    {
                        e.Item.Cells[11].Text = "<Font color=\'Red\'>满员</font>";
                        e.Item.Cells[12].Text = "--";
                    }
                    else
                    {
                        if (ddlIsuse.SelectedIndex > 0) // 历史期
                        {
                            e.Item.Cells[11].Text = "未成功";
                            e.Item.Cells[12].Text = "--";
                        }
                        else
                        {
                            e.Item.Cells[11].Text = "未满";
                            e.Item.Cells[12].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[14].Text + "' target='_blank'><font color=\"red\">入伙</Font></a>";
                        }
                    }
                }
            }
        }
    }

    #endregion

    private string CoordinateTeamName(string str)
    {
        if (str.Length == 2)
            str = str.Substring(0, 1) + "<BR>&nbsp;&nbsp;<BR>" + str.Substring(1, 1);
        return str;
    }

    protected void ddlIsuse_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        this.ViewState[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "MemberBuy_Join_Type"] = 7;
        BindData(7);
    }

    protected void btn1_ServerClick(object sender, EventArgs e)
    {
        this.Response.Redirect(String.Format("Join.aspx?Lottery={0}&BuyType={1}&Page={2}&Price={3}", Lottery_id, BuyType_id, BuyFileName, Price), true);
    }

    protected void btn2_ServerClick(object sender, EventArgs e)
    {
        this.Response.Redirect(String.Format("Initiate.aspx?Lottery={0}&BuyType={1}&Page={2}&Price={3}", Lottery_id, BuyType_id, BuyFileName, Price), true);
    }

    protected void btn3_ServerClick(object sender, EventArgs e)
    {
        this.Response.Redirect(String.Format("Surrogate.aspx?Lottery={0}&BuyType={1}&Page={2}&Price={3}", Lottery_id, BuyType_id - 1, BuyFileName, Price), true);
    }
}