﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Text.RegularExpressions;

public partial class MemberBuy_SchemeUpload : System.Web.UI.Page
{
    public Users user;
    public string strLotteryNumber, strSchemeFileName, strLottery_id, strBuyType, strBuyTypeName, strPanelNum, strIsuse;
    public string strLotteryName;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        user = Users.GetSessionUser();
        if (user == null)
            return;

        if (!this.IsPostBack)
        {
            Lottery lottery = new Lottery();

            int Lottery_id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (!lottery.ValidID(Lottery_id))
                return;

            tbLottery_id.Value = Lottery_id.ToString();
            strLottery_id = Lottery_id.ToString();

            strIsuse = "";
            try
            {
                strIsuse = this.Request["Isuse"].Trim();
            }
            catch
            { }
            tbIsuse.Value = strIsuse;

            int BuyType = ShoveEL._Convert.StrToInt(this.Request["BuyType"], -1);
            if (BuyType < 0)
                return;

            bool BuyTypeRight = false;

            strLotteryName = lottery[Lottery_id].name;
            BuyTypeRight = lottery[Lottery_id].CheckBuyType(BuyType);

            if (!BuyTypeRight)
                return;

            tbBuyType.Value = BuyType.ToString();
            strBuyType = BuyType.ToString();

            tbSchemeFileName.Value = "null";
            tbLotteryNumber.Value = "null";
            strSchemeFileName = "null";
            strLotteryNumber = "null";

            btnfileUp.Attributes.Add("onclick", "return btnfileUpClick();");

            btnfile.Disabled = false;
            btnfileUp.Enabled = true;
        }
    }

    protected void btnfileUp_Click(object sender, System.EventArgs e)
    {
        tbSchemeFileName.Value = "null";
        tbLotteryNumber.Value = "null";
        strSchemeFileName = "null";
        strLotteryNumber = "null";

        strBuyTypeName = new Lottery().GetBuyTypeName(int.Parse(tbBuyType.Value));
        strLotteryName = new Lottery()[int.Parse(tbLottery_id.Value)].name;

        string SchemeFileDir = this.Server.MapPath("../SchemeFiles/" + strLotteryName + "/" + tbIsuse.Value + "/" + strBuyTypeName);
        if (!System.IO.Directory.Exists(SchemeFileDir))
            System.IO.Directory.CreateDirectory(SchemeFileDir);

        string NewFileName = "";
        if (ShoveEL._IO.File.UploadFile(this.Page, btnfile, "../SchemeFiles/" + strLotteryName + "/" + tbIsuse.Value + "/" + strBuyTypeName + "/", ref NewFileName) != 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "方案上传失败。");
            return;
        }

        string Content = System.IO.File.ReadAllText(SchemeFileDir + "/" + NewFileName, System.Text.Encoding.Default);
        if (Content == "")
        {
            System.IO.File.Delete(this.Page.Server.MapPath(SchemeFileDir + "/" + NewFileName));
            ShoveEL._Web.JavaScript.Alert(this.Page, "方案文件没有任何内容，请重新选择。");
            return;
        }

        tbSchemeFileName.Value = NewFileName;
        strSchemeFileName = NewFileName;

        //分析
        int Lottery_id = ShoveEL._Convert.StrToInt(tbLottery_id.Value, -1);
        if (!new Lottery().ValidID(Lottery_id))
        {
            System.IO.File.Delete(SchemeFileDir + "/" + NewFileName);
            tbSchemeFileName.Value = "null";
            strSchemeFileName = "null";
            ShoveEL._Web.JavaScript.Alert(this.Page, "方案上传失败。");
            return;
        }

        int BuyType = int.Parse(tbBuyType.Value);
        tbLotteryNumber.Value = new Lottery()[Lottery_id].AnalyseScheme(Content, BuyType);

        strLotteryNumber = tbLotteryNumber.Value.Trim();
        if (strLotteryNumber == "")
        {
            System.IO.File.Delete(SchemeFileDir + "/" + NewFileName);
            tbLotteryNumber.Value = "null";
            strLotteryNumber = "null";
            tbSchemeFileName.Value = "null";
            strSchemeFileName = "null";
            ShoveEL._Web.JavaScript.Alert(this.Page, "从方案文件中没有提取到符合书写规则的投注内容。");
        }
        else
        {
            //				//将提取出的正确结果重新写入方案文件。
            //				Regex regex = new Regex(@"[|][^\n]+?\n", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            //				string strLotteryNumberNoWithNum = regex.Replace(strLotteryNumber + "\n", "\r\n");
            //				StreamWriter sw = System.IO.File.CreateText(SchemeFileDir + "/" + NewFileName);
            //				sw.Write(strLotteryNumberNoWithNum);
            //				sw.Close();

            ShoveEL._Web.JavaScript.Alert(this.Page, "方案上传成功。（注：系统只从方案中提取遵循书写规则的投注内容，如果系统提取的结果与您方案文件不一致，请检查方案文件是否完全遵循了书写规则）");
        }
    }
}