﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ZCDC_DCBF : MemberPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindIsuse();    //绑定期号
        }
    }

    private void BindIsuse()
    {
        DataTable dt = DAL.Tables.Isuse.Select("", "Lottery_id =  " + Lottery.ZCDC.ID + " and EndTime > GetDate()", "EndTime");
        if (dt == null)
        {
            GoError();
            return;
        }

        ddlIsuse.Items.Clear();
        if (dt.Rows.Count != 0)
        {
            ddlIsuse.DataTextField = "Isuse";
            ddlIsuse.DataValueField = "id";
            ddlIsuse.DataSource = dt;
            ddlIsuse.DataBind();

            ddlIsuse.SelectedIndex = 0;

            GetIsuserInfo(int.Parse(ddlIsuse.SelectedValue));
            BindTeam("", int.Parse(ddlIsuse.SelectedValue));
            BindDl();
            lbNoCompetition.Visible = false;
            dlcp.Visible = true;
            plCompetition.Visible = true;
            plBetting.Visible = true;
        }
        else
        {
            HiddenField tb_AssureShare = new HiddenField();
            tb_AssureShare.ID = "tb_AssureShare";
            tb_AssureShare.Value = "0";
            this.form1.Controls.Add(tb_AssureShare);
            HiddenField tb_BuyShare = new HiddenField();
            tb_BuyShare.ID = "tb_BuyShare";
            tb_BuyShare.Value = "0";
            this.form1.Controls.Add(tb_BuyShare);
            HiddenField sumMoney = new HiddenField();
            sumMoney.ID = "sumMoney";
            sumMoney.Value = "0";
            this.form1.Controls.Add(sumMoney);
            HiddenField lab_ShareMoney = new HiddenField();
            lab_ShareMoney.ID = "lab_ShareMoney";
            lab_ShareMoney.Value = "0";
            this.form1.Controls.Add(lab_ShareMoney);
            HiddenField lab_AssureMoney = new HiddenField();
            lab_AssureMoney.ID = "lab_AssureMoney";
            lab_AssureMoney.Value = "0";
            this.form1.Controls.Add(lab_AssureMoney);
            HiddenField lab_BuyMoney = new HiddenField();
            lab_BuyMoney.ID = "lab_BuyMoney";
            lab_BuyMoney.Value = "0";
            this.form1.Controls.Add(lab_BuyMoney);
            lab_Balance.Visible = false;
            //HiddenField lab_Balance = new HiddenField();
            //lab_Balance.ID = "lab_Balance";
            //lab_Balance.Value = "0";
            this.form1.Controls.Add(lab_Balance);

            ddlIsuse.Items.Add(new ListItem("没有相应的期数", "-1"));
            lbNoCompetition.Visible = true;
            dlcp.Visible = false;
            plCompetition.Visible = false;
            plBetting.Visible = false;
        }

        lab_Balance.Text = user.Balance.ToString("N");
        bool isValidBuyPassword = PublicFunction.GetOptionsAsBoolean("isValidBuyPassword", true);
        if (isValidBuyPassword && user.isAlipayMember)  //如果普通用户需要输入投注密码，支付宝会员不需要
        {
            isValidBuyPassword = false;
        }
        panel_InvestPassword.Visible = isValidBuyPassword;
    }

    private void BindTeam(string Team, int Isuse_id)
    {
        if (Team == "")
        {
            dlTeam.DataSource = DAL.Views.V_ZCDCLeagueType.Select("", "[Isuse_id]=" + Isuse_id.ToString() + " and DateTime > GetDate()", "[No]");
        }
        else
        {
            dlTeam.DataSource = DAL.Views.V_ZCDCLeagueType.Select("", "[Isuse_id]=" + Isuse_id.ToString() + " and [TypeId] = " + Team + " and DateTime > GetDate()", "[No]");
        }

        dlTeam.DataBind();
    }

    private void BindDl()
    {
        dlcp.Items.Clear();
        DataTable tb;
        tb = DAL.Tables.LeagueTypeForZCDC.Select("", "", "");

        if (tb == null)
        {
            GoError("参数错误，系统异常。");
            return;
        }

        dlcp.DataTextField = "LeagueTypeName";
        dlcp.DataValueField = "id";

        dlcp.DataSource = tb;
        dlcp.DataBind();

        dlcp.Items.Add(new ListItem("全部显示", ""));
        dlcp.SelectedIndex = dlcp.Items.Count - 1;

    }

    protected void dlcp_SelectedIndexChanged(object sender, EventArgs e)
    {
        BindTeam(dlcp.SelectedValue, int.Parse(ddlIsuse.SelectedValue));
    }

    protected void ddlIsuse_SelectedIndexChanged(object sender, EventArgs e)
    {
        GetIsuserInfo(int.Parse(ddlIsuse.SelectedValue));
        BindTeam("", int.Parse(ddlIsuse.SelectedValue));
        BindDl();
    }

    protected void GetIsuserInfo(int id)
    {
        DataTable dt;
        dt = DAL.Tables.Isuse.Select("[Isuse],[StartTime],[EndTime]", " id = '" + id.ToString() + "'", "");

        if (dt == null)
        {
            GoError("参数错误，系统异常。");
            return;
        }

        // 判断是否当期，并正在投注
        System.DateTime dtStart = DateTime.Parse(dt.Rows[0][1].ToString());
        System.DateTime dtEnd = DateTime.Parse(dt.Rows[0][2].ToString());

        labEndTime.Value = dtEnd.ToString();

        if ((DateTime.Now > dtStart) && (DateTime.Now <= dtEnd))
        {
            LbIsuse.Text = dt.Rows[0][0].ToString();
            LbCdtion.Text = "销售中";
            LbStart.Text = dtStart.ToString() + " 至 " + dtEnd.ToString();
            BindTeam("", int.Parse(ddlIsuse.SelectedValue));

        }
        else
        {
            LbCdtion.Text = "销售截止";
        }
    }
    protected void btn_OK_Click(object sender, EventArgs e)
    {
        if (!user.CanInvest)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，您还不是高级会员，请先免费升级为高级会员。谢谢！", "ZCDC_DCBF.aspx");
            return;
        }

        if (panel_InvestPassword.Visible)
        {
            if (tb_InvestPassword.Text != user.Password_2)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "投注密码错误！", "ZCDC_DCBF.aspx");
                return;
            }
        }

        System.DateTime dt = DateTime.Parse(labEndTime.Value);
        if (DateTime.Now >= dt)
        {
            //this.btn1.Disabled = true;
            // this.btn2.Disabled = true;
            //this.btn3.Disabled = true;
            ShoveEL._Web.JavaScript.Alert(this.Page, "本期投注已截止，谢谢。", "ZCDC_DCBF.aspx");
            return;
        }

        string[] LotteryNumbers = HidLotteryNumber.Value.Trim().Split('/');
        for (int i = 0; i < LotteryNumbers.Length; i++)
        {
            //判断是否过期
            if (!PublicFunction.GetZCDCNoIsOverdue(int.Parse(ddlIsuse.SelectedValue), LotteryNumbers[i].ToString().Split(':')[0]))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，您方案中的第" + LotteryNumbers[i].ToString().Split(':')[0] + "场比赛已过期，请重新投注。", "ZCDC_BQC.aspx");
                return;
            }
        }

        string LotteryNumber = Lottery.ZCDC.BuyType_ZQBF + ";[" + HidLotteryNumber.Value.Trim().Replace("[", "(").Replace(":", "").Replace("]", ")").Replace("/", "|") + "];[";

        if (ShoveEL._Convert.StrToInt(txtOneDouble.Value, 0) > 0)
        {
            LotteryNumber += "1" + txtOneDouble.Value + ",";
        }

        if (ShoveEL._Convert.StrToInt(txtTwoDouble.Value, 0) > 0)
        {
            LotteryNumber += "2" + txtTwoDouble.Value + ",";
        }

        if (ShoveEL._Convert.StrToInt(txtThreeDouble.Value, 0) > 0)
        {
            LotteryNumber += "3" + txtThreeDouble.Value + ",";
        }

        if (ShoveEL._Convert.StrToInt(txtDouble.Value, 0) > 0)
        {
            LotteryNumber += Hidtype.Value + txtDouble.Value + ",";
        }

        LotteryNumber = LotteryNumber.Substring(0, LotteryNumber.Length - 1);

        LotteryNumber += "]";

        double SumMoney = 0;
        int Share = 0;
        int BuyShare = 0;
        double AssureMoney = 0;
        int Multiple = 1;
        int SumNum = 0;

        try
        {
            SumMoney = double.Parse(tb_hide_SumMoney.Value);
            Share = int.Parse(tb_Share.Value);
            BuyShare = int.Parse(tb_BuyShare.Text);
            AssureMoney = double.Parse(lab_ShareMoney.Text);

            SumNum = int.Parse(tb_Share.Value);
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。", "ZCDC_DCBF.aspx");
            return;
        }

        if ((SumMoney <= 0) || (Share < 1) || (BuyShare < 1) || (Multiple < 1))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。", "ZCDC_DCBF.aspx");
            return;
        }

        string Return = "";
        user.GetUserBalance(ref Return);
        if ((((SumMoney / Share) * BuyShare) + AssureMoney) > user.Balance)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "您的帐户余额不足，请先增加预付款，谢谢。", "ZCDC_DCBF.aspx");
            return;
        }

        btn_OK.Enabled = false;

        int SecrecyLevel = rbSecrecy1.Checked ? 0 : (rbSecrecy2.Checked ? 1 : (rbSecrecy3.Checked ? 2 : 3));

        Return = "";
        int Result = user.Buy(tb_Title.Text.Trim() == "" ? "(无标题)" : tb_Title.Text.Trim(), tb_Description.Text.Trim(), int.Parse(ddlIsuse.SelectedValue), Lottery.ZCDC.BuyType_ZQBF, LotteryNumber, Multiple, SumMoney, AssureMoney, Share, BuyShare, "", tb_OpenUserList.Text.Trim(), SecrecyLevel, ref Return);
        if ((Return != "") || (Result != 0))
        {
            GoError(Return);
            return;
        }
        ShoveEL._Web.JavaScript.Alert(this.Page, "您发起的 方案已经提交成功，预祝您早中大奖！","ZCDC_DCBF.aspx");
    }
}