﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberBuyQuick_SZPL3_ZhiF : System.Web.UI.Page
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        if (!this.IsPostBack)
        {
            BindDataForIsuse();
            btnOK.Attributes.Add("onclick", "return btnOKClick();");

            panelInvestPassword.Visible = PublicFunction.GetOptionsAsBoolean("isValidBuyPassword", true);
        }
    }

    private void BindDataForIsuse()
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            this.Response.Redirect("../Error2.aspx?ErrorNumber=01", true);
            return;
        }

        SqlCommand Cmd = new SqlCommand("select top 1 *, dbo.F_GetSystemEndTime(" + Lottery.SZPL.BuyType_3_ZhiF_D.ToString() + ", EndTime) as SystemEndTime from V_Isuse where Lottery_id = " + Lottery.SZPL.sID + " and StartTime < GetDate() order by [EndTime] desc", conn);
        SqlDataReader dr = null;

        try
        {
            dr = Cmd.ExecuteReader();
        }
        catch
        {
            conn.Close();
            this.Response.Redirect("../Error2.aspx?ErrorNumber=01", true);
            return;
        }

        if (!dr.Read())
        {
            dr.Close();
            conn.Close();
            this.Response.Redirect("../Error2.aspx?ErrorNumber=04", true);
            return;
        }

        tbIsuse_id.Text = dr["id"].ToString();
        tbIsuseing.Text = (System.DateTime.Parse(dr["SystemEndTime"].ToString()) > System.DateTime.Now).ToString();
        labIsuse.Text = "数字排列-排列3第" + dr["Isuse"].ToString() + "期";
        labEndTime.Text = dr["SystemEndTime"].ToString();
        dr.Close();
        conn.Close();
    }

    protected void btnOK_Click(object sender, System.EventArgs e)
    {
        Users user = Users.GetSessionUser();
        if (user == null)
        {
            //ShoveEL._Web.JavaScript.OpenWindow(this.Page, "../Error.aspx?ErrorNumber=02&LastRequestPage=Index.aspx");
            ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，您还没有登录。");
            return;
        }

        bool Isuseing = bool.Parse(tbIsuseing.Text);
        if (!Isuseing)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "此期已经截止认购。");
            return;
        }

        System.DateTime dt = DateTime.Parse(labEndTime.Text);
        if (DateTime.Now >= dt)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "本期投注已截止，谢谢。");
            return;
        }

        if (!user.CanInvest)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，您还不是高级会员，请先免费升级为高级会员。谢谢！");
            return;
        }

        if (panelInvestPassword.Visible)
        {
            if (tbInvestPassword.Text != user.Password_2)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "投注密码错误！");
                return;
            }
        }

        double SumMoney = 0;
        int Multiple = 0;

        try
        {
            SumMoney = double.Parse(tbhide_SumMoney.Text);
            Multiple = int.Parse(tbMultiple.Text);
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        if ((SumMoney <= 0) || (Multiple < 1))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        string Return = "";
        user.GetUserBalance(ref Return);
        if (SumMoney > user.Balance)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "您的帐户余额不足，请先增加预付款，谢谢。");
            return;
        }

        string LotteryNumber = tbhide_LotteryNumber.Value.Trim();
        if (LotteryNumber[LotteryNumber.Length - 1] == '\n')
            LotteryNumber = LotteryNumber.Substring(0, LotteryNumber.Length - 1);

        Return = "";
        int Result = user.Buy("代购", "", int.Parse(tbIsuse_id.Text), Lottery.SZPL.BuyType_3_ZhiF_D, LotteryNumber, Multiple, SumMoney, "", 0, ref Return);
        if ((Return != "") || (Result != 0))
        {
            this.Response.Redirect("../Error2.aspx?ErrorNumber=01&Tip=" + Return, true);
            return;
        }

        //ShoveEL._Web.JavaScript.OpenWindow(this.Page, "../MemberBuy/OK.aspx?Tip=" + System.Web.HttpUtility.UrlEncode("您申请的排列3复式代购已经提交成功，预祝您早中大奖！"));
        ShoveEL._Web.JavaScript.Alert(this.Page, "您申请的排列3复式代购已经提交成功，预祝您早中大奖！");
    }
}