﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class MemberBuyQuick_SchemeAll : System.Web.UI.Page
{
    public string D_Surrogate = "";
    public string D_Join = "";
    public string D_Initiate = "";
    public string F_Surrogate = "";
    public string F_Join = "";
    public string F_Initiate = "";

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int Lottery_id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (!new Lottery().ValidID(Lottery_id))
            {
                this.Response.Redirect("../Error2.aspx?ErrorNumber=01", true);
                return;
            }

            tbLottery_id.Text = Lottery_id.ToString();

            Lottery lottery = new Lottery();

            D_Surrogate = "";
            D_Join = "";
            D_Initiate = "";
            F_Surrogate = "";
            F_Join = "";
            F_Initiate = "";

            lottery.GetBasePlayPage(Lottery_id, ref D_Surrogate, ref D_Join, ref D_Initiate, ref F_Surrogate, ref F_Join, ref F_Initiate);

            BindData();
        }
    }

    private void BindData()
    {
        int MemberBuyQuickSchemeAll_RowsCount = PublicFunction.GetOptionsAsInt("MemberBuyQuickSchemeAll_RowsCount", 10);
        if (MemberBuyQuickSchemeAll_RowsCount <= 0)
        {
            MemberBuyQuickSchemeAll_RowsCount = 10;
        }

        int Lottery_id = int.Parse(tbLottery_id.Text);

        DataTable dt = MSSQL.Select("select top 1 * from V_Isuse where Lottery_id = @Lottery_id and StartTime < GetDate() order by [EndTime] desc",
                                new MSSQL.Parameter("Lottery_id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id));
        if (dt == null)
        {
            this.Response.Redirect("../Error2.aspx?ErrorNumber=01", true);
            return;
        }

        if (dt.Rows.Count < 1)
        {
            this.Response.Redirect("../Error2.aspx?ErrorNumber=04", true);
            return;
        }

        string Isuse_id = dt.Rows[0]["id"].ToString();
        tbIsuseing.Text = (System.DateTime.Parse(dt.Rows[0]["EndTime"].ToString()) > System.DateTime.Now).ToString();

        string strCmd;
        if (PublicFunction.GetOptionsAsBoolean("isFirstPageUnionBuyWithAll", false))
            strCmd = "select top " + MemberBuyQuickSchemeAll_RowsCount.ToString() + " * from V_SchemeSchedule where Lottery_id = " + Lottery_id.ToString() + " and Isuse_id = " + Isuse_id + " order by AtTop desc, Schedule desc";
        else
            strCmd = "select top " + MemberBuyQuickSchemeAll_RowsCount.ToString() + " * from V_SchemeSchedule where Lottery_id = " + Lottery_id.ToString() + " and Isuse_id = " + Isuse_id + " and Schedule < 100 order by AtTop desc, Schedule desc";

        dt = MSSQL.Select(strCmd);
        if (dt == null)
        {
            this.Response.Redirect("../Error2.aspx?ErrorNumber=01", true);
            return;
        }

        g.PageSize = MemberBuyQuickSchemeAll_RowsCount;
        g.DataSource = dt;
        g.DataBind();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Attributes["onmouseover"] = "this.name=this.style.backgroundColor;this.style.backgroundColor='MistyRose'";
            e.Item.Attributes["onmouseout"] = "this.style.backgroundColor=this.name;";

            e.Item.Cells[0].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[10].Text + "' target='_blank'><font color=\"#330099\">" + e.Item.Cells[0].Text + "</Font></a>";

            e.Item.Cells[1].Text = "<a href='../Score.aspx?id=" + e.Item.Cells[11].Text + "&LotteryType=" + tbLottery_id.Text + "' target='_blank'><font color=\"#330099\">" + e.Item.Cells[1].Text + "</Font></a>";
            if (ShoveEL._Convert.StrToDouble(e.Item.Cells[9].Text, 0) > 0)
                e.Item.Cells[1].Text += "<font color=\'red\'>(保)</font>";

            double InitiateUserScore = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            if (InitiateUserScore <= 0)
                InitiateUserScore = 1;
            int Score = (int)Math.Log10(InitiateUserScore) - 1;
            e.Item.Cells[2].Text = "";
            for (int i = 0; i < Score; i++)
                e.Item.Cells[2].Text += "<img src='../Images/gold.gif' border='0'>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            e.Item.Cells[3].Text = (money == 0) ? "" : money.ToString("N");

            int Share = ShoveEL._Convert.StrToInt(e.Item.Cells[4].Text, 1);
            e.Item.Cells[5].Text = Math.Round(money / Share, 2).ToString("N");

            e.Item.Cells[6].Text += "%";

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[12].Text, false);
            if (Quashed)
            {
                e.Item.Cells[7].Text = "撤单";
                e.Item.Cells[8].Text = "--";
            }
            else
            {
                bool isBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[15].Text, false);
                if (isBuyed)
                {
                    e.Item.Cells[7].Text = "<Font color=\'Red\'>已成功</font>";
                    e.Item.Cells[8].Text = "--";
                }
                else
                {
                    if (e.Item.Cells[6].Text == "100%")
                    {
                        e.Item.Cells[7].Text = "<Font color=\'Red\'>满员</font>";
                        e.Item.Cells[8].Text = "--";
                    }
                    else
                    {
                        bool Isuseing = bool.Parse(tbIsuseing.Text);
                        if (Isuseing)	//当前最后1期,正在投注
                        {
                            e.Item.Cells[7].Text = "未满";
                            e.Item.Cells[8].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[10].Text + "' target='_blank'><font color=\"red\">入伙</Font></a>";
                        }
                        else	//历史期
                        {
                            e.Item.Cells[7].Text = "未成功";
                            e.Item.Cells[8].Text = "--";
                        }
                    }
                }
            }
        }
    }
}