﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberChase : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberChase.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("MemberChase" + user.ID.ToString());

        if (dt == null)
        {
            dt = DAL.Views.V_ChaseTotal.Select("", "[User_id] = " + user.ID.ToString(), "[DateTime]");

            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("MemberChase" + user.ID.ToString(), dt);
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            string str = e.Item.Cells[2].Text.Trim();
            if (str.Length > 8)
                str = str.Substring(0, 7) + "..";
            e.Item.Cells[2].Text = "<a href='MemberChaseDetail.aspx?id=" + e.Item.Cells[10].Text + "'><font color=\"#330099\">" + str + "</Font></a>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[5].Text, 0);
            e.Item.Cells[5].Text = (money == 0) ? "" : money.ToString("N");

            int SumIsuseNum = ShoveEL._Convert.StrToInt(e.Item.Cells[6].Text, 0);
            int BuyedIsuseNum = ShoveEL._Convert.StrToInt(e.Item.Cells[7].Text, 0);
            int QuashedIsuseNum = ShoveEL._Convert.StrToInt(e.Item.Cells[8].Text, 0);
            e.Item.Cells[9].Text = (SumIsuseNum > (BuyedIsuseNum + QuashedIsuseNum)) ? "<Font color=\'Red\'>进行中</font>" : "已终止";
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}