﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberChaseDetail : MemberPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        int Chase_id = ShoveEL._Convert.StrToInt(this.Request["ID"], -1);

        if (Chase_id < 1)
        {
            this.Response.Redirect("MemberChase.aspx");
            return;
        }

        if (!this.IsPostBack)
            BindData(Chase_id);
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberChaseDetail.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindData(int Chase_id)
    {
        DataTable dt = DAL.Views.V_ChaseTotal.Select("", "id = " + Chase_id.ToString(), "");

        if ((dt == null) || (dt.Rows.Count < 1))
        {
            GoError();
            return;
        }

        DataRow dr = dt.Rows[0];

        labChase_id.Text = Chase_id.ToString();

        labTitle.Text = dr["Title"].ToString().Trim();
        Label1.Text = dr["Name"].ToString() + " " + dr["ChaseBuyType"].ToString();
        Label2.Text = dr["BuyType"].ToString();

        if (dr["BuyType"].ToString().Trim() == "自选号码")
        {
            try
            {
                Label3.Text = ShoveEL._Convert.ToHtmlCode(ShoveEL._String.Decompress((byte[])dr["LotteryNumber"]));
            }
            catch
            {
                Label3.Text = " ";
            }
        }
        else
            Label3.Text = "(机选，见当期)";

        double IsuseMoney, SumMoney;
        int SumIsuseNum, BuyedIsuseNum, QuashedIsuseNum;
        SumMoney = ShoveEL._Convert.StrToDouble(dr["SumMoney"].ToString(), 0);
        SumIsuseNum = ShoveEL._Convert.StrToInt(dr["SumIsuseNum"].ToString(), 0);
        BuyedIsuseNum = ShoveEL._Convert.StrToInt(dr["BuyedIsuseNum"].ToString(), 0);
        QuashedIsuseNum = ShoveEL._Convert.StrToInt(dr["QuashedIsuseNum"].ToString(), 0);
        try
        {
            IsuseMoney = SumMoney / SumIsuseNum;
        }
        catch
        {
            GoError();
            return;
        }

        Label4.Text = "倍数:<font color=\'red\'>" + dr["Multiple"].ToString() + "</font>; 共<font color=\'red\'>" + SumIsuseNum.ToString() + "</font>期<font color=\'red\'>" +
            SumMoney.ToString("N") + "</font>元; 已完成<font color=\'red\'>" + BuyedIsuseNum.ToString() + "</font>期<font color=\'red\'>" + (BuyedIsuseNum * IsuseMoney).ToString("N") + "</font>元; 已取消<font color=\'red\'>" +
            QuashedIsuseNum.ToString() + "</font>期<font color=\'red\'>" + (QuashedIsuseNum * IsuseMoney).ToString("N") + "</font>元。";

        btnQuash.Enabled = (SumIsuseNum > (BuyedIsuseNum + QuashedIsuseNum));


        //填充每期列表
        dt = DAL.Views.V_ChaseDetail.Select("", "Chase_id = " + Chase_id.ToString(), "[DateTime]");

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Cells[0].Text += "期";
            e.Item.Cells[1].Text = "倍数:" + e.Item.Cells[1].Text;

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            e.Item.Cells[2].Text = (money == 0) ? "" : money.ToString("N");

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[6].Text, false);
            bool Buyed = ShoveEL._Convert.StrToBool(e.Item.Cells[7].Text, false);
            if (Quashed)
                e.Item.Cells[3].Text = "已撤消";
            else
            {
                if (Buyed)
                {
                    e.Item.Cells[3].Text = "<font color=\'#330099\'>已成功</font>";
                    int Scheme_id = ShoveEL._Convert.StrToInt(e.Item.Cells[8].Text, 0);
                    if (Scheme_id > 0)
                        e.Item.Cells[4].Text = "<a href='Scheme.aspx?id=" + Scheme_id.ToString() + "' target='_blank'><font color=\"#330099\">查看方案</Font></a>";
                }
                else
                {
                    e.Item.Cells[3].Text = "<font color=\'Red\'>进行中</font>";
                    ((Button)e.Item.Cells[5].FindControl("btnQuashIsuse")).Enabled = true;
                }
            }
        }
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
    {
        if (e.CommandName == "QuashIsuse")
        {
            int ChaseIsuse_id = ShoveEL._Convert.StrToInt(e.Item.Cells[9].Text, 0);
            if (ChaseIsuse_id < 1)
            {
                GoError();
                return;
            }

            string Return = "";
            int Result = user.QuashChase(ChaseIsuse_id, ref Return);
            if ((Return != "") || (Result != 0))
            {
                GoError(Return);
                return;
            }

            int Chase_id = ShoveEL._Convert.StrToInt(labChase_id.Text, 0);
            if (Chase_id < 1)
            {
                GoError();
                return;
            }

            BindData(Chase_id);
            return;
        }
    }

    protected void btnQuash_Click(object sender, System.EventArgs e)
    {
        int Chase_id = ShoveEL._Convert.StrToInt(labChase_id.Text, 0);
        if (Chase_id < 1)
        {
            GoError();
            return;
        }

        string Return = "";
        int Result = user.QuashChaseAll(Chase_id, ref Return);
        if ((Return != "") || (Result != 0))
        {
            GoError(Return);
            return;
        }

        BindData(Chase_id);
    }
}